/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.vis;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class HeatMapData
implements Iterator {
    private Map[] senders = null;
    private int size = 0;
    private Map maxs = new TreeMap();
    private Map mins = new TreeMap();
    private Set paths = new TreeSet();
    private static final int COUNT = 0;
    private static final int MAX = 1;
    private static final int MIN = 2;
    private static final int MEAN = 3;
    private static final int STDDEV = 4;
    private static final int VOLUME = 5;
    private int senderIndex = -1;
    private Iterator receiverIndex = null;

    public HeatMapData(int n) {
        this.size = n;
        this.senders = new Map[this.size];
    }

    public void put(int n, int n2, String string, double[] dArray) {
        TreeMap<String, double[]> treeMap;
        TreeMap<Integer, TreeMap<String, double[]>> treeMap2 = this.senders[n];
        if (treeMap2 == null) {
            this.senders[n] = treeMap2 = new TreeMap<Integer, TreeMap<String, double[]>>();
        }
        if ((treeMap = (TreeMap<String, double[]>)treeMap2.get(new Integer(n2))) == null) {
            treeMap = new TreeMap<String, double[]>();
            treeMap2.put(new Integer(n2), treeMap);
        }
        treeMap.put(string, dArray);
        this.paths.add(string);
    }

    public double[] get(int n, int n2, String string) {
        Map map;
        double[] dArray = null;
        Map map2 = this.senders[n];
        if (map2 != null && (map = (Map)map2.get(new Integer(n2))) != null) {
            return (double[])map.get(string);
        }
        return dArray;
    }

    public double get(int n, int n2, String string, int n3) {
        double[] dArray = this.get(n, n2, string);
        if (dArray != null) {
            return dArray[n3];
        }
        return 0.0;
    }

    public boolean hasNext() {
        int n = this.senderIndex;
        Iterator iterator = this.receiverIndex;
        while (iterator == null || !iterator.hasNext()) {
            if (++n >= this.size) {
                return false;
            }
            Map map = this.senders[n];
            if (map == null) continue;
            iterator = map.keySet().iterator();
        }
        return true;
    }

    public Object next() {
        Object object;
        while (this.receiverIndex == null || !this.receiverIndex.hasNext()) {
            ++this.senderIndex;
            if (this.senderIndex >= this.size) {
                return null;
            }
            object = this.senders[this.senderIndex];
            if (object == null) continue;
            this.receiverIndex = object.keySet().iterator();
        }
        object = new NextValue();
        ((NextValue)object).sender = this.senderIndex;
        Integer n = (Integer)this.receiverIndex.next();
        ((NextValue)object).data = (Map)this.senders[this.senderIndex].get(n);
        ((NextValue)object).receiver = n;
        return object;
    }

    public void remove() {
    }

    public static void main(String[] stringArray) {
        int n;
        double[] dArray = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0};
        double[] dArray2 = new double[]{6.0, 5.0, 4.0, 3.0, 2.0, 1.0};
        int n2 = 20;
        HeatMapData heatMapData = new HeatMapData(n2);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < i % 10 + 1; ++j) {
                heatMapData.put(i, (i + 1) % n2, "test" + j, dArray2);
                heatMapData.put(i, (i + n2 - 1) % n2, "test" + j, dArray);
            }
        }
        while (heatMapData.hasNext()) {
            NextValue nextValue = (NextValue)heatMapData.next();
            System.out.println(nextValue.sender + ", " + nextValue.receiver);
            Iterator iterator = nextValue.data.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                double[] dArray3 = (double[])nextValue.data.get(string);
                System.out.print("\t" + string + ": ");
                for (int i = 0; i < 6; ++i) {
                    System.out.print(dArray3[i] + " ");
                }
                System.out.println();
            }
        }
        double[] dArray4 = heatMapData.get(14, 13, "test1");
        System.out.print("14, 13\n\ttest1: ");
        for (n = 0; n < 6; ++n) {
            System.out.print(dArray4[n] + " ");
        }
        System.out.println();
        dArray4 = heatMapData.get(14, 15, "test1");
        System.out.print("14, 15\n\ttest1: ");
        for (n = 0; n < 6; ++n) {
            System.out.print(dArray4[n] + " ");
        }
        System.out.println();
    }

    public void massageData() {
        while (this.hasNext()) {
            NextValue nextValue = (NextValue)this.next();
            Iterator iterator = nextValue.data.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                double[] dArray = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
                if (nextValue.data.containsKey(string)) {
                    dArray = (double[])nextValue.data.get(string);
                }
                double[] dArray2 = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
                if (this.maxs.keySet().contains(string)) {
                    dArray2 = (double[])this.maxs.get(string);
                }
                double[] dArray3 = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
                if (this.mins.keySet().contains(string)) {
                    dArray3 = (double[])this.mins.get(string);
                }
                dArray[3] = dArray[0] > 0.0 ? dArray[5] / dArray[0] : 0.0;
                dArray[4] = dArray[0] > 0.0 ? Math.sqrt(Math.abs(dArray[4] / dArray[0] - dArray[3] * dArray[3])) : 0.0;
                dArray2[0] = Math.max(dArray2[0], dArray[0]);
                dArray2[1] = Math.max(dArray2[1], dArray[1]);
                dArray2[2] = Math.max(dArray2[2], dArray[2]);
                dArray2[3] = Math.max(dArray2[3], dArray[3]);
                dArray2[4] = Math.max(dArray2[4], dArray[4]);
                dArray2[5] = Math.max(dArray2[5], dArray[5]);
                if (dArray[0] > 0.0) {
                    dArray3[0] = dArray3[0] == 0.0 ? dArray[0] : Math.min(dArray3[0], dArray[0]);
                    dArray3[1] = dArray3[1] == 0.0 ? dArray[1] : Math.min(dArray3[1], dArray[1]);
                    dArray3[2] = dArray3[2] == 0.0 ? dArray[2] : Math.min(dArray3[2], dArray[2]);
                    dArray3[3] = dArray3[3] == 0.0 ? dArray[3] : Math.min(dArray3[3], dArray[3]);
                    dArray3[4] = dArray3[4] == 0.0 ? dArray[4] : Math.min(dArray3[4], dArray[4]);
                    dArray3[5] = dArray3[5] == 0.0 ? dArray[5] : Math.min(dArray3[5], dArray[5]);
                }
                this.maxs.put(string, dArray2);
                this.mins.put(string, dArray3);
                nextValue.data.put(string, dArray);
            }
        }
    }

    public void reset() {
        this.senderIndex = -1;
        this.receiverIndex = null;
    }

    public int getSize() {
        return this.size;
    }

    public Map getMaxs() {
        return this.maxs;
    }

    public Map getMins() {
        return this.mins;
    }

    public Set getPaths() {
        return this.paths;
    }

    public double getMin(String string, int n) {
        return ((double[])this.mins.get(string))[n];
    }

    public double getMax(String string, int n) {
        return ((double[])this.maxs.get(string))[n];
    }

    public class NextValue {
        public int sender;
        public int receiver;
        public Map data;

        public double getValue(String string, int n) {
            double[] dArray = (double[])this.data.get(string);
            if (dArray == null) {
                return 0.0;
            }
            return dArray[n];
        }
    }
}

