/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.vis;

import edu.uoregon.tau.common.ImageExport;
import edu.uoregon.tau.vis.HeatLegend;
import edu.uoregon.tau.vis.HeatMap;
import edu.uoregon.tau.vis.HeatMapData;
import edu.uoregon.tau.vis.SteppedComboBox;
import edu.uoregon.tau.vis.VerticalLabelUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public class HeatMapWindow
extends JFrame
implements ActionListener,
ImageExport {
    private SteppedComboBox pathSelector = null;
    private SteppedComboBox figureSelector = null;
    private JPanel mainPanel = null;
    private JPanel mapPanel;
    private Map maps = null;
    private Map maxs = null;
    private Map mins = null;
    private HeatMapData mapData = null;
    private static final String allPaths = "All Paths";
    private static final String CALLS = "NUMBER OF CALLS";
    private static final String MAX = "MAX MESSAGE BYTES";
    private static final String MIN = "MIN MESSAGE BYTES";
    private static final String MEAN = "MEAN MESSAGE BYTES";
    private static final String STDDEV = "MESSAGE BYTES STDDEV";
    private static final String VOLUME = "TOTAL VOLUME BYTES";
    private static final String[] figures = new String[]{"NUMBER OF CALLS", "MAX MESSAGE BYTES", "MIN MESSAGE BYTES", "MEAN MESSAGE BYTES", "MESSAGE BYTES STDDEV", "TOTAL VOLUME BYTES"};
    private String currentPath = "All Paths";
    private String currentFigure = "NUMBER OF CALLS";
    private static final String filenamePrefix = "HeatMap";
    private int size = 0;
    public static final int viewSize = 512;
    public static final int maxCells = 256;
    public static final int viewRatio = 2;
    private HeatMap heatMap = null;

    public HeatMapWindow(String string, HeatMapData heatMapData) {
        super(string);
        this.mapData = heatMapData;
        this.maxs = heatMapData.getMaxs();
        this.mins = heatMapData.getMins();
        this.size = heatMapData.getSize();
        this.pathSelector = new SteppedComboBox(heatMapData.getPaths().toArray());
        Dimension dimension = this.pathSelector.getPreferredSize();
        this.pathSelector.setPreferredSize(new Dimension(50, dimension.height));
        this.pathSelector.setMinimumSize(new Dimension(50, dimension.height));
        this.pathSelector.setPopupWidth(dimension.width);
        this.figureSelector = new SteppedComboBox(figures);
        dimension = this.figureSelector.getPreferredSize();
        this.figureSelector.setPreferredSize(new Dimension(50, dimension.height));
        this.figureSelector.setPopupWidth(dimension.width);
        this.drawFigures(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                HeatMapWindow.this.heatMap.goAway();
                HeatMapWindow.this.dispose();
                System.gc();
            }
        });
    }

    private void drawFigures(boolean bl) {
        int n = 0;
        for (n = 0; n < figures.length && !figures[n].equals(this.currentFigure); ++n) {
        }
        JSplitPane jSplitPane = new JSplitPane(1);
        jSplitPane.setResizeWeight(1.0);
        jSplitPane.setOneTouchExpandable(true);
        this.mapPanel = this.buildMapPanel(n, this.currentFigure);
        jSplitPane.setLeftComponent(this.mapPanel);
        jSplitPane.setRightComponent(this.buildOptionPanel("DISPLAY OPTIONS"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.99;
        gridBagConstraints.weighty = 0.99;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.mainPanel = new JPanel(new GridBagLayout());
        this.mainPanel.add((Component)jSplitPane, gridBagConstraints);
        this.getContentPane().add(this.mainPanel);
        if (bl) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Dimension dimension = toolkit.getScreenSize();
            int n2 = dimension.height;
            int n3 = dimension.width;
            int n4 = 1000;
            int n5 = 800;
            int n6 = (n3 - n4) / 2;
            int n7 = (n2 - n5) / 2;
            this.setLocation(n6, n7);
        }
        this.pack();
    }

    private Component buildOptionPanel(String string) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.01;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 5;
        JLabel jLabel = new JLabel(string, 0);
        jLabel.setFont(new Font("PE", jLabel.getFont().getStyle(), jLabel.getFont().getSize() * 2));
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.pathSelector.setSelectedItem(this.currentPath);
        this.pathSelector.addActionListener(this);
        this.pathSelector.addKeyListener(this.heatMap.getScanner());
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)new JLabel("Callpath:"), gridBagConstraints);
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)this.pathSelector, gridBagConstraints);
        this.figureSelector.setSelectedItem(this.currentPath);
        this.figureSelector.addActionListener(this);
        this.figureSelector.addKeyListener(this.heatMap.getScanner());
        gridBagConstraints.gridy = 3;
        jPanel.add((Component)new JLabel("Dataset:"), gridBagConstraints);
        gridBagConstraints.gridy = 4;
        jPanel.add((Component)this.figureSelector, gridBagConstraints);
        return jPanel;
    }

    private JPanel buildMapPanel(int n, String string) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.01;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        DecimalFormat decimalFormat = new DecimalFormat("0.00E0");
        DecimalFormat decimalFormat2 = new DecimalFormat("0.##");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 5;
        JLabel jLabel = new JLabel(string, 0);
        jLabel.setFont(new Font("PE", jLabel.getFont().getStyle(), jLabel.getFont().getSize() * 2));
        jPanel.add((Component)jLabel, gridBagConstraints);
        JLabel jLabel2 = new JLabel(this.currentPath, 0);
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)new JLabel("0", 0), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.99;
        jPanel.add((Component)new JLabel("RECEIVER", 0), gridBagConstraints);
        gridBagConstraints.weightx = 0.01;
        gridBagConstraints.gridx = 3;
        jPanel.add((Component)new JLabel(Integer.toString(this.size - 1), 0), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        jPanel.add((Component)new JLabel("0", 0), gridBagConstraints);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weighty = 0.99;
        JLabel jLabel3 = new JLabel("SENDER", 0);
        jLabel3.setUI(new VerticalLabelUI(false));
        jPanel.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.weighty = 0.01;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 3;
        if (this.heatMap == null) {
            this.heatMap = new HeatMap(this.mapData, n, this.currentPath, filenamePrefix);
        } else {
            this.heatMap.update(this.mapData, n, this.currentPath, filenamePrefix);
        }
        JScrollPane jScrollPane = new JScrollPane(this.heatMap);
        jScrollPane.setPreferredSize(new Dimension(512, 512));
        jScrollPane.setSize(new Dimension(512, 512));
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 4;
        double d = this.mapData.getMax(this.currentPath, n);
        if (d > 999.0) {
            jPanel.add((Component)new JLabel(decimalFormat.format(d), 0), gridBagConstraints);
        } else {
            jPanel.add((Component)new JLabel(decimalFormat2.format(d), 0), gridBagConstraints);
        }
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weighty = 0.99;
        gridBagConstraints.fill = 3;
        jPanel.add((Component)new HeatLegend(), gridBagConstraints);
        gridBagConstraints.fill = 1;
        jPanel.add((Component)new JPanel(), gridBagConstraints);
        gridBagConstraints.weighty = 0.01;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        d = this.mapData.getMin(this.currentPath, n);
        jPanel.add((Component)new JLabel(Integer.toString(this.size - 1), 0), gridBagConstraints);
        gridBagConstraints.gridx = 4;
        if (d > 999.0) {
            jPanel.add((Component)new JLabel(decimalFormat.format(d), 0), gridBagConstraints);
        } else {
            jPanel.add((Component)new JLabel(decimalFormat2.format(d), 0), gridBagConstraints);
        }
        return jPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            String string;
            Object object = actionEvent.getSource();
            Dimension dimension = this.getSize();
            if (object.equals(this.pathSelector) && !(string = (String)this.pathSelector.getSelectedItem()).equals(this.currentPath)) {
                this.currentPath = string;
                this.redrawHeatMap(dimension);
            }
            if (object.equals(this.figureSelector) && !(string = (String)this.figureSelector.getSelectedItem()).equals(this.currentFigure)) {
                this.currentFigure = string;
                this.redrawHeatMap(dimension);
            }
        }
        catch (Exception exception) {
            System.err.println("actionPerformed Exception: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    private void redrawHeatMap(Dimension dimension) {
        this.setVisible(false);
        this.remove(this.mainPanel);
        this.mainPanel = null;
        System.gc();
        this.drawFigures(false);
        this.setSize(dimension);
        this.figureSelector.addKeyListener(this.heatMap.getScanner());
        this.figureSelector.addKeyListener(this.heatMap.getScanner());
        this.heatMap.requestFocus();
        this.setVisible(true);
    }

    public HeatMap getHeatMap() {
        return this.heatMap;
    }

    public void export(Graphics2D graphics2D, boolean bl, boolean bl2, boolean bl3) {
        this.mapPanel.setDoubleBuffered(false);
        this.heatMap.setDoubleBuffered(false);
        this.mapPanel.paintAll(graphics2D);
        this.heatMap.setDoubleBuffered(true);
        this.mapPanel.setDoubleBuffered(true);
    }

    public Dimension getImageSize(boolean bl, boolean bl2) {
        return this.mapPanel.getSize();
    }

    private static void printMemoryStats(String string) {
        DecimalFormat decimalFormat = new DecimalFormat("#.## MB");
        System.out.print(string + " - ");
        System.out.print("Memory - Free: " + decimalFormat.format((double)Runtime.getRuntime().freeMemory() / 1000000.0));
        System.out.print("\tTotal: " + decimalFormat.format((double)Runtime.getRuntime().totalMemory() / 1000000.0));
        System.out.println("\tMax: " + decimalFormat.format((double)Runtime.getRuntime().maxMemory() / 1000000.0));
    }
}

