/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.ByteArrayBuffer;
import com.mysql.jdbc.ChannelBuffer;
import com.mysql.jdbc.SingleByteCharsetConverter;
import com.mysql.jdbc.StringUtils;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.sql.SQLException;

abstract class Buffer {
    static final int NO_LENGTH_LIMIT = -1;
    static final long NULL_LENGTH = -1L;
    static final int MAX_BYTES_TO_DUMP = 512;
    protected boolean wasMultiPacket = false;

    Buffer() {
    }

    public static Buffer allocateDirect(int size, boolean useNewIo) {
        if (!useNewIo) {
            return Buffer.allocateNew(size, useNewIo);
        }
        return new ChannelBuffer(size, true);
    }

    public static Buffer allocateNew(byte[] buf, boolean useNewIo) {
        if (!useNewIo) {
            return new ByteArrayBuffer(buf);
        }
        return new ChannelBuffer(buf);
    }

    public static Buffer allocateNew(int size, boolean useNewIo) {
        if (!useNewIo) {
            return new ByteArrayBuffer(size);
        }
        return new ChannelBuffer(size, true);
    }

    abstract void clear();

    final void dump() {
        this.dump(this.getBufLength());
    }

    final String dump(int numBytes) {
        return StringUtils.dumpAsHex(this.getBytes(0, numBytes > this.getBufLength() ? this.getBufLength() : numBytes), numBytes > this.getBufLength() ? this.getBufLength() : numBytes);
    }

    final String dumpClampedBytes(int numBytes) {
        int numBytesToDump = numBytes < 512 ? numBytes : 512;
        String dumped = StringUtils.dumpAsHex(this.getBytes(0, numBytesToDump > this.getBufLength() ? this.getBufLength() : numBytesToDump), numBytesToDump > this.getBufLength() ? this.getBufLength() : numBytesToDump);
        if (numBytesToDump < numBytes) {
            return dumped + " ....(packet exceeds max. dump length)";
        }
        return dumped;
    }

    final void dumpHeader() {
        for (int i = 0; i < 4; ++i) {
            String hexVal = Integer.toHexString(this.readByte(i) & 0xFF);
            if (hexVal.length() == 1) {
                hexVal = "0" + hexVal;
            }
            System.out.print(hexVal + " ");
        }
    }

    final void dumpNBytes(int start, int nBytes) {
        StringBuffer asciiBuf = new StringBuffer();
        for (int i = start; i < start + nBytes && i < this.getBufLength(); ++i) {
            String hexVal = Integer.toHexString(this.readByte(i) & 0xFF);
            if (hexVal.length() == 1) {
                hexVal = "0" + hexVal;
            }
            System.out.print(hexVal + " ");
            if (this.readByte(i) > 32 && this.readByte(i) < 127) {
                asciiBuf.append((char)this.readByte(i));
            } else {
                asciiBuf.append(".");
            }
            asciiBuf.append(" ");
        }
        System.out.println("    " + asciiBuf.toString());
    }

    abstract void ensureCapacity(int var1) throws SQLException;

    public abstract int fastSkipLenString();

    abstract int getBufLength();

    public abstract byte[] getByteBuffer();

    abstract byte[] getBytes(int var1);

    abstract byte[] getBytes(int var1, int var2);

    abstract int getCapacity();

    public abstract ByteBuffer getNioBuffer();

    public abstract int getPosition();

    abstract boolean isLastDataPacket();

    abstract long newReadLength();

    abstract byte readByte();

    abstract byte readByte(int var1);

    abstract long readFieldLength();

    abstract int readInt();

    abstract int readIntAsLong();

    abstract byte[] readLenByteArray(int var1);

    abstract long readLength();

    abstract long readLong();

    abstract int readLongInt();

    abstract long readLongLong();

    abstract int readnBytes();

    abstract String readString();

    abstract String readString(String var1) throws SQLException;

    abstract void setBufLength(int var1);

    public abstract void setByteBuffer(byte[] var1);

    public abstract void setPosition(int var1);

    public void setWasMultiPacket(boolean flag) {
        this.wasMultiPacket = flag;
    }

    public boolean wasMultiPacket() {
        return this.wasMultiPacket;
    }

    abstract void writeByte(byte var1) throws SQLException;

    abstract void writeBytesNoNull(byte[] var1) throws SQLException;

    abstract void writeBytesNoNull(byte[] var1, int var2, int var3) throws SQLException;

    abstract void writeDouble(double var1) throws SQLException;

    abstract void writeFieldLength(long var1) throws SQLException;

    abstract void writeFloat(float var1) throws SQLException;

    abstract void writeInt(int var1) throws SQLException;

    abstract void writeLenBytes(byte[] var1) throws SQLException;

    abstract void writeLenString(String var1, String var2, String var3, SingleByteCharsetConverter var4, boolean var5) throws UnsupportedEncodingException, SQLException;

    abstract void writeLong(long var1) throws SQLException;

    abstract void writeLongInt(int var1) throws SQLException;

    abstract void writeLongLong(long var1) throws SQLException;

    abstract void writeString(String var1) throws SQLException;

    abstract void writeStringNoNull(String var1) throws SQLException;

    abstract void writeStringNoNull(String var1, String var2, String var3, boolean var4) throws UnsupportedEncodingException, SQLException;

    public String toString() {
        return this.dumpClampedBytes(this.getPosition());
    }

    public String toSuperString() {
        return super.toString();
    }
}

