/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.common.Gzip;
import edu.uoregon.tau.perfdmf.AtomicEvent;
import edu.uoregon.tau.perfdmf.AtomicLocationProfile;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.DatabaseAPI;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.IntervalEvent;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Thread;
import edu.uoregon.tau.perfdmf.UserEvent;
import edu.uoregon.tau.perfdmf.UserEventProfile;
import edu.uoregon.tau.perfdmf.database.DB;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class DBDataSource
extends DataSource {
    private DatabaseAPI databaseAPI;
    private volatile boolean abort = false;
    private volatile int totalItems = 0;
    private volatile int itemsDone = 0;

    public DBDataSource(DatabaseAPI databaseAPI) {
        this.setMetrics(new Vector());
        this.databaseAPI = databaseAPI;
    }

    public int getProgress() {
        return 0;
    }

    public void cancelLoad() {
        this.abort = true;
    }

    private void fastGetIntervalEventData(Map map, Map map2) throws SQLException {
        int n = this.getNumberOfMetrics();
        DB dB = this.databaseAPI.getDb();
        StringBuffer stringBuffer = new StringBuffer();
        if (map2.size() == 0) {
            return;
        }
        stringBuffer.append(" WHERE p.metric in (");
        Object object = map2.keySet().iterator();
        while (object.hasNext()) {
            int n2 = (Integer)object.next();
            stringBuffer.append(n2);
            if (object.hasNext()) {
                stringBuffer.append(", ");
                continue;
            }
            stringBuffer.append(") ");
        }
        object = new StringBuffer();
        ((StringBuffer)object).append("select p.interval_event, p.metric, p.node, p.context, p.thread, ");
        if (dB.getDBType().compareTo("oracle") == 0) {
            ((StringBuffer)object).append("p.inclusive, p.excl, ");
        } else {
            ((StringBuffer)object).append("p.inclusive, p.exclusive, ");
        }
        if (dB.getDBType().compareTo("derby") == 0) {
            ((StringBuffer)object).append("p.num_calls, ");
        } else {
            ((StringBuffer)object).append("p.call, ");
        }
        ((StringBuffer)object).append("p.subroutines ");
        ((StringBuffer)object).append("from interval_location_profile p ");
        ((StringBuffer)object).append(stringBuffer);
        long l = System.currentTimeMillis();
        ResultSet resultSet = dB.executeQuery(((StringBuffer)object).toString());
        l = System.currentTimeMillis() - l;
        l = System.currentTimeMillis();
        while (resultSet.next()) {
            int n3;
            int n4;
            int n5 = resultSet.getInt(1);
            Function function = (Function)map.get(new Integer(n5));
            int n6 = resultSet.getInt(3);
            Thread thread = this.addThread(n6, n4 = resultSet.getInt(4), n3 = resultSet.getInt(5));
            FunctionProfile functionProfile = thread.getFunctionProfile(function);
            if (functionProfile == null) {
                functionProfile = new FunctionProfile(function, n);
                thread.addFunctionProfile(functionProfile);
            }
            int n7 = ((Metric)map2.get(new Integer(resultSet.getInt(2)))).getID();
            double d = resultSet.getDouble(6);
            double d2 = resultSet.getDouble(7);
            double d3 = resultSet.getDouble(8);
            double d4 = resultSet.getDouble(9);
            functionProfile.setNumCalls(d3);
            functionProfile.setNumSubr(d4);
            functionProfile.setExclusive(n7, d2);
            functionProfile.setInclusive(n7, d);
        }
        l = System.currentTimeMillis() - l;
        resultSet.close();
    }

    private void downloadMetaData() {
        try {
            DB dB = this.databaseAPI.getDb();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(" SELECT XML_METADATA_GZ");
            stringBuffer.append(" FROM TRIAL WHERE id = ");
            stringBuffer.append(this.databaseAPI.getTrial().getID());
            ResultSet resultSet = dB.executeQuery(stringBuffer.toString());
            resultSet.next();
            InputStream inputStream = resultSet.getBinaryStream(1);
            String string = Gzip.decompress((InputStream)inputStream);
            if (string != null) {
                XMLReader xMLReader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
                XMLParser xMLParser = new XMLParser();
                xMLReader.setContentHandler(xMLParser);
                xMLReader.setErrorHandler(xMLParser);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
                xMLReader.parse(new InputSource(byteArrayInputStream));
            }
        }
        catch (IOException iOException) {
        }
        catch (SAXException sAXException) {
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void load() throws SQLException {
        Comparable comparable;
        Object object;
        Object object2;
        ListIterator listIterator;
        Object object3;
        long l = System.currentTimeMillis();
        DB dB = this.databaseAPI.getDb();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT id, name ");
        stringBuffer.append("FROM " + dB.getSchemaPrefix() + "metric ");
        stringBuffer.append("WHERE trial = ");
        stringBuffer.append(this.databaseAPI.getTrial().getID());
        stringBuffer.append(" ORDER BY id ");
        HashMap hashMap = new HashMap();
        ResultSet resultSet = dB.executeQuery(stringBuffer.toString());
        int n = 0;
        while (resultSet.next()) {
            int n2 = resultSet.getInt(1);
            object3 = resultSet.getString(2);
            listIterator = this.addMetricNoCheck((String)object3);
            ((Metric)((Object)listIterator)).setDbMetricID(n2);
            hashMap.put(new Integer(n2), listIterator);
            ++n;
        }
        resultSet.close();
        HashMap<Integer, Object> hashMap2 = new HashMap<Integer, Object>();
        object3 = this.databaseAPI.getIntervalEvents();
        listIterator = object3.listIterator();
        while (listIterator.hasNext()) {
            object2 = (IntervalEvent)listIterator.next();
            object = this.addFunction(((IntervalEvent)object2).getName(), n);
            this.addGroups(((IntervalEvent)object2).getGroup(), (Function)object);
            hashMap2.put(new Integer(((IntervalEvent)object2).getID()), object);
        }
        this.fastGetIntervalEventData(hashMap2, hashMap);
        object2 = new HashMap();
        listIterator = this.databaseAPI.getAtomicEvents().listIterator();
        while (listIterator.hasNext()) {
            object = (AtomicEvent)listIterator.next();
            comparable = this.addUserEvent(((AtomicEvent)object).getName());
            object2.put(new Integer(((AtomicEvent)object).getID()), comparable);
        }
        listIterator = this.databaseAPI.getAtomicEventData().listIterator();
        while (listIterator.hasNext()) {
            UserEvent userEvent;
            object = (AtomicLocationProfile)listIterator.next();
            comparable = this.addThread(((AtomicLocationProfile)object).getNode(), ((AtomicLocationProfile)object).getContext(), ((AtomicLocationProfile)object).getThread());
            UserEventProfile userEventProfile = ((Thread)comparable).getUserEventProfile(userEvent = (UserEvent)object2.get(new Integer(((AtomicLocationProfile)object).getAtomicEventID())));
            if (userEventProfile == null) {
                userEventProfile = new UserEventProfile(userEvent);
                ((Thread)comparable).addUserEventProfile(userEventProfile);
            }
            userEventProfile.setNumSamples(((AtomicLocationProfile)object).getSampleCount());
            userEventProfile.setMaxValue(((AtomicLocationProfile)object).getMaximumValue());
            userEventProfile.setMinValue(((AtomicLocationProfile)object).getMinimumValue());
            userEventProfile.setMeanValue(((AtomicLocationProfile)object).getMeanValue());
            userEventProfile.setSumSquared(((AtomicLocationProfile)object).getSumSquared());
            userEventProfile.updateMax();
        }
        this.downloadMetaData();
        this.databaseAPI.terminate();
        l = System.currentTimeMillis() - l;
        this.generateDerivedData();
    }

    private class XMLParser
    extends DefaultHandler {
        private StringBuffer accumulator = new StringBuffer();
        private String currentName = "";
        private Thread currentThread;

        private XMLParser() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.accumulator = new StringBuffer();
            if (string2.equals("CommonProfileAttributes")) {
                this.currentThread = null;
            } else if (string2.equals("ProfileAttributes")) {
                int n = Integer.parseInt(attributes.getValue("node"));
                int n2 = Integer.parseInt(attributes.getValue("context"));
                int n3 = Integer.parseInt(attributes.getValue("thread"));
                this.currentThread = DBDataSource.this.getThread(n, n2, n3);
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (string2.equals("name")) {
                this.currentName = this.accumulator.toString().trim();
            } else if (string2.equals("value")) {
                String string4 = this.accumulator.toString().trim();
                if (this.currentThread == null) {
                    DBDataSource.this.getMetaData().put(this.currentName, string4);
                } else {
                    this.currentThread.getMetaData().put(this.currentName, string4);
                    DBDataSource.this.getUncommonMetaData().put(this.currentName, string4);
                }
            }
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            this.accumulator.append(cArray, n, n2);
        }
    }
}

