/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.perfdmf.CallPathUtilFuncs;
import edu.uoregon.tau.perfdmf.Context;
import edu.uoregon.tau.perfdmf.DataSourceException;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.Group;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Node;
import edu.uoregon.tau.perfdmf.Snapshot;
import edu.uoregon.tau.perfdmf.Thread;
import edu.uoregon.tau.perfdmf.UserEvent;
import edu.uoregon.tau.perfdmf.UserEventProfile;
import edu.uoregon.tau.perfdmf.UtilFncs;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class DataSource {
    public static final SimpleDateFormat dateTime = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    public static final int PPK = 0;
    public static final int TAUPROFILE = 1;
    public static final int DYNAPROF = 2;
    public static final int MPIP = 3;
    public static final int HPM = 4;
    public static final int GPROF = 5;
    public static final int PSRUN = 6;
    public static final int PPROF = 7;
    public static final int CUBE = 8;
    public static final int HPCTOOLKIT = 9;
    public static final int SNAP = 10;
    public static final int OMPP = 11;
    public static final int PERIXML = 12;
    public static final int GPTL = 13;
    public static final int PARAVER = 14;
    public static final int IPM = 15;
    public static final int GYRO = 100;
    public static final int GAMESS = 101;
    public static final String FILE_TYPE_INDEX = "File Type Index";
    public static final String FILE_TYPE_NAME = "File Type Name";
    public static String[] formatTypeStrings = new String[]{"ParaProf Packed Profile", "Tau profiles", "Dynaprof", "MpiP", "HPMToolkit", "Gprof", "PSRun", "Tau pprof.dat", "Cube", "HPCToolkit", "TAU Snapshot", "ompP", "PERI-XML", "General Purpose Timing Library (GPTL)", "Paraver", "IPM"};
    private static boolean meanIncludeNulls = true;
    private boolean userEventsPresent = false;
    private boolean callPathDataPresent = false;
    private boolean groupNamesPresent = false;
    private boolean phasesPresent = false;
    private Function topLevelPhase;
    protected List metrics = null;
    protected Thread meanData = null;
    protected Thread totalData = null;
    protected Thread stddevData = null;
    private Map nodes = new TreeMap();
    private Map functions = new TreeMap();
    private Map groups = new TreeMap();
    private Map userEvents = new TreeMap();
    private List allThreads;
    private boolean generateIntermediateCallPathData;
    private boolean reverseDataAvailable;
    private int[] maxNCT = null;
    protected volatile boolean reloading;
    protected Map metaData = new TreeMap();
    protected Map uncommonMetaData = new TreeMap();
    private File metadataFile;
    private StringBuffer metadataString = new StringBuffer();
    private boolean wellBehavedSnapshots;
    private long avgStartTime;
    protected boolean monitored;
    protected boolean hasThreads = true;
    protected boolean hasContexts = true;
    protected boolean hasMPI = false;
    private int fileType = 1;
    public static final int EXEC_TYPE_SINGLE = 0;
    public static final int EXEC_TYPE_MPI = 1;
    public static final int EXEC_TYPE_THREADED = 2;
    public static final int EXEC_TYPE_HYBRID = 3;
    public static final int EXEC_TYPE_OTHER = 4;

    public abstract void load() throws FileNotFoundException, IOException, DataSourceException, SQLException;

    public abstract int getProgress();

    public abstract void cancelLoad();

    public int getFileType() {
        return this.fileType;
    }

    public void setFileType(int n) {
        this.fileType = n;
    }

    public List getFiles() {
        return new ArrayList();
    }

    public boolean isReloading() {
        return this.reloading;
    }

    public boolean reloadData() throws Exception {
        if (this.reloading) {
            return false;
        }
        this.reloading = true;
        this.cleanData();
        this.load();
        this.reloading = false;
        return true;
    }

    protected void cleanData() {
        Iterator iterator = this.getAllThreads().iterator();
        while (iterator.hasNext()) {
            Thread thread = (Thread)iterator.next();
            Iterator iterator2 = thread.getFunctionProfileIterator();
            while (iterator2.hasNext()) {
                FunctionProfile functionProfile = (FunctionProfile)iterator2.next();
                if (functionProfile == null) continue;
                for (int i = 0; i < this.getNumberOfMetrics(); ++i) {
                    functionProfile.setExclusive(i, 0.0);
                    functionProfile.setInclusive(i, 0.0);
                }
                functionProfile.setNumSubr(0.0);
                functionProfile.setNumCalls(0.0);
            }
        }
    }

    public void setMonitored(boolean bl) {
        this.monitored = bl;
    }

    public Thread getMeanData() {
        return this.meanData;
    }

    public Thread getStdDevData() {
        return this.stddevData;
    }

    public Thread getTotalData() {
        return this.totalData;
    }

    private void setCallPathDataPresent(boolean bl) {
        this.callPathDataPresent = bl;
    }

    public boolean getCallPathDataPresent() {
        return this.callPathDataPresent;
    }

    protected void setGroupNamesPresent(boolean bl) {
        this.groupNamesPresent = bl;
    }

    public boolean getGroupNamesPresent() {
        return this.groupNamesPresent;
    }

    protected void setUserEventsPresent(boolean bl) {
        this.userEventsPresent = bl;
    }

    public boolean getUserEventsPresent() {
        return this.userEventsPresent;
    }

    public Function addFunction(String string) {
        return this.addFunction(string, this.getNumberOfMetrics());
    }

    public Function addFunction(String string, int n) {
        Function function = (Function)this.functions.get(string = string.trim());
        if (function != null) {
            return function;
        }
        function = new Function(string, this.functions.size(), n);
        this.functions.put(string, function);
        return function;
    }

    public Function getFunction(String string) {
        return (Function)this.functions.get(string.trim());
    }

    public int getNumFunctions() {
        return this.functions.size();
    }

    public Iterator getFunctions() {
        return this.functions.values().iterator();
    }

    public UserEvent addUserEvent(String string) {
        Object v = this.userEvents.get(string);
        if (v != null) {
            return (UserEvent)v;
        }
        UserEvent userEvent = new UserEvent(string, this.userEvents.size() + 1);
        this.userEvents.put(string, userEvent);
        this.setUserEventsPresent(true);
        return userEvent;
    }

    public UserEvent getUserEvent(String string) {
        return (UserEvent)this.userEvents.get(string);
    }

    public int getNumUserEvents() {
        return this.userEvents.size();
    }

    public Iterator getUserEvents() {
        return this.userEvents.values().iterator();
    }

    public Group getGroup(String string) {
        return (Group)this.groups.get(string);
    }

    public Group addGroup(String string) {
        Object v;
        if ((string = string.trim()) == "TAU_MPI") {
            this.hasMPI = true;
        }
        if ((v = this.groups.get(string)) != null) {
            return (Group)v;
        }
        Group group = new Group(string, this.groups.size() + 1);
        this.groups.put(string, group);
        return group;
    }

    protected void addGroups(String string, Function function) {
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2 == null) continue;
            Group group = this.addGroup(string2.trim());
            function.addGroup(group);
        }
        this.setGroupNamesPresent(true);
    }

    public int getNumGroups() {
        return this.groups.size();
    }

    public Iterator getGroups() {
        return this.groups.values().iterator();
    }

    public int[] getMaxNCTNumbers() {
        if (this.maxNCT == null) {
            this.maxNCT = new int[3];
            Iterator iterator = this.getNodes();
            while (iterator.hasNext()) {
                Node node = (Node)iterator.next();
                this.maxNCT[0] = Math.max(this.maxNCT[0], node.getNodeID());
                Iterator iterator2 = node.getContexts();
                while (iterator2.hasNext()) {
                    Context context = (Context)iterator2.next();
                    this.maxNCT[1] = Math.max(this.maxNCT[1], context.getContextID());
                    Iterator iterator3 = context.getThreads();
                    while (iterator3.hasNext()) {
                        Thread thread = (Thread)iterator3.next();
                        this.maxNCT[2] = Math.max(this.maxNCT[2], thread.getThreadID());
                    }
                }
            }
        }
        return this.maxNCT;
    }

    public int getNumThreads() {
        int n = 0;
        Iterator iterator = this.getNodes();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            Iterator iterator2 = node.getContexts();
            while (iterator2.hasNext()) {
                Context context = (Context)iterator2.next();
                Iterator iterator3 = context.getThreads();
                while (iterator3.hasNext()) {
                    iterator3.next();
                    ++n;
                }
            }
        }
        return n;
    }

    public void setMetrics(List list) {
        this.metrics = list;
    }

    public void addMetric(Metric metric) {
        if (this.metrics == null) {
            this.metrics = new ArrayList();
        } else {
            Iterator iterator = this.getAllThreads().iterator();
            while (iterator.hasNext()) {
                Thread thread = (Thread)iterator.next();
                thread.addMetric();
            }
            if (this.meanData != null) {
                this.meanData.addMetric();
                this.totalData.addMetric();
                this.stddevData.addMetric();
            }
        }
        metric.setID(this.getNumberOfMetrics());
        this.metrics.add(metric);
    }

    public Metric addMetric(String string) {
        Object object;
        if (this.metrics != null) {
            object = this.metrics.iterator();
            while (object.hasNext()) {
                Metric metric = (Metric)object.next();
                if (!metric.getName().equals(string)) continue;
                return metric;
            }
        }
        object = new Metric();
        ((Metric)object).setName(string);
        this.addMetric((Metric)object);
        return object;
    }

    public Metric addMetricNoCheck(String string) {
        Metric metric = new Metric();
        metric.setName(string);
        this.addMetric(metric);
        return metric;
    }

    public Metric addMetric(String string, Thread thread) {
        Metric metric = null;
        if (this.metrics == null) {
            this.metrics = new ArrayList();
        } else {
            Iterator iterator = this.metrics.iterator();
            while (iterator.hasNext()) {
                Metric metric2 = (Metric)iterator.next();
                if (!metric2.getName().equals(string)) continue;
                metric = metric2;
                break;
            }
        }
        if (metric == null) {
            metric = new Metric();
            metric.setName(string);
            metric.setID(this.getNumberOfMetrics());
            this.metrics.add(metric);
        }
        if (thread.getNumMetrics() < this.getNumberOfMetrics()) {
            thread.addMetric();
        }
        return metric;
    }

    public List getMetrics() {
        return this.metrics;
    }

    public void clearMetrics() {
        this.metrics = null;
    }

    public Metric getMetric(String string) {
        Iterator iterator = this.metrics.iterator();
        while (iterator.hasNext()) {
            Metric metric = (Metric)iterator.next();
            if (!metric.getName().equals(string)) continue;
            return metric;
        }
        return null;
    }

    public Metric getMetric(int n) {
        if (this.metrics != null && n < this.metrics.size()) {
            return (Metric)this.metrics.get(n);
        }
        return null;
    }

    public String getMetricName(int n) {
        if (this.metrics != null && n < this.metrics.size()) {
            return ((Metric)this.metrics.get(n)).getName();
        }
        return null;
    }

    public int getNumberOfMetrics() {
        if (this.metrics != null) {
            return this.metrics.size();
        }
        return 0;
    }

    private void generateBonusCallPathData() {
        Comparable comparable;
        if (!this.getCallPathDataPresent()) {
            return;
        }
        ArrayList<Function> arrayList = new ArrayList<Function>();
        Iterator iterator = this.getFunctions();
        while (iterator.hasNext()) {
            comparable = (Function)iterator.next();
            arrayList.add((Function)comparable);
        }
        this.initAllThreadsList();
        int n = this.allThreads.size();
        comparable = this.addGroup("TAU_CALLPATH_DERIVED");
        this.reverseDataAvailable = true;
        Iterator iterator2 = arrayList.iterator();
        while (iterator2.hasNext()) {
            Function function = (Function)iterator2.next();
            if (!function.isCallPathFunction() || !CallPathUtilFuncs.containsDoublePath(function.getName())) continue;
            String string = function.getName();
            string = string.substring(string.indexOf("=>") + 2);
            while (string.indexOf("=>") != -1) {
                Function function2 = this.getFunction(string);
                if (function2 == null) {
                    function2 = this.addFunction(string);
                    Iterator iterator3 = function.getGroups().iterator();
                    while (iterator3.hasNext()) {
                        function2.addGroup((Group)iterator3.next());
                    }
                }
                function2.addGroup((Group)comparable);
                string = string.substring(string.indexOf("=>") + 2);
                for (int i = 0; i < n; ++i) {
                    Thread thread = (Thread)this.allThreads.get(i);
                    FunctionProfile functionProfile = thread.getFunctionProfile(function);
                    if (functionProfile == null) continue;
                    FunctionProfile functionProfile2 = thread.getFunctionProfile(function2);
                    if (functionProfile2 == null) {
                        functionProfile2 = new FunctionProfile(function2, this.getNumberOfMetrics(), thread.getNumSnapshots());
                        thread.addFunctionProfile(functionProfile2);
                    }
                    for (int j = 0; j < this.getNumberOfMetrics(); ++j) {
                        functionProfile2.setExclusive(j, functionProfile2.getExclusive(j) + functionProfile.getExclusive(j));
                        functionProfile2.setInclusive(j, functionProfile2.getInclusive(j) + functionProfile.getInclusive(j));
                    }
                    functionProfile2.setNumCalls(functionProfile2.getNumCalls() + functionProfile.getNumCalls());
                    functionProfile2.setNumSubr(functionProfile2.getNumSubr() + functionProfile.getNumSubr());
                }
            }
        }
    }

    private void addDerivedSnapshots(Thread thread, Thread thread2) {
        if (this.wellBehavedSnapshots) {
            thread2.setStartTime(this.avgStartTime);
            Iterator iterator = thread.getSnapshots().iterator();
            while (iterator.hasNext()) {
                Snapshot snapshot = (Snapshot)iterator.next();
                Snapshot snapshot2 = thread2.addSnapshot(snapshot.getName());
                snapshot2.setTimestamp(snapshot.getTimestamp());
            }
        }
    }

    public void generateDerivedData() {
        this.allThreads = null;
        if (CallPathUtilFuncs.checkCallPathsPresent(this.getFunctions())) {
            this.setCallPathDataPresent(true);
        }
        if (this.generateIntermediateCallPathData) {
            this.generateBonusCallPathData();
        }
        this.checkForPhases();
        int n = ((Thread)this.getAllThreads().get(0)).getNumSnapshots();
        long l = 0L;
        Iterator iterator = this.getAllThreads().iterator();
        while (iterator.hasNext()) {
            String string;
            Thread thread = (Thread)iterator.next();
            thread.setThreadDataAllMetrics();
            int n2 = thread.getNumSnapshots();
            if (n2 != n) {
                n = -1;
            }
            if ((string = (String)thread.getMetaData().get("Starting Timestamp")) == null) continue;
            l += Long.parseLong(string);
        }
        if (n > 1) {
            this.wellBehavedSnapshots = true;
            this.avgStartTime = (long)((double)l / (double)this.getAllThreads().size());
        }
        try {
            this.generateStatistics(0, this.getNumberOfMetrics() - 1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.meanData.setThreadDataAllMetrics();
        this.totalData.setThreadDataAllMetrics();
        this.stddevData.setThreadDataAllMetrics();
        this.generateUserEventStatistics();
        this.finishPhaseAnalysis();
        this.getMetaData().put(FILE_TYPE_INDEX, Integer.toString(this.fileType));
        this.getMetaData().put(FILE_TYPE_NAME, formatTypeStrings[this.fileType]);
    }

    private double computeStdDev(double d, double d2, int n) {
        double d3 = 0.0;
        if (n > 1) {
            d3 = Math.sqrt(Math.abs(d / (double)n - d2 * d2));
        }
        return d3;
    }

    private void generateUserEventStatistics() {
        this.initAllThreadsList();
        int n = this.allThreads.size();
        int n2 = this.meanData.getNumSnapshots();
        int[] nArray = new int[this.getNumUserEvents() + 1];
        for (int i = 0; i < n2; ++i) {
            Object object;
            UserEventProfile userEventProfile;
            Object object2;
            Comparable comparable;
            for (int j = 0; j < n; ++j) {
                comparable = (Thread)this.allThreads.get(j);
                object2 = ((Thread)comparable).getUserEventProfiles();
                while (object2.hasNext()) {
                    UserEventProfile userEventProfile2;
                    UserEventProfile userEventProfile3;
                    userEventProfile = (UserEventProfile)object2.next();
                    object = userEventProfile.getUserEvent();
                    UserEventProfile userEventProfile4 = this.meanData.getUserEventProfile((UserEvent)object);
                    if (userEventProfile4 == null) {
                        userEventProfile4 = new UserEventProfile((UserEvent)object, n2);
                        this.meanData.addUserEventProfile(userEventProfile4);
                    }
                    if ((userEventProfile3 = this.totalData.getUserEventProfile((UserEvent)object)) == null) {
                        userEventProfile3 = new UserEventProfile((UserEvent)object, n2);
                        this.totalData.addUserEventProfile(userEventProfile3);
                    }
                    if ((userEventProfile2 = this.stddevData.getUserEventProfile((UserEvent)object)) == null) {
                        userEventProfile2 = new UserEventProfile((UserEvent)object, n2);
                        this.stddevData.addUserEventProfile(userEventProfile2);
                    }
                    int n3 = ((UserEvent)object).getID();
                    nArray[n3] = nArray[n3] + 1;
                    userEventProfile3.setNumSamples(userEventProfile3.getNumSamples() + userEventProfile.getNumSamples(i), i);
                    userEventProfile3.setMaxValue(userEventProfile3.getMaxValue() + userEventProfile.getMaxValue(i), i);
                    userEventProfile3.setMinValue(userEventProfile3.getMinValue() + userEventProfile.getMinValue(i), i);
                    userEventProfile3.setMeanValue(userEventProfile3.getMeanValue() + userEventProfile.getMeanValue(i), i);
                    userEventProfile3.setStdDev(userEventProfile3.getStdDev() + userEventProfile.getStdDev(i), i);
                    userEventProfile2.setNumSamples(userEventProfile2.getNumSamples() + userEventProfile.getNumSamples(i) * userEventProfile.getNumSamples(i), i);
                    userEventProfile2.setMaxValue(userEventProfile2.getMaxValue() + userEventProfile.getMaxValue(i) * userEventProfile.getMaxValue(i), i);
                    userEventProfile2.setMinValue(userEventProfile2.getMinValue() + userEventProfile.getMinValue(i) * userEventProfile.getMinValue(i), i);
                    userEventProfile2.setMeanValue(userEventProfile2.getMeanValue() + userEventProfile.getMeanValue(i) * userEventProfile.getMeanValue(i), i);
                    userEventProfile2.setStdDev(userEventProfile2.getStdDev() + userEventProfile.getStdDev(i) * userEventProfile.getStdDev(i), i);
                }
            }
            Iterator iterator = this.getUserEvents();
            while (iterator.hasNext()) {
                comparable = (UserEvent)iterator.next();
                object2 = this.meanData.getUserEventProfile((UserEvent)comparable);
                userEventProfile = this.totalData.getUserEventProfile((UserEvent)comparable);
                object = this.stddevData.getUserEventProfile((UserEvent)comparable);
                int n4 = n;
                if (!meanIncludeNulls) {
                    n4 = nArray[((UserEvent)comparable).getID()];
                }
                ((UserEventProfile)object2).setNumSamples(userEventProfile.getNumSamples() / (double)n4, i);
                ((UserEventProfile)object2).setMaxValue(userEventProfile.getMaxValue(i) / (double)n4, i);
                ((UserEventProfile)object2).setMinValue(userEventProfile.getMinValue(i) / (double)n4, i);
                ((UserEventProfile)object2).setMeanValue(userEventProfile.getMeanValue(i) / (double)n4, i);
                ((UserEventProfile)object2).setStdDev(userEventProfile.getStdDev(i) / (double)n4, i);
                ((UserEventProfile)object).setNumSamples(this.computeStdDev(((UserEventProfile)object).getNumSamples(i), ((UserEventProfile)object2).getNumSamples(i), n4), i);
                ((UserEventProfile)object).setMaxValue(this.computeStdDev(((UserEventProfile)object).getMaxValue(i), ((UserEventProfile)object2).getMaxValue(i), n4), i);
                ((UserEventProfile)object).setMinValue(this.computeStdDev(((UserEventProfile)object).getMinValue(i), ((UserEventProfile)object2).getMinValue(i), n4), i);
                ((UserEventProfile)object).setMeanValue(this.computeStdDev(((UserEventProfile)object).getMeanValue(i), ((UserEventProfile)object2).getMeanValue(i), n4), i);
                ((UserEventProfile)object).setStdDev(this.computeStdDev(((UserEventProfile)object).getStdDev(i), ((UserEventProfile)object2).getStdDev(i), n4), i);
            }
        }
    }

    public void generateStatistics(int n, int n2) {
        int n3 = this.getNumberOfMetrics();
        Thread thread = (Thread)this.getAllThreads().get(0);
        if (this.meanData == null) {
            this.meanData = new Thread(-1, -1, -1, n3, this);
            this.addDerivedSnapshots(thread, this.meanData);
        }
        if (this.totalData == null) {
            this.totalData = new Thread(-2, -2, -2, n3, this);
            this.addDerivedSnapshots(thread, this.totalData);
        }
        if (this.stddevData == null) {
            this.stddevData = new Thread(-3, -3, -3, n3, this);
            this.addDerivedSnapshots(thread, this.stddevData);
        }
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        double[] dArray3 = new double[n3];
        double[] dArray4 = new double[n3];
        this.initAllThreadsList();
        for (int i = 0; i < this.meanData.getNumSnapshots(); ++i) {
            Object object;
            Object object2;
            Object object3;
            for (int j = n; j <= n2; ++j) {
                object3 = new double[n3];
                object2 = this.allThreads.iterator();
                while (object2.hasNext()) {
                    object = (Thread)object2.next();
                    if (this.wellBehavedSnapshots) {
                        Object object4 = object3;
                        int n4 = j;
                        object4[n4] = object4[n4] + ((Thread)object).getMaxInclusive(j, i);
                        continue;
                    }
                    Object object5 = object3;
                    int n5 = j;
                    object5[n5] = object5[n5] + ((Thread)object).getMaxInclusive(j, ((Thread)object).getNumSnapshots() - 1);
                }
                this.totalData.setPercentDivider(j, i, object3[j] / 100.0);
                this.meanData.setPercentDivider(j, i, (double)(object3[j] / 100.0));
                this.stddevData.setPercentDivider(j, i, (double)(object3[j] / 100.0));
            }
            Iterator iterator = this.getFunctions();
            while (iterator.hasNext()) {
                int n6;
                int n7;
                object3 = (Function)iterator.next();
                object2 = this.meanData.getFunctionProfile((Function)object3);
                if (object2 == null) {
                    object2 = new FunctionProfile((Function)object3, n3, this.meanData.getNumSnapshots());
                    this.meanData.addFunctionProfile((FunctionProfile)object2);
                }
                ((Function)object3).setMeanProfile((FunctionProfile)object2);
                object = this.totalData.getFunctionProfile((Function)object3);
                if (object == null) {
                    object = new FunctionProfile((Function)object3, n3, this.meanData.getNumSnapshots());
                    this.totalData.addFunctionProfile((FunctionProfile)object);
                }
                ((Function)object3).setTotalProfile((FunctionProfile)object);
                FunctionProfile functionProfile = this.stddevData.getFunctionProfile((Function)object3);
                if (functionProfile == null) {
                    functionProfile = new FunctionProfile((Function)object3, n3, this.meanData.getNumSnapshots());
                    this.stddevData.addFunctionProfile(functionProfile);
                }
                ((Function)object3).setStddevProfile(functionProfile);
                int n8 = 0;
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 0.0;
                double d4 = 0.0;
                for (n7 = 0; n7 < n3; ++n7) {
                    dArray[n7] = 0.0;
                    dArray2[n7] = 0.0;
                    dArray3[n7] = 0.0;
                    dArray4[n7] = 0.0;
                }
                n7 = this.allThreads.size();
                for (n6 = 0; n6 < n7; ++n6) {
                    Thread thread2 = (Thread)this.allThreads.get(n6);
                    FunctionProfile functionProfile2 = thread2.getFunctionProfile((Function)object3);
                    int n9 = i;
                    if (!this.wellBehavedSnapshots) {
                        n9 = thread2.getNumSnapshots() - 1;
                    }
                    if (functionProfile2 == null) continue;
                    ++n8;
                    for (int j = n; j <= n2; ++j) {
                        int n10 = j;
                        dArray[n10] = dArray[n10] + functionProfile2.getExclusive(n9, j);
                        int n11 = j;
                        dArray2[n11] = dArray2[n11] + functionProfile2.getInclusive(n9, j);
                        int n12 = j;
                        dArray3[n12] = dArray3[n12] + functionProfile2.getExclusive(n9, j) * functionProfile2.getExclusive(n9, j);
                        int n13 = j;
                        dArray4[n13] = dArray4[n13] + functionProfile2.getInclusive(n9, j) * functionProfile2.getInclusive(n9, j);
                        if (j != 0) continue;
                        d += functionProfile2.getNumCalls(n9);
                        d2 += functionProfile2.getNumSubr(n9);
                        d3 += functionProfile2.getNumCalls(n9) * functionProfile2.getNumCalls(n9);
                        d4 += functionProfile2.getNumSubr(n9) * functionProfile2.getNumSubr(n9);
                    }
                }
                n6 = n7;
                if (!meanIncludeNulls) {
                    n6 = n8;
                }
                if (n == 0) {
                    ((FunctionProfile)object).setNumCalls(i, d);
                    ((FunctionProfile)object).setNumSubr(i, d2);
                    ((FunctionProfile)object2).setNumCalls(i, d / (double)n6);
                    ((FunctionProfile)object2).setNumSubr(i, d2 / (double)n6);
                    double d5 = 0.0;
                    if (n6 > 1) {
                        d5 = Math.sqrt(Math.abs(d3 / (double)n6 - ((FunctionProfile)object2).getNumCalls(i) * ((FunctionProfile)object2).getNumCalls(i)));
                    }
                    functionProfile.setNumCalls(i, d5);
                    d5 = 0.0;
                    if (n6 > 1) {
                        d5 = Math.sqrt(Math.abs(d4 / (double)n6 - ((FunctionProfile)object2).getNumSubr(i) * ((FunctionProfile)object2).getNumSubr(i)));
                    }
                    functionProfile.setNumSubr(i, d5);
                }
                for (int j = n; j <= n2; ++j) {
                    ((FunctionProfile)object).setExclusive(i, j, dArray[j]);
                    ((FunctionProfile)object).setInclusive(i, j, dArray2[j]);
                    ((FunctionProfile)object2).setExclusive(i, j, dArray[j] / (double)n6);
                    ((FunctionProfile)object2).setInclusive(i, j, dArray2[j] / (double)n6);
                    double d6 = 0.0;
                    if (n6 > 1) {
                        d6 = Math.sqrt(Math.abs(dArray3[j] / (double)n6 - ((FunctionProfile)object2).getExclusive(i, j) * ((FunctionProfile)object2).getExclusive(i, j)));
                    }
                    functionProfile.setExclusive(i, j, d6);
                    d6 = 0.0;
                    if (n6 > 1) {
                        d6 = Math.sqrt(Math.abs(dArray4[j] / (double)n6 - ((FunctionProfile)object2).getInclusive(i, j) * ((FunctionProfile)object2).getInclusive(i, j)));
                    }
                    functionProfile.setInclusive(i, j, d6);
                }
            }
        }
        int[] nArray = this.getMaxNCTNumbers();
        this.hasContexts = nArray[1] > 0;
        this.hasThreads = nArray[2] > 0;
    }

    public Node addNode(int n) {
        Object v = this.nodes.get(new Integer(n));
        if (v != null) {
            return (Node)v;
        }
        Node node = new Node(n, this);
        this.nodes.put(new Integer(n), node);
        return node;
    }

    public Thread addThread(int n, int n2, int n3) {
        Node node = this.addNode(n);
        Context context = node.addContext(n2);
        Thread thread = context.addThread(n3, this.getNumberOfMetrics());
        this.allThreads = null;
        return thread;
    }

    public Node getNode(int n) {
        return (Node)this.nodes.get(new Integer(n));
    }

    public int getNumberOfNodes() {
        return this.nodes.size();
    }

    public Iterator getNodes() {
        return this.nodes.values().iterator();
    }

    public int getTotalNumberOfContexts() {
        int n = -1;
        Iterator iterator = this.getNodes();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            n += node.getNumberOfContexts();
        }
        return n;
    }

    public int getNumberOfContexts(int n) {
        return this.getNode(n).getNumberOfContexts();
    }

    public Iterator getContexts(int n) {
        Node node = this.getNode(n);
        if (node != null) {
            return node.getContexts();
        }
        return null;
    }

    public Context getContext(int n, int n2) {
        Node node = this.getNode(n);
        if (node != null) {
            return node.getContext(n2);
        }
        return null;
    }

    public int getTotalNumberOfThreads() {
        int n = 0;
        Iterator iterator = this.getNodes();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            Iterator iterator2 = node.getContexts();
            while (iterator2.hasNext()) {
                Context context = (Context)iterator2.next();
                n += context.getNumberOfThreads();
            }
        }
        return n;
    }

    public int getNumberOfThreads(int n, int n2) {
        return this.getContext(n, n2).getNumberOfThreads();
    }

    public List getThreads() {
        ArrayList<Thread> arrayList = new ArrayList<Thread>();
        Iterator iterator = this.getNodes();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            Iterator iterator2 = node.getContexts();
            while (iterator2.hasNext()) {
                Context context = (Context)iterator2.next();
                Iterator iterator3 = context.getThreads();
                while (iterator3.hasNext()) {
                    Thread thread = (Thread)iterator3.next();
                    arrayList.add(thread);
                }
            }
        }
        return arrayList;
    }

    public Thread getThread(int n, int n2, int n3) {
        if (n == -1) {
            return this.getMeanData();
        }
        if (n == -3) {
            return this.getStdDevData();
        }
        Context context = this.getContext(n, n2);
        Thread thread = null;
        if (context != null) {
            thread = context.getThread(n3);
        }
        return thread;
    }

    private void initAllThreadsList() {
        this.allThreads = new ArrayList();
        Iterator iterator = this.getNodes();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            Iterator iterator2 = node.getContexts();
            while (iterator2.hasNext()) {
                Context context = (Context)iterator2.next();
                Iterator iterator3 = context.getThreads();
                while (iterator3.hasNext()) {
                    Thread thread = (Thread)iterator3.next();
                    this.allThreads.add(thread);
                }
            }
        }
    }

    public List getAllThreads() {
        if (this.allThreads == null) {
            this.initAllThreadsList();
        }
        return this.allThreads;
    }

    public static void setMeanIncludeNulls(boolean bl) {
        meanIncludeNulls = bl;
    }

    protected void checkForPhases() {
        Group group = this.getGroup("TAU_PHASE");
        if (group != null) {
            Function function;
            this.phasesPresent = true;
            Iterator iterator = this.getFunctions();
            while (iterator.hasNext()) {
                function = (Function)iterator.next();
                if (!function.isGroupMember(group)) continue;
                function.setPhase(true);
                function.setActualPhase(function);
            }
            iterator = this.getFunctions();
            while (iterator.hasNext()) {
                function = (Function)iterator.next();
                int n = function.getName().indexOf("=>");
                if (n <= 0) continue;
                String string = UtilFncs.getLeftSide(function.getName());
                String string2 = UtilFncs.getRightSide(function.getName());
                Function function2 = this.getFunction(string2);
                if (function2.isPhase()) {
                    function.setPhase(true);
                    function.setActualPhase(function2);
                }
                function.setParentPhase(this.getFunction(string));
            }
        }
    }

    protected void finishPhaseAnalysis() {
        if (this.phasesPresent) {
            Function function;
            Group group = this.getGroup("TAU_PHASE");
            ArrayList<Function> arrayList = new ArrayList<Function>();
            Iterator iterator = this.getFunctions();
            while (iterator.hasNext()) {
                function = (Function)iterator.next();
                if (!function.isGroupMember(group)) continue;
                arrayList.add(function);
            }
            if (arrayList.size() == 0) {
                throw new RuntimeException("Error: TAU_PHASE found, but no phases!");
            }
            this.topLevelPhase = (Function)arrayList.get(0);
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                function = (Function)iterator.next();
                if (!(function.getMeanInclusive(0) > this.topLevelPhase.getMeanInclusive(0))) continue;
                this.topLevelPhase = function;
            }
        }
    }

    public boolean getPhasesPresent() {
        return this.phasesPresent;
    }

    public Function getTopLevelPhase() {
        return this.topLevelPhase;
    }

    public boolean getGenerateIntermediateCallPathData() {
        return this.generateIntermediateCallPathData;
    }

    public void setGenerateIntermediateCallPathData(boolean bl) {
        this.generateIntermediateCallPathData = bl;
    }

    public boolean getReverseDataAvailable() {
        return this.reverseDataAvailable;
    }

    public Map getMetaData() {
        return this.metaData;
    }

    public void setMetaData(Map map) {
        this.metaData = map;
    }

    public void buildXMLMetaData() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement("tau:metadata");
            element.setAttribute("xmlns:tau", "http://www.cs.uoregon.edu/research/tau");
            document.appendChild(element);
            Element element2 = null;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ArrayList<Boolean> arrayList2 = new ArrayList<Boolean>();
            if (this.metaData.size() > 0) {
                element2 = document.createElement("tau:CommonProfileAttributes");
                element.appendChild(element2);
                object7 = this.metaData.keySet().iterator();
                while (object7.hasNext()) {
                    object6 = (String)object7.next();
                    object5 = (String)this.metaData.get(object6);
                    Element element3 = document.createElement("tau:attribute");
                    element2.appendChild(element3);
                    object4 = document.createElement("tau:name");
                    element3.appendChild((org.w3c.dom.Node)object4);
                    object4.appendChild(document.createTextNode((String)object6));
                    object3 = document.createElement("tau:value");
                    element3.appendChild((org.w3c.dom.Node)object3);
                    object3.appendChild(document.createTextNode((String)object5));
                }
            }
            object7 = this.getAllThreads().iterator();
            while (object7.hasNext()) {
                object6 = (Thread)object7.next();
                object5 = document.createElement("tau:ProfileAttributes");
                object5.setAttribute("node", Integer.toString(((Thread)object6).getNodeID()));
                object5.setAttribute("context", Integer.toString(((Thread)object6).getContextID()));
                object5.setAttribute("thread", Integer.toString(((Thread)object6).getThreadID()));
                boolean bl = false;
                object4 = ((Thread)object6).getMetaData().keySet().iterator();
                while (object4.hasNext()) {
                    object3 = (String)object4.next();
                    object2 = (String)((Thread)object6).getMetaData().get(object3);
                    if (this.metaData.containsKey(object3)) continue;
                    object = document.createElement("tau:attribute");
                    object5.appendChild((org.w3c.dom.Node)object);
                    Element element4 = document.createElement("tau:name");
                    object.appendChild(element4);
                    element4.appendChild(document.createTextNode((String)object3));
                    Element element5 = document.createElement("tau:value");
                    object.appendChild(element5);
                    element5.appendChild(document.createTextNode((String)object2));
                    bl = true;
                }
                arrayList.add(object5);
                if (bl) {
                    element.appendChild((org.w3c.dom.Node)object5);
                    arrayList2.add(new Boolean(true));
                    continue;
                }
                arrayList2.add(new Boolean(false));
            }
            if (this.metadataFile != null) {
                object7 = documentBuilder.parse(this.metadataFile);
                object6 = object7.getDocumentElement();
                object5 = document.importNode((org.w3c.dom.Node)object6, true);
                System.out.println(object5.getPrefix());
                System.out.println(object5.getNodeName());
                if (element2 != null && object5.getNodeType() == 1 && object5.getNodeName().equals("tau:metadata")) {
                    NodeList nodeList = object5.getChildNodes();
                    int n = 0;
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        object2 = nodeList.item(i);
                        if (object2.getNodeType() == 1 && object2.getNodeName().equals("tau:CommonProfileAttributes")) {
                            object = object2.getChildNodes();
                            for (int j = 0; j < object.getLength(); ++j) {
                                org.w3c.dom.Node node = object.item(j);
                                if (node.getNodeType() != 1 || !node.getNodeName().equals("tau:attribute")) continue;
                                element2.appendChild(node);
                            }
                            continue;
                        }
                        if (object2.getNodeType() != 1 || !object2.getNodeName().equals("tau:ProfileAttributes")) continue;
                        object = (Element)arrayList.get(n);
                        if (((Boolean)arrayList2.get(n)).booleanValue()) {
                            NodeList nodeList2 = object2.getChildNodes();
                            for (int j = 0; j < nodeList2.getLength(); ++j) {
                                org.w3c.dom.Node node = nodeList2.item(j);
                                if (node.getNodeType() != 1 || !node.getNodeName().equals("tau:attribute")) continue;
                                object.appendChild(node);
                            }
                        } else {
                            element.appendChild((org.w3c.dom.Node)object2);
                        }
                        ++n;
                    }
                } else {
                    element.appendChild((org.w3c.dom.Node)object5);
                }
            }
            document.getDocumentElement().normalize();
            object7 = TransformerFactory.newInstance();
            object6 = ((TransformerFactory)object7).newTransformer();
            object5 = new DOMSource(document);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            StreamResult streamResult = new StreamResult(byteArrayOutputStream);
            ((Transformer)object6).transform((Source)object5, streamResult);
            if (element.hasChildNodes()) {
                this.metadataString.append(byteArrayOutputStream.toString());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void aggregateMetaData() {
        String string;
        Iterator iterator;
        Object object;
        Thread thread = (Thread)this.getAllThreads().get(0);
        if (thread == null) {
            return;
        }
        Iterator<Object> iterator2 = thread.getMetaData().keySet().iterator();
        while (iterator2.hasNext()) {
            object = (String)iterator2.next();
            iterator = (String)thread.getMetaData().get(object);
            this.metaData.put(object, iterator);
        }
        iterator2 = this.getAllThreads().iterator();
        while (iterator2.hasNext()) {
            object = (Thread)iterator2.next();
            iterator = ((Thread)object).getMetaData().keySet().iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                String string2 = (String)((Thread)object).getMetaData().get(string);
                String string3 = (String)this.metaData.get(string);
                if (string3 != null && string2.equals(string3)) continue;
                this.metaData.remove(string);
                this.uncommonMetaData.put(string, string2);
            }
        }
        iterator2 = this.getAllThreads().iterator();
        while (iterator2.hasNext()) {
            object = (Thread)iterator2.next();
            iterator = this.metaData.keySet().iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                ((Thread)object).getMetaData().remove(string);
            }
        }
    }

    public void setMetadataFile(String string) throws IOException {
        this.metadataFile = new File(string);
        if (!this.metadataFile.exists()) {
            throw new FileNotFoundException("The file " + string + " does not exist.");
        }
        if (!this.metadataFile.canRead()) {
            throw new IOException("The file " + string + " does not have read permission.");
        }
        if (!this.metadataFile.isFile()) {
            throw new FileNotFoundException(string + " is not a valid file.");
        }
    }

    public String getMetadataString() {
        return this.metadataString.toString();
    }

    public boolean getWellBehavedSnapshots() {
        return this.wellBehavedSnapshots;
    }

    public Map getUncommonMetaData() {
        return this.uncommonMetaData;
    }

    public boolean getHasThreads() {
        return this.hasThreads;
    }

    public boolean getHasContexts() {
        return this.hasContexts;
    }

    public int getExecutionType() {
        if (this.getAllThreads().size() == 1) {
            if (this.hasMPI) {
                return 1;
            }
            return 0;
        }
        if (!this.getHasContexts() && !this.getHasThreads()) {
            return 1;
        }
        if (!this.getHasContexts()) {
            return 3;
        }
        return 4;
    }
}

