/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.common.Utility;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.Group;
import edu.uoregon.tau.perfdmf.Thread;
import edu.uoregon.tau.perfdmf.UtilFncs;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class EBSTraceReader {
    private static String reader_version = "0.2";
    private DataSource dataSource;
    private Map sampleMap = new HashMap();
    private int node = -1;
    private int tid = -1;
    private static boolean showCallSites = false;
    private Group callpathGroup;
    private Group sampleGroup;
    private Thread thread;

    public EBSTraceReader(DataSource dataSource) {
        this.dataSource = dataSource;
        this.callpathGroup = dataSource.getGroup("TAU_CALLPATH");
        this.sampleGroup = dataSource.addGroup("TAU_SAMPLE");
    }

    private void addSample(String string, String string2) {
        HashMap<String, Integer> hashMap = (HashMap<String, Integer>)this.sampleMap.get(string2);
        if (hashMap != null) {
            Integer n = (Integer)hashMap.get(string);
            if (n != null) {
                hashMap.put(string, new Integer(n + 1));
            } else {
                hashMap.put(string, new Integer(1));
            }
        } else {
            hashMap = new HashMap<String, Integer>();
            hashMap.put(string, new Integer(1));
            this.sampleMap.put(string2, hashMap);
        }
    }

    private boolean stackMatch(String string, String string2) {
        String[] stringArray = string2.split(":");
        String string3 = stringArray[0];
        if (string3.endsWith("()")) {
            string3 = string3.substring(0, string3.length() - 2);
        }
        return string.equals(string3);
    }

    private String resolveCallpath(String string, String string2) {
        int n;
        int n2;
        String[] stringArray = string.split("=>");
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].trim();
        }
        String[] stringArray2 = string2.split("=>");
        for (n2 = 0; n2 < stringArray2.length; ++n2) {
            stringArray2[n2] = stringArray2[n2].trim();
        }
        n2 = 0;
        int n3 = 0;
        block2: for (int i = stringArray.length - 1; i >= 0; --i) {
            for (n = stringArray2.length - 1; n >= 0; --n) {
                if (!this.stackMatch(stringArray[i], stringArray2[n])) continue;
                n2 = n;
                n3 = i;
                break block2;
            }
        }
        String string3 = null;
        for (n = 0; n < stringArray.length; ++n) {
            string3 = string3 == null ? stringArray[n] : string3 + " => " + stringArray[n];
        }
        for (n = n2; n < stringArray2.length; ++n) {
            string3 = string3 == null ? stringArray2[n] : string3 + " => " + stringArray2[n];
        }
        return string3;
    }

    private void addIntermediateNodes(Thread thread, String string, int n, double d, Group group) {
        String[] stringArray = string.split("=>");
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].trim();
        }
        String string2 = stringArray[0];
        for (int i = 1; i < stringArray.length; ++i) {
            string2 = string2 + " => " + stringArray[i];
            Function function = this.dataSource.addFunction(string2);
            function.addGroup(group);
            FunctionProfile functionProfile = thread.getOrCreateFunctionProfile(function, this.dataSource.getNumberOfMetrics());
            if (functionProfile.getNumCalls() != 0.0) continue;
            functionProfile.setInclusive(n, functionProfile.getInclusive(n) + d);
        }
    }

    private void processMap() {
        Thread thread = this.dataSource.getThread(this.node, 0, this.tid);
        Group group = this.dataSource.getGroup("TAU_CALLPATH");
        Group group2 = this.dataSource.addGroup("TAU_SAMPLE");
        Iterator iterator = this.sampleMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            String string = (String)iterator.next();
            Map map = (Map)this.sampleMap.get(string);
            int n = 0;
            Object object2 = map.values().iterator();
            while (object2.hasNext()) {
                object = (Integer)object2.next();
                n += ((Integer)object).intValue();
            }
            object2 = this.dataSource.getFunction(string = Utility.removeRuns((String)string));
            if (object2 == null) {
                System.err.println("Error: callpath not found in profile: \"" + string + "\"");
                continue;
            }
            object = thread.getFunctionProfile((Function)object2);
            FunctionProfile functionProfile = null;
            if (string.lastIndexOf("=>") != -1) {
                String string2 = string.substring(string.lastIndexOf("=>") + 2).trim();
                Function function = this.dataSource.getFunction(string2);
                if (function == null) {
                    System.err.println("Error: function not found in profile: " + string2);
                    continue;
                }
                functionProfile = thread.getFunctionProfile(function);
            }
            for (int i = 0; i < this.dataSource.getNumberOfMetrics(); ++i) {
                double d = ((FunctionProfile)object).getExclusive(i);
                double d2 = d / (double)n;
                ((FunctionProfile)object).setExclusive(i, 0.0);
                if (functionProfile != null) {
                    functionProfile.setExclusive(i, 0.0);
                }
                Iterator iterator2 = map.keySet().iterator();
                while (iterator2.hasNext()) {
                    String string3 = (String)iterator2.next();
                    int n2 = (Integer)map.get(string3);
                    double d3 = d2 * (double)n2;
                    String string4 = string + " => " + string3;
                    Function function = this.dataSource.addFunction(string4);
                    function.addGroup(group);
                    function.addGroup(group2);
                    FunctionProfile functionProfile2 = thread.getOrCreateFunctionProfile(function, this.dataSource.getNumberOfMetrics());
                    functionProfile2.setInclusive(i, functionProfile2.getInclusive(i) + d3);
                    functionProfile2.setExclusive(i, functionProfile2.getExclusive(i) + d3);
                    functionProfile2.setNumCalls(functionProfile2.getNumCalls() + (double)n2);
                    this.addIntermediateNodes(thread, string4, i, d3, group);
                    if (string4.lastIndexOf("=>") == -1) continue;
                    String string5 = UtilFncs.getRightMost(string4);
                    Function function2 = this.dataSource.addFunction(string5);
                    function.addGroup(group2);
                    FunctionProfile functionProfile3 = thread.getOrCreateFunctionProfile(function2, this.dataSource.getNumberOfMetrics());
                    functionProfile3.setInclusive(i, functionProfile3.getInclusive(i) + d3);
                    functionProfile3.setExclusive(i, functionProfile3.getExclusive(i) + d3);
                    functionProfile3.setNumCalls(functionProfile3.getNumCalls() + (double)n2);
                }
            }
        }
    }

    private static String stripFileLine(String string) {
        try {
            int n = string.lastIndexOf(58);
            int n2 = string.lastIndexOf(58, n - 1);
            return "[INTERMEDIATE] " + string.substring(0, n2);
        }
        catch (Exception exception) {
            System.out.println("Location = " + string);
            exception.printStackTrace();
            return string;
        }
    }

    private static String stripPath(String string) {
        try {
            int n = string.lastIndexOf(58);
            int n2 = string.lastIndexOf(58, n - 1);
            String string2 = string.substring(0, n2);
            String string3 = string.substring(n2 + 1, n);
            String string4 = string.substring(n + 1);
            String string5 = string3.substring(string3.lastIndexOf("/") + 1);
            return string2 + ":" + string5 + ":" + string4;
        }
        catch (Exception exception) {
            System.out.println("Location = " + string);
            exception.printStackTrace();
            return string;
        }
    }

    public static void main(String[] stringArray) {
        System.out.println(EBSTraceReader.stripFileLine("foo:bar.cc:2060"));
    }

    private void processEBSTrace(DataSource dataSource, File file) {
        block19: {
            try {
                this.sampleMap.clear();
                this.node = -1;
                FileInputStream fileInputStream = new FileInputStream(file);
                InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String string = bufferedReader.readLine();
                while (string != null) {
                    Object object;
                    if (string.startsWith("#")) {
                        if (string.startsWith("# Format version:") && !((String)(object = string.substring("# Format version:".length() + 1).trim())).equals(reader_version)) {
                            String string2 = "Wrong EBS version, we are looking for " + reader_version + ", but found " + (String)object;
                            System.err.println(string2);
                            throw new RuntimeException(string2);
                        }
                        if (string.startsWith("# node:")) {
                            object = string.substring(8);
                            this.node = Integer.parseInt((String)object);
                            if (this.tid != -1) {
                                this.thread = dataSource.getThread(this.node, 0, this.tid);
                            }
                        }
                        if (string.startsWith("# thread:")) {
                            object = string.substring(10);
                            this.tid = Integer.parseInt((String)object);
                            if (this.node != -1) {
                                this.thread = dataSource.getThread(this.node, 0, this.tid);
                            }
                        }
                    } else {
                        object = string.split("\\|");
                        long l = Long.parseLong(object[0].trim());
                        long l2 = Long.parseLong(object[1].trim());
                        long l3 = Long.parseLong(((String)object[2]).trim());
                        String string3 = ((String)object[3]).trim();
                        String string4 = ((String)object[4]).trim();
                        String string5 = ((String)object[5]).trim();
                        if (!string5.startsWith("??:")) {
                            try {
                                ArrayList<String> arrayList = new ArrayList<String>();
                                String[] stringArray = string5.split("@");
                                int n = stringArray.length;
                                if (n > 1) {
                                    --n;
                                }
                                for (int i = 0; i < n; ++i) {
                                    if (showCallSites) {
                                        arrayList.add(stringArray[i]);
                                        continue;
                                    }
                                    if (i == 0) {
                                        arrayList.add(EBSTraceReader.stripPath(stringArray[i]));
                                        continue;
                                    }
                                    arrayList.add(EBSTraceReader.stripFileLine(stringArray[i]));
                                }
                                Collections.reverse(arrayList);
                                String string6 = null;
                                Iterator iterator = arrayList.iterator();
                                while (iterator.hasNext()) {
                                    if (string6 == null) {
                                        string6 = (String)iterator.next();
                                        continue;
                                    }
                                    string6 = string6 + " => " + iterator.next();
                                }
                                this.addSample(string6, string4);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                                System.out.println(string);
                            }
                        }
                    }
                    string = bufferedReader.readLine();
                }
                this.processMap();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (exception instanceof IOException || exception instanceof FileNotFoundException) break block19;
                throw new RuntimeException(exception == null ? null : exception.toString());
            }
        }
    }

    public static void processEBSTraces(DataSource dataSource, File file) {
        long l = System.currentTimeMillis();
        if (!file.isDirectory()) {
            return;
        }
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.startsWith("ebstrace.processed.");
            }
        };
        File[] fileArray = file.listFiles(filenameFilter);
        EBSTraceReader eBSTraceReader = new EBSTraceReader(dataSource);
        for (int i = 0; i < fileArray.length; ++i) {
            eBSTraceReader.processEBSTrace(dataSource, fileArray[i]);
        }
        l = System.currentTimeMillis() - l;
    }
}

