/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.common.AlphanumComparator;
import edu.uoregon.tau.perfdmf.Database;
import edu.uoregon.tau.perfdmf.DatabaseException;
import edu.uoregon.tau.perfdmf.database.DB;
import edu.uoregon.tau.perfdmf.database.DBConnector;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Vector;

public class Experiment
implements Serializable,
Comparable {
    private int experimentID;
    private int applicationID;
    private String name;
    private String[] fields;
    private Database database;
    private static AlphanumComparator alphanum = new AlphanumComparator();

    public Experiment() {
        this.fields = new String[0];
    }

    public Experiment(Experiment experiment) {
        this.name = experiment.getName();
        this.applicationID = experiment.getApplicationID();
        this.experimentID = experiment.getID();
        this.fields = (String[])experiment.fields.clone();
        this.database = experiment.database;
    }

    public String[] getFields() {
        return this.fields;
    }

    public void setFields(String[] stringArray) {
        this.fields = stringArray;
    }

    public static void getMetaData(DB dB) {
        Database database = dB.getDatabase();
        if (database.getExpFieldNames() != null) {
            return;
        }
        try {
            Object object;
            ResultSet resultSet = null;
            Object var3_4 = null;
            Object var4_5 = null;
            DatabaseMetaData databaseMetaData = dB.getMetaData();
            resultSet = dB.getDBType().compareTo("oracle") == 0 || dB.getDBType().compareTo("derby") == 0 || dB.getDBType().compareTo("db2") == 0 ? databaseMetaData.getColumns(null, null, "EXPERIMENT", "%") : databaseMetaData.getColumns(null, null, "experiment", "%");
            Vector<String> vector = new Vector<String>();
            Vector<Integer> vector2 = new Vector<Integer>();
            boolean bl = false;
            while (resultSet.next()) {
                int n = resultSet.getInt("DATA_TYPE");
                object = resultSet.getString("COLUMN_NAME");
                String string = resultSet.getString("TYPE_NAME");
                if (((String)object).equals("ID")) {
                    if (bl) break;
                    bl = true;
                }
                if (!DBConnector.isReadAbleType(n) || ((String)object).toUpperCase().compareTo("ID") == 0 || ((String)object).toUpperCase().compareTo("NAME") == 0 || ((String)object).toUpperCase().compareTo("APPLICATION") == 0) continue;
                vector.add(resultSet.getString("COLUMN_NAME"));
                vector2.add(new Integer(n));
            }
            resultSet.close();
            String[] stringArray = new String[vector.size()];
            object = new int[vector2.size()];
            for (int i = 0; i < vector2.size(); ++i) {
                stringArray[i] = (String)vector.get(i);
                object[i] = (Integer)vector2.get(i);
            }
            database.setExpFieldNames(stringArray);
            database.setExpFieldTypes((int[])object);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public int getNumFields() {
        return this.fields.length;
    }

    public String getFieldName(int n) {
        return this.database.getExpFieldNames()[n];
    }

    public String getField(int n) {
        return this.fields[n];
    }

    public int getFieldType(int n) {
        return this.database.getExpFieldTypes()[n];
    }

    public void setField(int n, String string) {
        if (DBConnector.isIntegerType(this.database.getExpFieldTypes()[n]) && string != null) {
            try {
                int n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
        }
        if (DBConnector.isFloatingPointType(this.database.getExpFieldTypes()[n]) && string != null) {
            try {
                double d = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
        }
        this.fields[n] = string;
    }

    public int getID() {
        return this.experimentID;
    }

    public int getApplicationID() {
        return this.applicationID;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public void setID(int n) {
        this.experimentID = n;
    }

    public void setApplicationID(int n) {
        this.applicationID = n;
    }

    public void setName(String string) {
        this.name = string;
    }

    public static String[] getFieldNames(DB dB) throws DatabaseException {
        Experiment.getMetaData(dB);
        return dB.getDatabase().getExpFieldNames();
    }

    public static Vector getExperimentList(DB dB, String string) throws DatabaseException {
        try {
            Experiment.getMetaData(dB);
            Database database = dB.getDatabase();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("select id, application, name");
            for (int i = 0; i < database.getExpFieldNames().length; ++i) {
                stringBuffer.append(", " + database.getExpFieldNames()[i]);
            }
            stringBuffer.append(" from ");
            stringBuffer.append(dB.getSchemaPrefix());
            stringBuffer.append("experiment ");
            stringBuffer.append(string);
            if (dB.getDBType().compareTo("oracle") == 0) {
                stringBuffer.append(" order by dbms_lob.substr(name), id asc");
            } else if (dB.getDBType().compareTo("derby") == 0) {
                stringBuffer.append(" order by cast(name as varchar(256)), id asc");
            } else if (dB.getDBType().compareTo("db2") == 0) {
                stringBuffer.append(" order by cast(name as varchar(256)), id asc");
            } else {
                stringBuffer.append(" order by name, id asc ");
            }
            Vector<Experiment> vector = new Vector<Experiment>();
            ResultSet resultSet = dB.executeQuery(stringBuffer.toString());
            while (resultSet.next()) {
                Experiment experiment = new Experiment();
                experiment.setDatabase(dB.getDatabase());
                experiment.setID(resultSet.getInt(1));
                experiment.setApplicationID(resultSet.getInt(2));
                experiment.setName(resultSet.getString(3));
                for (int i = 0; i < database.getExpFieldNames().length; ++i) {
                    experiment.setField(i, resultSet.getString(i + 4));
                }
                vector.addElement(experiment);
            }
            resultSet.close();
            Collections.sort(vector);
            return vector;
        }
        catch (SQLException sQLException) {
            throw new DatabaseException("Error getting experiment list", sQLException);
        }
    }

    public int saveExperiment(DB dB) throws SQLException {
        int n;
        boolean bl = this.exists(dB);
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append("UPDATE " + dB.getSchemaPrefix() + "experiment SET application = ?, name = ?");
            for (n = 0; n < this.getNumFields(); ++n) {
                if (!DBConnector.isWritableType(this.getFieldType(n))) continue;
                stringBuffer.append(", " + this.getFieldName(n) + " = ?");
            }
            stringBuffer.append(" WHERE id = ?");
        } else {
            stringBuffer.append("INSERT INTO " + dB.getSchemaPrefix() + "experiment (application, name");
            for (n = 0; n < this.getNumFields(); ++n) {
                if (!DBConnector.isWritableType(this.getFieldType(n))) continue;
                stringBuffer.append(", " + this.getFieldName(n));
            }
            stringBuffer.append(") VALUES (?, ?");
            for (n = 0; n < this.getNumFields(); ++n) {
                if (!DBConnector.isWritableType(this.getFieldType(n))) continue;
                stringBuffer.append(", ?");
            }
            stringBuffer.append(")");
        }
        PreparedStatement preparedStatement = dB.prepareStatement(stringBuffer.toString());
        int n3 = 1;
        preparedStatement.setInt(n3++, this.applicationID);
        preparedStatement.setString(n3++, this.name);
        for (int i = 0; i < this.getNumFields(); ++i) {
            if (!DBConnector.isWritableType(this.getFieldType(i))) continue;
            preparedStatement.setString(n3++, this.getField(i));
        }
        if (bl) {
            preparedStatement.setInt(n3++, this.getID());
        }
        preparedStatement.executeUpdate();
        preparedStatement.close();
        if (bl) {
            n2 = this.experimentID;
        } else {
            String string = new String();
            string = dB.getDBType().compareTo("mysql") == 0 ? "select LAST_INSERT_ID();" : (dB.getDBType().compareTo("db2") == 0 ? "select IDENTITY_VAL_LOCAL() FROM experiment" : (dB.getDBType().compareTo("derby") == 0 ? "select IDENTITY_VAL_LOCAL() FROM experiment" : (dB.getDBType().compareTo("oracle") == 0 ? "select " + dB.getSchemaPrefix() + "experiment_id_seq.currval FROM dual" : "select currval('experiment_id_seq');")));
            n2 = Integer.parseInt(dB.getDataItem(string));
        }
        return n2;
    }

    private boolean exists(DB dB) throws SQLException {
        boolean bl = false;
        PreparedStatement preparedStatement = dB.prepareStatement("SELECT application FROM " + dB.getSchemaPrefix() + "experiment WHERE id = ?");
        preparedStatement.setInt(1, this.experimentID);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            bl = true;
        }
        resultSet.close();
        return bl;
    }

    public static void deleteExperiment(DB dB, int n) throws DatabaseException {
        try {
            PreparedStatement preparedStatement = null;
            preparedStatement = dB.prepareStatement("delete from " + dB.getSchemaPrefix() + "experiment where id = ?");
            preparedStatement.setInt(1, n);
            preparedStatement.execute();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            throw new DatabaseException("Error deleting experiment", sQLException);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    public Database getDatabase() {
        return this.database;
    }

    public void setDatabase(Database database) {
        this.database = database;
        this.fields = new String[database.getExpFieldNames().length];
    }

    public int compareTo(Object object) {
        return alphanum.compare((Object)this.getName(), (Object)((Experiment)object).getName());
    }
}

