/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.common.TrackerInputStream;
import edu.uoregon.tau.perfdmf.Context;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Node;
import edu.uoregon.tau.perfdmf.Thread;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;

public class GPTLDataSource
extends DataSource {
    private int linenumber = 0;
    private int currentProcess = 0;
    private int currentThread = 0;
    private File file = null;
    private GlobalData globalData = null;
    private volatile long totalBytes = 0L;
    private volatile TrackerInputStream tracker;

    public GPTLDataSource(File file) {
        this.file = file;
    }

    public void cancelLoad() {
    }

    public int getProgress() {
        if (this.totalBytes != 0L) {
            return (int)((float)this.tracker.byteCount() / (float)this.totalBytes * 100.0f);
        }
        return 0;
    }

    public void load() throws FileNotFoundException, IOException {
        long l = System.currentTimeMillis();
        Node node = null;
        Context context = null;
        Thread thread = null;
        int n = -1;
        FileInputStream fileInputStream = new FileInputStream(this.file);
        this.tracker = new TrackerInputStream((InputStream)fileInputStream);
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)this.tracker);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        this.totalBytes = this.file.length();
        this.globalData = this.processGlobalSection(bufferedReader);
        ThreadData threadData = this.processThreadData(bufferedReader);
        while (threadData != null) {
            node = this.addNode(threadData.processid);
            context = node.addContext(0);
            thread = context.addThread(threadData.threadid);
            for (int i = 0; i < threadData.eventData.size(); ++i) {
                EventData eventData = (EventData)threadData.eventData.get(i);
                this.createFunction(thread, eventData, false);
                if (i <= 0) continue;
                this.createFunction(thread, eventData, true);
            }
            this.generateDerivedData();
            threadData = this.processThreadData(bufferedReader);
        }
        this.setGroupNamesPresent(true);
        l = System.currentTimeMillis() - l;
        fileInputStream.close();
    }

    private void createFunction(Thread thread, EventData eventData, boolean bl) {
        Function function = null;
        FunctionProfile functionProfile = null;
        if (bl) {
            function = this.addFunction(eventData.callpathName);
            function.addGroup(this.addGroup("TAU_CALLPATH"));
        } else {
            function = this.addFunction(eventData.name);
            function.addGroup(this.addGroup("TAU_DEFAULT"));
        }
        functionProfile = new FunctionProfile(function, 3 + 2 * this.globalData.metrics.size());
        thread.addFunctionProfile(functionProfile);
        functionProfile.setNumCalls(eventData.calls);
        functionProfile.setNumSubr(eventData.children.size());
        Measurements measurements = eventData.inclusive;
        Measurements measurements2 = eventData.getExclusive();
        Metric metric = this.addMetric("WALL_CLOCK_TIME", thread);
        functionProfile.setInclusive(metric.getID(), measurements.wallclock * 1000000.0);
        functionProfile.setExclusive(metric.getID(), measurements2.wallclock * 1000000.0);
        metric = this.addMetric("WALL_CLOCK_TIME max", thread);
        functionProfile.setInclusive(metric.getID(), measurements.wallclockMax * 1000000.0);
        functionProfile.setExclusive(metric.getID(), measurements.wallclockMax * 1000000.0);
        metric = this.addMetric("WALL_CLOCK_TIME min", thread);
        functionProfile.setInclusive(metric.getID(), measurements.wallclockMin * 1000000.0);
        functionProfile.setExclusive(metric.getID(), measurements.wallclockMin * 1000000.0);
        for (int i = 0; i < this.globalData.metrics.size(); ++i) {
            String string = (String)this.globalData.metrics.get(i);
            metric = this.addMetric(string, thread);
            functionProfile.setInclusive(metric.getID(), measurements.papi[i]);
            functionProfile.setExclusive(metric.getID(), measurements2.papi[i]);
            metric = this.addMetric(string + " e6/sec", thread);
            functionProfile.setInclusive(metric.getID(), measurements.papiE6OverSeconds[i]);
            functionProfile.setExclusive(metric.getID(), measurements2.papiE6OverSeconds[i]);
        }
    }

    private GlobalData processGlobalSection(BufferedReader bufferedReader) {
        GlobalData globalData = new GlobalData();
        String string = null;
        String string2 = null;
        try {
            while ((string = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer;
                if (string.trim().startsWith("***** GLOBAL STATISTICS ")) {
                    stringTokenizer = new StringTokenizer(string, " \t\n\r");
                    string2 = stringTokenizer.nextToken();
                    string2 = stringTokenizer.nextToken();
                    string2 = stringTokenizer.nextToken();
                    string2 = stringTokenizer.nextToken();
                    string2 = stringTokenizer.nextToken();
                    globalData.numTasks = Integer.parseInt(string2);
                    continue;
                }
                if (string.trim().startsWith("name")) {
                    stringTokenizer = new StringTokenizer(string, " \t\n\r()");
                    string2 = stringTokenizer.nextToken();
                    string2 = stringTokenizer.nextToken();
                    string2 = stringTokenizer.nextToken();
                    string2 = stringTokenizer.nextToken();
                    string2 = stringTokenizer.nextToken();
                    string2 = stringTokenizer.nextToken();
                    string2 = stringTokenizer.nextToken();
                    string2 = stringTokenizer.nextToken();
                    while (stringTokenizer.hasMoreTokens()) {
                        string2 = stringTokenizer.nextToken();
                        globalData.metrics.add(string2.replaceAll("max", ""));
                        string2 = stringTokenizer.nextToken();
                        string2 = stringTokenizer.nextToken();
                        string2 = stringTokenizer.nextToken();
                        string2 = stringTokenizer.nextToken();
                        string2 = stringTokenizer.nextToken();
                    }
                    continue;
                }
                if (string.trim().length() != 0 || globalData.metrics.size() <= 0) continue;
                break;
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            iOException.printStackTrace();
        }
        return globalData;
    }

    private ThreadData processThreadData(BufferedReader bufferedReader) {
        ThreadData threadData = null;
        String string = null;
        String string2 = null;
        try {
            boolean bl = false;
            boolean bl2 = false;
            Stack<Object> stack = new Stack<Object>();
            while ((string = bufferedReader.readLine()) != null) {
                Object object;
                if (string.trim().startsWith("************ PROCESS")) {
                    bl2 = false;
                    threadData = new ThreadData();
                    object = new StringTokenizer(string, " \t\n\r()");
                    string2 = ((StringTokenizer)object).nextToken();
                    string2 = ((StringTokenizer)object).nextToken();
                    string2 = ((StringTokenizer)object).nextToken();
                    threadData.processid = Integer.parseInt(string2, 10);
                    continue;
                }
                if (string.trim().startsWith("Stats for thread 0:")) {
                    bl2 = false;
                    bl = true;
                    object = new StringTokenizer(string, " \t\n\r:");
                    string2 = ((StringTokenizer)object).nextToken();
                    string2 = ((StringTokenizer)object).nextToken();
                    string2 = ((StringTokenizer)object).nextToken();
                    string2 = ((StringTokenizer)object).nextToken();
                    threadData.threadid = Integer.parseInt(string2);
                    continue;
                }
                if (string.trim().startsWith("Called")) {
                    bl2 = false;
                    bl = true;
                    continue;
                }
                if (string.trim().startsWith("Overhead sum")) {
                    bl2 = false;
                    bl = false;
                    continue;
                }
                if (string.trim().startsWith("Total calls")) {
                    bl2 = false;
                    bl = false;
                    continue;
                }
                if (string.trim().startsWith("Total recursive calls")) {
                    bl2 = false;
                    bl = false;
                    continue;
                }
                if (string.trim().startsWith("thread")) {
                    bl2 = false;
                    bl = false;
                    continue;
                }
                if (string.trim().startsWith("hashtable")) {
                    bl2 = false;
                    bl = false;
                    continue;
                }
                if (string.trim().length() == 0) {
                    if (!bl2 || bl) {
                        bl2 = true;
                        continue;
                    }
                    break;
                }
                if (!bl) {
                    bl2 = false;
                    continue;
                }
                if (!bl) continue;
                bl2 = false;
                object = this.processEventLine(string);
                threadData.eventData.add(object);
                if (stack.empty()) {
                    stack.push(object);
                    continue;
                }
                EventData eventData = (EventData)stack.peek();
                if (((EventData)object).depth > eventData.depth) {
                    stack.push(object);
                    eventData.children.add(object);
                    ((EventData)object).callpathName = eventData.callpathName + " => " + ((EventData)object).callpathName;
                    continue;
                }
                if (((EventData)object).depth == eventData.depth) {
                    stack.pop();
                    eventData = (EventData)stack.peek();
                    eventData.children.add(object);
                    ((EventData)object).callpathName = eventData.callpathName + " => " + ((EventData)object).callpathName;
                    stack.push(object);
                    continue;
                }
                if (((EventData)object).depth >= eventData.depth) continue;
                while (((EventData)object).depth <= eventData.depth) {
                    stack.pop();
                    eventData = (EventData)stack.peek();
                }
                eventData.children.add(object);
                ((EventData)object).callpathName = eventData.callpathName + " => " + ((EventData)object).callpathName;
                stack.push(object);
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            iOException.printStackTrace();
        }
        return threadData;
    }

    private EventData processEventLine(String string) {
        EventData eventData = new EventData();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r()");
        eventData.name = stringTokenizer.nextToken();
        if (eventData.name.equals("*")) {
            eventData.name = stringTokenizer.nextToken();
            eventData.depth = string.length() - string.replaceFirst("\\*", "").trim().length();
        } else {
            eventData.depth = string.length() - string.trim().length();
        }
        eventData.callpathName = eventData.name;
        eventData.calls = Integer.parseInt(stringTokenizer.nextToken());
        stringTokenizer.nextToken();
        eventData.inclusive.wallclock = Double.parseDouble(stringTokenizer.nextToken());
        eventData.inclusive.wallclockMax = Double.parseDouble(stringTokenizer.nextToken());
        eventData.inclusive.wallclockMin = Double.parseDouble(stringTokenizer.nextToken());
        stringTokenizer.nextToken();
        eventData.inclusive.utrOverhead = Double.parseDouble(stringTokenizer.nextToken());
        eventData.inclusive.papi = new double[this.globalData.metrics.size()];
        eventData.inclusive.papiE6OverSeconds = new double[this.globalData.metrics.size()];
        for (int i = 0; i < this.globalData.metrics.size(); ++i) {
            eventData.inclusive.papi[i] = Double.parseDouble(stringTokenizer.nextToken());
            eventData.inclusive.papiE6OverSeconds[i] = Double.parseDouble(stringTokenizer.nextToken());
        }
        eventData.inclusive.ohCycles = Double.parseDouble(stringTokenizer.nextToken());
        return eventData;
    }

    private class Measurements
    implements Cloneable {
        public double wallclock;
        public double wallclockMax;
        public double wallclockMin;
        public double utrOverhead;
        public double[] papi;
        public double[] papiE6OverSeconds;
        public double ohCycles;

        private Measurements() {
        }

        public Object clone() {
            Measurements measurements = new Measurements();
            measurements.wallclock = this.wallclock;
            measurements.wallclockMax = this.wallclockMax;
            measurements.wallclockMin = this.wallclockMin;
            measurements.utrOverhead = this.utrOverhead;
            measurements.ohCycles = this.ohCycles;
            measurements.papi = new double[((GPTLDataSource)GPTLDataSource.this).globalData.metrics.size()];
            measurements.papiE6OverSeconds = new double[((GPTLDataSource)GPTLDataSource.this).globalData.metrics.size()];
            for (int i = 0; i < ((GPTLDataSource)GPTLDataSource.this).globalData.metrics.size(); ++i) {
                measurements.papi[i] = this.papi[i];
                measurements.papiE6OverSeconds[i] = this.papiE6OverSeconds[i];
            }
            return measurements;
        }
    }

    private class EventData {
        public String name;
        public String callpathName;
        public int depth;
        public int calls;
        private List children = new ArrayList();
        public Measurements inclusive = new Measurements();

        private EventData() {
        }

        public Measurements getExclusive() {
            int n;
            Measurements measurements = (Measurements)this.inclusive.clone();
            for (n = 0; n < this.children.size(); ++n) {
                EventData eventData = (EventData)this.children.get(n);
                measurements.wallclock -= eventData.inclusive.wallclock;
                measurements.wallclockMax -= eventData.inclusive.wallclockMax;
                measurements.wallclockMin -= eventData.inclusive.wallclockMin;
                measurements.utrOverhead -= eventData.inclusive.utrOverhead;
                measurements.ohCycles -= eventData.inclusive.ohCycles;
                for (int i = 0; i < ((GPTLDataSource)GPTLDataSource.this).globalData.metrics.size(); ++i) {
                    int n2 = i;
                    measurements.papi[n2] = measurements.papi[n2] - eventData.inclusive.papi[i];
                }
            }
            measurements.wallclock = measurements.wallclock < 0.0 ? 0.0 : measurements.wallclock;
            measurements.wallclockMax = measurements.wallclockMax < 0.0 ? 0.0 : measurements.wallclockMax;
            measurements.wallclockMin = measurements.wallclockMin < 0.0 ? 0.0 : measurements.wallclockMin;
            measurements.utrOverhead = measurements.utrOverhead < 0.0 ? 0.0 : measurements.utrOverhead;
            measurements.ohCycles = measurements.ohCycles < 0.0 ? 0.0 : measurements.ohCycles;
            for (n = 0; n < ((GPTLDataSource)GPTLDataSource.this).globalData.metrics.size(); ++n) {
                measurements.papi[n] = measurements.papi[n] < 0.0 ? 0.0 : measurements.papi[n];
                measurements.papiE6OverSeconds[n] = measurements.papi[n] / 1000000.0 / measurements.wallclock;
            }
            return measurements;
        }

        public boolean hasChildren() {
            return this.children.size() > 0;
        }
    }

    private class ThreadData {
        public List eventData = new ArrayList();
        public int processid = 0;
        public int threadid = 0;

        private ThreadData() {
        }
    }

    private class GlobalData {
        public int numTasks = 0;
        public List metrics = new ArrayList();

        private GlobalData() {
        }
    }
}

