/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.perfdmf.Context;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.DataSourceException;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.IPMXMLHandler;
import edu.uoregon.tau.perfdmf.NoOpEntityResolver;
import edu.uoregon.tau.perfdmf.Node;
import edu.uoregon.tau.perfdmf.Thread;
import java.io.File;
import java.io.FileInputStream;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class IPMDataSource
extends DataSource {
    private int metric = 0;
    private Function function = null;
    private FunctionProfile functionProfile = null;
    private Node node = null;
    private Context context = null;
    private Thread thread = null;
    private int nodeID = -1;
    private int contextID = -1;
    private int threadID = -1;
    private List v = null;
    boolean initialized = false;
    private Hashtable nodeHash = new Hashtable();
    private int threadCounter = 0;
    private File file = null;

    public IPMDataSource(File file) {
        this.setMetrics(new Vector());
        this.file = file;
    }

    public void cancelLoad() {
    }

    public int getProgress() {
        return 0;
    }

    public void load() throws DataSourceException {
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            IPMXMLHandler iPMXMLHandler = new IPMXMLHandler(this);
            xMLReader.setContentHandler(iPMXMLHandler);
            xMLReader.setErrorHandler(iPMXMLHandler);
            xMLReader.setEntityResolver(new NoOpEntityResolver());
            long l = System.currentTimeMillis();
            this.nodeID = 0;
            this.contextID = 0;
            this.threadID = 0;
            xMLReader.parse(new InputSource(new FileInputStream(this.file)));
            IPMXMLHandler iPMXMLHandler2 = iPMXMLHandler;
            l = System.currentTimeMillis() - l;
            this.generateDerivedData();
            this.aggregateMetaData();
            this.buildXMLMetaData();
            this.setGroupNamesPresent(true);
        }
        catch (Exception exception) {
            if (exception instanceof DataSourceException) {
                throw (DataSourceException)exception;
            }
            throw new DataSourceException(exception);
        }
    }

    public void initializeThread(boolean bl) {
        if (bl) {
            ++this.nodeID;
        } else {
            this.nodeID = this.nodeID == -1 ? 0 : this.nodeID;
            this.contextID = this.contextID == -1 ? 0 : this.contextID;
            this.threadID = this.threadID == -1 ? 0 : this.threadID;
        }
        this.node = this.getNode(this.nodeID);
        if (this.node == null) {
            this.node = this.addNode(this.nodeID);
        }
        this.context = this.node.getContext(this.contextID);
        if (this.context == null) {
            this.context = this.node.addContext(this.contextID);
        }
        this.thread = this.context.getThread(this.threadID);
        if (this.thread == null) {
            this.thread = this.context.addThread(this.threadID);
        }
    }

    public Thread getThread() {
        return this.thread;
    }
}

