/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.perfdmf.DatabaseAPI;
import edu.uoregon.tau.perfdmf.IntervalLocationProfile;
import edu.uoregon.tau.perfdmf.database.DB;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;

public class IntervalEvent {
    private int intervalEventID;
    private String name;
    private String group;
    private int trialID;
    private IntervalLocationProfile meanSummary = null;
    private IntervalLocationProfile totalSummary = null;
    private DatabaseAPI dataSession = null;

    public IntervalEvent(DatabaseAPI databaseAPI) {
        this.dataSession = databaseAPI;
    }

    public int getID() {
        return this.intervalEventID;
    }

    public String getName() {
        return this.name;
    }

    public String getGroup() {
        return this.group;
    }

    public int getTrialID() {
        return this.trialID;
    }

    public IntervalLocationProfile getMeanSummary() throws SQLException {
        if (this.meanSummary == null) {
            this.dataSession.getIntervalEventDetail(this);
        }
        return this.meanSummary;
    }

    public IntervalLocationProfile getTotalSummary() throws SQLException {
        if (this.totalSummary == null) {
            this.dataSession.getIntervalEventDetail(this);
        }
        return this.totalSummary;
    }

    public void setID(int n) {
        this.intervalEventID = n;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setGroup(String string) {
        this.group = string;
    }

    public void setTrialID(int n) {
        this.trialID = n;
    }

    public void setMeanSummary(IntervalLocationProfile intervalLocationProfile) {
        this.meanSummary = intervalLocationProfile;
    }

    public void setTotalSummary(IntervalLocationProfile intervalLocationProfile) {
        this.totalSummary = intervalLocationProfile;
    }

    public static Vector getIntervalEvents(DatabaseAPI databaseAPI, DB dB, String string) {
        Vector<IntervalEvent> vector = new Vector<IntervalEvent>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select id, name, group_name, trial ");
        stringBuffer.append("from " + dB.getSchemaPrefix() + "interval_event ");
        stringBuffer.append(string);
        if (dB.getDBType().compareTo("oracle") == 0) {
            stringBuffer.append(" order by dbms_lob.substr(name) asc");
        } else if (dB.getDBType().compareTo("derby") == 0) {
            stringBuffer.append(" order by cast (name as varchar(4000)) asc");
        } else if (dB.getDBType().compareTo("db2") == 0) {
            stringBuffer.append(" order by cast (name as varchar(256)) asc");
        } else {
            stringBuffer.append(" order by name asc ");
        }
        try {
            ResultSet resultSet = dB.executeQuery(stringBuffer.toString());
            Object var6_7 = null;
            while (resultSet.next()) {
                IntervalEvent intervalEvent = new IntervalEvent(databaseAPI);
                intervalEvent.setID(resultSet.getInt(1));
                intervalEvent.setName(resultSet.getString(2));
                intervalEvent.setGroup(resultSet.getString(3));
                intervalEvent.setTrialID(resultSet.getInt(4));
                vector.addElement(intervalEvent);
            }
            resultSet.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return vector;
    }

    public int saveIntervalEvent(DB dB, int n, Hashtable hashtable, int n2) throws SQLException {
        int n3 = -1;
        PreparedStatement preparedStatement = null;
        if (n2 < 0) {
            preparedStatement = dB.prepareStatement("INSERT INTO " + dB.getSchemaPrefix() + "interval_event (trial, name, group_name) VALUES (?, ?, ?)");
            preparedStatement.setInt(1, n);
            preparedStatement.setString(2, this.name);
            preparedStatement.setString(3, this.group);
            preparedStatement.executeUpdate();
            preparedStatement.close();
            String string = new String();
            string = dB.getDBType().compareTo("mysql") == 0 ? "select LAST_INSERT_ID();" : (dB.getDBType().compareTo("db2") == 0 ? "select IDENTITY_VAL_LOCAL() FROM interval_event" : (dB.getDBType().compareTo("derby") == 0 ? "select IDENTITY_VAL_LOCAL() FROM interval_event" : (dB.getDBType().compareTo("oracle") == 0 ? "select " + dB.getSchemaPrefix() + "interval_event_id_seq.currval FROM dual" : "select currval('interval_event_id_seq');")));
            n3 = Integer.parseInt(dB.getDataItem(string));
        } else {
            preparedStatement = dB.getDBType().compareTo("oracle") == 0 ? dB.prepareStatement("SELECT id FROM " + dB.getSchemaPrefix() + "interval_event where dbms_lob.instr(name, ?) > 0 and trial = ?") : (dB.getDBType().compareTo("derby") == 0 ? dB.prepareStatement("SELECT id FROM " + dB.getSchemaPrefix() + "interval_event where cast(name as varchar(4000)) = ? and trial = ?") : dB.prepareStatement("SELECT id FROM " + dB.getSchemaPrefix() + "interval_event where name = ? and trial = ?"));
            preparedStatement.setString(1, this.name);
            preparedStatement.setInt(2, n);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                n3 = resultSet.getInt(1);
            }
            resultSet.close();
            preparedStatement.close();
        }
        if (n3 == -1) {
            throw new RuntimeException("Unable to find event in database, event: " + this.name, null);
        }
        if (this.meanSummary != null) {
            this.meanSummary.saveMeanSummary(dB, n3, hashtable, n2);
        }
        if (this.totalSummary != null) {
            this.totalSummary.saveTotalSummary(dB, n3, hashtable, n2);
        }
        return n3;
    }

    public static void getMetaData(DB dB) {
        try {
            String[] stringArray;
            Object object;
            int n;
            ResultSet resultSet = null;
            Object var2_3 = null;
            Object var3_4 = null;
            DatabaseMetaData databaseMetaData = dB.getMetaData();
            resultSet = dB.getDBType().compareTo("oracle") == 0 || dB.getDBType().compareTo("derby") == 0 || dB.getDBType().compareTo("db2") == 0 ? databaseMetaData.getColumns(null, null, "INTERVAL_EVENT", "%") : databaseMetaData.getColumns(null, null, "interval_event", "%");
            Vector<String> vector = new Vector<String>();
            Vector<Integer> vector2 = new Vector<Integer>();
            ArrayList<String[]> arrayList = new ArrayList<String[]>();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            boolean bl = false;
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            for (n = 0; n < resultSetMetaData.getColumnCount(); ++n) {
            }
            while (resultSet.next()) {
                n = resultSet.getInt("DATA_TYPE");
                object = resultSet.getString("COLUMN_NAME");
                stringArray = resultSet.getString("TYPE_NAME");
                Integer n2 = new Integer(resultSet.getInt("COLUMN_SIZE"));
                if (((String)object).equals("ID")) {
                    if (bl) break;
                    bl = true;
                }
                vector.add(resultSet.getString("COLUMN_NAME"));
                vector2.add(new Integer(n));
                arrayList.add(stringArray);
                arrayList2.add(n2);
            }
            resultSet.close();
            String[] stringArray2 = new String[vector.size()];
            object = new int[vector2.size()];
            stringArray = new String[vector2.size()];
            for (int i = 0; i < vector2.size(); ++i) {
                stringArray2[i] = (String)vector.get(i);
                object[i] = (Integer)vector2.get(i);
                stringArray[i] = (Integer)arrayList2.get(i) > 255 ? (String)arrayList.get(i) + "(" + arrayList2.get(i).toString() + ")" : (String)arrayList.get(i);
            }
            dB.getDatabase().setIntervalEventFieldNames(stringArray2);
            dB.getDatabase().setIntervalEventFieldTypeNames(stringArray);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }
}

