/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.perfdmf.IntervalEvent;
import edu.uoregon.tau.perfdmf.database.DB;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;

public class IntervalLocationProfile {
    private int node;
    private int context;
    private int thread;
    private int eventID;
    private double[] doubleList;
    private double numCalls;
    private double numSubroutines;
    private static int fieldCount = 5;

    public IntervalLocationProfile() {
        this.doubleList = new double[fieldCount];
    }

    public IntervalLocationProfile(int n) {
        int n2 = n * fieldCount;
        this.doubleList = new double[n2];
    }

    public int getNode() {
        return this.node;
    }

    public int getContext() {
        return this.context;
    }

    public int getThread() {
        return this.thread;
    }

    public int getIntervalEventID() {
        return this.eventID;
    }

    public double getInclusivePercentage(int n) {
        return this.getDouble(n, 0);
    }

    public double getInclusivePercentage() {
        return this.getDouble(0, 0);
    }

    public double getInclusive(int n) {
        return this.getDouble(n, 1);
    }

    public double getInclusive() {
        return this.getDouble(0, 1);
    }

    public double getExclusivePercentage(int n) {
        return this.getDouble(n, 2);
    }

    public double getExclusivePercentage() {
        return this.getDouble(0, 2);
    }

    public double getExclusive(int n) {
        return this.getDouble(n, 3);
    }

    public double getExclusive() {
        return this.getDouble(0, 3);
    }

    public double getInclusivePerCall(int n) {
        return this.getDouble(n, 4);
    }

    public double getInclusivePerCall() {
        return this.getDouble(0, 4);
    }

    public double getNumCalls() {
        return this.numCalls;
    }

    public double getNumSubroutines() {
        return this.numSubroutines;
    }

    private void incrementStorage() {
        int n = this.doubleList.length;
        double[] dArray = new double[n + fieldCount];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.doubleList[i];
        }
        this.doubleList = dArray;
    }

    private void insertDouble(int n, int n2, double d) {
        int n3 = n * fieldCount + n2;
        if (n3 >= this.doubleList.length) {
            this.incrementStorage();
        }
        try {
            this.doubleList[n3] = d;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private double getDouble(int n, int n2) {
        int n3 = n * fieldCount + n2;
        try {
            return this.doubleList[n3];
        }
        catch (Exception exception) {
            return -1.0;
        }
    }

    public void setNode(int n) {
        this.node = n;
    }

    public void setContext(int n) {
        this.context = n;
    }

    public void setThread(int n) {
        this.thread = n;
    }

    public void setIntervalEventID(int n) {
        this.eventID = n;
    }

    public void setInclusivePercentage(int n, double d) {
        this.insertDouble(n, 0, d);
    }

    public void setInclusive(int n, double d) {
        this.insertDouble(n, 1, d);
    }

    public void setExclusivePercentage(int n, double d) {
        this.insertDouble(n, 2, d);
    }

    public void setExclusive(int n, double d) {
        this.insertDouble(n, 3, d);
    }

    public void setInclusivePerCall(int n, double d) {
        this.insertDouble(n, 4, d);
    }

    public void setNumCalls(double d) {
        this.numCalls = d;
    }

    public void setNumSubroutines(double d) {
        this.numSubroutines = d;
    }

    public static void getIntervalEventDetail(DB dB, IntervalEvent intervalEvent, String string) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select ms.interval_event, ");
        stringBuffer.append("ms.inclusive_percentage, ms.inclusive, ");
        if (dB.getDBType().compareTo("oracle") == 0) {
            stringBuffer.append("ms.exclusive_percentage, ms.excl, ");
        } else {
            stringBuffer.append("ms.exclusive_percentage, ms.exclusive, ");
        }
        if (dB.getDBType().compareTo("derby") == 0) {
            stringBuffer.append("ms.num_calls, ");
        } else if (dB.getDBType().compareTo("mysql") == 0) {
            stringBuffer.append("ms.`call`, ");
        } else {
            stringBuffer.append("ms.call, ");
        }
        stringBuffer.append("ms.subroutines, ms.inclusive_per_call, ");
        stringBuffer.append("ms.metric, ");
        stringBuffer.append("ts.inclusive_percentage, ts.inclusive, ");
        if (dB.getDBType().compareTo("oracle") == 0) {
            stringBuffer.append("ts.exclusive_percentage, ts.excl, ");
        } else {
            stringBuffer.append("ts.exclusive_percentage, ts.exclusive, ");
        }
        if (dB.getDBType().compareTo("derby") == 0) {
            stringBuffer.append("ts.num_calls, ");
        } else if (dB.getDBType().compareTo("mysql") == 0) {
            stringBuffer.append("ts.`call`, ");
        } else {
            stringBuffer.append("ts.call, ");
        }
        stringBuffer.append("ts.subroutines, ts.inclusive_per_call ");
        stringBuffer.append("from " + dB.getSchemaPrefix() + "interval_mean_summary ms inner join ");
        stringBuffer.append(dB.getSchemaPrefix() + "interval_total_summary ts ");
        stringBuffer.append("on ms.interval_event = ts.interval_event ");
        stringBuffer.append("and ms.metric = ts.metric ");
        stringBuffer.append(string);
        stringBuffer.append(" order by ms.interval_event, ms.metric");
        ResultSet resultSet = dB.executeQuery(stringBuffer.toString());
        int n = 0;
        IntervalLocationProfile intervalLocationProfile = new IntervalLocationProfile();
        IntervalLocationProfile intervalLocationProfile2 = new IntervalLocationProfile();
        while (resultSet.next()) {
            intervalLocationProfile.setIntervalEventID(resultSet.getInt(1));
            intervalLocationProfile.setInclusivePercentage(n, resultSet.getDouble(2));
            intervalLocationProfile.setInclusive(n, resultSet.getDouble(3));
            intervalLocationProfile.setExclusivePercentage(n, resultSet.getDouble(4));
            intervalLocationProfile.setExclusive(n, resultSet.getDouble(5));
            intervalLocationProfile.setNumCalls(resultSet.getDouble(6));
            intervalLocationProfile.setNumSubroutines(resultSet.getDouble(7));
            intervalLocationProfile.setInclusivePerCall(n, resultSet.getDouble(8));
            intervalLocationProfile2.setInclusivePercentage(n, resultSet.getDouble(10));
            intervalLocationProfile2.setInclusive(n, resultSet.getDouble(11));
            intervalLocationProfile2.setExclusivePercentage(n, resultSet.getDouble(12));
            intervalLocationProfile2.setExclusive(n, resultSet.getDouble(13));
            intervalLocationProfile2.setNumCalls(resultSet.getDouble(14));
            intervalLocationProfile2.setNumSubroutines(resultSet.getDouble(15));
            intervalLocationProfile2.setInclusivePerCall(n, resultSet.getDouble(16));
            ++n;
        }
        intervalEvent.setMeanSummary(intervalLocationProfile);
        intervalEvent.setTotalSummary(intervalLocationProfile2);
        resultSet.close();
    }

    public static Vector getIntervalEventData(DB dB, int n, String string) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select p.interval_event, p.metric, p.node, p.context, p.thread, ");
        stringBuffer.append("p.inclusive_percentage, ");
        if (dB.getDBType().compareTo("oracle") == 0) {
            stringBuffer.append("p.inclusive, p.exclusive_percentage, p.excl, ");
        } else {
            stringBuffer.append("p.inclusive, p.exclusive_percentage, p.exclusive, ");
        }
        if (dB.getDBType().compareTo("derby") == 0) {
            stringBuffer.append("p.num_calls, ");
        } else if (dB.getDBType().compareTo("mysql") == 0) {
            stringBuffer.append("p.`call`, ");
        } else {
            stringBuffer.append("p.call, ");
        }
        stringBuffer.append("p.subroutines, p.inclusive_per_call ");
        stringBuffer.append("from " + dB.getSchemaPrefix() + "interval_event e inner join " + dB.getSchemaPrefix() + "interval_location_profile p ");
        stringBuffer.append("on e.id = p.interval_event ");
        stringBuffer.append(string);
        stringBuffer.append(" order by p.interval_event, p.node, p.context, p.thread, p.metric ");
        Vector<IntervalLocationProfile> vector = new Vector<IntervalLocationProfile>();
        ResultSet resultSet = dB.executeQuery(stringBuffer.toString());
        while (resultSet.next()) {
            int n2 = 0;
            IntervalLocationProfile intervalLocationProfile = new IntervalLocationProfile();
            intervalLocationProfile.setIntervalEventID(resultSet.getInt(1));
            intervalLocationProfile.setNode(resultSet.getInt(3));
            intervalLocationProfile.setContext(resultSet.getInt(4));
            intervalLocationProfile.setThread(resultSet.getInt(5));
            intervalLocationProfile.setInclusivePercentage(n2, resultSet.getDouble(6));
            intervalLocationProfile.setInclusive(n2, resultSet.getDouble(7));
            intervalLocationProfile.setExclusivePercentage(n2, resultSet.getDouble(8));
            intervalLocationProfile.setExclusive(n2, resultSet.getDouble(9));
            intervalLocationProfile.setNumCalls(resultSet.getDouble(10));
            intervalLocationProfile.setNumSubroutines(resultSet.getDouble(11));
            intervalLocationProfile.setInclusivePerCall(n2, resultSet.getDouble(12));
            for (int i = 1; i < n && resultSet.next(); ++i) {
                intervalLocationProfile.setInclusivePercentage(++n2, resultSet.getDouble(6));
                intervalLocationProfile.setInclusive(n2, resultSet.getDouble(7));
                intervalLocationProfile.setExclusivePercentage(n2, resultSet.getDouble(8));
                intervalLocationProfile.setExclusive(n2, resultSet.getDouble(9));
                intervalLocationProfile.setInclusivePerCall(n2, resultSet.getDouble(12));
            }
            vector.addElement(intervalLocationProfile);
        }
        resultSet.close();
        return vector;
    }

    public void saveMeanSummary(DB dB, int n, Hashtable hashtable, int n2) throws SQLException {
        int n3 = 0;
        Integer n4 = (Integer)hashtable.get(new Integer(n3));
        while (n4 != null) {
            if (n2 < 0 || n3 == n2) {
                PreparedStatement preparedStatement = null;
                preparedStatement = dB.getDBType().compareTo("oracle") == 0 ? dB.prepareStatement("INSERT INTO " + dB.getSchemaPrefix() + "interval_mean_summary (interval_event, metric, inclusive_percentage, inclusive, exclusive_percentage, excl, call, subroutines, inclusive_per_call) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)") : (dB.getDBType().compareTo("derby") == 0 ? dB.prepareStatement("INSERT INTO " + dB.getSchemaPrefix() + "interval_mean_summary (interval_event, metric, inclusive_percentage, inclusive, exclusive_percentage, exclusive, num_calls, subroutines, inclusive_per_call) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)") : (dB.getDBType().compareTo("mysql") == 0 ? dB.prepareStatement("INSERT INTO " + dB.getSchemaPrefix() + "interval_mean_summary (interval_event, metric, inclusive_percentage, inclusive, exclusive_percentage, exclusive, `call`, subroutines, inclusive_per_call) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)") : dB.prepareStatement("INSERT INTO " + dB.getSchemaPrefix() + "interval_mean_summary (interval_event, metric, inclusive_percentage, inclusive, exclusive_percentage, exclusive, call, subroutines, inclusive_per_call) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)")));
                preparedStatement.setInt(1, n);
                preparedStatement.setInt(2, n4);
                preparedStatement.setDouble(3, this.getInclusivePercentage(n3));
                preparedStatement.setDouble(4, this.getInclusive(n3));
                preparedStatement.setDouble(5, this.getExclusivePercentage(n3));
                preparedStatement.setDouble(6, this.getExclusive(n3));
                preparedStatement.setDouble(7, this.getNumCalls());
                preparedStatement.setDouble(8, this.getNumSubroutines());
                preparedStatement.setDouble(9, this.getInclusivePerCall(n3));
                preparedStatement.executeUpdate();
                preparedStatement.close();
            }
            n4 = (Integer)hashtable.get(new Integer(++n3));
        }
    }

    public void saveTotalSummary(DB dB, int n, Hashtable hashtable, int n2) throws SQLException {
        int n3 = 0;
        Integer n4 = (Integer)hashtable.get(new Integer(n3));
        while (n4 != null) {
            if (n2 < 0 || n3 == n2) {
                PreparedStatement preparedStatement = null;
                preparedStatement = dB.getDBType().compareTo("oracle") == 0 ? dB.prepareStatement("INSERT INTO " + dB.getSchemaPrefix() + "interval_total_summary (interval_event, metric, inclusive_percentage, inclusive, exclusive_percentage, excl, call, subroutines, inclusive_per_call) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)") : (dB.getDBType().compareTo("derby") == 0 ? dB.prepareStatement("INSERT INTO " + dB.getSchemaPrefix() + "interval_total_summary (interval_event, metric, inclusive_percentage, inclusive, exclusive_percentage, exclusive, num_calls, subroutines, inclusive_per_call) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)") : (dB.getDBType().compareTo("mysql") == 0 ? dB.prepareStatement("INSERT INTO " + dB.getSchemaPrefix() + "interval_total_summary (interval_event, metric, inclusive_percentage, inclusive, exclusive_percentage, exclusive, `call`, subroutines, inclusive_per_call) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)") : dB.prepareStatement("INSERT INTO " + dB.getSchemaPrefix() + "interval_total_summary (interval_event, metric, inclusive_percentage, inclusive, exclusive_percentage, exclusive, call, subroutines, inclusive_per_call) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)")));
                preparedStatement.setInt(1, n);
                preparedStatement.setInt(2, n4);
                preparedStatement.setDouble(3, this.getInclusivePercentage(n3));
                preparedStatement.setDouble(4, this.getInclusive(n3));
                preparedStatement.setDouble(5, this.getExclusivePercentage(n3));
                preparedStatement.setDouble(6, this.getExclusive(n3));
                preparedStatement.setDouble(7, this.getNumCalls());
                preparedStatement.setDouble(8, this.getNumSubroutines());
                preparedStatement.setDouble(9, this.getInclusivePerCall(n3));
                preparedStatement.executeUpdate();
                preparedStatement.close();
            }
            n4 = (Integer)hashtable.get(new Integer(++n3));
        }
    }
}

