/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.perfdmf.Context;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.Thread;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Node
implements Comparable {
    private int nodeID = -1;
    private Map contexts = new TreeMap();
    private DataSource dataSource;

    Node(int n, DataSource dataSource) {
        this.nodeID = n;
        this.dataSource = dataSource;
    }

    public int getNodeID() {
        return this.nodeID;
    }

    public Context addContext(int n) {
        Object v = this.contexts.get(new Integer(n));
        if (v != null) {
            return (Context)v;
        }
        Context context = new Context(this.nodeID, n, this.dataSource);
        this.contexts.put(new Integer(n), context);
        return context;
    }

    public Iterator getContexts() {
        return this.contexts.values().iterator();
    }

    public Context getContext(int n) {
        return (Context)this.contexts.get(new Integer(n));
    }

    public int getNumberOfContexts() {
        return this.contexts.size();
    }

    public int compareTo(Object object) {
        return this.nodeID - ((Node)object).getNodeID();
    }

    public List getThreads() {
        ArrayList<Thread> arrayList = new ArrayList<Thread>();
        Iterator iterator = this.getContexts();
        while (iterator.hasNext()) {
            Context context = (Context)iterator.next();
            Iterator iterator2 = context.getThreads();
            while (iterator2.hasNext()) {
                Thread thread = (Thread)iterator2.next();
                arrayList.add(thread);
            }
        }
        return arrayList;
    }
}

