/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.common.TrackerInputStream;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.DataSourceException;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.Group;
import edu.uoregon.tau.perfdmf.Thread;
import edu.uoregon.tau.perfdmf.UserEvent;
import edu.uoregon.tau.perfdmf.UserEventProfile;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.SQLException;
import java.util.TreeMap;
import java.util.zip.GZIPInputStream;

public class PackedProfileDataSource
extends DataSource {
    private File file;
    private volatile boolean abort = false;
    private volatile long totalBytes = 0L;
    private volatile long bytesRead = 0L;
    private volatile TrackerInputStream tracker;

    public PackedProfileDataSource(File file) {
        this.file = file;
    }

    public void cancelLoad() {
        this.abort = true;
    }

    public int getProgress() {
        if (this.totalBytes != 0L) {
            return (int)((float)this.tracker.byteCount() / (float)this.totalBytes * 100.0f);
        }
        return 0;
    }

    public void load() throws FileNotFoundException, IOException, DataSourceException, SQLException {
        int n;
        int n2;
        Object object;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        InputStream inputStream;
        Object object2;
        long l = System.currentTimeMillis();
        if (this.file.toString().toLowerCase().startsWith("http:")) {
            object2 = new URL("http://" + this.file.toString().substring(6).replace('\\', '/'));
            inputStream = ((URL)object2).openStream();
        } else {
            inputStream = new FileInputStream(this.file);
        }
        this.tracker = new TrackerInputStream(inputStream);
        object2 = new GZIPInputStream((InputStream)this.tracker);
        BufferedInputStream bufferedInputStream = new BufferedInputStream((InputStream)object2);
        DataInputStream dataInputStream = new DataInputStream(bufferedInputStream);
        this.totalBytes = this.file.length();
        char c = dataInputStream.readChar();
        char c2 = dataInputStream.readChar();
        char c3 = dataInputStream.readChar();
        if (c != 'P' || c2 != 'P' || c3 != 'K') {
            throw new DataSourceException("This doesn't look like a packed profile");
        }
        int n8 = dataInputStream.readInt();
        int n9 = dataInputStream.readInt();
        if (n9 > 2) {
            throw new DataSourceException("This packed profile is not compatible, please upgrade\nVersion: " + n9 + " > " + "2");
        }
        this.metaData = new TreeMap();
        if (n8 >= 2) {
            n7 = dataInputStream.readInt();
            n6 = dataInputStream.readInt();
            dataInputStream.skipBytes(n6);
            int n10 = dataInputStream.readInt();
            for (n5 = 0; n5 < n10; ++n5) {
                String string = dataInputStream.readUTF();
                String string2 = dataInputStream.readUTF();
                this.metaData.put(string, string2);
            }
            n5 = dataInputStream.readInt();
            for (int i = 0; i < n5; ++i) {
                int n11 = dataInputStream.readInt();
                int n12 = dataInputStream.readInt();
                int n13 = dataInputStream.readInt();
                Thread thread = this.addThread(n11, n12, n13);
                n4 = dataInputStream.readInt();
                for (n3 = 0; n3 < n4; ++n3) {
                    String string = dataInputStream.readUTF();
                    object = dataInputStream.readUTF();
                    thread.getMetaData().put(string, object);
                    this.uncommonMetaData.put(string, object);
                }
            }
        } else {
            n7 = dataInputStream.readInt();
            dataInputStream.skipBytes(n7);
        }
        n7 = dataInputStream.readInt();
        for (n6 = 0; n6 < n7; ++n6) {
            String string = dataInputStream.readUTF();
            this.addMetric(string);
        }
        n6 = dataInputStream.readInt();
        if (n6 != 0) {
            this.setGroupNamesPresent(true);
        }
        Group[] groupArray = new Group[n6];
        for (n5 = 0; n5 < n6; ++n5) {
            groupArray[n5] = this.addGroup(dataInputStream.readUTF());
        }
        n5 = dataInputStream.readInt();
        Function[] functionArray = new Function[n5];
        for (n2 = 0; n2 < n5; ++n2) {
            Function function;
            String string = dataInputStream.readUTF();
            functionArray[n2] = function = this.addFunction(string, n7);
            int n14 = dataInputStream.readInt();
            for (n4 = 0; n4 < n14; ++n4) {
                n3 = dataInputStream.readInt();
                function.addGroup(groupArray[n3]);
            }
        }
        n2 = dataInputStream.readInt();
        UserEvent[] userEventArray = new UserEvent[n2];
        for (n = 0; n < n2; ++n) {
            UserEvent userEvent;
            String string = dataInputStream.readUTF();
            userEventArray[n] = userEvent = this.addUserEvent(string);
        }
        n = dataInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            int n15;
            int n16;
            int n17 = dataInputStream.readInt();
            n3 = dataInputStream.readInt();
            int n18 = dataInputStream.readInt();
            object = this.addThread(n17, n3, n18);
            int n19 = dataInputStream.readInt();
            for (n16 = 0; n16 < n19; ++n16) {
                n15 = dataInputStream.readInt();
                FunctionProfile functionProfile = new FunctionProfile(functionArray[n15], n7);
                ((Thread)object).addFunctionProfile(functionProfile);
                functionProfile.setNumCalls(dataInputStream.readDouble());
                functionProfile.setNumSubr(dataInputStream.readDouble());
                for (int j = 0; j < n7; ++j) {
                    functionProfile.setExclusive(j, dataInputStream.readDouble());
                    functionProfile.setInclusive(j, dataInputStream.readDouble());
                }
            }
            n16 = dataInputStream.readInt();
            for (n15 = 0; n15 < n16; ++n15) {
                int n20 = dataInputStream.readInt();
                UserEventProfile userEventProfile = new UserEventProfile(userEventArray[n20]);
                userEventProfile.setNumSamples(dataInputStream.readInt());
                userEventProfile.setMinValue(dataInputStream.readDouble());
                userEventProfile.setMaxValue(dataInputStream.readDouble());
                userEventProfile.setMeanValue(dataInputStream.readDouble());
                userEventProfile.setSumSquared(dataInputStream.readDouble());
                userEventProfile.updateMax();
                ((Thread)object).addUserEventProfile(userEventProfile);
            }
        }
        dataInputStream.close();
        ((GZIPInputStream)object2).close();
        this.tracker.close();
        inputStream.close();
        if (n2 > 0) {
            this.setUserEventsPresent(true);
        }
        this.generateDerivedData();
        this.buildXMLMetaData();
        l = System.currentTimeMillis() - l;
    }
}

