/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.AnalysisManagementPane;
import client.ChartPane;
import client.PerfExplorerJTabbedPane;
import client.PerfExplorerJTree;
import client.PerfExplorerModel;
import client.PerfExplorerTableModel;
import client.PerformanceExplorerPane;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class PerfExplorerTreeSelectionListener
implements TreeSelectionListener {
    private JTree tree;
    private TreePath[] oldPaths = null;

    public PerfExplorerTreeSelectionListener(JTree jTree) {
        this.tree = jTree;
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        if (treePathArray == null) {
            return;
        }
        if (treePathArray.length == 1) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
            if (defaultMutableTreeNode == null) {
                return;
            }
            PerfExplorerJTree.setConnectionIndex(defaultMutableTreeNode);
            Object object = defaultMutableTreeNode.getUserObject();
            Object[] objectArray = defaultMutableTreeNode.getUserObjectPath();
            PerfExplorerModel.getModel().setCurrentSelection(objectArray);
            this.oldPaths = treePathArray;
            this.updateRightPanel(object);
        } else {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            HashSet<Integer> hashSet = new HashSet<Integer>();
            DefaultMutableTreeNode defaultMutableTreeNode = null;
            for (int i = 0; i < treePathArray.length; ++i) {
                defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[i].getLastPathComponent();
                arrayList.add(defaultMutableTreeNode.getUserObject());
                hashSet.add(new Integer(PerfExplorerJTree.getConnectionIndex(defaultMutableTreeNode)));
            }
            if (hashSet.size() > 1) {
                JOptionPane.showMessageDialog(null, "Please select only one type (Application, Experiment, Trial, Metric, Event) of level from one database.", "Selection Error", 0);
                this.tree.clearSelection();
                if (this.oldPaths != null) {
                    this.tree.setSelectionPaths(this.oldPaths);
                }
            } else if (!PerfExplorerModel.getModel().setMultiSelection(arrayList)) {
                JOptionPane.showMessageDialog(null, "Please select only one type (Application, Experiment, Trial, Metric, Event) of level.", "Selection Error", 0);
                this.tree.clearSelection();
                if (this.oldPaths != null) {
                    this.tree.setSelectionPaths(this.oldPaths);
                }
            } else {
                PerfExplorerJTree.setConnectionIndex(defaultMutableTreeNode);
                this.oldPaths = treePathArray;
            }
        }
    }

    public void updateRightPanel(Object object) {
        PerfExplorerJTabbedPane perfExplorerJTabbedPane = PerfExplorerJTabbedPane.getPane();
        int n = perfExplorerJTabbedPane.getSelectedIndex();
        if (n == 0) {
            PerfExplorerTableModel perfExplorerTableModel = (PerfExplorerTableModel)AnalysisManagementPane.getPane().getTable().getModel();
            perfExplorerTableModel.updateObject(object);
        } else if (n == 3) {
            ChartPane.getPane().refreshDynamicControls(true, true, true);
            ChartPane.getPane().drawChart();
        } else {
            PerformanceExplorerPane.getPane().updateImagePanel();
        }
        perfExplorerJTabbedPane.update();
    }
}

