/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.PerfExplorerException;
import java.io.ObjectStreamException;
import java.io.Serializable;

public final class EngineType
implements Serializable {
    private final transient String _name;
    public static final EngineType WEKA = new EngineType("weka");
    public static final EngineType RPROJECT = new EngineType("r");
    public static final EngineType OCTAVE = new EngineType("octave");
    private static int nextOrdinal = 0;
    private final int ordinal = nextOrdinal++;
    private static final EngineType[] VALUES = new EngineType[]{WEKA, RPROJECT, OCTAVE};

    private EngineType(String string) {
        this._name = string;
    }

    public String toString() {
        return this._name;
    }

    public static EngineType getType(String string) throws PerfExplorerException {
        PerfExplorerException perfExplorerException = new PerfExplorerException("Unknown engine type.");
        if (string == null) {
            throw perfExplorerException;
        }
        String string2 = string.toLowerCase();
        if (string.equals(WEKA.toString())) {
            return WEKA;
        }
        if (string.equals(RPROJECT.toString())) {
            return RPROJECT;
        }
        if (string.equals(OCTAVE.toString())) {
            return OCTAVE;
        }
        throw perfExplorerException;
    }

    Object readResolve() throws ObjectStreamException {
        return VALUES[this.ordinal];
    }
}

