/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Paint;
import java.net.URL;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.title.LegendTitle;

public class Utility {
    public static String removeRuns(String string) {
        int n = string.indexOf("  ");
        while (n > 0) {
            string = string.substring(0, n) + string.substring(n + 1);
            n = string.indexOf("  ");
        }
        return string;
    }

    public static ImageIcon getImageIconResource(String string) {
        URL uRL = Utility.getResource(string);
        if (uRL != null) {
            return new ImageIcon(uRL);
        }
        return null;
    }

    public static URL getResource(String string) {
        URL uRL = null;
        uRL = Utility.class.getResource(string);
        if (uRL == null) {
            uRL = Utility.class.getResource("/" + string);
        }
        if (uRL == null) {
            uRL = Utility.class.getResource("resources/" + string);
        }
        return uRL;
    }

    public static void applyDefaultChartTheme(JFreeChart jFreeChart) {
        jFreeChart.setBackgroundPaint((Paint)new Color(238, 238, 238));
        LegendTitle legendTitle = jFreeChart.getLegend();
        if (legendTitle != null) {
            legendTitle.setItemFont(new Font(null, 0, 16));
        }
        Plot plot = jFreeChart.getPlot();
        plot.setBackgroundPaint((Paint)Color.white);
        if (plot instanceof XYPlot) {
            XYPlot xYPlot = (XYPlot)plot;
            Utility.setAxisFont((Axis)xYPlot.getRangeAxis());
            Utility.setAxisFont((Axis)xYPlot.getDomainAxis());
            xYPlot.setDomainGridlinePaint((Paint)Color.gray);
            xYPlot.setDomainMinorGridlinePaint((Paint)Color.gray);
            xYPlot.setRangeGridlinePaint((Paint)Color.gray);
            xYPlot.setRangeMinorGridlinePaint((Paint)Color.gray);
        } else if (plot instanceof CategoryPlot) {
            CategoryPlot categoryPlot = (CategoryPlot)plot;
            Utility.setAxisFont((Axis)categoryPlot.getRangeAxis());
            Utility.setAxisFont((Axis)categoryPlot.getDomainAxis());
            categoryPlot.setBackgroundPaint((Paint)Color.white);
            categoryPlot.setDomainGridlinePaint((Paint)Color.gray);
            categoryPlot.setRangeGridlinePaint((Paint)Color.gray);
        }
    }

    private static void setAxisFont(Axis axis) {
        if (axis == null) {
            return;
        }
        Font font = axis.getLabelFont();
        font = font == null ? new Font(null, 0, 16) : font.deriveFont(16.0f);
        axis.setLabelFont(font);
    }

    public static String shortenFunctionName(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "(");
        String string2 = null;
        try {
            string2 = stringTokenizer.nextToken();
            if (string2.length() < string.length()) {
                string2 = string2 + "()";
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            string2 = string;
        }
        string = string2;
        stringTokenizer = new StringTokenizer(string, "[{");
        string2 = null;
        try {
            string2 = stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            string2 = string;
        }
        return string2.trim();
    }

    public static void addCompItem(Container container, Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        container.add(component, gridBagConstraints);
    }

    public static void addCompItem(JFrame jFrame, Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        jFrame.getContentPane().add(component, gridBagConstraints);
    }
}

