/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.common.Utility;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.WindowPlacer;
import edu.uoregon.tau.paraprof.interfaces.ParaProfWindow;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.Thread;
import edu.uoregon.tau.perfdmf.UserEventProfile;
import edu.uoregon.tau.vis.HeatMapData;
import edu.uoregon.tau.vis.HeatMapWindow;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.net.URL;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;

public class CommunicationMatrixWindow
implements ParaProfWindow,
Printable {
    private HeatMapData mapData = null;
    private int size = 0;
    private static final String allPaths = "All Paths";
    private static final int COUNT = 0;
    private static final int MAX = 1;
    private static final int MIN = 2;
    private static final int MEAN = 3;
    private static final int STDDEV = 4;
    private static final int VOLUME = 5;
    private JFrame window = null;
    private int numEvents = 0;
    private ParaProfTrial ppTrial;

    private CommunicationMatrixWindow(ParaProfTrial paraProfTrial) {
        this.ppTrial = paraProfTrial;
    }

    public static JFrame createCommunicationMatrixWindow(ParaProfTrial paraProfTrial, JFrame jFrame) {
        CommunicationMatrixWindow communicationMatrixWindow = new CommunicationMatrixWindow(paraProfTrial);
        JFrame jFrame2 = communicationMatrixWindow.doCommunicationMatrix(paraProfTrial.getDataSource(), jFrame);
        if (jFrame2 == null) {
            return jFrame2;
        }
        jFrame2.setLocation(WindowPlacer.getNewLocation(jFrame2, jFrame));
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(ParaProfUtils.createFileMenu(communicationMatrixWindow, communicationMatrixWindow, jFrame2));
        jMenuBar.add(ParaProfUtils.createWindowsMenu(paraProfTrial, jFrame2));
        jMenuBar.add(ParaProfUtils.createHelpMenu(jFrame2, communicationMatrixWindow));
        jFrame2.setJMenuBar(jMenuBar);
        jFrame2.pack();
        if (ParaProf.getHelpWindow().isVisible()) {
            communicationMatrixWindow.help(false);
        }
        ParaProf.incrementNumWindows();
        return jFrame2;
    }

    private JFrame doCommunicationMatrix(DataSource dataSource, JFrame jFrame) {
        boolean bl = false;
        int n = 0;
        this.size = dataSource.getAllThreads().size();
        this.mapData = new HeatMapData(this.size);
        Object object = dataSource.getAllThreads().iterator();
        while (object.hasNext()) {
            Thread thread = (Thread)object.next();
            Iterator iterator = thread.getUserEventProfiles();
            while (iterator.hasNext()) {
                UserEventProfile userEventProfile = (UserEventProfile)iterator.next();
                if (userEventProfile == null || !(userEventProfile.getNumSamples() > 0.0)) continue;
                String string = userEventProfile.getName();
                if (string.startsWith("Message size sent to node ") && string.indexOf("=>") == -1) {
                    bl = true;
                    this.extractData(userEventProfile, n, string, string, allPaths);
                    continue;
                }
                if (!string.startsWith("Message size sent to node ") || string.indexOf("=>") < 0) continue;
                bl = true;
                StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
                String string2 = stringTokenizer.nextToken().trim();
                String string3 = stringTokenizer.nextToken().trim();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string3, "=>");
                String string4 = null;
                while (stringTokenizer2.hasMoreTokens()) {
                    string4 = stringTokenizer2.nextToken().trim();
                    this.extractData(userEventProfile, n, string, string2, string4);
                }
            }
            ++n;
        }
        if (!bl) {
            JOptionPane.showMessageDialog(jFrame, "This trial does not have communication matrix data.\nTo collect communication matrix data, set the environment variable TAU_COMM_MATRIX=1 before executing your application.", "No Communication Matrix Data", 0);
            return null;
        }
        this.mapData.massageData();
        this.window = new HeatMapWindow("Message Size Heat Maps", this.mapData);
        object = Utility.getResource((String)"tau32x32.gif");
        if (object != null) {
            this.window.setIconImage(Toolkit.getDefaultToolkit().getImage((URL)object));
        }
        return this.window;
    }

    private void extractData(UserEventProfile userEventProfile, int n, String string, String string2, String string3) {
        double d = 0.0;
        double[] dArray = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "Message size sent to node ");
        if (stringTokenizer.hasMoreTokens()) {
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            double[] dArray2 = this.mapData.get(n, n2, string3);
            if (dArray2 == null) {
                dArray2 = dArray;
            }
            double d2 = userEventProfile.getNumSamples();
            dArray2[0] = dArray2[0] + d2;
            double d3 = userEventProfile.getMaxValue();
            dArray2[1] = Math.max(d3, dArray2[1]);
            double d4 = userEventProfile.getMinValue();
            dArray2[2] = dArray2[2] > 0.0 ? Math.min(dArray2[2], d4) : d4;
            double d5 = userEventProfile.getMeanValue();
            dArray2[3] = dArray2[3] + d5;
            double d6 = userEventProfile.getStdDev();
            dArray2[4] = dArray2[4] + d6;
            d = d2 * d5;
            dArray2[5] = dArray2[5] + d;
            this.mapData.put(n, n2, string3, dArray2);
        }
    }

    public JFrame getWindow() {
        try {
            this.window.setVisible(false);
            ParaProf.decrementNumWindows();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.window.dispose();
        return this.window;
    }

    public void closeThisWindow() {
        this.window.setVisible(false);
    }

    public void help(boolean bl) {
        ParaProf.getHelpWindow().clearText();
        if (bl) {
            ParaProf.getHelpWindow().setVisible(true);
        }
        ParaProf.getHelpWindow().writeText("Communication Matrix Window");
        ParaProf.getHelpWindow().writeText("");
        ParaProf.getHelpWindow().writeText("This window shows communication data between nodes.");
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        return 0;
    }

    public JFrame getFrame() {
        return this.window;
    }
}

