/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.paraprof.MetricNotFoundException;
import edu.uoregon.tau.paraprof.ParaProfApplication;
import edu.uoregon.tau.paraprof.ParaProfExperiment;
import edu.uoregon.tau.paraprof.ParaProfExpression;
import edu.uoregon.tau.paraprof.ParaProfManagerWindow;
import edu.uoregon.tau.paraprof.ParaProfMetric;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.ParsingException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class DerivedMetricPanel
extends JPanel
implements ActionListener {
    private ParaProfManagerWindow paraProfManager = null;
    private JTextField arg1Field = new JTextField("", 30);

    public DerivedMetricPanel(ParaProfManagerWindow paraProfManagerWindow) {
        this.paraProfManager = paraProfManagerWindow;
        int n = 800;
        int n2 = 200;
        this.setSize(new Dimension(n, n2));
        this.arg1Field.setEditable(true);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addCompItem(new JLabel("Expression:"), gridBagConstraints, 0, 0, 1, 1);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 0.0;
        this.addCompItem(this.arg1Field, gridBagConstraints, 1, 0, 7, 1);
        JButton jButton = new JButton("Clear");
        jButton.addActionListener(this);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addCompItem(jButton, gridBagConstraints, 8, 0, 1, 1);
        JButton jButton2 = new JButton("Apply");
        jButton2.addActionListener(this);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addCompItem(jButton2, gridBagConstraints, 7, 2, 1, 1);
        JButton jButton3 = new JButton("(");
        jButton3.addActionListener(this);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addCompItem(jButton3, gridBagConstraints, 5, 2, 1, 1);
        JButton jButton4 = new JButton(")");
        jButton4.addActionListener(this);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addCompItem(jButton4, gridBagConstraints, 6, 2, 1, 1);
        JButton jButton5 = new JButton("+");
        jButton5.addActionListener(this);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addCompItem(jButton5, gridBagConstraints, 0, 2, 1, 1);
        JButton jButton6 = new JButton("-");
        jButton6.addActionListener(this);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addCompItem(jButton6, gridBagConstraints, 1, 2, 1, 1);
        JButton jButton7 = new JButton("*");
        jButton7.addActionListener(this);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addCompItem(jButton7, gridBagConstraints, 2, 2, 1, 1);
        JButton jButton8 = new JButton("/");
        jButton8.addActionListener(this);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addCompItem(jButton8, gridBagConstraints, 3, 2, 1, 1);
        JButton jButton9 = new JButton("=");
        jButton9.addActionListener(this);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addCompItem(jButton9, gridBagConstraints, 4, 2, 1, 1);
        JMenuItem jMenuItem = new JMenuItem("Copy");
        jMenuItem.addActionListener(this);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        jMenuItem.setMnemonic(67);
        JMenuItem jMenuItem2 = new JMenuItem("Cut");
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        jMenuItem2.setMnemonic(84);
        jMenuItem2.addActionListener(this);
        JMenuItem jMenuItem3 = new JMenuItem("Paste");
        jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        jMenuItem3.setMnemonic(80);
        jMenuItem3.addActionListener(this);
    }

    public void setArg1Field(String string) {
        this.arg1Field.setText(string);
    }

    public String getArg1Field() {
        return this.arg1Field.getText().trim();
    }

    private void copy() {
        String string = this.arg1Field.getText();
        this.setClipboard(string);
    }

    private void paste() throws IOException {
        String string = this.getFromClipboard();
        this.arg1Field.setText(string);
    }

    private void setClipboard(String string) {
        StringSelection stringSelection = new StringSelection(string);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, stringSelection);
    }

    private String getFromClipboard() {
        boolean bl;
        String string = "";
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(null);
        boolean bl2 = bl = transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor);
        if (bl) {
            try {
                string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                System.out.println(unsupportedFlavorException);
                unsupportedFlavorException.printStackTrace();
            }
            catch (IOException iOException) {
                System.out.println(iOException);
                iOException.printStackTrace();
            }
        }
        return string;
    }

    private void applyToTrial(ParaProfTrial paraProfTrial, String string) throws MetricNotFoundException {
        if (paraProfTrial != null) {
            while (paraProfTrial.loading()) {
                DerivedMetricPanel.sleep(500);
            }
            try {
                this.paraProfManager.expandTrial(paraProfTrial);
                ParaProfExpression paraProfExpression = new ParaProfExpression();
                ParaProfMetric paraProfMetric = paraProfExpression.evaluateExpression(paraProfTrial, string);
                if (paraProfMetric != null) {
                    if (paraProfMetric.getParaProfTrial().dBTrial()) {
                        this.paraProfManager.uploadMetric(paraProfMetric);
                    }
                    this.paraProfManager.populateTrialMetrics(paraProfMetric.getParaProfTrial());
                }
            }
            catch (ParsingException parsingException) {
                parsingException.printStackTrace();
            }
        }
    }

    public void applyOperation() {
        if (!ParaProfExpression.validate(this.arg1Field.getText())) {
            JOptionPane.showMessageDialog(this.paraProfManager, "The expression entered is not valid.", "Expression Error", 0);
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = this.paraProfManager.getSelectedObject();
        if (defaultMutableTreeNode == null) {
            JOptionPane.showMessageDialog(this.paraProfManager, "Please select a trial, experiment or application.", "Warning", 2);
            return;
        }
        ArrayList arrayList = this.collectTrials(defaultMutableTreeNode);
        ArrayList arrayList2 = new ArrayList();
        for (int i = 0; i < arrayList.size(); ++i) {
            try {
                this.applyToTrial((ParaProfTrial)arrayList.get(i), this.arg1Field.getText());
                continue;
            }
            catch (MetricNotFoundException metricNotFoundException) {
                arrayList2.add(arrayList.get(i));
            }
        }
        if (arrayList2.size() > 0) {
            arrayList2.add(0, "The metric could not be derived for the following trials because they did not contain all of the metrics required.\n");
            JOptionPane.showMessageDialog(this.paraProfManager, arrayList2.toArray(), "Warning", 2);
        }
    }

    private ArrayList collectTrials(DefaultMutableTreeNode defaultMutableTreeNode) {
        Object object = this.paraProfManager.getSelectedObject().getUserObject();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (object instanceof ParaProfMetric) {
            ParaProfMetric paraProfMetric = (ParaProfMetric)object;
            arrayList.add(paraProfMetric.getParaProfTrial());
        } else if (object instanceof ParaProfTrial) {
            arrayList.add(defaultMutableTreeNode.getUserObject());
        } else if (object instanceof ParaProfExperiment) {
            this.paraProfManager.expand(defaultMutableTreeNode);
            Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
                this.paraProfManager.expand(defaultMutableTreeNode2);
                arrayList.add(defaultMutableTreeNode2.getUserObject());
            }
        } else if (object instanceof ParaProfApplication) {
            this.paraProfManager.expand(defaultMutableTreeNode);
            Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)enumeration.nextElement();
                this.paraProfManager.expand(defaultMutableTreeNode3);
                Enumeration<TreeNode> enumeration2 = defaultMutableTreeNode3.children();
                while (enumeration2.hasMoreElements()) {
                    DefaultMutableTreeNode defaultMutableTreeNode4 = (DefaultMutableTreeNode)enumeration2.nextElement();
                    this.paraProfManager.expand(defaultMutableTreeNode4);
                    arrayList.add(defaultMutableTreeNode4.getUserObject());
                }
            }
        } else {
            JOptionPane.showMessageDialog(this.paraProfManager, "Please select a trial, experiment or application.", "Warning", 2);
        }
        return arrayList;
    }

    private static void sleep(int n) {
        try {
            Thread.sleep(n);
        }
        catch (Exception exception) {
            throw new RuntimeException("Exception while sleeping");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            String string = actionEvent.getActionCommand();
            if (string.equals("Apply")) {
                this.applyOperation();
            } else if (string.equals("Clear")) {
                this.arg1Field.setText("");
            } else if (string.equals("+")) {
                this.insertString("+");
            } else if (string.equals("+")) {
                this.insertString("+");
            } else if (string.equals("-")) {
                this.insertString("-");
            } else if (string.equals("*")) {
                this.insertString("*");
            } else if (string.equals("/")) {
                this.insertString("/");
            } else if (string.equals("(")) {
                this.insertString(")");
            } else if (string.equals(")")) {
                this.insertString(")");
            } else if (string.equals("=")) {
                this.insertString("=");
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        this.add(component, gridBagConstraints);
    }

    public void insertMetric(ParaProfMetric paraProfMetric) {
        this.arg1Field.replaceSelection("\"" + paraProfMetric.getName() + "\"");
        this.arg1Field.requestFocusInWindow();
        int n = this.arg1Field.getSelectionStart();
        this.arg1Field.setCaretPosition(n);
        if (this.arg1Field.getText().length() == n) {
            this.arg1Field.setText(this.arg1Field.getText() + " ");
            this.arg1Field.setCaretPosition(n);
        }
    }

    public void removeMetric(ParaProfMetric paraProfMetric) {
        int n = this.arg1Field.getSelectionStart();
        String string = this.arg1Field.getText();
        String string2 = string.substring(0, n - (paraProfMetric.getName().length() + 2));
        String string3 = string.substring(n + 1);
        this.arg1Field.setText(string2 + string3);
        this.arg1Field.setCaretPosition(n -= paraProfMetric.getName().length() + 2);
        if (this.arg1Field.getText().length() == n) {
            this.arg1Field.setText(this.arg1Field.getText() + " ");
            this.arg1Field.setCaretPosition(n);
        }
    }

    private void insertString(String string) {
        this.arg1Field.replaceSelection(string);
        this.arg1Field.requestFocusInWindow();
        int n = this.arg1Field.getSelectionStart();
        this.arg1Field.setCaretPosition(n);
        if (this.arg1Field.getText().length() == n) {
            this.arg1Field.setText(this.arg1Field.getText() + " ");
            this.arg1Field.setCaretPosition(n);
        }
    }

    public void applyExpressionFile(LineNumberReader lineNumberReader) throws IOException {
        String string = lineNumberReader.readLine();
        ArrayList arrayList = new ArrayList();
        DefaultMutableTreeNode defaultMutableTreeNode = this.paraProfManager.getSelectedObject();
        if (defaultMutableTreeNode == null) {
            JOptionPane.showMessageDialog(this.paraProfManager, "Please select a trial, experiment or application.", "Warning", 2);
            return;
        }
        if (!(defaultMutableTreeNode.getUserObject() instanceof ParaProfMetric || defaultMutableTreeNode.getUserObject() instanceof ParaProfTrial || defaultMutableTreeNode.getUserObject() instanceof ParaProfTrial || defaultMutableTreeNode.getUserObject() instanceof ParaProfApplication)) {
            JOptionPane.showMessageDialog(this.paraProfManager, "Please select a trial, experiment or application.", "Warning", 2);
            return;
        }
        while (string != null) {
            if (!(string = string.trim()).equals("")) {
                if (!ParaProfExpression.validate(string)) {
                    JOptionPane.showMessageDialog(this.paraProfManager, "The expression entered is not valid.", "Expression Error", 0);
                } else {
                    ArrayList arrayList2 = this.collectTrials(defaultMutableTreeNode);
                    for (int i = 0; i < arrayList2.size(); ++i) {
                        try {
                            this.applyToTrial((ParaProfTrial)arrayList2.get(i), string);
                            continue;
                        }
                        catch (MetricNotFoundException metricNotFoundException) {
                            arrayList.add(arrayList2.get(i));
                        }
                    }
                }
            }
            string = lineNumberReader.readLine();
        }
        if (arrayList.size() > 0) {
            arrayList.add(0, "The metric could not be derived for the follow trials because they did not contain all of the metrics required.\n");
            JOptionPane.showMessageDialog(this.paraProfManager, arrayList.toArray(), "Warning", 2);
        }
    }
}

