/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.paraprof.MetricNotFoundException;
import edu.uoregon.tau.paraprof.ParaProfException;
import edu.uoregon.tau.paraprof.ParaProfMetric;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParsingException;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.Thread;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

public class ParaProfExpression {
    public void evaluateExpression(String string, List list) throws ParsingException, MetricNotFoundException {
        int n;
        char[] cArray = string.toCharArray();
        String string2 = null;
        for (n = 0; n < cArray.length; ++n) {
            if (cArray[n] == '\"') {
                ++n;
                while (cArray[n] != '\"') {
                    ++n;
                }
                continue;
            }
            if (cArray[n] != '=') continue;
            string2 = string.substring(0, n);
            string = string.substring(n + 1);
            break;
        }
        if (string2 == null) {
            string2 = string;
        }
        for (n = 0; n < list.size(); ++n) {
            ParaProfTrial paraProfTrial = (ParaProfTrial)list.get(n);
            ArrayList arrayList = ParaProfExpression.infixToPostfix(string);
            this.evaluate(string2, paraProfTrial, arrayList);
        }
    }

    public ParaProfMetric evaluateExpression(ParaProfTrial paraProfTrial, String string) throws ParsingException, MetricNotFoundException {
        char[] cArray = string.toCharArray();
        String string2 = null;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '\"') {
                ++i;
                while (cArray[i] != '\"') {
                    ++i;
                }
                continue;
            }
            if (cArray[i] != '=') continue;
            string2 = string.substring(0, i);
            string = string.substring(i + 1);
            break;
        }
        ArrayList arrayList = ParaProfExpression.infixToPostfix(string);
        if (string2 == null) {
            string.trim();
            string = string.replace('\"', ' ');
            string2 = "(" + string + ")";
        }
        return this.evaluate(string2, paraProfTrial, arrayList);
    }

    public String evaluateExpressions(String string, List list) throws ParsingException, IOException, MetricNotFoundException {
        return this.evaluateMany(new LineNumberReader(new CharArrayReader(string.toCharArray())), list);
    }

    public String evaluateFile(String string, List list) throws ParsingException, IOException, MetricNotFoundException {
        LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(new File(string)));
        return this.evaluateMany(lineNumberReader, list);
    }

    private String evaluateMany(LineNumberReader lineNumberReader, List list) throws ParsingException, IOException, MetricNotFoundException {
        String string = lineNumberReader.readLine();
        while (string != null) {
            string.trim();
            if (!string.equals("")) {
                this.evaluateExpression(string.trim(), list);
            }
            string = lineNumberReader.readLine();
        }
        return "";
    }

    public static boolean validate(String string) {
        try {
            ArrayList arrayList = ParaProfExpression.infixToPostfix(string);
            if (arrayList.size() < 2) {
                return false;
            }
            for (int i = 0; arrayList.size() > 1 && arrayList.size() > i; ++i) {
                if (!ParaProfExpression.isOperation(arrayList.get(i))) continue;
                try {
                    Object e = arrayList.remove(i);
                    Object e2 = arrayList.remove(i - 1);
                    Object e3 = arrayList.remove(i - 2);
                    arrayList.add(i -= 2, "Intermedate");
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new ParsingException();
                }
            }
            return true;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return false;
        }
        catch (ParsingException parsingException) {
            return false;
        }
    }

    private static ArrayList infixToPostfix(String string) throws ParsingException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = "";
        Stack<Character> stack = new Stack<Character>();
        char[] cArray = string.toCharArray();
        block20: for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            switch (c) {
                case '\"': {
                    ++i;
                    while (cArray[i] != '\"') {
                        string2 = string2 + cArray[i];
                        ++i;
                    }
                    continue block20;
                }
                case '+': {
                    if (!string2.equals("")) {
                        arrayList.add(string2 + "");
                    }
                    string2 = "";
                    try {
                        while (((Character)stack.peek()).charValue() != '(') {
                            arrayList.add(stack.pop() + "");
                        }
                    }
                    catch (EmptyStackException emptyStackException) {
                        // empty catch block
                    }
                    stack.push(new Character('+'));
                    continue block20;
                }
                case '-': {
                    if (!string2.equals("")) {
                        arrayList.add(string2 + "");
                    }
                    string2 = "";
                    try {
                        while (((Character)stack.peek()).charValue() != '(') {
                            arrayList.add(stack.pop() + "");
                        }
                    }
                    catch (EmptyStackException emptyStackException) {
                        // empty catch block
                    }
                    stack.push(new Character('-'));
                    continue block20;
                }
                case '/': {
                    if (!string2.equals("")) {
                        arrayList.add(string2 + "");
                    }
                    string2 = "";
                    try {
                        while (((Character)stack.peek()).charValue() != '(' && ((Character)stack.peek()).charValue() != '-' && ((Character)stack.peek()).charValue() != '+') {
                            arrayList.add(stack.pop() + "");
                        }
                    }
                    catch (EmptyStackException emptyStackException) {
                        // empty catch block
                    }
                    stack.push(new Character('/'));
                    continue block20;
                }
                case '*': {
                    if (!string2.equals("")) {
                        arrayList.add(string2 + "");
                    }
                    string2 = "";
                    try {
                        while (((Character)stack.peek()).charValue() != '(' && ((Character)stack.peek()).charValue() != '-' && ((Character)stack.peek()).charValue() != '+') {
                            arrayList.add(stack.pop() + "");
                        }
                    }
                    catch (EmptyStackException emptyStackException) {
                        // empty catch block
                    }
                    stack.push(new Character('*'));
                    continue block20;
                }
                case '(': {
                    stack.push(new Character('('));
                    continue block20;
                }
                case ')': {
                    if (!string2.equals("")) {
                        arrayList.add(string2 + "");
                    }
                    string2 = "";
                    try {
                        while (((Character)stack.peek()).charValue() != '(') {
                            arrayList.add(stack.pop() + "");
                        }
                        stack.pop();
                        continue block20;
                    }
                    catch (EmptyStackException emptyStackException) {
                        throw new ParsingException("Unmatched )");
                    }
                }
                case ' ': {
                    continue block20;
                }
                default: {
                    string2 = string2 + c;
                }
            }
        }
        if (!string2.equals("")) {
            arrayList.add(string2 + "");
        }
        string2 = "";
        while (!stack.isEmpty()) {
            arrayList.add(stack.pop() + "");
        }
        return arrayList;
    }

    private static boolean isValue(String string) {
        try {
            Double.valueOf(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private static double apply(char c, double d, double d2) {
        double d3 = 0.0;
        switch (c) {
            case '+': {
                d3 = d + d2;
                break;
            }
            case '-': {
                if (!(d > d2)) break;
                d3 = d - d2;
                break;
            }
            case '*': {
                d3 = d * d2;
                break;
            }
            case '/': {
                if (d2 == 0.0) break;
                return d / d2;
            }
            default: {
                throw new ParaProfException("Unexpected operation type: " + c);
            }
        }
        return d3;
    }

    private ParaProfMetric findMetric(Object object, ParaProfTrial paraProfTrial) throws MetricNotFoundException {
        if (object instanceof ParaProfMetric) {
            return (ParaProfMetric)object;
        }
        int n = paraProfTrial.getMetricID((String)object);
        if (n < 0) {
            throw new MetricNotFoundException("Metric \"" + object + "\" was not found");
        }
        return paraProfTrial.getMetric(n);
    }

    private static boolean isOperation(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            char c = string.charAt(0);
            return c == '+' || c == '-' || c == '*' || c == '/';
        }
        return false;
    }

    protected ParaProfMetric rename(String string, ParaProfMetric paraProfMetric) {
        paraProfMetric.setName(string);
        return paraProfMetric;
    }

    private static void sleep(int n) {
        try {
            java.lang.Thread.sleep(n);
        }
        catch (Exception exception) {
            throw new RuntimeException("Exception while sleeping");
        }
    }

    private ParaProfMetric evaluate(String string, ParaProfTrial paraProfTrial, ArrayList arrayList) throws ParsingException, MetricNotFoundException {
        Object object;
        if (paraProfTrial == null) {
            throw new ParsingException("Null trial");
        }
        if (string != null) {
            string = string.trim();
        }
        if (arrayList.size() == 1) {
            return this.rename(string, this.findMetric(arrayList.get(0), paraProfTrial));
        }
        while (paraProfTrial.loading()) {
            ParaProfExpression.sleep(500);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            String string2 = (String)arrayList.get(i);
            if (ParaProfExpression.isOperation(string2)) continue;
            if (ParaProfExpression.isValue(string2)) {
                object = new Double[]{Double.valueOf(string2), Double.valueOf(string2)};
                arrayList.remove(i);
                arrayList.add(i, object);
                continue;
            }
            object = this.findMetric(string2, paraProfTrial);
            arrayList.remove(i);
            arrayList.add(i, object);
        }
        ParaProfMetric paraProfMetric = paraProfTrial.addMetric();
        paraProfMetric.setPpTrial(paraProfTrial);
        paraProfMetric.setName(string);
        paraProfMetric.setDerivedMetric(true);
        int n = paraProfMetric.getID();
        object = paraProfTrial.getDataSource().getFunctions();
        Iterator iterator = paraProfTrial.getDataSource().getAllThreads().iterator();
        while (iterator.hasNext()) {
            Thread thread = (Thread)iterator.next();
            thread.addMetric();
            object = thread.getFunctionProfileIterator();
            while (object.hasNext()) {
                FunctionProfile functionProfile = (FunctionProfile)object.next();
                if (functionProfile == null) continue;
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                for (int i = 0; i < arrayList.size(); ++i) {
                    Object e = arrayList.get(i);
                    if (e instanceof ParaProfMetric) {
                        ParaProfMetric paraProfMetric2 = (ParaProfMetric)e;
                        double d = functionProfile.getExclusive(paraProfMetric2.getID());
                        double d2 = functionProfile.getInclusive(paraProfMetric2.getID());
                        Double[] doubleArray = new Double[]{new Double(d2), new Double(d)};
                        arrayList2.add(doubleArray);
                        continue;
                    }
                    arrayList2.add(e);
                }
                Double[] doubleArray = this.eval(arrayList2);
                functionProfile.setInclusive(n, doubleArray[0].doubleValue());
                functionProfile.setExclusive(n, doubleArray[1].doubleValue());
            }
            thread.setThreadData(n);
        }
        paraProfTrial.setMeanData(n);
        paraProfTrial.getDataSource().getMeanData().setThreadData(n);
        paraProfTrial.getDataSource().getTotalData().setThreadData(n);
        paraProfTrial.getDataSource().getStdDevData().setThreadData(n);
        return paraProfMetric;
    }

    private Double[] eval(ArrayList arrayList) throws ParsingException {
        for (int i = 0; arrayList.size() > 1 && arrayList.size() > i; ++i) {
            if (!ParaProfExpression.isOperation(arrayList.get(i))) continue;
            try {
                char c = ((String)arrayList.remove(i)).trim().charAt(0);
                Double[] doubleArray = (Double[])arrayList.remove(i - 1);
                Double[] doubleArray2 = (Double[])arrayList.remove(i - 2);
                double d = ParaProfExpression.apply(c, doubleArray2[0], doubleArray[0]);
                double d2 = ParaProfExpression.apply(c, doubleArray2[1], doubleArray[1]);
                Double[] doubleArray3 = new Double[]{new Double(d), new Double(d2)};
                arrayList.add(i -= 2, doubleArray3);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new ParsingException();
            }
        }
        return (Double[])arrayList.get(0);
    }
}

