/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.common.TauRuntimeException;
import edu.uoregon.tau.common.Utility;
import edu.uoregon.tau.paraprof.DerivedMetricPanel;
import edu.uoregon.tau.paraprof.FunctionBarChartWindow;
import edu.uoregon.tau.paraprof.LoadTrialProgressWindow;
import edu.uoregon.tau.paraprof.LoadTrialWindow;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfApplication;
import edu.uoregon.tau.paraprof.ParaProfExperiment;
import edu.uoregon.tau.paraprof.ParaProfMetric;
import edu.uoregon.tau.paraprof.ParaProfTreeCellRenderer;
import edu.uoregon.tau.paraprof.ParaProfTreeNodeUserObject;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.RegressionGraph;
import edu.uoregon.tau.paraprof.SelectiveFileGenerator;
import edu.uoregon.tau.paraprof.tablemodel.ApplicationTableModel;
import edu.uoregon.tau.paraprof.tablemodel.ExperimentTableModel;
import edu.uoregon.tau.paraprof.tablemodel.MetricTableModel;
import edu.uoregon.tau.paraprof.tablemodel.TrialCellRenderer;
import edu.uoregon.tau.paraprof.tablemodel.TrialTableModel;
import edu.uoregon.tau.perfdmf.Application;
import edu.uoregon.tau.perfdmf.DBDataSource;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.DataSourceException;
import edu.uoregon.tau.perfdmf.DataSourceExport;
import edu.uoregon.tau.perfdmf.Database;
import edu.uoregon.tau.perfdmf.DatabaseAPI;
import edu.uoregon.tau.perfdmf.DatabaseException;
import edu.uoregon.tau.perfdmf.Experiment;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfdmf.UtilFncs;
import edu.uoregon.tau.perfdmf.database.DB;
import edu.uoregon.tau.perfdmf.database.DBConnector;
import edu.uoregon.tau.perfdmf.database.DBManagerListener;
import edu.uoregon.tau.perfdmf.database.DatabaseManagerWindow;
import edu.uoregon.tau.perfdmf.database.ParseConfig;
import edu.uoregon.tau.perfdmf.database.PasswordCallback;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ParaProfManagerWindow
extends JFrame
implements ActionListener,
TreeSelectionListener,
TreeWillExpandListener,
DBManagerListener {
    private DefaultMutableTreeNode root;
    private JTree tree = null;
    private DefaultTreeModel treeModel = null;
    private DefaultMutableTreeNode standard = null;
    private DefaultMutableTreeNode runtime = null;
    private JSplitPane jSplitInnerPane = null;
    private JSplitPane jSplitOuterPane = null;
    private JCheckBoxMenuItem showApplyOperationItem = null;
    private DerivedMetricPanel derivedMetricPanel = new DerivedMetricPanel(this);
    private JScrollPane treeScrollPane;
    private Vector loadedDBTrials = new Vector();
    private Vector loadedTrials = new Vector();
    private boolean metaDataRetrieved;
    private JPopupMenu popup1 = new JPopupMenu();
    private JPopupMenu stdAppPopup = new JPopupMenu();
    private JPopupMenu stdExpPopup = new JPopupMenu();
    private JPopupMenu stdTrialPopup = new JPopupMenu();
    private JPopupMenu dbAppPopup = new JPopupMenu();
    private JPopupMenu dbExpPopup = new JPopupMenu();
    private JPopupMenu dbTrialPopup = new JPopupMenu();
    private JPopupMenu metricPopup = new JPopupMenu();
    private JPopupMenu multiPopup = new JPopupMenu();
    private JPopupMenu runtimePopup = new JPopupMenu();
    private Object clickedOnObject = null;
    private DefaultMutableTreeNode selectedObject = null;
    private ParaProfMetric operand1 = null;
    private ParaProfMetric operand2 = null;
    private String dbDisplayName;
    private List databases;
    private JFileChooser expressionFileC = new JFileChooser();
    private static String commandLineConfig;
    static /* synthetic */ Class class$java$lang$Object;

    public Object getClickedOnObject() {
        return this.clickedOnObject;
    }

    public DefaultMutableTreeNode getSelectedObject() {
        return this.selectedObject;
    }

    public void refreshDatabases() {
        ArrayList arrayList;
        DefaultMutableTreeNode defaultMutableTreeNode;
        this.databases = Database.getDatabases();
        if (commandLineConfig != null) {
            this.databases.add(new Database("Portal", commandLineConfig));
        }
        Iterator iterator = this.databases.iterator();
        Enumeration<TreeNode> enumeration = this.root.children();
        while (enumeration.hasMoreElements() && iterator.hasNext()) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            if (defaultMutableTreeNode.getUserObject() == "Standard Applications") continue;
            arrayList = iterator.next();
            defaultMutableTreeNode.setUserObject(arrayList);
        }
        arrayList = new ArrayList<DefaultMutableTreeNode>();
        while (enumeration.hasMoreElements()) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            arrayList.add(defaultMutableTreeNode);
        }
        while (iterator.hasNext()) {
            Object e = iterator.next();
            this.root.add(new DefaultMutableTreeNode(e));
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)arrayList.get(i);
            defaultMutableTreeNode.removeFromParent();
        }
        this.getTreeModel().reload();
    }

    public ParaProfManagerWindow() {
        this("");
    }

    public ParaProfManagerWindow(String string) {
        if (string != null && string != "") {
            commandLineConfig = string;
        }
        int n = 800;
        int n2 = 515;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        int n3 = dimension.height;
        int n4 = dimension.width;
        Point point = ParaProf.preferences.getManagerWindowPosition();
        if (point == null || point.x + n > n4 || point.y + n2 > n3) {
            int n5 = (n4 - n) / 2;
            int n6 = (n3 - n2) / 2;
            if (n5 > 50) {
                n5 -= 50;
            }
            if (n6 > 50) {
                n6 -= 50;
            }
            this.setLocation(n5, n6);
        } else {
            this.setLocation(point);
        }
        if (ParaProf.demoMode) {
            this.setLocation(0, 0);
        }
        this.setSize(ParaProfUtils.checkSize(new Dimension(n, n2)));
        this.setTitle("TAU: ParaProf Manager");
        ParaProfUtils.setFrameIcon(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ParaProfManagerWindow.this.thisWindowClosing(windowEvent);
            }
        });
        this.setupMenus();
        this.root = new DefaultMutableTreeNode("Applications");
        this.standard = new DefaultMutableTreeNode("Standard Applications");
        this.root.add(this.standard);
        this.databases = Database.getDatabases();
        if (commandLineConfig != null) {
            this.databases.add(new Database("Portal", commandLineConfig));
        }
        Object object = this.databases.iterator();
        while (object.hasNext()) {
            Database database = (Database)object.next();
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(database);
            this.root.add(defaultMutableTreeNode);
        }
        this.setTreeModel(new DefaultTreeModel(this.root));
        this.getTreeModel().setAsksAllowsChildren(true);
        this.tree = new JTree(this.getTreeModel());
        this.tree.getSelectionModel().setSelectionMode(4);
        object = new ParaProfTreeCellRenderer();
        this.tree.setCellRenderer((TreeCellRenderer)object);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                try {
                    TreePath[] treePathArray;
                    Object object;
                    if (ParaProfUtils.rightClick(mouseEvent)) {
                        int n = ParaProfManagerWindow.this.tree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                        object = ParaProfManagerWindow.this.tree.getSelectionRows();
                        boolean bl = false;
                        if (object != null) {
                            for (int i = 0; i < ((Object)object).length; ++i) {
                                if (n != object[i]) continue;
                                bl = true;
                                break;
                            }
                        }
                        if (!bl) {
                            ParaProfManagerWindow.this.tree.setSelectionRow(n);
                        }
                    }
                    if ((treePathArray = ParaProfManagerWindow.this.tree.getSelectionPaths()) == null) {
                        return;
                    }
                    if (treePathArray.length > 1) {
                        ParaProfManagerWindow.this.clickedOnObject = treePathArray;
                        if (ParaProfUtils.rightClick(mouseEvent)) {
                            object = treePathArray[0];
                            ParaProfManagerWindow.this.multiPopup.show(ParaProfManagerWindow.this.tree, mouseEvent.getX(), mouseEvent.getY());
                        }
                    }
                    if (treePathArray.length == 1) {
                        object = treePathArray[0];
                        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)((TreePath)object).getLastPathComponent();
                        Object object2 = defaultMutableTreeNode.getUserObject();
                        if (ParaProfUtils.rightClick(mouseEvent)) {
                            if (object2 instanceof ParaProfApplication) {
                                ParaProfManagerWindow.this.clickedOnObject = object2;
                                if (((ParaProfApplication)object2).dBApplication()) {
                                    ParaProfManagerWindow.this.dbAppPopup.show(ParaProfManagerWindow.this.tree, mouseEvent.getX(), mouseEvent.getY());
                                } else {
                                    ParaProfManagerWindow.this.stdAppPopup.show(ParaProfManagerWindow.this.tree, mouseEvent.getX(), mouseEvent.getY());
                                }
                            } else if (object2 instanceof ParaProfExperiment) {
                                ParaProfManagerWindow.this.clickedOnObject = object2;
                                if (((ParaProfExperiment)object2).dBExperiment()) {
                                    ParaProfManagerWindow.this.dbExpPopup.show(ParaProfManagerWindow.this.tree, mouseEvent.getX(), mouseEvent.getY());
                                } else {
                                    ParaProfManagerWindow.this.stdExpPopup.show(ParaProfManagerWindow.this.tree, mouseEvent.getX(), mouseEvent.getY());
                                }
                            } else if (object2 instanceof ParaProfTrial) {
                                ParaProfManagerWindow.this.clickedOnObject = object2;
                                if (((ParaProfTrial)object2).dBTrial()) {
                                    ParaProfManagerWindow.this.dbTrialPopup.show(ParaProfManagerWindow.this.tree, mouseEvent.getX(), mouseEvent.getY());
                                } else {
                                    ParaProfManagerWindow.this.stdTrialPopup.show(ParaProfManagerWindow.this.tree, mouseEvent.getX(), mouseEvent.getY());
                                }
                            } else if (object2 instanceof ParaProfMetric) {
                                ParaProfManagerWindow.this.clickedOnObject = object2;
                                ParaProfManagerWindow.this.metricPopup.show(ParaProfManagerWindow.this.tree, mouseEvent.getX(), mouseEvent.getY());
                            } else {
                                ParaProfManagerWindow.this.clickedOnObject = defaultMutableTreeNode;
                                ParaProfManagerWindow.this.popup1.show(ParaProfManagerWindow.this.tree, mouseEvent.getX(), mouseEvent.getY());
                            }
                        } else if (object2 instanceof ParaProfMetric) {
                            ParaProfMetric paraProfMetric = (ParaProfMetric)object2;
                            if (mouseEvent.getClickCount() == 2) {
                                ParaProfManagerWindow.this.showMetric(paraProfMetric);
                                if (ParaProfManagerWindow.this.showApplyOperationItem.isSelected()) {
                                    ParaProfManagerWindow.this.derivedMetricPanel.removeMetric(paraProfMetric);
                                }
                            } else if (ParaProfManagerWindow.this.showApplyOperationItem.isSelected()) {
                                ParaProfManagerWindow.this.derivedMetricPanel.insertMetric(paraProfMetric);
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    ParaProfUtils.handleException(exception);
                }
            }
        };
        this.tree.addMouseListener(mouseAdapter);
        this.tree.addTreeSelectionListener(this);
        this.tree.addTreeWillExpandListener(this);
        this.treeScrollPane = new JScrollPane(this.tree);
        this.jSplitInnerPane = new JSplitPane(1, this.treeScrollPane, this.getPanelHelpMessage(0));
        this.jSplitInnerPane.setContinuousLayout(true);
        this.jSplitInnerPane.setResizeWeight(0.5);
        this.getContentPane().add((Component)this.jSplitInnerPane, "Center");
        this.jSplitInnerPane.setDividerLocation(0.5);
        DBConnector.setPasswordCallback((PasswordCallback)new PasswordCallback(){

            public String getPassword(ParseConfig parseConfig) {
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.insets = new Insets(5, 5, 5, 5);
                JLabel jLabel = new JLabel("<html>Enter password for user '" + parseConfig.getDBUserName() + "'<br> Database: '" + parseConfig.getDBName() + "' (" + parseConfig.getDBHost() + ":" + parseConfig.getDBPort() + ")</html>");
                JPasswordField jPasswordField = new JPasswordField(15);
                gridBagConstraints.fill = 1;
                gridBagConstraints.anchor = 10;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                Utility.addCompItem((Container)jPanel, (Component)jLabel, (GridBagConstraints)gridBagConstraints, (int)0, (int)0, (int)1, (int)1);
                gridBagConstraints.fill = 2;
                Utility.addCompItem((Container)jPanel, (Component)jPasswordField, (GridBagConstraints)gridBagConstraints, (int)1, (int)0, (int)1, (int)1);
                if (JOptionPane.showConfirmDialog(null, jPanel, "Enter Password", 2) == 0) {
                    return new String(jPasswordField.getPassword());
                }
                return null;
            }
        });
        ParaProf.incrementNumWindows();
    }

    void setupMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        JMenuItem jMenuItem = new JMenuItem("Open...");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Preferences...");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Database Configuration");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Close This Window");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Exit ParaProf!");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        JMenu jMenu2 = new JMenu("Options");
        this.showApplyOperationItem = new JCheckBoxMenuItem("Show Derived Metric Panel", false);
        this.showApplyOperationItem.addActionListener(this);
        jMenu2.add(this.showApplyOperationItem);
        JMenuItem jMenuItem2 = new JMenuItem("Apply Expression File");
        jMenuItem2.addActionListener(this);
        jMenu2.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem("Re-Apply Expression File");
        jMenuItem3.addActionListener(this);
        jMenu2.add(jMenuItem3);
        JMenu jMenu3 = new JMenu("Help");
        JMenuItem jMenuItem4 = new JMenuItem("Show Help Window");
        jMenuItem4.addActionListener(this);
        jMenu3.add(jMenuItem4);
        JMenuItem jMenuItem5 = new JMenuItem("About ParaProf");
        jMenuItem5.addActionListener(this);
        jMenu3.add(jMenuItem5);
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        jMenuBar.add(jMenu3);
        this.setJMenuBar(jMenuBar);
        JMenuItem jMenuItem6 = new JMenuItem("Add Application");
        jMenuItem6.addActionListener(this);
        this.popup1.add(jMenuItem6);
        jMenuItem6 = new JMenuItem("Add Experiment");
        jMenuItem6.addActionListener(this);
        this.popup1.add(jMenuItem6);
        jMenuItem6 = new JMenuItem("Add Trial");
        jMenuItem6.addActionListener(this);
        this.popup1.add(jMenuItem6);
        jMenuItem6 = new JMenuItem("Monitor Application");
        jMenuItem6.addActionListener(this);
        this.runtimePopup.add(jMenuItem6);
        jMenuItem6 = new JMenuItem("Add Experiment");
        jMenuItem6.addActionListener(this);
        this.stdAppPopup.add(jMenuItem6);
        jMenuItem6 = new JMenuItem("Add Trial");
        jMenuItem6.addActionListener(this);
        this.stdAppPopup.add(jMenuItem6);
        jMenuItem6 = new JMenuItem("Upload Application to DB");
        jMenuItem6.addActionListener(this);
        this.stdAppPopup.add(jMenuItem6);
        jMenuItem6 = new JMenuItem("Delete");
        jMenuItem6.addActionListener(this);
        this.stdAppPopup.add(jMenuItem6);
        jMenuItem6 = new JMenuItem("Add Experiment");
        jMenuItem6.addActionListener(this);
        this.dbAppPopup.add(jMenuItem6);
        jMenuItem6 = new JMenuItem("Add Trial");
        jMenuItem6.addActionListener(this);
        this.dbAppPopup.add(jMenuItem6);
        jMenuItem6 = new JMenuItem("Delete");
        jMenuItem6.addActionListener(this);
        this.dbAppPopup.add(jMenuItem6);
        jMenuItem6 = new JMenuItem("Upload Experiment to DB");
        jMenuItem6.addActionListener(this);
        this.stdExpPopup.add(jMenuItem6);
        jMenuItem6 = new JMenuItem("Add Trial");
        jMenuItem6.addActionListener(this);
        this.stdExpPopup.add(jMenuItem6);
        jMenuItem6 = new JMenuItem("Delete");
        jMenuItem6.addActionListener(this);
        this.stdExpPopup.add(jMenuItem6);
        jMenuItem6 = new JMenuItem("Add Trial");
        jMenuItem6.addActionListener(this);
        this.dbExpPopup.add(jMenuItem6);
        jMenuItem6 = new JMenuItem("Delete");
        jMenuItem6.addActionListener(this);
        this.dbExpPopup.add(jMenuItem6);
        jMenuItem6 = new JMenuItem("Export Profile");
        jMenuItem6.addActionListener(this);
        this.stdTrialPopup.add(jMenuItem6);
        jMenuItem6 = new JMenuItem("Convert to Phase Profile");
        jMenuItem6.addActionListener(this);
        this.stdTrialPopup.add(jMenuItem6);
        jMenuItem6 = new JMenuItem("Create Selective Instrumentation File");
        jMenuItem6.addActionListener(this);
        this.stdTrialPopup.add(jMenuItem6);
        jMenuItem6 = new JMenuItem("Add Mean to Comparison Window");
        jMenuItem6.addActionListener(this);
        this.stdTrialPopup.add(jMenuItem6);
        jMenuItem6 = new JMenuItem("Upload Trial to DB");
        jMenuItem6.addActionListener(this);
        this.stdTrialPopup.add(jMenuItem6);
        jMenuItem6 = new JMenuItem("Delete");
        jMenuItem6.addActionListener(this);
        this.stdTrialPopup.add(jMenuItem6);
        jMenuItem6 = new JMenuItem("Show metric in new window");
        jMenuItem6.addActionListener(this);
        this.metricPopup.add(jMenuItem6);
        jMenuItem6 = new JMenuItem("Show metric in all sub-windows");
        jMenuItem6.addActionListener(this);
        this.metricPopup.add(jMenuItem6);
        jMenuItem6 = new JMenuItem("Delete");
        jMenuItem6.addActionListener(this);
        this.metricPopup.add(jMenuItem6);
        jMenuItem6 = new JMenuItem("Export Profile");
        jMenuItem6.addActionListener(this);
        this.dbTrialPopup.add(jMenuItem6);
        jMenuItem6 = new JMenuItem("Convert to Phase Profile");
        jMenuItem6.addActionListener(this);
        this.dbTrialPopup.add(jMenuItem6);
        jMenuItem6 = new JMenuItem("Create Selective Instrumentation File");
        jMenuItem6.addActionListener(this);
        this.dbTrialPopup.add(jMenuItem6);
        jMenuItem6 = new JMenuItem("Add Mean to Comparison Window");
        jMenuItem6.addActionListener(this);
        this.dbTrialPopup.add(jMenuItem6);
        jMenuItem6 = new JMenuItem("Delete");
        jMenuItem6.addActionListener(this);
        this.dbTrialPopup.add(jMenuItem6);
        jMenuItem6 = new JMenuItem("Delete");
        jMenuItem6.addActionListener(this);
        this.multiPopup.add(jMenuItem6);
    }

    public void recomputeStats() {
        for (int i = 0; i < this.loadedTrials.size(); ++i) {
            ParaProfTrial paraProfTrial = (ParaProfTrial)this.loadedTrials.get(i);
            paraProfTrial.getDataSource().generateDerivedData();
        }
    }

    public void handleDelete(Object object) throws SQLException, DatabaseException {
        if (object instanceof TreePath[]) {
            TreePath[] treePathArray = (TreePath[])object;
            for (int i = 0; i < treePathArray.length; ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[i].getLastPathComponent();
                Object object2 = defaultMutableTreeNode.getUserObject();
                this.handleDelete(object2);
            }
        } else if (object instanceof ParaProfApplication) {
            ParaProfApplication paraProfApplication = (ParaProfApplication)object;
            if (paraProfApplication.dBApplication()) {
                DatabaseAPI databaseAPI = this.getDatabaseAPI(paraProfApplication.getDatabase());
                if (databaseAPI != null) {
                    databaseAPI.deleteApplication(paraProfApplication.getID());
                    databaseAPI.terminate();
                    Enumeration enumeration = this.loadedDBTrials.elements();
                    while (enumeration.hasMoreElements()) {
                        ParaProfTrial paraProfTrial = (ParaProfTrial)enumeration.nextElement();
                        if (paraProfTrial.getApplicationID() != paraProfApplication.getID() || paraProfTrial.loading()) continue;
                        this.loadedDBTrials.remove(paraProfTrial);
                    }
                    this.getTreeModel().removeNodeFromParent(paraProfApplication.getDMTN());
                }
            } else {
                ParaProf.applicationManager.removeApplication(paraProfApplication);
                this.getTreeModel().removeNodeFromParent(paraProfApplication.getDMTN());
            }
        } else if (object instanceof ParaProfExperiment) {
            ParaProfExperiment paraProfExperiment = (ParaProfExperiment)object;
            if (paraProfExperiment.dBExperiment()) {
                DatabaseAPI databaseAPI = this.getDatabaseAPI(paraProfExperiment.getDatabase());
                if (databaseAPI != null) {
                    databaseAPI.deleteExperiment(paraProfExperiment.getID());
                    databaseAPI.terminate();
                    Enumeration enumeration = this.loadedDBTrials.elements();
                    while (enumeration.hasMoreElements()) {
                        ParaProfTrial paraProfTrial = (ParaProfTrial)enumeration.nextElement();
                        if (paraProfTrial.getApplicationID() != paraProfExperiment.getApplicationID() || paraProfTrial.getExperimentID() != paraProfExperiment.getID() || paraProfTrial.loading()) continue;
                        this.loadedDBTrials.remove(paraProfTrial);
                    }
                    if (paraProfExperiment.getDMTN() != null) {
                        this.getTreeModel().removeNodeFromParent(paraProfExperiment.getDMTN());
                    }
                }
            } else {
                paraProfExperiment.getApplication().removeExperiment(paraProfExperiment);
                this.getTreeModel().removeNodeFromParent(paraProfExperiment.getDMTN());
            }
        } else if (object instanceof ParaProfTrial) {
            ParaProfTrial paraProfTrial = (ParaProfTrial)object;
            if (paraProfTrial.dBTrial()) {
                DatabaseAPI databaseAPI = this.getDatabaseAPI(paraProfTrial.getDatabase());
                if (databaseAPI != null) {
                    databaseAPI.deleteTrial(paraProfTrial.getID());
                    databaseAPI.terminate();
                    Enumeration enumeration = this.loadedDBTrials.elements();
                    while (enumeration.hasMoreElements()) {
                        ParaProfTrial paraProfTrial2 = (ParaProfTrial)enumeration.nextElement();
                        if (paraProfTrial2.getApplicationID() != paraProfTrial.getApplicationID() || paraProfTrial2.getExperimentID() != paraProfTrial.getID() || paraProfTrial2.getID() != paraProfTrial.getID() || paraProfTrial2.loading()) continue;
                        this.loadedDBTrials.remove(paraProfTrial2);
                    }
                    this.getTreeModel().removeNodeFromParent(paraProfTrial.getDMTN());
                }
            } else {
                paraProfTrial.getExperiment().removeTrial(paraProfTrial);
                this.getTreeModel().removeNodeFromParent(paraProfTrial.getDMTN());
            }
        } else if (object instanceof ParaProfMetric) {
            ParaProfMetric paraProfMetric = (ParaProfMetric)object;
            this.deleteMetric(paraProfMetric);
        }
    }

    private boolean isLoaded(ParaProfTrial paraProfTrial) {
        boolean bl = true;
        if (paraProfTrial.dBTrial()) {
            bl = false;
            Enumeration enumeration = this.loadedDBTrials.elements();
            while (enumeration.hasMoreElements()) {
                ParaProfTrial paraProfTrial2 = (ParaProfTrial)enumeration.nextElement();
                if (paraProfTrial.getID() != paraProfTrial2.getID() || paraProfTrial.getExperimentID() != paraProfTrial2.getExperimentID() || paraProfTrial.getApplicationID() != paraProfTrial2.getApplicationID()) continue;
                bl = true;
            }
        }
        return bl;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            if (object instanceof JMenuItem) {
                String string = actionEvent.getActionCommand();
                if (string.equals("Exit ParaProf!")) {
                    this.setVisible(false);
                    this.dispose();
                    ParaProf.exitParaProf(0);
                } else if (string.equals("Open...")) {
                    ParaProfApplication paraProfApplication = this.addApplication(false, this.standard);
                    if (paraProfApplication != null) {
                        this.expandApplicationType(0, paraProfApplication.getID(), paraProfApplication);
                        ParaProfExperiment paraProfExperiment = this.addExperiment(false, paraProfApplication);
                        if (paraProfExperiment != null) {
                            this.expandApplication(0, paraProfApplication, paraProfExperiment);
                            new LoadTrialWindow(this, paraProfApplication, paraProfExperiment, true, true).setVisible(true);
                        }
                    }
                } else if (string.equals("Preferences...")) {
                    ParaProf.preferencesWindow.showPreferencesWindow(this);
                } else if (string.equals("Close This Window")) {
                    this.closeThisWindow();
                } else if (string.equals("Database Configuration")) {
                    new DatabaseManagerWindow((DBManagerListener)this, ParaProf.jarLocation, ParaProf.schemaLocation).setVisible(true);
                } else if (string.equals("Show Derived Metric Panel")) {
                    if (this.showApplyOperationItem.isSelected()) {
                        this.getContentPane().removeAll();
                        this.jSplitOuterPane = new JSplitPane(0, this.jSplitInnerPane, this.derivedMetricPanel);
                        this.getContentPane().add((Component)this.jSplitOuterPane, "Center");
                        this.validate();
                        this.jSplitOuterPane.setDividerLocation(0.75);
                    } else {
                        double d = this.jSplitInnerPane.getDividerLocation();
                        this.getContentPane().removeAll();
                        this.jSplitInnerPane = new JSplitPane(1, this.treeScrollPane, this.getPanelHelpMessage(0));
                        this.jSplitInnerPane.setContinuousLayout(true);
                        this.getContentPane().add((Component)this.jSplitInnerPane, "Center");
                        this.validate();
                        this.jSplitInnerPane.setDividerLocation(d / (double)this.getWidth());
                        this.jSplitOuterPane.setDividerLocation(1.0);
                    }
                } else if (string.equals("Apply Expression File")) {
                    if (this.selectedObject == null) {
                        JOptionPane.showMessageDialog(this, "Please select a trial, experiment or application.", "Warning", 2);
                        return;
                    }
                    if (!(this.selectedObject.getUserObject() instanceof ParaProfMetric || this.selectedObject.getUserObject() instanceof ParaProfTrial || this.selectedObject.getUserObject() instanceof ParaProfTrial || this.selectedObject.getUserObject() instanceof ParaProfApplication)) {
                        JOptionPane.showMessageDialog(this, "Please select a trial, experiment or application.", "Warning", 2);
                        return;
                    }
                    int n = this.expressionFileC.showOpenDialog(this);
                    if (n == 0) {
                        this.derivedMetricPanel.applyExpressionFile(new LineNumberReader(new FileReader(this.expressionFileC.getSelectedFile())));
                    }
                } else if (string.equals("Re-Apply Expression File")) {
                    if (this.selectedObject == null) {
                        JOptionPane.showMessageDialog(this, "Please select a trial, experiment or application.", "Warning", 2);
                        return;
                    }
                    if (!(this.selectedObject.getUserObject() instanceof ParaProfMetric || this.selectedObject.getUserObject() instanceof ParaProfTrial || this.selectedObject.getUserObject() instanceof ParaProfTrial || this.selectedObject.getUserObject() instanceof ParaProfApplication)) {
                        JOptionPane.showMessageDialog(this, "Please select a trial, experiment or application.", "Warning", 2);
                        return;
                    }
                    if (this.expressionFileC.getSelectedFile() != null) {
                        this.derivedMetricPanel.applyExpressionFile(new LineNumberReader(new FileReader(this.expressionFileC.getSelectedFile())));
                    } else {
                        int n = this.expressionFileC.showOpenDialog(this);
                        if (n == 0) {
                            this.derivedMetricPanel.applyExpressionFile(new LineNumberReader(new FileReader(this.expressionFileC.getSelectedFile())));
                        }
                    }
                } else if (string.equals("About ParaProf")) {
                    ImageIcon imageIcon = Utility.getImageIconResource((String)"tau-medium.png");
                    JOptionPane.showMessageDialog(this, ParaProf.getInfoString(), "About ParaProf", 1, imageIcon);
                } else if (string.equals("Show Help Window")) {
                    ParaProf.getHelpWindow().setVisible(true);
                    ParaProf.getHelpWindow().clearText();
                    ParaProf.getHelpWindow().writeText("This is ParaProf's manager window!");
                    ParaProf.getHelpWindow().writeText("");
                    ParaProf.getHelpWindow().writeText("This window allows you to manage all of ParaProf's data sources, including loading data from local files, or from a database. We also support the generation of derived metrics. Please see the items below for more help.");
                    ParaProf.getHelpWindow().writeText("");
                    ParaProf.getHelpWindow().writeText("------------------");
                    ParaProf.getHelpWindow().writeText("");
                    ParaProf.getHelpWindow().writeText("1) Navigation: The window is split into two17 halves, the left side gives a tree representation of all data. The right side gives information about items clicked on in the left half. You can also update information in the right half by double clicking in the fields, and entering new data.  This automatically updates the left half. Right-clicking on the tree nodes in the left half displays popup menus which allow you to add/delete applications, experiments, or trials.");
                    ParaProf.getHelpWindow().writeText("");
                    ParaProf.getHelpWindow().writeText("2) DB Configuration: By default, ParaProf looks in the .ParaProf home directory in your home directory for the database configuration file.  If that file is found, then you are done, and can just expand the DB Applications node.  If there was a problem finding the file, you can enter the location of the file by selecting File -> Database Configuration.  You can also override the configuration file password in the same manner.");
                    ParaProf.getHelpWindow().writeText("");
                    ParaProf.getHelpWindow().writeText("3) Deriving new metrics: By selecting Options -> Show Derived Metric Panel, you will display the apply operations window.  Clicking on the metrics of a trial will update the arguments to the selected operation.  Currently, you can only derive metrics from metric in the same trial (thus for example creating floating point operations per second by taking PAPI_FP_INS and dividing it by GET_TIME_OF_DAY). The 2nd argument is a user editable textbox and can be filled in with scalar  values using the keyword 'val' (e.g. \"val 1.5\".");
                    ParaProf.getHelpWindow().writeText("");
                    ParaProf.getHelpWindow().writeText("------------------");
                    ParaProf.getHelpWindow().writeText("");
                } else if (string.equals("Delete")) {
                    this.handleDelete(this.clickedOnObject);
                } else if (string.equals("Add Application")) {
                    if (this.clickedOnObject == this.standard) {
                        ParaProfApplication paraProfApplication = this.addApplication(false, this.standard);
                        this.expandApplicationType(0, paraProfApplication.getID(), paraProfApplication);
                    } else {
                        ParaProfApplication paraProfApplication = this.addApplication(true, (DefaultMutableTreeNode)this.clickedOnObject);
                        this.expandApplicationType(2, paraProfApplication.getID(), paraProfApplication);
                    }
                } else if (string.equals("Add Experiment")) {
                    if (this.clickedOnObject == this.standard) {
                        ParaProfApplication paraProfApplication = this.addApplication(false, this.standard);
                        ParaProfExperiment paraProfExperiment = this.addExperiment(false, paraProfApplication);
                        if (paraProfApplication != null || paraProfExperiment != null) {
                            this.expandApplicationType(0, paraProfApplication.getID(), paraProfApplication);
                            this.expandApplication(0, paraProfApplication, paraProfExperiment);
                        }
                    } else if (this.clickedOnObject instanceof DefaultMutableTreeNode) {
                        ParaProfApplication paraProfApplication = this.addApplication(true, (DefaultMutableTreeNode)this.clickedOnObject);
                        ParaProfExperiment paraProfExperiment = this.addExperiment(true, paraProfApplication);
                        if (paraProfApplication != null || paraProfExperiment != null) {
                            this.expandApplicationType(2, paraProfApplication.getID(), paraProfApplication);
                            this.expandApplication(2, paraProfApplication, paraProfExperiment);
                        }
                    } else if (this.clickedOnObject instanceof ParaProfApplication) {
                        ParaProfApplication paraProfApplication = (ParaProfApplication)this.clickedOnObject;
                        if (paraProfApplication.dBApplication()) {
                            ParaProfExperiment paraProfExperiment = this.addExperiment(true, paraProfApplication);
                            if (paraProfExperiment != null) {
                                this.expandApplication(2, paraProfApplication, paraProfExperiment);
                            }
                        } else {
                            ParaProfExperiment paraProfExperiment = this.addExperiment(false, paraProfApplication);
                            if (paraProfExperiment != null) {
                                this.expandApplication(0, paraProfApplication, paraProfExperiment);
                            }
                        }
                    }
                } else if (string.equals("Add Trial")) {
                    if (this.clickedOnObject == this.standard) {
                        ParaProfApplication paraProfApplication = this.addApplication(false, this.standard);
                        if (paraProfApplication != null) {
                            this.expandApplicationType(0, paraProfApplication.getID(), paraProfApplication);
                            ParaProfExperiment paraProfExperiment = this.addExperiment(false, paraProfApplication);
                            if (paraProfExperiment != null) {
                                this.expandApplication(0, paraProfApplication, paraProfExperiment);
                                new LoadTrialWindow(this, paraProfApplication, paraProfExperiment, true, true).setVisible(true);
                            }
                        }
                    } else if (this.clickedOnObject instanceof ParaProfApplication) {
                        ParaProfApplication paraProfApplication = (ParaProfApplication)this.clickedOnObject;
                        if (paraProfApplication.dBApplication()) {
                            ParaProfExperiment paraProfExperiment = this.addExperiment(true, paraProfApplication);
                            if (paraProfExperiment != null) {
                                this.expandApplication(2, paraProfApplication, paraProfExperiment);
                                new LoadTrialWindow(this, null, paraProfExperiment, false, true).setVisible(true);
                            }
                        } else {
                            ParaProfExperiment paraProfExperiment = this.addExperiment(false, paraProfApplication);
                            if (paraProfExperiment != null) {
                                this.expandApplication(0, paraProfApplication, paraProfExperiment);
                                new LoadTrialWindow(this, null, paraProfExperiment, false, true).setVisible(true);
                            }
                        }
                    } else if (this.clickedOnObject instanceof ParaProfExperiment) {
                        ParaProfExperiment paraProfExperiment = (ParaProfExperiment)this.clickedOnObject;
                        new LoadTrialWindow(this, null, paraProfExperiment, false, false).setVisible(true);
                    } else {
                        ParaProfApplication paraProfApplication = this.addApplication(true, (DefaultMutableTreeNode)this.clickedOnObject);
                        if (paraProfApplication != null) {
                            this.expandApplicationType(2, paraProfApplication.getID(), paraProfApplication);
                            ParaProfExperiment paraProfExperiment = this.addExperiment(true, paraProfApplication);
                            if (paraProfExperiment != null) {
                                this.expandApplication(2, paraProfApplication, paraProfExperiment);
                                new LoadTrialWindow(this, paraProfApplication, paraProfExperiment, true, true).setVisible(true);
                            }
                        }
                    }
                } else if (string.equals("Upload Application to DB")) {
                    Thread thread = new Thread(new Runnable(){

                        public void run() {
                            try {
                                ParaProfApplication paraProfApplication = (ParaProfApplication)ParaProfManagerWindow.this.clickedOnObject;
                                ParaProfManagerWindow.this.uploadApplication(paraProfApplication, true, true);
                            }
                            catch (Exception exception) {
                                EventQueue.invokeLater(new Runnable(this, exception){
                                    private final /* synthetic */ Exception val$e;
                                    private final /* synthetic */ 4 this$1;
                                    {
                                        this.this$1 = var1_1;
                                        this.val$e = exception;
                                    }

                                    public void run() {
                                        ParaProfUtils.handleException(this.val$e);
                                    }
                                });
                            }
                        }
                    });
                    thread.start();
                } else if (string.equals("Export Application to Filesystem")) {
                    ParaProfApplication paraProfApplication = (ParaProfApplication)this.clickedOnObject;
                    DatabaseAPI databaseAPI = this.getDatabaseAPI(paraProfApplication.getDatabase());
                    if (databaseAPI != null) {
                        boolean bl = false;
                        String string2 = paraProfApplication.getName().replace('/', '%');
                        boolean bl2 = new File(string2).mkdir();
                        databaseAPI.setApplication((Application)paraProfApplication);
                        Iterator iterator = databaseAPI.getExperimentList().iterator();
                        while (iterator.hasNext()) {
                            ParaProfExperiment paraProfExperiment = new ParaProfExperiment((Experiment)iterator.next());
                            String string3 = string2 + File.separator + paraProfExperiment.getName().replace('/', '%');
                            bl2 = new File(string3).mkdir();
                            databaseAPI.setExperiment((Experiment)paraProfExperiment);
                            Iterator iterator2 = databaseAPI.getTrialList(true).iterator();
                            while (iterator2.hasNext()) {
                                Trial trial = (Trial)iterator2.next();
                                databaseAPI.setTrial(trial.getID(), true);
                                DBDataSource dBDataSource = new DBDataSource(databaseAPI);
                                dBDataSource.load();
                                String string4 = string3 + File.separator + trial.getName().replace('/', '%') + ".ppk";
                                DataSourceExport.writePacked((DataSource)dBDataSource, (File)new File(string4));
                            }
                        }
                    }
                } else if (string.equals("Upload Experiment to DB")) {
                    Thread thread = new Thread(new Runnable(){

                        public void run() {
                            try {
                                ParaProfExperiment paraProfExperiment = (ParaProfExperiment)ParaProfManagerWindow.this.clickedOnObject;
                                ParaProfManagerWindow.this.uploadExperiment(null, paraProfExperiment, true, true);
                            }
                            catch (Exception exception) {
                                EventQueue.invokeLater(new Runnable(this, exception){
                                    private final /* synthetic */ Exception val$e;
                                    private final /* synthetic */ 6 this$1;
                                    {
                                        this.this$1 = var1_1;
                                        this.val$e = exception;
                                    }

                                    public void run() {
                                        ParaProfUtils.handleException(this.val$e);
                                    }
                                });
                            }
                        }
                    });
                    thread.start();
                } else if (string.equals("Upload Trial to DB")) {
                    Thread thread = new Thread(new Runnable(){

                        public void run() {
                            try {
                                ParaProfManagerWindow.this.uploadTrial(null, (ParaProfTrial)ParaProfManagerWindow.this.clickedOnObject);
                            }
                            catch (Exception exception) {
                                EventQueue.invokeLater(new Runnable(this, exception){
                                    private final /* synthetic */ Exception val$e;
                                    private final /* synthetic */ 8 this$1;
                                    {
                                        this.this$1 = var1_1;
                                        this.val$e = exception;
                                    }

                                    public void run() {
                                        ParaProfUtils.handleException(this.val$e);
                                    }
                                });
                            }
                        }
                    });
                    thread.start();
                } else if (string.equals("Add all trials to Comparison Window")) {
                    ParaProfExperiment paraProfExperiment = (ParaProfExperiment)this.clickedOnObject;
                    this.compareAllTrials(paraProfExperiment);
                } else if (string.equals("Add Mean to Comparison Window")) {
                    ParaProfTrial paraProfTrial = (ParaProfTrial)this.clickedOnObject;
                    this.addMeanToComparisonWindow(paraProfTrial);
                } else if (string.equals("Export Profile")) {
                    ParaProfTrial paraProfTrial = (ParaProfTrial)this.clickedOnObject;
                    if (paraProfTrial.loading()) {
                        JOptionPane.showMessageDialog(this, "Cannot export trial while loading");
                        return;
                    }
                    if (!this.isLoaded(paraProfTrial)) {
                        JOptionPane.showMessageDialog(this, "Please load the trial before exporting (expand the tree)");
                        return;
                    }
                    ParaProfUtils.exportTrial(paraProfTrial, this);
                } else if (string.equals("Convert to Phase Profile")) {
                    ParaProfTrial paraProfTrial = (ParaProfTrial)this.clickedOnObject;
                    if (paraProfTrial.loading()) {
                        JOptionPane.showMessageDialog(this, "Cannot convert while loading");
                        return;
                    }
                    if (!this.isLoaded(paraProfTrial)) {
                        JOptionPane.showMessageDialog(this, "Please load the trial before converting (expand the tree)");
                        return;
                    }
                    ParaProfUtils.phaseConvertTrial(paraProfTrial, this);
                } else if (string.equals("Create Selective Instrumentation File")) {
                    ParaProfTrial paraProfTrial = (ParaProfTrial)this.clickedOnObject;
                    if (paraProfTrial.loading()) {
                        JOptionPane.showMessageDialog(this, "Cannot convert while loading");
                        return;
                    }
                    if (!this.isLoaded(paraProfTrial)) {
                        JOptionPane.showMessageDialog(this, "Please load the trial before converting (expand the tree)");
                        return;
                    }
                    SelectiveFileGenerator.showWindow(paraProfTrial, this);
                } else if (string.equals("Show metric in new window")) {
                    ParaProfMetric paraProfMetric = (ParaProfMetric)this.clickedOnObject;
                    this.showMetric(paraProfMetric);
                } else if (string.equals("Show metric in all sub-windows")) {
                    ParaProfMetric paraProfMetric = (ParaProfMetric)this.clickedOnObject;
                    this.switchToMetric(paraProfMetric);
                }
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    private void addMeanToComparisonWindow(ParaProfTrial paraProfTrial) {
        if (paraProfTrial.loading()) {
            JOptionPane.showMessageDialog(this, "Cannot perform operation while loading");
        } else {
            boolean bl = true;
            if (paraProfTrial.dBTrial()) {
                bl = false;
                Enumeration enumeration = this.loadedDBTrials.elements();
                while (enumeration.hasMoreElements()) {
                    ParaProfTrial paraProfTrial2 = (ParaProfTrial)enumeration.nextElement();
                    if (paraProfTrial.getID() != paraProfTrial2.getID() || paraProfTrial.getExperimentID() != paraProfTrial2.getExperimentID() || paraProfTrial.getApplicationID() != paraProfTrial2.getApplicationID()) continue;
                    paraProfTrial = paraProfTrial2;
                    bl = true;
                }
            }
            if (!bl) {
                JOptionPane.showMessageDialog(this, "Please load the trial first (expand the tree)");
            } else {
                if (ParaProf.theComparisonWindow == null) {
                    ParaProf.theComparisonWindow = FunctionBarChartWindow.CreateComparisonWindow(paraProfTrial, paraProfTrial.getDataSource().getMeanData(), this);
                } else {
                    ParaProf.theComparisonWindow.addThread(paraProfTrial, paraProfTrial.getDataSource().getMeanData());
                }
                ParaProf.theComparisonWindow.setVisible(true);
            }
        }
    }

    private void compareAllTrials(ParaProfExperiment paraProfExperiment) {
        RegressionGraph regressionGraph = RegressionGraph.createBasicChart(paraProfExperiment.getTrials());
        JFrame jFrame = regressionGraph.createFrame();
        jFrame.setVisible(true);
    }

    private ParaProfApplication uploadApplication(ParaProfApplication paraProfApplication, boolean bl, boolean bl2) throws SQLException, DatabaseException {
        DatabaseAPI databaseAPI = this.getDatabaseAPI(null);
        if (databaseAPI != null) {
            ParaProfApplication paraProfApplication2;
            boolean bl3 = false;
            ListIterator listIterator = databaseAPI.getApplicationList().listIterator();
            while (listIterator.hasNext()) {
                paraProfApplication2 = new ParaProfApplication((Application)listIterator.next());
                if (!paraProfApplication2.getName().equals(paraProfApplication.getName())) continue;
                bl3 = true;
                if (bl) {
                    Object[] objectArray = new String[]{"Overwrite", "Don't overwrite", "Cancel"};
                    int n = JOptionPane.showOptionDialog(this, "An Application with the name \"" + paraProfApplication.getName() + "\" already exists, it will be updated new experiments/trials, should the metadata be overwritten?", "Upload Application", 0, 3, null, objectArray, objectArray[1]);
                    if (n == -1 || n == 2) {
                        return null;
                    }
                    if (n == 0) {
                        paraProfApplication2.setFields(paraProfApplication.getFields());
                        databaseAPI.saveApplication((Application)paraProfApplication2);
                    }
                    if (bl2) {
                        ListIterator listIterator2 = paraProfApplication.getExperimentList();
                        while (listIterator2.hasNext()) {
                            ParaProfExperiment paraProfExperiment = (ParaProfExperiment)listIterator2.next();
                            this.uploadExperiment(paraProfApplication2, paraProfExperiment, true, true);
                        }
                    }
                }
                paraProfApplication2.setDatabase(this.getDefaultDatabase());
                return paraProfApplication2;
            }
            if (!bl3) {
                paraProfApplication2 = new Application((Application)paraProfApplication);
                paraProfApplication2.setID(-1);
                ParaProfApplication paraProfApplication3 = new ParaProfApplication(paraProfApplication2);
                paraProfApplication3.setDBApplication(true);
                paraProfApplication3.setID(databaseAPI.saveApplication((Application)paraProfApplication3));
                if (bl2) {
                    ListIterator listIterator3 = paraProfApplication.getExperimentList();
                    while (listIterator3.hasNext()) {
                        ParaProfExperiment paraProfExperiment = (ParaProfExperiment)listIterator3.next();
                        this.uploadExperiment(paraProfApplication3, paraProfExperiment, true, true);
                    }
                }
                return paraProfApplication3;
            }
        }
        return null;
    }

    private ParaProfExperiment uploadExperiment(ParaProfApplication paraProfApplication, ParaProfExperiment paraProfExperiment, boolean bl, boolean bl2) throws SQLException, DatabaseException {
        ParaProfExperiment paraProfExperiment2;
        DatabaseAPI databaseAPI = this.getDatabaseAPI(null);
        if (databaseAPI == null) {
            return null;
        }
        if (paraProfApplication == null) {
            paraProfApplication = this.uploadApplication(paraProfExperiment.getApplication(), false, false);
        }
        boolean bl3 = false;
        databaseAPI.setApplication((Application)paraProfApplication);
        ListIterator listIterator = databaseAPI.getExperimentList().listIterator();
        while (listIterator.hasNext()) {
            paraProfExperiment2 = new ParaProfExperiment((Experiment)listIterator.next());
            if (!paraProfExperiment2.getName().equals(paraProfExperiment.getName())) continue;
            bl3 = true;
            if (bl) {
                Object[] objectArray = new String[]{"Overwrite", "Don't overwrite", "Cancel"};
                int n = JOptionPane.showOptionDialog(this, "An Experiment with the name \"" + paraProfExperiment.getName() + "\" already exists, it will be updated new trials, should the metadata be overwritten?", "Upload Application", 0, 3, null, objectArray, objectArray[1]);
                if (n == -1 || n == 2) {
                    return null;
                }
                if (n == 0) {
                    paraProfExperiment2.setFields(paraProfExperiment.getFields());
                    databaseAPI.saveExperiment((Experiment)paraProfExperiment2);
                }
                if (bl2) {
                    ListIterator listIterator2 = paraProfExperiment.getTrialList();
                    while (listIterator2.hasNext()) {
                        ParaProfTrial paraProfTrial = (ParaProfTrial)listIterator2.next();
                        this.uploadTrial(paraProfExperiment2, paraProfTrial);
                    }
                }
            }
            paraProfExperiment2.setApplication(paraProfApplication);
            return paraProfExperiment2;
        }
        if (!bl3) {
            paraProfExperiment2 = new Experiment((Experiment)paraProfExperiment);
            ParaProfExperiment paraProfExperiment3 = new ParaProfExperiment(paraProfExperiment2);
            paraProfExperiment2.setID(-1);
            paraProfExperiment3.setDBExperiment(true);
            paraProfExperiment3.setApplicationID(paraProfApplication.getID());
            paraProfExperiment3.setApplication(paraProfApplication);
            paraProfExperiment3.setID(databaseAPI.saveExperiment((Experiment)paraProfExperiment3));
            if (bl2) {
                ListIterator listIterator3 = paraProfExperiment.getTrialList();
                while (listIterator3.hasNext()) {
                    ParaProfTrial paraProfTrial = (ParaProfTrial)listIterator3.next();
                    this.uploadTrial(paraProfExperiment3, paraProfTrial);
                }
            }
            return paraProfExperiment3;
        }
        return null;
    }

    private ParaProfTrial uploadTrial(ParaProfExperiment paraProfExperiment, ParaProfTrial paraProfTrial) throws SQLException, DatabaseException {
        DatabaseAPI databaseAPI = this.getDatabaseAPI(null);
        if (databaseAPI == null) {
            return null;
        }
        if (paraProfExperiment == null) {
            paraProfExperiment = this.uploadExperiment(null, paraProfTrial.getExperiment(), false, false);
        }
        ParaProfTrial paraProfTrial2 = new ParaProfTrial(paraProfTrial.getTrial());
        paraProfTrial2.setID(-1);
        paraProfTrial2.setExperimentID(paraProfExperiment.getID());
        paraProfTrial2.setApplicationID(paraProfExperiment.getApplicationID());
        paraProfTrial2.getTrial().setDataSource(paraProfTrial.getDataSource());
        paraProfTrial2.setExperiment(paraProfExperiment);
        paraProfTrial2.setUpload(true);
        LoadTrialProgressWindow loadTrialProgressWindow = new LoadTrialProgressWindow(this, paraProfTrial2.getDataSource(), paraProfTrial2, true);
        loadTrialProgressWindow.setVisible(true);
        loadTrialProgressWindow.waitForLoad();
        return paraProfTrial2;
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        try {
            TreePath treePath = this.tree.getSelectionPath();
            if (treePath == null) {
                return;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            Object object = defaultMutableTreeNode.getUserObject();
            this.selectedObject = defaultMutableTreeNode;
            int n = this.jSplitInnerPane.getDividerLocation();
            if (defaultMutableTreeNode.isRoot()) {
                this.jSplitInnerPane.setRightComponent(this.getPanelHelpMessage(0));
            } else if (defaultMutableTreeNode2.isRoot()) {
                if (object.toString().equals("Standard Applications")) {
                    this.jSplitInnerPane.setRightComponent(this.getPanelHelpMessage(1));
                } else if (object.toString().equals("Runtime Applications")) {
                    this.jSplitInnerPane.setRightComponent(this.getPanelHelpMessage(2));
                } else if (object.toString().equals("DB Applications")) {
                    this.jSplitInnerPane.setRightComponent(this.getPanelHelpMessage(3));
                }
            } else if (object instanceof ParaProfApplication) {
                this.jSplitInnerPane.setRightComponent(this.getTable(object));
            } else if (object instanceof ParaProfExperiment) {
                this.jSplitInnerPane.setRightComponent(this.getTable(object));
            } else if (object instanceof ParaProfTrial) {
                this.jSplitInnerPane.setRightComponent(this.getTable(object));
            } else if (object instanceof ParaProfMetric) {
                this.metricSelected((ParaProfMetric)object, false);
            }
            this.jSplitInnerPane.setDividerLocation(n);
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    private void clearDefaultMutableTreeNodes(DefaultMutableTreeNode defaultMutableTreeNode) {
        int n = defaultMutableTreeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            ((ParaProfTreeNodeUserObject)defaultMutableTreeNode2.getUserObject()).clearDefaultMutableTreeNode();
            this.clearDefaultMutableTreeNodes((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i));
        }
    }

    public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) {
        try {
            TreePath treePath = treeExpansionEvent.getPath();
            if (treePath == null) {
                return;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            Object object = defaultMutableTreeNode.getUserObject();
            if (defaultMutableTreeNode.isRoot()) {
                this.clearDefaultMutableTreeNodes(this.standard);
            } else if (defaultMutableTreeNode2.isRoot()) {
                this.clearDefaultMutableTreeNodes(defaultMutableTreeNode);
            } else if (object instanceof ParaProfTreeNodeUserObject) {
                this.clearDefaultMutableTreeNodes(defaultMutableTreeNode);
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void treeWillExpandNEW(TreeExpansionEvent treeExpansionEvent) {
        TreePath treePath = treeExpansionEvent.getPath();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        if (defaultMutableTreeNode.isRoot()) {
            return;
        }
    }

    public void expand(DefaultMutableTreeNode defaultMutableTreeNode) {
        try {
            int n;
            DefaultMutableTreeNode defaultMutableTreeNode2;
            Object object;
            ListIterator listIterator;
            ParaProfTreeNodeUserObject paraProfTreeNodeUserObject;
            TreePath treePath = new TreePath(defaultMutableTreeNode);
            TreeExpansionEvent treeExpansionEvent = new TreeExpansionEvent(this.tree, treePath);
            DefaultMutableTreeNode defaultMutableTreeNode3 = defaultMutableTreeNode;
            Object object2 = defaultMutableTreeNode.getUserObject();
            if (object2 instanceof ParaProfApplication) {
                ListIterator listIterator2;
                paraProfTreeNodeUserObject = (ParaProfApplication)object2;
                if (((ParaProfApplication)paraProfTreeNodeUserObject).dBApplication()) {
                    for (int i = defaultMutableTreeNode3.getChildCount(); i > 0; --i) {
                        this.getTreeModel().removeNodeFromParent((DefaultMutableTreeNode)defaultMutableTreeNode3.getChildAt(i - 1));
                    }
                    listIterator2 = this.getDatabaseAPI(paraProfTreeNodeUserObject.getDatabase());
                    if (listIterator2 != null) {
                        listIterator2.setApplication(paraProfTreeNodeUserObject.getID());
                        listIterator = listIterator2.getExperimentList().listIterator();
                        while (listIterator.hasNext()) {
                            object = new ParaProfExperiment((Experiment)listIterator.next());
                            ((ParaProfExperiment)object).setDBExperiment(true);
                            ((ParaProfExperiment)object).setApplication((ParaProfApplication)paraProfTreeNodeUserObject);
                            defaultMutableTreeNode2 = new DefaultMutableTreeNode(object);
                            ((ParaProfExperiment)object).setDMTN(defaultMutableTreeNode2);
                            this.getTreeModel().insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode3, defaultMutableTreeNode3.getChildCount());
                        }
                        listIterator2.terminate();
                    }
                } else {
                    for (int i = defaultMutableTreeNode3.getChildCount(); i > 0; --i) {
                        this.getTreeModel().removeNodeFromParent((DefaultMutableTreeNode)defaultMutableTreeNode3.getChildAt(i - 1));
                    }
                    listIterator2 = ((ParaProfApplication)paraProfTreeNodeUserObject).getExperimentList();
                    while (listIterator2.hasNext()) {
                        listIterator = (ParaProfExperiment)listIterator2.next();
                        object = new DefaultMutableTreeNode(listIterator);
                        ((ParaProfExperiment)((Object)listIterator)).setDMTN((DefaultMutableTreeNode)object);
                        this.getTreeModel().insertNodeInto((MutableTreeNode)object, defaultMutableTreeNode3, defaultMutableTreeNode3.getChildCount());
                    }
                }
                n = this.jSplitInnerPane.getDividerLocation();
                this.jSplitInnerPane.setRightComponent(this.getTable(object2));
                this.jSplitInnerPane.setDividerLocation(n);
            }
            if (object2 instanceof ParaProfExperiment) {
                ListIterator listIterator3;
                paraProfTreeNodeUserObject = (ParaProfExperiment)object2;
                if (((ParaProfExperiment)paraProfTreeNodeUserObject).dBExperiment()) {
                    for (n = defaultMutableTreeNode3.getChildCount(); n > 0; --n) {
                        this.getTreeModel().removeNodeFromParent((DefaultMutableTreeNode)defaultMutableTreeNode3.getChildAt(n - 1));
                    }
                    ((ParaProfExperiment)paraProfTreeNodeUserObject).setApplication((ParaProfApplication)((DefaultMutableTreeNode)defaultMutableTreeNode3.getParent()).getUserObject());
                    listIterator3 = this.getDatabaseAPI(paraProfTreeNodeUserObject.getDatabase());
                    if (listIterator3 != null) {
                        listIterator3.setExperiment(paraProfTreeNodeUserObject.getID());
                        if (listIterator3.getTrialList(false) != null) {
                            listIterator = listIterator3.getTrialList(true).listIterator();
                            while (listIterator.hasNext()) {
                                object = new ParaProfTrial((Trial)listIterator.next());
                                ((ParaProfTrial)object).setDBTrial(true);
                                ((ParaProfTrial)object).setExperiment((ParaProfExperiment)paraProfTreeNodeUserObject);
                                defaultMutableTreeNode2 = new DefaultMutableTreeNode(object);
                                ((ParaProfTrial)object).setDMTN(defaultMutableTreeNode2);
                                this.getTreeModel().insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode3, defaultMutableTreeNode3.getChildCount());
                            }
                        }
                        listIterator3.terminate();
                    }
                } else {
                    for (n = defaultMutableTreeNode3.getChildCount(); n > 0; --n) {
                        this.getTreeModel().removeNodeFromParent((DefaultMutableTreeNode)defaultMutableTreeNode3.getChildAt(n - 1));
                    }
                    listIterator3 = ((ParaProfExperiment)paraProfTreeNodeUserObject).getTrialList();
                    while (listIterator3.hasNext()) {
                        listIterator = (ParaProfTrial)listIterator3.next();
                        object = new DefaultMutableTreeNode(listIterator);
                        ((ParaProfTrial)((Object)listIterator)).setDMTN((DefaultMutableTreeNode)object);
                        this.getTreeModel().insertNodeInto((MutableTreeNode)object, defaultMutableTreeNode3, defaultMutableTreeNode3.getChildCount());
                        ((ParaProfTrial)((Object)listIterator)).setTreePath(new TreePath(((DefaultMutableTreeNode)object).getPath()));
                    }
                }
                int n2 = this.jSplitInnerPane.getDividerLocation();
                this.jSplitInnerPane.setRightComponent(this.getTable(object2));
                this.jSplitInnerPane.setDividerLocation(n2);
            }
            if (object2 instanceof ParaProfTrial) {
                this.trialWillExpand(defaultMutableTreeNode3);
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) {
        try {
            int n;
            DefaultMutableTreeNode defaultMutableTreeNode;
            Object object;
            ListIterator listIterator;
            ParaProfTreeNodeUserObject paraProfTreeNodeUserObject;
            TreePath treePath = treeExpansionEvent.getPath();
            if (treePath == null) {
                return;
            }
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getParent();
            Object object2 = defaultMutableTreeNode2.getUserObject();
            if (defaultMutableTreeNode2.isRoot()) {
                return;
            }
            if (defaultMutableTreeNode3.isRoot()) {
                int n2 = this.jSplitInnerPane.getDividerLocation();
                if (defaultMutableTreeNode2 == this.standard) {
                    this.jSplitInnerPane.setRightComponent(this.getPanelHelpMessage(1));
                    for (int i = this.standard.getChildCount(); i > 0; --i) {
                        this.getTreeModel().removeNodeFromParent((DefaultMutableTreeNode)this.standard.getChildAt(i - 1));
                    }
                    Iterator iterator = ParaProf.applicationManager.getApplications().iterator();
                    while (iterator.hasNext()) {
                        ParaProfApplication paraProfApplication = (ParaProfApplication)iterator.next();
                        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(paraProfApplication);
                        paraProfApplication.setDMTN(defaultMutableTreeNode4);
                        this.getTreeModel().insertNodeInto(defaultMutableTreeNode4, this.standard, this.standard.getChildCount());
                    }
                } else if (defaultMutableTreeNode2 == this.runtime) {
                    this.jSplitInnerPane.setRightComponent(this.getPanelHelpMessage(2));
                } else {
                    this.jSplitInnerPane.setRightComponent(this.getPanelHelpMessage(3));
                    for (int i = defaultMutableTreeNode2.getChildCount(); i > 0; --i) {
                        this.getTreeModel().removeNodeFromParent((DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(i - 1));
                    }
                    Database database = (Database)object2;
                    DatabaseAPI databaseAPI = this.getDatabaseAPI(database);
                    if (databaseAPI != null) {
                        ListIterator listIterator2 = databaseAPI.getApplicationList().listIterator();
                        while (listIterator2.hasNext()) {
                            ParaProfApplication paraProfApplication = new ParaProfApplication((Application)listIterator2.next());
                            paraProfApplication.setDBApplication(true);
                            DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode(paraProfApplication);
                            paraProfApplication.setDMTN(defaultMutableTreeNode5);
                            this.getTreeModel().insertNodeInto(defaultMutableTreeNode5, defaultMutableTreeNode2, defaultMutableTreeNode2.getChildCount());
                        }
                        databaseAPI.terminate();
                    }
                }
                this.jSplitInnerPane.setDividerLocation(n2);
                return;
            }
            if (object2 instanceof ParaProfApplication) {
                ListIterator listIterator3;
                paraProfTreeNodeUserObject = (ParaProfApplication)object2;
                if (((ParaProfApplication)paraProfTreeNodeUserObject).dBApplication()) {
                    for (int i = defaultMutableTreeNode2.getChildCount(); i > 0; --i) {
                        this.getTreeModel().removeNodeFromParent((DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(i - 1));
                    }
                    listIterator3 = this.getDatabaseAPI(paraProfTreeNodeUserObject.getDatabase());
                    if (listIterator3 != null) {
                        listIterator3.setApplication(paraProfTreeNodeUserObject.getID());
                        listIterator = listIterator3.getExperimentList().listIterator();
                        while (listIterator.hasNext()) {
                            object = new ParaProfExperiment((Experiment)listIterator.next());
                            ((ParaProfExperiment)object).setDBExperiment(true);
                            ((ParaProfExperiment)object).setApplication((ParaProfApplication)paraProfTreeNodeUserObject);
                            defaultMutableTreeNode = new DefaultMutableTreeNode(object);
                            ((ParaProfExperiment)object).setDMTN(defaultMutableTreeNode);
                            this.getTreeModel().insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, defaultMutableTreeNode2.getChildCount());
                        }
                        listIterator3.terminate();
                    }
                } else {
                    for (int i = defaultMutableTreeNode2.getChildCount(); i > 0; --i) {
                        this.getTreeModel().removeNodeFromParent((DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(i - 1));
                    }
                    listIterator3 = ((ParaProfApplication)paraProfTreeNodeUserObject).getExperimentList();
                    while (listIterator3.hasNext()) {
                        listIterator = (ParaProfExperiment)listIterator3.next();
                        object = new DefaultMutableTreeNode(listIterator);
                        ((ParaProfExperiment)((Object)listIterator)).setDMTN((DefaultMutableTreeNode)object);
                        this.getTreeModel().insertNodeInto((MutableTreeNode)object, defaultMutableTreeNode2, defaultMutableTreeNode2.getChildCount());
                    }
                }
                n = this.jSplitInnerPane.getDividerLocation();
                this.jSplitInnerPane.setRightComponent(this.getTable(object2));
                this.jSplitInnerPane.setDividerLocation(n);
            }
            if (object2 instanceof ParaProfExperiment) {
                ListIterator listIterator4;
                paraProfTreeNodeUserObject = (ParaProfExperiment)object2;
                if (((ParaProfExperiment)paraProfTreeNodeUserObject).dBExperiment()) {
                    for (n = defaultMutableTreeNode2.getChildCount(); n > 0; --n) {
                        this.getTreeModel().removeNodeFromParent((DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(n - 1));
                    }
                    ((ParaProfExperiment)paraProfTreeNodeUserObject).setApplication((ParaProfApplication)defaultMutableTreeNode3.getUserObject());
                    listIterator4 = this.getDatabaseAPI(paraProfTreeNodeUserObject.getDatabase());
                    if (listIterator4 != null) {
                        listIterator4.setExperiment(paraProfTreeNodeUserObject.getID());
                        if (listIterator4.getTrialList(false) != null) {
                            listIterator = listIterator4.getTrialList(true).listIterator();
                            while (listIterator.hasNext()) {
                                object = new ParaProfTrial((Trial)listIterator.next());
                                ((ParaProfTrial)object).setDBTrial(true);
                                ((ParaProfTrial)object).setExperiment((ParaProfExperiment)paraProfTreeNodeUserObject);
                                defaultMutableTreeNode = new DefaultMutableTreeNode(object);
                                ((ParaProfTrial)object).setDMTN(defaultMutableTreeNode);
                                this.getTreeModel().insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, defaultMutableTreeNode2.getChildCount());
                            }
                        }
                        listIterator4.terminate();
                    }
                } else {
                    for (n = defaultMutableTreeNode2.getChildCount(); n > 0; --n) {
                        this.getTreeModel().removeNodeFromParent((DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(n - 1));
                    }
                    listIterator4 = ((ParaProfExperiment)paraProfTreeNodeUserObject).getTrialList();
                    while (listIterator4.hasNext()) {
                        listIterator = (ParaProfTrial)listIterator4.next();
                        object = new DefaultMutableTreeNode(listIterator);
                        ((ParaProfTrial)((Object)listIterator)).setDMTN((DefaultMutableTreeNode)object);
                        this.getTreeModel().insertNodeInto((MutableTreeNode)object, defaultMutableTreeNode2, defaultMutableTreeNode2.getChildCount());
                        ((ParaProfTrial)((Object)listIterator)).setTreePath(new TreePath(((DefaultMutableTreeNode)object).getPath()));
                    }
                }
                int n3 = this.jSplitInnerPane.getDividerLocation();
                this.jSplitInnerPane.setRightComponent(this.getTable(object2));
                this.jSplitInnerPane.setDividerLocation(n3);
            }
            if (object2 instanceof ParaProfTrial) {
                this.trialWillExpand(defaultMutableTreeNode2);
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    private void trialWillExpand(DefaultMutableTreeNode defaultMutableTreeNode) {
        Object object;
        Object object2;
        int n;
        Object object3 = defaultMutableTreeNode.getUserObject();
        Object object4 = (ParaProfTrial)object3;
        if (((ParaProfTrial)object4).dBTrial()) {
            n = 0;
            object2 = this.loadedDBTrials.elements();
            while (object2.hasMoreElements()) {
                object = (ParaProfTrial)object2.nextElement();
                if (((ParaProfTrial)object4).getID() != ((ParaProfTrial)object).getID() || ((ParaProfTrial)object4).getExperimentID() != ((ParaProfTrial)object).getExperimentID() || ((ParaProfTrial)object4).getApplicationID() != ((ParaProfTrial)object).getApplicationID()) continue;
                defaultMutableTreeNode.setUserObject(object);
                ((ParaProfTrial)object).setDMTN(defaultMutableTreeNode);
                object4 = object;
                n = 1;
            }
            if (n == 0) {
                if (((ParaProfTrial)object4).loading()) {
                    return;
                }
                ((ParaProfTrial)object4).setLoading(true);
                object2 = this.getDatabaseAPI(((ParaProfTrial)object4).getDatabase());
                if (object2 != null) {
                    object2.setApplication(((ParaProfTrial)object4).getApplicationID());
                    object2.setExperiment(((ParaProfTrial)object4).getExperimentID());
                    object2.setTrial(((ParaProfTrial)object4).getID(), true);
                    object = new DBDataSource((DatabaseAPI)object2);
                    object.setGenerateIntermediateCallPathData(ParaProf.preferences.getGenerateIntermediateCallPathData());
                    ((ParaProfTrial)object4).getTrial().setDataSource((DataSource)object);
                    Object object5 = object;
                    Object object6 = object4;
                    Thread thread = new Thread(new Runnable((DataSource)object5, (ParaProfTrial)object6){
                        private final /* synthetic */ DataSource val$dataSource;
                        private final /* synthetic */ ParaProfTrial val$theTrial;
                        {
                            this.val$dataSource = dataSource;
                            this.val$theTrial = paraProfTrial;
                        }

                        public void run() {
                            try {
                                this.val$dataSource.load();
                                this.val$theTrial.finishLoad();
                                ParaProf.paraProfManagerWindow.populateTrialMetrics(this.val$theTrial);
                            }
                            catch (Exception exception) {
                                EventQueue.invokeLater(new Runnable(this, exception){
                                    private final /* synthetic */ Exception val$e;
                                    private final /* synthetic */ 10 this$1;
                                    {
                                        this.this$1 = var1_1;
                                        this.val$e = exception;
                                    }

                                    public void run() {
                                        ParaProfUtils.handleException(this.val$e);
                                    }
                                });
                            }
                        }
                    });
                    thread.start();
                    this.loadedDBTrials.add(object4);
                }
            }
        }
        if (!((ParaProfTrial)object4).loading()) {
            for (n = defaultMutableTreeNode.getChildCount(); n > 0; --n) {
                this.getTreeModel().removeNodeFromParent((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n - 1));
            }
            Iterator iterator = ((ParaProfTrial)object4).getMetrics().iterator();
            while (iterator.hasNext()) {
                object2 = (ParaProfMetric)iterator.next();
                object = new DefaultMutableTreeNode(object2, false);
                ((ParaProfMetric)object2).setDMTN((DefaultMutableTreeNode)object);
                this.getTreeModel().insertNodeInto((MutableTreeNode)object, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
            }
            int n2 = this.jSplitInnerPane.getDividerLocation();
            this.jSplitInnerPane.setRightComponent(this.getTable(object3));
            this.jSplitInnerPane.setDividerLocation(n2);
        }
    }

    private void showMetric(ParaProfMetric paraProfMetric) {
        ParaProfTrial paraProfTrial = paraProfMetric.getParaProfTrial();
        paraProfTrial.setDefaultMetric(paraProfMetric);
        paraProfTrial.showMainWindow();
    }

    private void deleteMetric(ParaProfMetric paraProfMetric) {
        try {
            ParaProfTrial paraProfTrial = paraProfMetric.getParaProfTrial();
            if (paraProfTrial.dBTrial()) {
                DatabaseAPI databaseAPI = this.getDatabaseAPI(paraProfTrial.getDatabase());
                Trial.deleteMetric((DB)databaseAPI.getDb(), (int)paraProfTrial.getID(), (int)paraProfMetric.getDbMetricID());
            }
            this.getTreeModel().removeNodeFromParent(paraProfMetric.getDMTN());
            paraProfTrial.deleteMetric(paraProfMetric);
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    private void switchToMetric(ParaProfMetric paraProfMetric) {
        try {
            ParaProfTrial paraProfTrial = paraProfMetric.getParaProfTrial();
            paraProfTrial.setDefaultMetric(paraProfMetric);
            paraProfTrial.updateRegisteredObjects("dataEvent");
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    private void metricSelected(ParaProfMetric paraProfMetric, boolean bl) {
        int n = this.jSplitInnerPane.getDividerLocation();
        this.jSplitInnerPane.setRightComponent(this.getTable(paraProfMetric));
        this.jSplitInnerPane.setDividerLocation(n);
        this.operand2 = this.operand1;
        if (bl) {
            this.switchToMetric(paraProfMetric);
        }
    }

    public ParaProfMetric getOperand1() {
        return this.operand1;
    }

    public ParaProfMetric getOperand2() {
        return this.operand2;
    }

    public void uploadMetric(ParaProfMetric paraProfMetric) {
        DatabaseAPI databaseAPI;
        if (paraProfMetric != null && (databaseAPI = this.getDatabaseAPI(paraProfMetric.getParaProfTrial().getDatabase())) != null) {
            try {
                databaseAPI.saveTrial(paraProfMetric.getParaProfTrial().getTrial(), (Metric)paraProfMetric);
            }
            catch (DatabaseException databaseException) {
                ParaProfUtils.handleException((Exception)((Object)databaseException));
            }
            databaseAPI.terminate();
        }
    }

    public int[] getSelectedDBExperiment() {
        if (ParaProf.preferences.getDatabaseConfigurationFile() == null || ParaProf.preferences.getDatabasePassword() == null) {
            JOptionPane.showMessageDialog(this, "Please set the database configuration information (file menu).", "DB Configuration Error!", 0);
            return null;
        }
        TreePath treePath = this.tree.getSelectionPath();
        boolean bl = false;
        if (treePath == null) {
            bl = true;
        } else {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            Object object = defaultMutableTreeNode.getUserObject();
            if (object instanceof ParaProfExperiment) {
                ParaProfExperiment paraProfExperiment = (ParaProfExperiment)object;
                if (paraProfExperiment.dBExperiment()) {
                    int[] nArray = new int[]{paraProfExperiment.getApplicationID(), paraProfExperiment.getID()};
                    return nArray;
                }
                bl = true;
            } else {
                bl = true;
            }
        }
        if (bl) {
            JOptionPane.showMessageDialog(this, "Please select an db experiment first!", "DB Upload Error!", 0);
        }
        return null;
    }

    private Component getPanelHelpMessage(int n) {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        switch (n) {
            case 0: {
                jTextArea.append("ParaProf Manager\n\n");
                jTextArea.append("This window allows you to manage all of ParaProf's loaded data.\n");
                jTextArea.append("Data can be static (ie, not updated at runtime), and loaded either remotely or locally.  You can also specify data to be uploaded at runtime.\n\n");
                break;
            }
            case 1: {
                jTextArea.append("ParaProf Manager\n\n");
                jTextArea.append("This is the Standard application section:\n\n");
                jTextArea.append("Standard - The classic ParaProf mode.  Data sets that are loaded at startup are placed under the default application automatically. Please see the ParaProf documentation for more details.\n");
                break;
            }
            case 2: {
                jTextArea.append("ParaProf Manager\n\n");
                jTextArea.append("This is the Runtime application section:\n\n");
                jTextArea.append("Runtime - A new feature allowing ParaProf to update data at runtime.  Please see the ParaProf documentation if the options are not clear.\n");
                jTextArea.append("*** THIS FEATURE IS CURRENTLY OFF ***\n");
                break;
            }
            case 3: {
                jTextArea.append("ParaProf Manager\n\n");
                jTextArea.append("This is the DB Apps application section:\n\n");
                jTextArea.append("DB Apps - ParaProf can load data from a database.  Please see the ParaProf and PerfDMF documentation for more details.\n");
                break;
            }
        }
        return new JScrollPane(jTextArea);
    }

    private Component getTable(Object object) {
        if (object instanceof ParaProfApplication) {
            return new JScrollPane(new JTable(new ApplicationTableModel(this, (ParaProfApplication)object, this.getTreeModel())));
        }
        if (object instanceof ParaProfExperiment) {
            return new JScrollPane(new JTable(new ExperimentTableModel(this, (ParaProfExperiment)object, this.getTreeModel())));
        }
        if (object instanceof ParaProfTrial) {
            ParaProfTrial paraProfTrial = (ParaProfTrial)object;
            TrialTableModel trialTableModel = new TrialTableModel(this, paraProfTrial, this.getTreeModel());
            JTable jTable = new JTable(trialTableModel);
            jTable.addMouseListener(trialTableModel.getMouseListener(jTable));
            jTable.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = ParaProfManagerWindow.class$("java.lang.Object")) : class$java$lang$Object, new TrialCellRenderer(paraProfTrial.getTrial().getMetaData(), paraProfTrial.getTrial().getUncommonMetaData()));
            return new JScrollPane(jTable);
        }
        return new JScrollPane(new JTable(new MetricTableModel(this, (ParaProfMetric)object, this.getTreeModel())));
    }

    public ParaProfApplication addApplication(boolean bl, DefaultMutableTreeNode defaultMutableTreeNode) throws SQLException {
        ParaProfApplication paraProfApplication = null;
        if (bl) {
            Database database = (Database)defaultMutableTreeNode.getUserObject();
            DatabaseAPI databaseAPI = this.getDatabaseAPI(database);
            if (databaseAPI != null) {
                paraProfApplication = new ParaProfApplication();
                paraProfApplication.setDBApplication(true);
                paraProfApplication.setName("New Application");
                paraProfApplication.setID(databaseAPI.saveApplication((Application)paraProfApplication));
                paraProfApplication.setDatabase((Database)defaultMutableTreeNode.getUserObject());
                databaseAPI.terminate();
            }
        } else {
            paraProfApplication = ParaProf.applicationManager.addApplication();
            paraProfApplication.setName("New Application");
        }
        return paraProfApplication;
    }

    public ParaProfExperiment addExperiment(boolean bl, ParaProfApplication paraProfApplication) {
        ParaProfExperiment paraProfExperiment = null;
        if (bl) {
            DatabaseAPI databaseAPI = this.getDatabaseAPI(paraProfApplication.getDatabase());
            if (databaseAPI != null) {
                try {
                    paraProfExperiment = new ParaProfExperiment(databaseAPI.db());
                    paraProfExperiment.setDBExperiment(true);
                    paraProfExperiment.setApplication(paraProfApplication);
                    paraProfExperiment.setApplicationID(paraProfApplication.getID());
                    paraProfExperiment.setName("New Experiment");
                    paraProfExperiment.setID(databaseAPI.saveExperiment((Experiment)paraProfExperiment));
                    paraProfExperiment.setDatabase(paraProfApplication.getDatabase());
                }
                catch (DatabaseException databaseException) {
                    ParaProfUtils.handleException((Exception)((Object)databaseException));
                }
                databaseAPI.terminate();
            }
        } else {
            paraProfExperiment = paraProfApplication.addExperiment();
            paraProfExperiment.setName("New Experiment");
        }
        return paraProfExperiment;
    }

    public void addTrial(ParaProfApplication paraProfApplication, ParaProfExperiment paraProfExperiment, File[] fileArray, int n, boolean bl, boolean bl2) {
        ParaProfTrial paraProfTrial = null;
        DataSource dataSource = null;
        try {
            dataSource = UtilFncs.initializeDataSource((File[])fileArray, (int)n, (boolean)bl);
            if (dataSource == null) {
                throw new RuntimeException("Error creating dataSource!");
            }
            dataSource.setGenerateIntermediateCallPathData(ParaProf.preferences.getGenerateIntermediateCallPathData());
        }
        catch (DataSourceException dataSourceException) {
            if (fileArray == null || fileArray.length != 0) {
                ParaProfUtils.handleException((Exception)((Object)dataSourceException));
            }
            return;
        }
        paraProfTrial = new ParaProfTrial();
        paraProfTrial.getTrial().setDataSource(dataSource);
        paraProfTrial.setLoading(true);
        dataSource.setMonitored(bl2);
        paraProfTrial.setMonitored(bl2);
        paraProfTrial.setExperiment(paraProfExperiment);
        paraProfTrial.setApplicationID(paraProfExperiment.getApplicationID());
        paraProfTrial.setExperimentID(paraProfExperiment.getID());
        if (fileArray.length != 0) {
            paraProfTrial.setPaths(fileArray[0].getPath());
        } else {
            paraProfTrial.setPaths(System.getProperty("user.dir"));
        }
        if (!ParaProf.usePathNameInTrial && fileArray.length == 1) {
            paraProfTrial.getTrial().setName(fileArray[0].toString());
            paraProfTrial.setPaths(fileArray[0].toString());
        } else {
            paraProfTrial.getTrial().setName(paraProfTrial.getPathReverse());
        }
        if (paraProfExperiment.dBExperiment()) {
            this.loadedDBTrials.add(paraProfTrial);
            paraProfTrial.setUpload(true);
        } else {
            paraProfExperiment.addTrial(paraProfTrial);
        }
        LoadTrialProgressWindow loadTrialProgressWindow = new LoadTrialProgressWindow(this, dataSource, paraProfTrial, false);
        loadTrialProgressWindow.setVisible(true);
    }

    public void populateTrialMetrics(final ParaProfTrial paraProfTrial) {
        try {
            this.loadedTrials.add(paraProfTrial);
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    try {
                        if (paraProfTrial.upload()) {
                            paraProfTrial.setUpload(false);
                        }
                        ParaProfManagerWindow.this.expandTrial(paraProfTrial);
                    }
                    catch (Exception exception) {
                        ParaProfUtils.handleException(exception);
                    }
                }
            });
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    private void recurseExpand(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode == null || defaultMutableTreeNode.isRoot()) {
            return;
        }
        this.recurseExpand((DefaultMutableTreeNode)defaultMutableTreeNode.getParent());
        this.tree.expandPath(new TreePath(defaultMutableTreeNode));
    }

    public DefaultMutableTreeNode expandApplicationType(int n, int n2, ParaProfApplication paraProfApplication) {
        switch (n) {
            case 0: {
                if (!this.tree.isExpanded(new TreePath(this.standard.getPath()))) {
                    this.tree.expandPath(new TreePath(this.standard.getPath()));
                }
                for (int i = this.standard.getChildCount(); i > 0; --i) {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.standard.getChildAt(i - 1);
                    if (n2 != ((ParaProfApplication)defaultMutableTreeNode.getUserObject()).getID()) continue;
                    return defaultMutableTreeNode;
                }
                if (paraProfApplication != null) {
                    DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(paraProfApplication);
                    paraProfApplication.setDMTN(defaultMutableTreeNode);
                    this.getTreeModel().insertNodeInto(defaultMutableTreeNode, this.standard, this.standard.getChildCount());
                    return defaultMutableTreeNode;
                }
                return null;
            }
            case 2: {
                DefaultMutableTreeNode defaultMutableTreeNode;
                int n3;
                DefaultMutableTreeNode defaultMutableTreeNode2 = null;
                Database database = null;
                try {
                    for (n3 = 0; n3 < this.root.getChildCount(); ++n3) {
                        defaultMutableTreeNode = (DefaultMutableTreeNode)this.root.getChildAt(n3);
                        if (defaultMutableTreeNode.getUserObject() != paraProfApplication.getDatabase()) continue;
                        defaultMutableTreeNode2 = defaultMutableTreeNode;
                        database = (Database)defaultMutableTreeNode.getUserObject();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (!this.tree.isExpanded(new TreePath(defaultMutableTreeNode2.getPath()))) {
                    this.tree.expandPath(new TreePath(defaultMutableTreeNode2.getPath()));
                }
                for (n3 = defaultMutableTreeNode2.getChildCount(); n3 > 0; --n3) {
                    defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(n3 - 1);
                    if (n2 != ((ParaProfApplication)defaultMutableTreeNode.getUserObject()).getID()) continue;
                    return defaultMutableTreeNode;
                }
                if (paraProfApplication != null) {
                    DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(paraProfApplication);
                    paraProfApplication.setDMTN(defaultMutableTreeNode3);
                    this.getTreeModel().insertNodeInto(defaultMutableTreeNode3, defaultMutableTreeNode2, defaultMutableTreeNode2.getChildCount());
                    return defaultMutableTreeNode3;
                }
                return null;
            }
        }
        return null;
    }

    public DefaultMutableTreeNode expandApplicationType(Database database, ParaProfApplication paraProfApplication) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        int n;
        if (database == null) {
            if (!this.tree.isExpanded(new TreePath(this.standard.getPath()))) {
                this.tree.expandPath(new TreePath(this.standard.getPath()));
            }
            for (int i = this.standard.getChildCount(); i > 0; --i) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)this.standard.getChildAt(i - 1);
                if (paraProfApplication.getID() != ((ParaProfApplication)defaultMutableTreeNode2.getUserObject()).getID()) continue;
                return defaultMutableTreeNode2;
            }
            if (paraProfApplication != null) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(paraProfApplication);
                paraProfApplication.setDMTN(defaultMutableTreeNode3);
                this.getTreeModel().insertNodeInto(defaultMutableTreeNode3, this.standard, this.standard.getChildCount());
                return defaultMutableTreeNode3;
            }
            return null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode4 = null;
        Database database2 = null;
        for (n = 0; n < this.root.getChildCount(); ++n) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)this.root.getChildAt(n);
            if (!(defaultMutableTreeNode.getUserObject() instanceof Database) || ((Database)defaultMutableTreeNode.getUserObject()).getConfig().getPath().compareTo(paraProfApplication.getDatabase().getConfig().getPath()) != 0) continue;
            defaultMutableTreeNode4 = defaultMutableTreeNode;
            database2 = (Database)defaultMutableTreeNode.getUserObject();
        }
        if (!this.tree.isExpanded(new TreePath(defaultMutableTreeNode4.getPath()))) {
            this.tree.expandPath(new TreePath(defaultMutableTreeNode4.getPath()));
        }
        for (n = defaultMutableTreeNode4.getChildCount(); n > 0; --n) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode4.getChildAt(n - 1);
            if (paraProfApplication.getID() != ((ParaProfApplication)defaultMutableTreeNode.getUserObject()).getID()) continue;
            return defaultMutableTreeNode;
        }
        if (paraProfApplication != null) {
            DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode(paraProfApplication);
            paraProfApplication.setDMTN(defaultMutableTreeNode5);
            this.getTreeModel().insertNodeInto(defaultMutableTreeNode5, defaultMutableTreeNode4, defaultMutableTreeNode4.getChildCount());
            return defaultMutableTreeNode5;
        }
        return null;
    }

    public DefaultMutableTreeNode expandApplication(int n, ParaProfApplication paraProfApplication, ParaProfExperiment paraProfExperiment) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.expandApplicationType(n, paraProfApplication.getID(), paraProfApplication);
        if (defaultMutableTreeNode != null) {
            this.tree.expandPath(new TreePath(defaultMutableTreeNode.getPath()));
            this.tree.expandPath(new TreePath(this.standard.getPath()));
            for (int i = defaultMutableTreeNode.getChildCount(); i > 0; --i) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i - 1);
                if (paraProfExperiment.getID() != ((ParaProfExperiment)defaultMutableTreeNode2.getUserObject()).getID()) continue;
                return defaultMutableTreeNode2;
            }
            if (paraProfExperiment != null) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(paraProfExperiment);
                paraProfExperiment.setDMTN(defaultMutableTreeNode3);
                this.getTreeModel().insertNodeInto(defaultMutableTreeNode3, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
                return defaultMutableTreeNode3;
            }
            return null;
        }
        return null;
    }

    public DefaultMutableTreeNode expandApplication(ParaProfApplication paraProfApplication, ParaProfExperiment paraProfExperiment) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.expandApplicationType(paraProfApplication.getDatabase(), paraProfApplication);
        if (defaultMutableTreeNode != null) {
            this.tree.expandPath(new TreePath(defaultMutableTreeNode.getPath()));
            this.tree.expandPath(new TreePath(this.standard.getPath()));
            for (int i = defaultMutableTreeNode.getChildCount(); i > 0; --i) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i - 1);
                if (paraProfExperiment.getID() != ((ParaProfExperiment)defaultMutableTreeNode2.getUserObject()).getID()) continue;
                return defaultMutableTreeNode2;
            }
            if (paraProfExperiment != null) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(paraProfExperiment);
                paraProfExperiment.setDMTN(defaultMutableTreeNode3);
                this.getTreeModel().insertNodeInto(defaultMutableTreeNode3, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
                return defaultMutableTreeNode3;
            }
            return null;
        }
        return null;
    }

    public DefaultMutableTreeNode expandExperiment(ParaProfExperiment paraProfExperiment, ParaProfTrial paraProfTrial) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        ParaProfApplication paraProfApplication = paraProfExperiment.getApplication();
        if (paraProfApplication == null) {
            paraProfApplication = new ParaProfApplication();
        }
        if ((defaultMutableTreeNode = this.expandApplication(paraProfApplication, paraProfExperiment)) != null) {
            this.tree.expandPath(new TreePath(defaultMutableTreeNode.getPath()));
            for (int i = defaultMutableTreeNode.getChildCount(); i > 0; --i) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i - 1);
                if (paraProfTrial.getID() != ((ParaProfTrial)defaultMutableTreeNode2.getUserObject()).getID()) continue;
                return defaultMutableTreeNode2;
            }
            if (paraProfTrial != null) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(paraProfTrial);
                paraProfTrial.setDMTN(defaultMutableTreeNode3);
                this.getTreeModel().insertNodeInto(defaultMutableTreeNode3, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
                return defaultMutableTreeNode3;
            }
            return null;
        }
        return null;
    }

    public DefaultMutableTreeNode expandExperiment(int n, int n2, int n3, int n4, ParaProfApplication paraProfApplication, ParaProfExperiment paraProfExperiment, ParaProfTrial paraProfTrial) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.expandApplication(n, paraProfApplication, paraProfExperiment);
        if (defaultMutableTreeNode != null) {
            this.tree.expandPath(new TreePath(defaultMutableTreeNode.getPath()));
            for (int i = defaultMutableTreeNode.getChildCount(); i > 0; --i) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i - 1);
                if (n4 != ((ParaProfTrial)defaultMutableTreeNode2.getUserObject()).getID()) continue;
                return defaultMutableTreeNode2;
            }
            if (paraProfTrial != null) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(paraProfTrial);
                paraProfTrial.setDMTN(defaultMutableTreeNode3);
                this.getTreeModel().insertNodeInto(defaultMutableTreeNode3, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
                return defaultMutableTreeNode3;
            }
            return null;
        }
        return null;
    }

    public void expandTrial(ParaProfTrial paraProfTrial) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.expandExperiment(paraProfTrial.getExperiment(), paraProfTrial);
        if (defaultMutableTreeNode != null) {
            if (this.tree.isExpanded(new TreePath(defaultMutableTreeNode.getPath()))) {
                this.tree.collapsePath(new TreePath(defaultMutableTreeNode.getPath()));
            }
            this.tree.expandPath(new TreePath(defaultMutableTreeNode.getPath()));
        }
    }

    public void expandTrial(int n, int n2, int n3, int n4, ParaProfApplication paraProfApplication, ParaProfExperiment paraProfExperiment, ParaProfTrial paraProfTrial) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.expandExperiment(n, n2, n3, n4, paraProfApplication, paraProfExperiment, paraProfTrial);
        if (defaultMutableTreeNode != null) {
            if (this.tree.isExpanded(new TreePath(defaultMutableTreeNode.getPath()))) {
                this.tree.collapsePath(new TreePath(defaultMutableTreeNode.getPath()));
            }
            this.tree.expandPath(new TreePath(defaultMutableTreeNode.getPath()));
        }
    }

    public String getDatabaseName() {
        if (this.dbDisplayName == null) {
            try {
                if (ParaProf.preferences.getDatabaseConfigurationFile() == null) {
                    this.dbDisplayName = "";
                }
                ParseConfig parseConfig = new ParseConfig(ParaProf.preferences.getDatabaseConfigurationFile());
                this.dbDisplayName = parseConfig.getConnectionString();
                if (this.dbDisplayName.compareTo("") == 0) {
                    this.dbDisplayName = "none";
                }
            }
            catch (Exception exception) {
                this.dbDisplayName = "none";
            }
        }
        return this.dbDisplayName;
    }

    public Database getDefaultDatabase() {
        return (Database)this.databases.get(0);
    }

    public DatabaseAPI getDatabaseAPI(Database database) {
        try {
            if (database == null) {
                database = this.getDefaultDatabase();
            }
            DatabaseAPI databaseAPI = new DatabaseAPI();
            databaseAPI.initialize(database);
            return databaseAPI;
        }
        catch (Exception exception) {
            Exception exception2;
            ParaProf.getHelpWindow().setVisible(true);
            ParaProf.getHelpWindow().clearText();
            ParaProf.getHelpWindow().writeText("There was an error connecting to the database!");
            ParaProf.getHelpWindow().writeText("");
            ParaProf.getHelpWindow().writeText("Please see the help items below to try and resolve this issue. If none of those work, send an email to tau-bugs@cs.uoregon.edu including as complete a description of the problem as possible.");
            ParaProf.getHelpWindow().writeText("");
            ParaProf.getHelpWindow().writeText("------------------");
            ParaProf.getHelpWindow().writeText("");
            ParaProf.getHelpWindow().writeText("1) JDBC driver issue: The JDBC driver is required in your classpath. If you ran ParaProf using the shell script provided in tau (paraprof), then the default. location used is $LOCATION_OF_TAU_ROOT/$ARCH/lib.");
            ParaProf.getHelpWindow().writeText("");
            ParaProf.getHelpWindow().writeText(" If you ran ParaProf manually, make sure that the location of the JDBC driver is in your classpath (you can set this in your. environment, or as a commmand line option to java. As an example, PostgreSQL uses postgresql.jar as its JDBC driver name.");
            ParaProf.getHelpWindow().writeText("");
            ParaProf.getHelpWindow().writeText("2) Network connection issue: Check your ability to connect to the database. You might be connecting to the incorrect port (PostgreSQL uses port 5432 by default). Also make sure that if there exists a firewall on you network (or local machine), it is not blocking you connection. Also check your database logs to ensure that you have permission to connect to the server.");
            ParaProf.getHelpWindow().writeText("");
            ParaProf.getHelpWindow().writeText("3) Password issue: Make sure that your password is set correctly. If it is not in the perfdmf configuration file, you can enter it manually by selecting  File -> Database Configuration in the ParaProfManagerWindow window.");
            ParaProf.getHelpWindow().writeText("");
            ParaProf.getHelpWindow().writeText("------------------");
            ParaProf.getHelpWindow().writeText("");
            ParaProf.getHelpWindow().writeText("The full error is given below:\n");
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            if (exception instanceof TauRuntimeException) {
                ParaProf.getHelpWindow().writeText(((TauRuntimeException)exception).getMessage() + "\n\n");
                exception2 = ((TauRuntimeException)exception).getActualException();
            }
            exception2.printStackTrace(printWriter);
            printWriter.close();
            ParaProf.getHelpWindow().writeText(stringWriter.toString());
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    ParaProf.getHelpWindow().getScrollPane().getVerticalScrollBar().setValue(0);
                }
            });
            return null;
        }
    }

    void thisWindowClosing(WindowEvent windowEvent) {
        this.closeThisWindow();
    }

    void closeThisWindow() {
        try {
            ParaProf.preferences.setManagerWindowPosition(this.getLocation());
            this.setVisible(false);
            ParaProf.decrementNumWindows();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.dispose();
    }

    public Vector getLoadedTrials() {
        return this.loadedTrials;
    }

    public void setTreeModel(DefaultTreeModel defaultTreeModel) {
        this.treeModel = defaultTreeModel;
    }

    public DefaultTreeModel getTreeModel() {
        return this.treeModel;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

