/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.common.Utility;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.PrefSpacingPanel;
import edu.uoregon.tau.paraprof.Preferences;
import edu.uoregon.tau.paraprof.WindowPlacer;
import edu.uoregon.tau.perfdmf.DataSource;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;

public class PreferencesWindow
extends JFrame
implements ActionListener,
Observer {
    private boolean mShown = false;
    private PrefSpacingPanel prefSpacingPanel;
    private JCheckBox bold;
    private JCheckBox italic;
    private JComboBox fontComboBox;
    private JLabel barHeightLabel = new JLabel("Size");
    private JSlider barHeightSlider = new JSlider(0, 0, 40, 0);
    private Preferences preferences;
    private String fontName = "SansSerif";
    private int fontStyle = 0;
    private int fontSize = 12;
    private Font font;
    private JComboBox unitsBox;
    private JCheckBox autoLabelsBox = new JCheckBox("Auto label node/context/threads");
    private JCheckBox showValuesAsPercentBox = new JCheckBox("Show Values as Percent");
    private JCheckBox showPathTitleInReverseBox = new JCheckBox("Show Path Title in Reverse");
    private JCheckBox reverseCallPathsBox = new JCheckBox("Reverse Call Paths");
    private JCheckBox meanIncludeNullBox = new JCheckBox("<html>Interpret threads that do not call a given function as a 0 value for statistics computation</html>");
    private JCheckBox generateIntermediateCallPathDataBox = new JCheckBox("<html>Generate data for reverse calltree<br>(requires lots of memory)<br>(does not apply to currently loaded profiles)</html>");
    private JCheckBox showSourceLocationsBox = new JCheckBox("<html>Show Source Locations</html>");

    public PreferencesWindow(Preferences preferences) {
        this.preferences = preferences;
        String[] stringArray = new String[]{"Microseconds", "Milliseconds", "Seconds", "hr:mm:ss"};
        this.unitsBox = new JComboBox<String>(stringArray);
        this.meanIncludeNullBox.setToolTipText("<html>There are two methods for computing the mean for a given function over all threads:<br>1. Add up the values for that function for each thread and divide by the total number of threads.<br>2. Add up the values for that function for each thread and divide by the number of threads that actually called that function.<br><br>This has the effect that if a particular function is only called by 2 threads:<br>The first method will show the mean value as 1/N where N is the total number of threads.<br>The second method will only divide by 2.<br><br>This option also affects standard deviation computation.");
        this.reverseCallPathsBox.setToolTipText("<html>If this option is enabled, call path names will be shown in reverse<br>(e.g. \"C &lt;= B &lt;= A\" vs. \"A =&gt; B =&gt; C\")");
        this.generateIntermediateCallPathDataBox.setToolTipText("<html>If this option is enabled, then the reverse calltree will be available.<br>However, it requires additional memory and should be disabled if the JVM<br>runs out of memory on large callpath datasets.</html>");
        this.autoLabelsBox.setToolTipText("<html>If this option is enabled, execution thread labels \"n,c,t 0,0,0\" will be shortened based on the execution type (MPI, threaded, hybrid)</html>");
        this.fontName = preferences.getFontName();
        this.fontStyle = preferences.getFontStyle();
        this.fontSize = preferences.getFontSize();
        this.unitsBox.setSelectedIndex(preferences.getUnits());
        this.showValuesAsPercentBox.setSelected(preferences.getShowValuesAsPercent());
        this.showPathTitleInReverseBox.setSelected(preferences.getShowPathTitleInReverse());
        this.reverseCallPathsBox.setSelected(preferences.getReversedCallPaths());
        this.autoLabelsBox.setSelected(preferences.getAutoLabels());
        this.meanIncludeNullBox.setSelected(!preferences.getComputeMeanWithoutNulls());
        this.generateIntermediateCallPathDataBox.setSelected(preferences.getGenerateIntermediateCallPathData());
        this.showSourceLocationsBox.setSelected(preferences.getShowSourceLocation());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PreferencesWindow.this.thisWindowClosing(windowEvent);
            }
        });
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] stringArray2 = graphicsEnvironment.getAvailableFontFamilyNames();
        this.fontComboBox = new JComboBox<String>(stringArray2);
        this.fontComboBox.addActionListener(this);
        this.prefSpacingPanel = new PrefSpacingPanel();
        this.setTitle("TAU: ParaProf: Preferences");
        ParaProfUtils.setFrameIcon(this);
        int n = 650;
        int n2 = 520;
        this.setSize(new Dimension(n, n2));
        this.setResizable(true);
        int n3 = 0;
        int n4 = 0;
        this.setLocation(n3, n4);
        this.setupMenus();
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        JScrollPane jScrollPane = new JScrollPane(this.prefSpacingPanel);
        jScrollPane.setPreferredSize(new Dimension(300, 200));
        this.bold = new JCheckBox("Bold");
        this.bold.addActionListener(this);
        this.italic = new JCheckBox("Italic");
        this.italic.addActionListener(this);
        this.setControls();
        this.barHeightSlider.setPaintTicks(true);
        this.barHeightSlider.setMajorTickSpacing(10);
        this.barHeightSlider.setMinorTickSpacing(5);
        this.barHeightSlider.setPaintLabels(true);
        this.barHeightSlider.addChangeListener(this.prefSpacingPanel);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Font"));
        jPanel.setLayout(new GridBagLayout());
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        Utility.addCompItem((Container)jPanel, (Component)this.fontComboBox, (GridBagConstraints)gridBagConstraints, (int)0, (int)0, (int)2, (int)1);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        Utility.addCompItem((Container)jPanel, (Component)this.bold, (GridBagConstraints)gridBagConstraints, (int)0, (int)1, (int)1, (int)1);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        Utility.addCompItem((Container)jPanel, (Component)this.italic, (GridBagConstraints)gridBagConstraints, (int)0, (int)2, (int)1, (int)1);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        Utility.addCompItem((Container)jPanel, (Component)this.barHeightLabel, (GridBagConstraints)gridBagConstraints, (int)1, (int)1, (int)1, (int)1);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.25;
        gridBagConstraints.weighty = 0.25;
        Utility.addCompItem((Container)jPanel, (Component)this.barHeightSlider, (GridBagConstraints)gridBagConstraints, (int)1, (int)2, (int)1, (int)1);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Window defaults"));
        jPanel2.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel("Units");
        Utility.addCompItem((Container)jPanel2, (Component)jLabel, (GridBagConstraints)gridBagConstraints, (int)0, (int)0, (int)1, (int)1);
        Utility.addCompItem((Container)jPanel2, (Component)this.unitsBox, (GridBagConstraints)gridBagConstraints, (int)1, (int)0, (int)1, (int)1);
        Utility.addCompItem((Container)jPanel2, (Component)this.showValuesAsPercentBox, (GridBagConstraints)gridBagConstraints, (int)0, (int)1, (int)2, (int)1);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Settings"));
        jPanel3.setLayout(new GridBagLayout());
        Utility.addCompItem((Container)jPanel3, (Component)this.showPathTitleInReverseBox, (GridBagConstraints)gridBagConstraints, (int)0, (int)2, (int)2, (int)1);
        Utility.addCompItem((Container)jPanel3, (Component)this.reverseCallPathsBox, (GridBagConstraints)gridBagConstraints, (int)0, (int)3, (int)2, (int)1);
        Utility.addCompItem((Container)jPanel3, (Component)this.meanIncludeNullBox, (GridBagConstraints)gridBagConstraints, (int)0, (int)4, (int)2, (int)1);
        Utility.addCompItem((Container)jPanel3, (Component)this.generateIntermediateCallPathDataBox, (GridBagConstraints)gridBagConstraints, (int)0, (int)5, (int)2, (int)1);
        Utility.addCompItem((Container)jPanel3, (Component)this.showSourceLocationsBox, (GridBagConstraints)gridBagConstraints, (int)0, (int)6, (int)2, (int)1);
        Utility.addCompItem((Container)jPanel3, (Component)this.autoLabelsBox, (GridBagConstraints)gridBagConstraints, (int)0, (int)7, (int)2, (int)1);
        gridBagConstraints.fill = 1;
        this.addCompItem(jPanel, gridBagConstraints, 0, 0, 1, 1);
        this.addCompItem(jPanel2, gridBagConstraints, 0, 1, 1, 1);
        this.addCompItem(jPanel3, gridBagConstraints, 1, 1, 1, 1);
        JButton jButton = new JButton("Restore Defaults");
        jButton.addActionListener(this);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addCompItem(jButton, gridBagConstraints, 0, 2, 1, 1);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        this.addCompItem(jScrollPane, gridBagConstraints, 1, 0, 1, 1);
        JPanel jPanel4 = new JPanel();
        JButton jButton2 = new JButton("Apply");
        jButton2.addActionListener(this);
        JButton jButton3 = new JButton("Cancel");
        jButton3.addActionListener(this);
        jPanel4.add(jButton2);
        jPanel4.add(jButton3);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addCompItem(jPanel4, gridBagConstraints, 1, 2, 1, 1);
        this.setSavedPreferences();
    }

    void setControls() {
        int n = this.fontComboBox.getItemCount();
        int n2 = 0;
        String string = (String)this.fontComboBox.getItemAt(n2);
        while (n2 < n && !this.fontName.equals(string)) {
            string = (String)this.fontComboBox.getItemAt(++n2);
        }
        if (n2 == n) {
            System.out.println("The default font was not found!  This is not a good thing as it is a default Java font!");
        } else {
            this.fontComboBox.setSelectedIndex(n2);
        }
        this.bold.setSelected(this.fontStyle == 1 || this.fontStyle == 3);
        this.italic.setSelected(this.fontStyle == 2 || this.fontStyle == 3);
        this.barHeightSlider.setValue(this.fontSize);
    }

    private void setupMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        JMenuItem jMenuItem = new JMenuItem("Load Preferences...");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Save Preferences...");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Edit Default Colors");
        jMenuItem2.addActionListener(this);
        jMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem("Edit Source Directories");
        jMenuItem3.addActionListener(this);
        jMenu.add(jMenuItem3);
        jMenuItem3 = new JMenuItem("Show Color Map");
        jMenuItem3.addActionListener(this);
        jMenu.add(jMenuItem3);
        JMenuItem jMenuItem4 = new JMenuItem("Apply and Close Window");
        jMenuItem4.addActionListener(this);
        jMenu.add(jMenuItem4);
        JMenuItem jMenuItem5 = new JMenuItem("Exit ParaProf!");
        jMenuItem5.addActionListener(this);
        jMenu.add(jMenuItem5);
        jMenuBar.add(jMenu);
        this.setJMenuBar(jMenuBar);
    }

    public void showPreferencesWindow(Component component) {
        this.setTitle("ParaProf Preferences");
        this.setLocation(WindowPlacer.getNewLocation(this, component));
        this.setVisible(true);
    }

    public void loadSavedPreferences() {
        this.preferences = ParaProf.preferences;
        this.fontName = this.preferences.getFontName();
        this.fontStyle = this.preferences.getFontStyle();
        this.fontSize = this.preferences.getFontSize();
        this.font = null;
    }

    public Font getFont() {
        if (this.font == null) {
            this.font = new Font(this.fontName, this.fontStyle, this.fontSize);
        }
        return this.font;
    }

    public void setSavedPreferences() {
        ParaProf.preferences.setFontName(this.fontName);
        ParaProf.preferences.setFontStyle(this.fontStyle);
        ParaProf.preferences.setFontSize(this.fontSize);
        ParaProf.preferences.setUnits(this.unitsBox.getSelectedIndex());
        ParaProf.preferences.setShowValuesAsPercent(this.showValuesAsPercentBox.isSelected());
        ParaProf.preferences.setShowPathTitleInReverse(this.showPathTitleInReverseBox.isSelected());
        ParaProf.preferences.setReversedCallPaths(this.reverseCallPathsBox.isSelected());
        ParaProf.preferences.setAutoLabels(this.autoLabelsBox.isSelected());
        ParaProf.preferences.setComputeMeanWithoutNulls(!this.meanIncludeNullBox.isSelected());
        ParaProf.preferences.setGenerateIntermediateCallPathData(this.generateIntermediateCallPathDataBox.isSelected());
        ParaProf.preferences.setShowSourceLocation(this.showSourceLocationsBox.isSelected());
    }

    public String getFontName() {
        return this.fontName;
    }

    public int getFontStyle() {
        return this.fontStyle;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int n) {
        this.fontSize = n;
        this.font = null;
    }

    public void updateFontSize() {
        this.fontSize = Math.max(1, this.barHeightSlider.getValue());
        this.font = null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block29: {
            try {
                Object object = actionEvent.getSource();
                String string = actionEvent.getActionCommand();
                if (object instanceof JMenuItem) {
                    if (string.equals("Show Color Map")) {
                        ParaProf.colorMap.showColorMap(this);
                        break block29;
                    }
                    if (string.equals("Edit Source Directories")) {
                        ParaProf.getDirectoryManager().display(this);
                        break block29;
                    }
                    if (string.equals("Load Preferences...")) {
                        JFileChooser jFileChooser = new JFileChooser();
                        jFileChooser.setCurrentDirectory(new File("."));
                        int n = jFileChooser.showOpenDialog(this);
                        if (n != 0) break block29;
                        File file = jFileChooser.getSelectedFile();
                        try {
                            ParaProf.loadPreferences(file);
                        }
                        catch (Exception exception) {
                            JOptionPane.showMessageDialog(this, "Error loading preferences!", "ParaProf Preferences", 0);
                        }
                        this.loadSavedPreferences();
                        this.setControls();
                        break block29;
                    }
                    if (string.equals("Save Preferences...")) {
                        File file;
                        JFileChooser jFileChooser = new JFileChooser();
                        jFileChooser.setCurrentDirectory(new File("."));
                        int n = jFileChooser.showSaveDialog(this);
                        if (n == 0 && !ParaProf.savePreferences(file = jFileChooser.getSelectedFile())) {
                            JOptionPane.showMessageDialog(this, "Error Saving preferences!", "ParaProf Preferences", 0);
                        }
                    } else if (string.equals("Edit Default Colors")) {
                        ParaProf.colorChooser.showColorChooser(this);
                    } else if (string.equals("Exit ParaProf!")) {
                        this.setVisible(false);
                        this.dispose();
                        ParaProf.exitParaProf(0);
                    } else if (string.equals("Apply and Close Window")) {
                        this.setVisible(false);
                        this.apply();
                    }
                    break block29;
                }
                if (object instanceof JCheckBox) {
                    if (string.equals("Bold")) {
                        this.fontStyle = this.italic.isSelected() ? (this.bold.isSelected() ? 3 : 2) : (this.bold.isSelected() ? 1 : 0);
                        this.prefSpacingPanel.repaint();
                    } else if (string.equals("Italic")) {
                        this.fontStyle = this.italic.isSelected() ? (this.bold.isSelected() ? 3 : 2) : (this.bold.isSelected() ? 1 : 0);
                        this.prefSpacingPanel.repaint();
                    }
                } else if (object == this.fontComboBox) {
                    this.fontName = (String)this.fontComboBox.getSelectedItem();
                    this.prefSpacingPanel.repaint();
                } else if (object instanceof JButton) {
                    if (string.equals("Apply")) {
                        this.apply();
                    } else if (string.equals("Cancel")) {
                        this.setVisible(false);
                        this.fontName = this.preferences.getFontName();
                        this.fontStyle = this.preferences.getFontStyle();
                        this.fontSize = this.preferences.getFontSize();
                        this.setControls();
                    } else if (string.equals("Restore Defaults")) {
                        this.fontName = "SansSerif";
                        this.fontStyle = 0;
                        this.fontSize = 12;
                        this.unitsBox.setSelectedIndex(2);
                        this.showValuesAsPercentBox.setSelected(false);
                        this.showPathTitleInReverseBox.setSelected(false);
                        this.reverseCallPathsBox.setSelected(false);
                        this.meanIncludeNullBox.setSelected(true);
                        this.autoLabelsBox.setSelected(true);
                        this.generateIntermediateCallPathDataBox.setSelected(false);
                        this.showSourceLocationsBox.setSelected(true);
                        this.setControls();
                    }
                }
            }
            catch (Exception exception) {
                ParaProfUtils.handleException(exception);
            }
        }
    }

    private void apply() {
        boolean bl = false;
        if (this.reverseCallPathsBox.isSelected() != ParaProf.preferences.getReversedCallPaths()) {
            bl = true;
        }
        if (this.autoLabelsBox.isSelected() != ParaProf.preferences.getAutoLabels()) {
            bl = true;
        }
        if (this.meanIncludeNullBox.isSelected() == ParaProf.preferences.getComputeMeanWithoutNulls()) {
            bl = true;
            DataSource.setMeanIncludeNulls((boolean)this.meanIncludeNullBox.isSelected());
            ParaProf.paraProfManagerWindow.recomputeStats();
        }
        this.font = null;
        this.setSavedPreferences();
        Vector vector = ParaProf.paraProfManagerWindow.getLoadedTrials();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            ParaProfTrial paraProfTrial = (ParaProfTrial)iterator.next();
            paraProfTrial.updateRegisteredObjects("prefEvent");
            paraProfTrial.updateRegisteredObjects("dataEvent");
        }
    }

    public void update(Observable observable, Object object) {
        String string = (String)object;
        if (string.equals("colorEvent")) {
            this.prefSpacingPanel.repaint();
        }
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        this.getContentPane().add(component, gridBagConstraints);
    }

    public void addNotify() {
        super.addNotify();
        if (this.mShown) {
            return;
        }
        JMenuBar jMenuBar = this.getJMenuBar();
        if (jMenuBar != null) {
            int n = jMenuBar.getPreferredSize().height;
            Dimension dimension = this.getSize();
            dimension.height += n;
            this.setSize(dimension);
        }
        this.mShown = true;
    }

    void thisWindowClosing(WindowEvent windowEvent) {
        this.setVisible(false);
        this.fontName = this.preferences.getFontName();
        this.fontStyle = this.preferences.getFontStyle();
        this.fontSize = this.preferences.getFontSize();
        this.setControls();
    }
}

