/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.common.Utility;
import edu.uoregon.tau.paraprof.DataSorter;
import edu.uoregon.tau.paraprof.PPFunctionProfile;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.enums.SortType;
import edu.uoregon.tau.paraprof.enums.ValueType;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.File;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import javax.swing.JFrame;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.LogarithmicAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.StandardXYItemLabelGenerator;
import org.jfree.chart.labels.XYItemLabelGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class RegressionGraph {
    public int metric = 0;
    public double unitMultiple = 1.0E-6;
    public double percent = 0.02;
    public ValueType valueType = ValueType.EXCLUSIVE;
    public String unitsString = "Seconds";
    public String xaxisLabel = "UEDGE Test Cases";
    public String yaxisLabel = "Time (in Seconds)";
    public String title = "Time spent in UEDGE test cases";
    public boolean barChart = true;
    public boolean mainOnly = true;
    public boolean horizontal = false;
    public boolean legend = true;
    public boolean angledXaxis = true;
    public boolean singleTrial = false;
    public boolean useProcCountAsTrialName = false;
    public int stringLimit = 60;
    public boolean logScale = false;
    public boolean scalingChart = false;
    public boolean speedupChart = false;
    public Font titleFont = new Font("SansSerif", 1, 16);
    public Font smallFont = new Font("SansSerif", 1, 14);
    public Font tickFont = new Font("SansSerif", 0, 12);
    public List trials;
    public List exps;
    public List expnames;

    private RegressionGraph() {
    }

    public void setTrials(List list) {
        this.trials = list;
        this.exps = new ArrayList();
        this.exps.add(list);
        this.expnames = new ArrayList();
        this.expnames.add("wallclock");
    }

    public static RegressionGraph createChart() {
        RegressionGraph regressionGraph = new RegressionGraph();
        return regressionGraph;
    }

    public static RegressionGraph createChart(ParaProfTrial paraProfTrial) {
        ArrayList<ParaProfTrial> arrayList = new ArrayList<ParaProfTrial>();
        arrayList.add(paraProfTrial);
        return RegressionGraph.createBasicChart(arrayList);
    }

    public static RegressionGraph createBasicChart(List list) {
        RegressionGraph regressionGraph = new RegressionGraph();
        regressionGraph.trials = list;
        regressionGraph.exps = new ArrayList();
        regressionGraph.exps.add(list);
        regressionGraph.expnames = new ArrayList();
        regressionGraph.expnames.add("wallclock");
        return regressionGraph;
    }

    public static RegressionGraph createExperimentChart(List list, List list2) {
        RegressionGraph regressionGraph = new RegressionGraph();
        regressionGraph.exps = list;
        regressionGraph.trials = (List)regressionGraph.exps.get(0);
        regressionGraph.expnames = list2;
        return regressionGraph;
    }

    private PPFunctionProfile getTopLevelTimer(ParaProfTrial paraProfTrial) {
        DataSorter dataSorter = new DataSorter(paraProfTrial);
        dataSorter.setSortType(SortType.VALUE);
        dataSorter.setSortValueType(ValueType.INCLUSIVE);
        dataSorter.setValueType(ValueType.INCLUSIVE);
        List list = dataSorter.getFunctionProfiles(paraProfTrial.getMeanThread());
        PPFunctionProfile pPFunctionProfile = (PPFunctionProfile)list.get(0);
        return pPFunctionProfile;
    }

    private XYDataset getScalingDataSet() {
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        XYSeries xYSeries = new XYSeries((Comparable)((Object)"ideal"));
        xYSeriesCollection.addSeries(xYSeries);
        double d = Double.MIN_VALUE;
        double d2 = Double.MAX_VALUE;
        for (int i = 0; i < this.exps.size(); ++i) {
            PPFunctionProfile pPFunctionProfile;
            ParaProfTrial paraProfTrial;
            int n;
            List list = (List)this.exps.get(i);
            XYSeries xYSeries2 = new XYSeries((Comparable)((Object)((String)this.expnames.get(i))));
            double d3 = Double.MAX_VALUE;
            double d4 = Double.MAX_VALUE;
            if (this.speedupChart) {
                for (n = 0; n < list.size(); ++n) {
                    paraProfTrial = (ParaProfTrial)list.get(n);
                    pPFunctionProfile = this.getTopLevelTimer(paraProfTrial);
                    int n2 = paraProfTrial.getMaxNCTNumbers()[0] + 1;
                    d = Math.max(d, (double)n2);
                    d2 = Math.min(d2, (double)n2);
                    if (!((double)n2 < d3)) continue;
                    d3 = n2;
                    d4 = ValueType.INCLUSIVE.getValue(pPFunctionProfile.getFunctionProfile(), this.metric) * this.unitMultiple;
                }
            }
            for (n = 0; n < list.size(); ++n) {
                paraProfTrial = (ParaProfTrial)list.get(n);
                pPFunctionProfile = this.getTopLevelTimer(paraProfTrial);
                double d5 = ValueType.INCLUSIVE.getValue(pPFunctionProfile.getFunctionProfile(), this.metric) * this.unitMultiple;
                int n3 = paraProfTrial.getMaxNCTNumbers()[0] + 1;
                if (this.speedupChart) {
                    d5 = d4 / d5;
                }
                xYSeries2.add((double)n3, d5);
            }
            xYSeriesCollection.addSeries(xYSeries2);
        }
        if (this.speedupChart) {
            xYSeries.add(1.0, d2);
            xYSeries.add(d, d);
        } else {
            xYSeriesCollection.removeSeries(xYSeries);
        }
        return xYSeriesCollection;
    }

    private CategoryDataset getMainOnlyDataSet() {
        ParaProfTrial paraProfTrial;
        int n;
        Object object;
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (int i = 0; i < this.exps.size(); ++i) {
            object = (List)this.exps.get(i);
            for (n = 0; n < object.size(); ++n) {
                paraProfTrial = (ParaProfTrial)object.get(n);
                treeMap.put(paraProfTrial.getName(), paraProfTrial.getName());
            }
        }
        Iterator iterator = treeMap.keySet().iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            defaultCategoryDataset.addValue(42.0, (Comparable)((Object)"@@@"), (Comparable)object);
        }
        for (int i = 0; i < this.exps.size(); ++i) {
            object = (List)this.exps.get(i);
            Collections.sort(object, new NCTComparator());
            for (n = 0; n < object.size(); ++n) {
                paraProfTrial = (ParaProfTrial)object.get(n);
                DataSorter dataSorter = new DataSorter(paraProfTrial);
                dataSorter.setSortType(SortType.VALUE);
                dataSorter.setSortValueType(ValueType.INCLUSIVE);
                dataSorter.setValueType(ValueType.INCLUSIVE);
                List list = dataSorter.getFunctionProfiles(paraProfTrial.getMeanThread());
                PPFunctionProfile pPFunctionProfile = (PPFunctionProfile)list.get(0);
                double d = ValueType.INCLUSIVE.getValue(pPFunctionProfile.getFunctionProfile(), this.metric) * this.unitMultiple;
                defaultCategoryDataset.addValue(d, (Comparable)((Object)((String)this.expnames.get(i))), (Comparable)((Object)paraProfTrial.getName()));
            }
        }
        defaultCategoryDataset.removeRow((Comparable)((Object)"@@@"));
        return defaultCategoryDataset;
    }

    private CategoryDataset getDataSet() {
        Object object;
        Comparable comparable;
        Object object2;
        Object object3;
        Object object4;
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        int n = 0;
        Iterator iterator = this.trials.iterator();
        while (iterator.hasNext()) {
            ParaProfTrial paraProfTrial = (ParaProfTrial)iterator.next();
            object4 = new DataSorter(paraProfTrial);
            ((DataSorter)object4).setSortType(SortType.VALUE);
            ((DataSorter)object4).setSortValueType(ValueType.INCLUSIVE);
            ((DataSorter)object4).setValueType(ValueType.INCLUSIVE);
            List list = ((DataSorter)object4).getFunctionProfiles(paraProfTrial.getMeanThread());
            object3 = this.getTopLevelTimer(paraProfTrial);
            double d = ((PPFunctionProfile)object3).getInclusiveValue();
            double d2 = d * this.percent;
            object2 = list.iterator();
            while (object2.hasNext()) {
                String string;
                comparable = (PPFunctionProfile)object2.next();
                if (!(((PPFunctionProfile)comparable).getExclusiveValue() > d2) || hashMap.get(string = ((PPFunctionProfile)comparable).getDisplayName()) != null) continue;
                hashMap.put(string, new Integer(n++));
            }
        }
        hashMap.put("other", new Integer(n++));
        int n2 = (Integer)hashMap.get("other");
        int n3 = this.trials.size();
        object4 = new double[n][n3];
        for (int i = 0; i < this.trials.size(); ++i) {
            object3 = (ParaProfTrial)this.trials.get(i);
            DataSorter dataSorter = new DataSorter((ParaProfTrial)object3);
            object = dataSorter.getFunctionProfiles(((ParaProfTrial)object3).getMeanThread());
            Iterator iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                PPFunctionProfile pPFunctionProfile = (PPFunctionProfile)iterator2.next();
                object2 = pPFunctionProfile.getDisplayName();
                comparable = (Integer)hashMap.get(object2);
                double d = this.valueType.getValue(pPFunctionProfile.getFunctionProfile(), this.metric) * this.unitMultiple;
                if (comparable != null) {
                    object4[((Integer)comparable).intValue()][i] = d;
                    continue;
                }
                Object object5 = object4[n2];
                int n4 = i;
                object5[n4] = object5[n4] + d;
            }
        }
        String[] stringArray = new String[n3];
        for (int i = 0; i < this.trials.size(); ++i) {
            ParaProfTrial paraProfTrial = (ParaProfTrial)this.trials.get(i);
            stringArray[i] = this.useProcCountAsTrialName ? Integer.toString(paraProfTrial.getDataSource().getNumberOfNodes()) : paraProfTrial.getName();
        }
        String[] stringArray2 = new String[n];
        DefaultCategoryDataset defaultCategoryDataset = hashMap.keySet().iterator();
        while (defaultCategoryDataset.hasNext()) {
            object = (String)defaultCategoryDataset.next();
            Integer n5 = (Integer)hashMap.get(object);
            if (((String)object).length() > this.stringLimit) {
                object = ((String)object).substring(0, this.stringLimit) + "...";
            }
            stringArray2[n5.intValue()] = object;
        }
        defaultCategoryDataset = new DefaultCategoryDataset();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n3; ++j) {
                if (!(object4[i][j] > 0.0)) continue;
                defaultCategoryDataset.addValue((double)object4[i][j], (Comparable)((Object)stringArray2[i]), (Comparable)((Object)stringArray[j]));
            }
        }
        return defaultCategoryDataset;
    }

    private CategoryDataset getSingleDataSet() {
        ParaProfTrial paraProfTrial = (ParaProfTrial)this.trials.get(0);
        PPFunctionProfile pPFunctionProfile = this.getTopLevelTimer(paraProfTrial);
        double d = pPFunctionProfile.getInclusiveValue();
        double d2 = d * this.percent;
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        DataSorter dataSorter = new DataSorter(paraProfTrial);
        dataSorter.setSortType(SortType.VALUE);
        dataSorter.setSortValueType(this.valueType);
        dataSorter.setValueType(this.valueType);
        List list = dataSorter.getFunctionProfiles(paraProfTrial.getMeanThread());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            PPFunctionProfile pPFunctionProfile2 = (PPFunctionProfile)iterator.next();
            if (!(pPFunctionProfile2.getExclusiveValue() > d2)) continue;
            String string = pPFunctionProfile2.getDisplayName();
            double d3 = this.valueType.getValue(pPFunctionProfile2.getFunctionProfile(), this.metric) * this.unitMultiple;
            defaultCategoryDataset.addValue(d3, (Comparable)((Object)string), (Comparable)((Object)string));
        }
        return defaultCategoryDataset;
    }

    public JFreeChart getChart() {
        ValueAxis valueAxis;
        XYPlot xYPlot;
        XYLineAndShapeRenderer xYLineAndShapeRenderer;
        XYPlot xYPlot2;
        JFreeChart jFreeChart;
        ParaProf.preferences.setShowSourceLocation(false);
        CategoryDataset categoryDataset = null;
        XYDataset xYDataset = null;
        if (this.singleTrial) {
            categoryDataset = this.getSingleDataSet();
        } else if (this.scalingChart) {
            xYDataset = this.getScalingDataSet();
        } else {
            categoryDataset = this.mainOnly ? this.getMainOnlyDataSet() : this.getDataSet();
        }
        PlotOrientation plotOrientation = this.horizontal ? PlotOrientation.HORIZONTAL : PlotOrientation.VERTICAL;
        if (this.scalingChart) {
            jFreeChart = ChartFactory.createXYLineChart((String)this.title, (String)this.xaxisLabel, (String)this.yaxisLabel, (XYDataset)xYDataset, (PlotOrientation)plotOrientation, (boolean)this.legend, (boolean)true, (boolean)false);
            xYPlot2 = jFreeChart.getXYPlot();
            xYLineAndShapeRenderer = (XYLineAndShapeRenderer)xYPlot2.getRenderer();
            xYLineAndShapeRenderer.setBaseShapesVisible(true);
            xYLineAndShapeRenderer.setBaseShapesFilled(true);
            xYLineAndShapeRenderer.setBaseStroke((Stroke)new BasicStroke(2.0f, 1, 2));
            if (this.speedupChart) {
                xYLineAndShapeRenderer.setSeriesShapesVisible(0, false);
            }
            xYPlot = new StandardXYItemLabelGenerator("{2}", (NumberFormat)new DecimalFormat("0.00"), (NumberFormat)new DecimalFormat("0.00"));
            xYLineAndShapeRenderer.setSeriesItemLabelGenerator(xYDataset.getSeriesCount() - 1, (XYItemLabelGenerator)xYPlot);
            xYLineAndShapeRenderer.setSeriesItemLabelsVisible(xYDataset.getSeriesCount() - 1, true);
            valueAxis = xYPlot2.getDomainAxis();
            TickUnitSource tickUnitSource = NumberAxis.createIntegerTickUnits();
            valueAxis.setStandardTickUnits(tickUnitSource);
            if (this.speedupChart) {
                xYLineAndShapeRenderer.setSeriesPaint(0, (Paint)Color.gray);
            } else {
                xYLineAndShapeRenderer.setSeriesPaint(0, (Paint)Color.red);
            }
            xYLineAndShapeRenderer.setSeriesPaint(1, (Paint)Color.blue);
            xYLineAndShapeRenderer.setSeriesPaint(2, (Paint)Color.green);
            xYLineAndShapeRenderer.setSeriesPaint(3, (Paint)Color.magenta);
            xYLineAndShapeRenderer.setSeriesPaint(4, (Paint)Color.cyan);
            xYLineAndShapeRenderer.setSeriesPaint(5, (Paint)Color.pink);
            xYLineAndShapeRenderer.setSeriesPaint(6, (Paint)Color.red);
            xYLineAndShapeRenderer.setSeriesPaint(7, (Paint)Color.orange);
            xYLineAndShapeRenderer.setSeriesPaint(8, (Paint)Color.lightGray);
        } else if (this.barChart) {
            jFreeChart = ChartFactory.createStackedBarChart((String)this.title, (String)this.xaxisLabel, (String)this.yaxisLabel, (CategoryDataset)categoryDataset, (PlotOrientation)plotOrientation, (boolean)this.legend, (boolean)true, (boolean)false);
        } else {
            jFreeChart = ChartFactory.createLineChart((String)this.title, (String)this.xaxisLabel, (String)this.yaxisLabel, (CategoryDataset)categoryDataset, (PlotOrientation)plotOrientation, (boolean)this.legend, (boolean)true, (boolean)false);
            xYPlot2 = jFreeChart.getCategoryPlot();
            xYLineAndShapeRenderer = (LineAndShapeRenderer)xYPlot2.getRenderer();
            xYLineAndShapeRenderer.setBaseShapesVisible(true);
            xYLineAndShapeRenderer.setBaseShapesFilled(true);
            xYLineAndShapeRenderer.setBaseStroke((Stroke)new BasicStroke(2.0f, 1, 2));
            xYLineAndShapeRenderer.setSeriesPaint(0, (Paint)Color.red);
            xYLineAndShapeRenderer.setSeriesPaint(1, (Paint)Color.blue);
            xYLineAndShapeRenderer.setSeriesPaint(2, (Paint)Color.green);
            xYLineAndShapeRenderer.setSeriesPaint(3, (Paint)Color.magenta);
            xYLineAndShapeRenderer.setSeriesPaint(4, (Paint)Color.cyan);
            xYLineAndShapeRenderer.setSeriesPaint(5, (Paint)Color.pink);
            xYLineAndShapeRenderer.setSeriesPaint(6, (Paint)Color.gray);
            xYLineAndShapeRenderer.setSeriesPaint(7, (Paint)Color.orange);
            xYLineAndShapeRenderer.setSeriesPaint(8, (Paint)Color.lightGray);
            xYLineAndShapeRenderer.setSeriesPaint(categoryDataset.getRowCount() - 1, (Paint)Color.black);
        }
        if (this.angledXaxis && !this.scalingChart) {
            xYPlot2 = jFreeChart.getCategoryPlot();
            xYLineAndShapeRenderer = xYPlot2.getDomainAxis();
            xYLineAndShapeRenderer.setCategoryLabelPositions(CategoryLabelPositions.UP_45);
        }
        xYPlot2 = new TextTitle();
        xYPlot2.setText(this.title);
        xYPlot2.setFont(this.titleFont);
        jFreeChart.setTitle((TextTitle)xYPlot2);
        if (this.scalingChart) {
            xYPlot = jFreeChart.getXYPlot();
            valueAxis = xYPlot.getDomainAxis();
            valueAxis.setLabelFont(this.smallFont);
            valueAxis.setTickLabelFont(this.tickFont);
            xYLineAndShapeRenderer = xYPlot.getRangeAxis();
        } else {
            xYPlot = jFreeChart.getCategoryPlot();
            valueAxis = xYPlot.getDomainAxis();
            valueAxis.setLabelFont(this.smallFont);
            valueAxis.setTickLabelFont(this.tickFont);
            xYLineAndShapeRenderer = xYPlot.getRangeAxis();
        }
        Utility.applyDefaultChartTheme((JFreeChart)jFreeChart);
        if (this.logScale) {
            xYPlot = new LogarithmicAxis("");
            xYPlot.setAllowNegativesFlag(true);
            xYPlot.setLog10TickLabelsFlag(false);
            xYLineAndShapeRenderer = xYPlot;
            if (this.scalingChart) {
                valueAxis = jFreeChart.getXYPlot();
                valueAxis.setRangeAxis((ValueAxis)xYLineAndShapeRenderer);
            } else {
                valueAxis = jFreeChart.getCategoryPlot();
                valueAxis.setRangeAxis((ValueAxis)xYLineAndShapeRenderer);
            }
        }
        xYLineAndShapeRenderer.setLabel(this.yaxisLabel);
        xYLineAndShapeRenderer.setLabelFont(new Font("SansSerif", 1, 14));
        xYLineAndShapeRenderer.setTickLabelFont(this.tickFont);
        return jFreeChart;
    }

    public JFrame createFrame() {
        ChartPanel chartPanel = new ChartPanel(this.getChart());
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().add((Component)chartPanel);
        jFrame.setSize(640, 480);
        ParaProfUtils.setFrameIcon(jFrame);
        return jFrame;
    }

    public void savePNG(String string) {
        try {
            JFreeChart jFreeChart = this.getChart();
            ChartUtilities.saveChartAsPNG((File)new File(string), (JFreeChart)jFreeChart, (int)640, (int)480);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public int getMetric() {
        return this.metric;
    }

    public void setMetric(int n) {
        this.metric = n;
    }

    public double getUnitMultiple() {
        return this.unitMultiple;
    }

    public void setUnitMultiple(double d) {
        this.unitMultiple = d;
    }

    public double getPercent() {
        return this.percent;
    }

    public void setPercent(double d) {
        this.percent = d;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public void setValueType(ValueType valueType) {
        this.valueType = valueType;
    }

    public String getUnitsString() {
        return this.unitsString;
    }

    public void setUnitsString(String string) {
        this.unitsString = string;
    }

    public String getXaxisLabel() {
        return this.xaxisLabel;
    }

    public void setXaxisLabel(String string) {
        this.xaxisLabel = string;
    }

    public String getYaxisLabel() {
        return this.yaxisLabel;
    }

    public void setYaxisLabel(String string) {
        this.yaxisLabel = string;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public boolean getBarChart() {
        return this.barChart;
    }

    public void setBarChart(boolean bl) {
        this.barChart = bl;
    }

    public boolean getMainOnly() {
        return this.mainOnly;
    }

    public void setMainOnly(boolean bl) {
        this.mainOnly = bl;
    }

    public boolean getHorizontal() {
        return this.horizontal;
    }

    public void setHorizontal(boolean bl) {
        this.horizontal = bl;
    }

    public boolean getLegend() {
        return this.legend;
    }

    public void setLegend(boolean bl) {
        this.legend = bl;
    }

    public boolean getAngledXaxis() {
        return this.angledXaxis;
    }

    public void setAngledXaxis(boolean bl) {
        this.angledXaxis = bl;
    }

    public int getStringLimit() {
        return this.stringLimit;
    }

    public void setStringLimit(int n) {
        this.stringLimit = n;
    }

    public boolean getLogScale() {
        return this.logScale;
    }

    public void setLogScale(boolean bl) {
        this.logScale = bl;
    }

    public boolean getScalingChart() {
        return this.scalingChart;
    }

    public void setScalingChart(boolean bl) {
        this.scalingChart = bl;
    }

    public boolean getSpeedupChart() {
        return this.speedupChart;
    }

    public void setSpeedupChart(boolean bl) {
        this.speedupChart = bl;
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public void setTitleFont(Font font) {
        this.titleFont = font;
    }

    public Font getSmallFont() {
        return this.smallFont;
    }

    public void setSmallFont(Font font) {
        this.smallFont = font;
    }

    public Font getTickFont() {
        return this.tickFont;
    }

    public void setTickFont(Font font) {
        this.tickFont = font;
    }

    public void setExps(List list, List list2) {
        this.exps = list;
        this.expnames = list2;
        this.trials = (List)this.exps.get(0);
    }

    public void setSingleTrial(boolean bl) {
        this.singleTrial = bl;
    }

    public void setUseProcCountAsName(boolean bl) {
        this.useProcCountAsTrialName = bl;
    }

    private static class NCTComparator
    implements Comparator {
        private NCTComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object instanceof ParaProfTrial) {
                ParaProfTrial paraProfTrial = (ParaProfTrial)object;
                ParaProfTrial paraProfTrial2 = (ParaProfTrial)object2;
                return paraProfTrial.getMaxNCTNumbers()[0] - paraProfTrial2.getMaxNCTNumbers()[0];
            }
            List list = (List)object;
            List list2 = (List)object2;
            ParaProfTrial paraProfTrial = (ParaProfTrial)list.get(0);
            ParaProfTrial paraProfTrial3 = (ParaProfTrial)list2.get(0);
            return paraProfTrial.getMaxNCTNumbers()[0] - paraProfTrial3.getMaxNCTNumbers()[0];
        }
    }
}

