/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.common.Utility;
import edu.uoregon.tau.paraprof.FunctionSelectorDialog;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.ThreeDeeScalePanel;
import edu.uoregon.tau.paraprof.ThreeDeeSettings;
import edu.uoregon.tau.paraprof.ThreeDeeWindow;
import edu.uoregon.tau.paraprof.enums.ValueType;
import edu.uoregon.tau.paraprof.enums.VisType;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Thread;
import edu.uoregon.tau.perfdmf.UtilFncs;
import edu.uoregon.tau.vis.Plot;
import edu.uoregon.tau.vis.SteppedComboBox;
import edu.uoregon.tau.vis.VisRenderer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxUI;

public class ThreeDeeControlPanel
extends JPanel
implements ActionListener {
    private ThreeDeeSettings settings;
    private ThreeDeeWindow window;
    private ParaProfTrial ppTrial;
    private SteppedComboBox heightValueBox;
    private SteppedComboBox heightMetricBox;
    private SteppedComboBox colorValueBox;
    private SteppedComboBox colorMetricBox;
    private JPanel subPanel;
    private VisRenderer visRenderer;
    private JTextField heightValueField = new JTextField("");
    private JTextField colorValueField = new JTextField("");
    private int selectedTab;
    private JTabbedPane tabbedPane;
    private ThreeDeeScalePanel scalePanel;

    public ThreeDeeControlPanel(ThreeDeeWindow threeDeeWindow, ThreeDeeSettings threeDeeSettings, ParaProfTrial paraProfTrial, VisRenderer visRenderer) {
        this.settings = threeDeeSettings;
        this.window = threeDeeWindow;
        this.ppTrial = paraProfTrial;
        this.visRenderer = visRenderer;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButton jRadioButton = new JRadioButton(VisType.TRIANGLE_MESH_PLOT.toString(), threeDeeSettings.getVisType() == VisType.TRIANGLE_MESH_PLOT);
        jRadioButton.addActionListener(this);
        buttonGroup.add(jRadioButton);
        this.addCompItem(this, jRadioButton, gridBagConstraints, 0, 0, 1, 1);
        jRadioButton = new JRadioButton(VisType.BAR_PLOT.toString(), threeDeeSettings.getVisType() == VisType.BAR_PLOT);
        jRadioButton.addActionListener(this);
        buttonGroup.add(jRadioButton);
        this.addCompItem(this, jRadioButton, gridBagConstraints, 0, 2, 1, 1);
        jRadioButton = new JRadioButton(VisType.SCATTER_PLOT.toString(), threeDeeSettings.getVisType() == VisType.SCATTER_PLOT);
        jRadioButton.addActionListener(this);
        buttonGroup.add(jRadioButton);
        this.addCompItem(this, jRadioButton, gridBagConstraints, 0, 3, 1, 1);
        this.createSubPanel();
    }

    private void createSubPanel() {
        if (this.subPanel != null) {
            this.remove(this.subPanel);
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.subPanel = this.settings.getVisType() == VisType.SCATTER_PLOT ? this.createScatterPanel() : (this.settings.getVisType() == VisType.CALLGRAPH ? this.createCallGraphPanel() : this.createFullDataPanel());
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.addCompItem(this, this.subPanel, gridBagConstraints, 0, 5, 1, 1);
        this.revalidate();
        this.validate();
        this.setPreferredSize(this.getMinimumSize());
    }

    private JPanel createScatterSelectionPanel(String string, final int n) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        String string2 = "   <none>";
        if (this.settings.getScatterFunctions()[n] != null) {
            string2 = this.settings.getScatterFunctions()[n].getName();
        }
        final JTextField jTextField = new JTextField(string2);
        jTextField.setEditable(false);
        jTextField.setBorder(BorderFactory.createLoweredBevelBorder());
        jTextField.setCaretPosition(0);
        final SteppedComboBox steppedComboBox = new SteppedComboBox((Object[])ValueType.VALUES);
        Dimension dimension = steppedComboBox.getPreferredSize();
        steppedComboBox.setMinimumSize(new Dimension(50, steppedComboBox.getMinimumSize().height));
        steppedComboBox.setPopupWidth(dimension.width);
        final SteppedComboBox steppedComboBox2 = new SteppedComboBox((Object[])this.ppTrial.getMetricArray());
        dimension = steppedComboBox2.getPreferredSize();
        steppedComboBox2.setMinimumSize(new Dimension(50, steppedComboBox2.getMinimumSize().height));
        steppedComboBox2.setPopupWidth(dimension.width);
        steppedComboBox.setSelectedItem((Object)this.settings.getScatterValueTypes()[n]);
        steppedComboBox2.setSelectedItem((Object)this.settings.getScatterMetrics()[n]);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ThreeDeeControlPanel.this.settings.setScatterValueType((ValueType)steppedComboBox.getSelectedItem(), n);
                    ThreeDeeControlPanel.this.settings.setScatterMetric((Metric)steppedComboBox2.getSelectedItem(), n);
                    ThreeDeeControlPanel.this.window.redraw();
                }
                catch (Exception exception) {
                    ParaProfUtils.handleException(exception);
                }
            }
        };
        steppedComboBox.addActionListener(actionListener);
        steppedComboBox2.addActionListener(actionListener);
        JButton jButton = new JButton("...");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    FunctionSelectorDialog functionSelectorDialog = new FunctionSelectorDialog(ThreeDeeControlPanel.this.window, true, ThreeDeeControlPanel.this.ppTrial.getDisplayedFunctions().iterator(), ThreeDeeControlPanel.this.settings.getScatterFunctions()[n], true, false);
                    if (functionSelectorDialog.choose()) {
                        Function function = (Function)functionSelectorDialog.getSelectedObject();
                        ThreeDeeControlPanel.this.settings.setScatterFunction(function, n);
                        String string = "   <none>";
                        if (ThreeDeeControlPanel.this.settings.getScatterFunctions()[n] != null) {
                            string = ParaProfUtils.getDisplayName(ThreeDeeControlPanel.this.settings.getScatterFunctions()[n]);
                        }
                        jTextField.setText(string);
                        ThreeDeeControlPanel.this.window.redraw();
                    }
                }
                catch (Exception exception) {
                    ParaProfUtils.handleException(exception);
                }
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        this.addCompItem(jPanel2, jTextField, gridBagConstraints, 0, 0, 1, 1);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        this.addCompItem(jPanel2, jButton, gridBagConstraints, 1, 0, 1, 1);
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        this.addCompItem(jPanel, jPanel2, gridBagConstraints, 1, 0, 2, 1);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        this.addCompItem(jPanel, (Component)steppedComboBox, gridBagConstraints, 1, 1, 1, 1);
        this.addCompItem(jPanel, (Component)steppedComboBox2, gridBagConstraints, 2, 1, 1, 1);
        return jPanel;
    }

    private JPanel createCallGraphPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.addCompItem(jPanel, new JLabel("Thread"), gridBagConstraints, 0, 0, 1, 1);
        ArrayList<Thread> arrayList = new ArrayList<Thread>();
        arrayList.add(this.ppTrial.getDataSource().getMeanData());
        arrayList.add(this.ppTrial.getDataSource().getStdDevData());
        arrayList.addAll(this.ppTrial.getDataSource().getAllThreads());
        final SliderComboBox sliderComboBox = new SliderComboBox(arrayList.toArray());
        sliderComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ThreeDeeControlPanel.this.settings.setSelectedThread((Thread)sliderComboBox.getSelectedItem());
                System.out.println("bargle");
                ThreeDeeControlPanel.this.window.redraw();
            }
        });
        this.addCompItem(jPanel, sliderComboBox, gridBagConstraints, 1, 0, 1, 1);
        this.tabbedPane = new JTabbedPane();
        Plot plot = this.window.getPlot();
        this.tabbedPane.addTab(plot.getName(), plot.getControlPanel(this.visRenderer));
        this.tabbedPane.addTab("ColorScale", this.window.getColorScale().getControlPanel(this.visRenderer));
        this.tabbedPane.addTab("Render", this.visRenderer.getControlPanel());
        this.tabbedPane.setMinimumSize(new Dimension(300, 160));
        this.tabbedPane.setSelectedIndex(0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        this.addCompItem(jPanel, this.tabbedPane, gridBagConstraints, 0, 1, 2, 1);
        return jPanel;
    }

    private JPanel createScatterPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.weightx = 0.0;
        this.addCompItem(jPanel, new JLabel("Width"), gridBagConstraints, 0, 0, 1, 1);
        this.addCompItem(jPanel, this.createScatterSelectionPanel("Width", 0), gridBagConstraints, 1, 0, 1, 1);
        gridBagConstraints.weightx = 0.0;
        this.addCompItem(jPanel, new JLabel("Depth"), gridBagConstraints, 0, 1, 1, 1);
        this.addCompItem(jPanel, this.createScatterSelectionPanel("Depth", 1), gridBagConstraints, 1, 1, 1, 1);
        gridBagConstraints.weightx = 0.0;
        this.addCompItem(jPanel, new JLabel("Height"), gridBagConstraints, 0, 2, 1, 1);
        this.addCompItem(jPanel, this.createScatterSelectionPanel("Height", 2), gridBagConstraints, 1, 2, 1, 1);
        gridBagConstraints.weightx = 0.0;
        this.addCompItem(jPanel, new JLabel("Color"), gridBagConstraints, 0, 3, 1, 1);
        this.addCompItem(jPanel, this.createScatterSelectionPanel("Color", 3), gridBagConstraints, 1, 3, 1, 1);
        this.tabbedPane = new JTabbedPane();
        Plot plot = this.window.getPlot();
        this.tabbedPane.addTab(plot.getName(), plot.getControlPanel(this.visRenderer));
        this.tabbedPane.addTab("Axes", plot.getAxes().getControlPanel(this.visRenderer));
        this.tabbedPane.addTab("ColorScale", this.window.getColorScale().getControlPanel(this.visRenderer));
        this.tabbedPane.addTab("Render", this.visRenderer.getControlPanel());
        this.tabbedPane.setMinimumSize(new Dimension(300, 160));
        this.selectedTab = Math.min(this.selectedTab, this.tabbedPane.getTabCount() - 1);
        this.tabbedPane.setSelectedIndex(this.selectedTab);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        this.addCompItem(jPanel, this.tabbedPane, gridBagConstraints, 0, 4, 2, 1);
        return jPanel;
    }

    private JPanel createSelectorPanel(int n, int n2, final List list, final int n3) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.settings.getSelections()[n3] = Math.min(this.settings.getSelections()[n3], n2);
        this.settings.getSelections()[n3] = Math.max(this.settings.getSelections()[n3], n);
        final JScrollBar jScrollBar = new JScrollBar(0, this.settings.getSelections()[n3], 1, n, n2);
        jScrollBar.setBlockIncrement((n2 - n) / 10);
        final JTextField jTextField = new JTextField("<none>");
        jTextField.setHorizontalAlignment(0);
        if (this.settings.getSelections()[n3] >= 0 && list != null) {
            jTextField.setText((String)list.get(this.settings.getSelections()[n3]));
        }
        jTextField.setEditable(false);
        jTextField.setCaretPosition(0);
        jScrollBar.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                int n = jScrollBar.getValue();
                ThreeDeeControlPanel.this.settings.setSelection(n3, n);
                if (n >= 0 && list != null) {
                    jTextField.setText((String)list.get(n));
                } else {
                    jTextField.setText("<none>");
                }
                jTextField.setCaretPosition(0);
                ThreeDeeControlPanel.this.heightValueField.setText(ThreeDeeControlPanel.this.window.getSelectedHeightValue());
                ThreeDeeControlPanel.this.colorValueField.setText(ThreeDeeControlPanel.this.window.getSelectedColorValue());
                ThreeDeeControlPanel.this.scalePanel.setPosition(0, ThreeDeeControlPanel.this.window.getSelectedHeightRatio());
                ThreeDeeControlPanel.this.scalePanel.setPosition(1, ThreeDeeControlPanel.this.window.getSelectedColorRatio());
                ThreeDeeControlPanel.this.window.redraw();
            }
        });
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        Utility.addCompItem((Container)jPanel, (Component)jTextField, (GridBagConstraints)gridBagConstraints, (int)1, (int)0, (int)1, (int)1);
        Utility.addCompItem((Container)jPanel, (Component)jScrollBar, (GridBagConstraints)gridBagConstraints, (int)1, (int)1, (int)1, (int)1);
        return jPanel;
    }

    private String getScaleString(double d, Metric metric, ValueType valueType) {
        int n = this.window.getUnits();
        if (!metric.isTimeMetric() || !ValueType.isTimeUnits(valueType)) {
            n = 0;
        }
        return UtilFncs.getOutputString((int)n, (double)d, (int)6, (boolean)metric.isTimeDenominator()).trim();
    }

    private void updateScalePanel() {
        String[] stringArray = new String[2];
        String[] stringArray2 = new String[2];
        stringArray[0] = "0";
        stringArray[1] = "0";
        stringArray2[0] = this.getScaleString(this.window.getMaxHeightValue(), this.settings.getHeightMetric(), this.settings.getHeightValue());
        stringArray2[1] = this.getScaleString(this.window.getMaxColorValue(), this.settings.getColorMetric(), this.settings.getColorValue());
        String[] stringArray3 = new String[]{"height", "color"};
        String[] stringArray4 = new String[]{this.window.getHeightUnitLabel(), this.window.getColorUnitLabel()};
        this.scalePanel.setRanges(stringArray, stringArray2, stringArray3, stringArray4);
        this.scalePanel.setPosition(0, this.window.getSelectedHeightRatio());
        this.scalePanel.setPosition(1, this.window.getSelectedColorRatio());
    }

    private JPanel createScalePanel() {
        if (this.scalePanel == null) {
            this.scalePanel = ThreeDeeScalePanel.CreateScalePanel();
            this.updateScalePanel();
        }
        return this.scalePanel.getJPanel();
    }

    private JPanel createFullDataPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Plot plot = ThreeDeeControlPanel.this.window.getPlot();
                    ThreeDeeControlPanel.this.settings.setHeightMetric((Metric)ThreeDeeControlPanel.this.heightMetricBox.getSelectedItem());
                    ThreeDeeControlPanel.this.settings.setColorMetric((Metric)ThreeDeeControlPanel.this.colorMetricBox.getSelectedItem());
                    ThreeDeeControlPanel.this.settings.setHeightValue((ValueType)ThreeDeeControlPanel.this.heightValueBox.getSelectedItem());
                    ThreeDeeControlPanel.this.settings.setColorValue((ValueType)ThreeDeeControlPanel.this.colorValueBox.getSelectedItem());
                    ThreeDeeControlPanel.this.settings.setSize((int)plot.getWidth(), (int)plot.getDepth(), (int)plot.getHeight());
                    ThreeDeeControlPanel.this.settings.setRegularAim(ThreeDeeControlPanel.this.visRenderer.getAim());
                    ThreeDeeControlPanel.this.settings.setRegularEye(ThreeDeeControlPanel.this.visRenderer.getEye());
                    ThreeDeeControlPanel.this.heightValueField.setText(ThreeDeeControlPanel.this.window.getSelectedHeightValue());
                    ThreeDeeControlPanel.this.colorValueField.setText(ThreeDeeControlPanel.this.window.getSelectedColorValue());
                    ThreeDeeControlPanel.this.window.redraw();
                    ThreeDeeControlPanel.this.updateScalePanel();
                }
                catch (Exception exception) {
                    ParaProfUtils.handleException(exception);
                }
            }
        };
        this.heightValueBox = new SteppedComboBox((Object[])ValueType.VALUES);
        Dimension dimension = this.heightValueBox.getPreferredSize();
        this.heightValueBox.setMinimumSize(new Dimension(50, this.heightValueBox.getMinimumSize().height));
        this.heightValueBox.setPopupWidth(dimension.width);
        this.heightValueBox.setSelectedItem((Object)this.settings.getHeightValue());
        this.heightValueBox.addActionListener(actionListener);
        this.colorValueBox = new SteppedComboBox((Object[])ValueType.VALUES);
        dimension = this.colorValueBox.getPreferredSize();
        this.colorValueBox.setMinimumSize(new Dimension(50, this.colorValueBox.getMinimumSize().height));
        this.colorValueBox.setPopupWidth(dimension.width);
        this.colorValueBox.setSelectedItem((Object)this.settings.getColorValue());
        this.colorValueBox.addActionListener(actionListener);
        this.heightMetricBox = new SteppedComboBox((Object[])this.ppTrial.getMetricArray());
        dimension = this.heightMetricBox.getPreferredSize();
        this.heightMetricBox.setMinimumSize(new Dimension(50, this.heightMetricBox.getMinimumSize().height));
        this.heightMetricBox.setPopupWidth(dimension.width);
        this.heightMetricBox.setSelectedItem((Object)this.settings.getHeightMetric());
        this.heightMetricBox.addActionListener(actionListener);
        this.colorMetricBox = new SteppedComboBox((Object[])this.ppTrial.getMetricArray());
        dimension = this.colorMetricBox.getPreferredSize();
        this.colorMetricBox.setMinimumSize(new Dimension(50, this.colorMetricBox.getMinimumSize().height));
        this.colorMetricBox.setPopupWidth(dimension.width);
        this.colorMetricBox.setSelectedItem((Object)this.settings.getColorMetric());
        this.colorMetricBox.addActionListener(actionListener);
        this.tabbedPane = new JTabbedPane();
        Plot plot = this.window.getPlot();
        this.tabbedPane.setTabLayoutPolicy(1);
        this.tabbedPane.addTab("Scales", this.createScalePanel());
        this.tabbedPane.addTab("Plot", plot.getControlPanel(this.visRenderer));
        this.tabbedPane.addTab("Axes", plot.getAxes().getControlPanel(this.visRenderer));
        this.tabbedPane.addTab("Color", this.window.getColorScale().getControlPanel(this.visRenderer));
        this.tabbedPane.addTab("Render", this.visRenderer.getControlPanel());
        this.tabbedPane.setMinimumSize(new Dimension(290, 160));
        this.tabbedPane.setSelectedIndex(this.selectedTab);
        JPanel jPanel2 = this.createSelectorPanel(-1, this.window.getFunctionNames().size(), this.window.getFunctionNames(), 0);
        JPanel jPanel3 = this.createSelectorPanel(0, this.ppTrial.getDataSource().getNumThreads(), this.window.getThreadNames(), 1);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addCompItem(jPanel, new JLabel("Height Metric"), gridBagConstraints, 0, 0, 2, 1);
        this.addCompItem(jPanel, new JLabel("Color Metric"), gridBagConstraints, 0, 2, 2, 1);
        gridBagConstraints.weightx = 0.5;
        this.addCompItem(jPanel, (Component)this.heightValueBox, gridBagConstraints, 0, 1, 1, 1);
        this.addCompItem(jPanel, (Component)this.heightMetricBox, gridBagConstraints, 1, 1, 1, 1);
        this.addCompItem(jPanel, (Component)this.colorValueBox, gridBagConstraints, 0, 3, 1, 1);
        this.addCompItem(jPanel, (Component)this.colorMetricBox, gridBagConstraints, 1, 3, 1, 1);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridBagLayout());
        this.heightValueField.setEditable(false);
        this.colorValueField.setEditable(false);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        this.addCompItem(jPanel4, new JLabel("Function"), gridBagConstraints, 0, 0, 1, 1);
        this.addCompItem(jPanel4, new JLabel("Thread"), gridBagConstraints, 0, 1, 1, 1);
        this.addCompItem(jPanel4, new JLabel("Height value"), gridBagConstraints, 0, 2, 1, 1);
        this.addCompItem(jPanel4, new JLabel("Color value"), gridBagConstraints, 0, 3, 1, 1);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.addCompItem(jPanel4, jPanel2, gridBagConstraints, 1, 0, 1, 1);
        this.addCompItem(jPanel4, jPanel3, gridBagConstraints, 1, 1, 1, 1);
        this.addCompItem(jPanel4, this.heightValueField, gridBagConstraints, 1, 2, 1, 1);
        this.addCompItem(jPanel4, this.colorValueField, gridBagConstraints, 1, 3, 1, 1);
        this.addCompItem(jPanel, jPanel4, gridBagConstraints, 0, 4, 2, 1);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        this.addCompItem(jPanel, this.tabbedPane, gridBagConstraints, 0, 5, 2, 1);
        return jPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            if (object instanceof JRadioButton) {
                this.selectedTab = this.tabbedPane.getSelectedIndex();
                this.selectedTab = 0;
                String string = actionEvent.getActionCommand();
                Plot plot = this.window.getPlot();
                if (this.settings.getVisType() == VisType.BAR_PLOT || this.settings.getVisType() == VisType.TRIANGLE_MESH_PLOT) {
                    this.settings.setSize((int)plot.getWidth(), (int)plot.getDepth(), (int)plot.getHeight());
                    this.settings.setRegularAim(this.visRenderer.getAim());
                    this.settings.setRegularEye(this.visRenderer.getEye());
                } else if (this.settings.getVisType() == VisType.SCATTER_PLOT) {
                    this.settings.setScatterAim(this.visRenderer.getAim());
                    this.settings.setScatterEye(this.visRenderer.getEye());
                }
                if (string.equals(VisType.BAR_PLOT.toString())) {
                    this.settings.setVisType(VisType.BAR_PLOT);
                } else if (string.equals(VisType.TRIANGLE_MESH_PLOT.toString())) {
                    this.settings.setVisType(VisType.TRIANGLE_MESH_PLOT);
                } else if (string.equals(VisType.SCATTER_PLOT.toString())) {
                    this.settings.setVisType(VisType.SCATTER_PLOT);
                } else if (string.equals(VisType.CALLGRAPH.toString())) {
                    this.settings.setVisType(VisType.CALLGRAPH);
                }
                this.window.resetSplitPane();
                this.createSubPanel();
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void dataChanged() {
        this.window.redraw();
        this.updateScalePanel();
        this.createSubPanel();
        this.heightValueField.setText(this.window.getSelectedHeightValue());
        this.colorValueField.setText(this.window.getSelectedColorValue());
    }

    private void addCompItem(JPanel jPanel, Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        jPanel.add(component, gridBagConstraints);
    }

    public class SliderComboBox
    extends JComboBox {
        public SliderComboBox() {
            this.setUI(new SliderComboUI());
        }

        public SliderComboBox(Object[] objectArray) {
            super(objectArray);
            this.setUI(new SliderComboUI());
        }

        public class SliderComboUI
        extends MetalComboBoxUI {
            protected ComboPopup createPopup() {
                BasicComboPopup basicComboPopup = new BasicComboPopup(this, this.comboBox){
                    private final /* synthetic */ SliderComboUI this$2;
                    {
                        this.this$2 = sliderComboUI;
                    }

                    protected JScrollPane createScroller() {
                        return new JScrollPane(this.list, 20, 30);
                    }
                };
                return basicComboPopup;
            }
        }
    }
}

