/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof.barchart;

import edu.uoregon.tau.paraprof.DataSorter;
import edu.uoregon.tau.paraprof.FunctionBarChartWindow;
import edu.uoregon.tau.paraprof.PPFunctionProfile;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.barchart.AbstractBarChartModel;
import edu.uoregon.tau.paraprof.enums.ValueType;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.UtilFncs;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;

public class FunctionBarChartModel
extends AbstractBarChartModel {
    private List list;
    private FunctionBarChartWindow window;
    private DataSorter dataSorter;
    private Function function;
    private ParaProfTrial ppTrial;

    public FunctionBarChartModel(FunctionBarChartWindow functionBarChartWindow, DataSorter dataSorter, Function function) {
        this.window = functionBarChartWindow;
        this.dataSorter = dataSorter;
        this.function = function;
        this.reloadData();
        this.ppTrial = functionBarChartWindow.getPpTrial();
    }

    public int getNumRows() {
        return this.list.size();
    }

    public String getRowLabel(int n) {
        PPFunctionProfile pPFunctionProfile = (PPFunctionProfile)this.list.get(n);
        String string = this.window.isPhaseDisplay() ? UtilFncs.getLeftSide((String)pPFunctionProfile.getDisplayName()) : (pPFunctionProfile.getNodeID() == -1 ? "mean" : (pPFunctionProfile.getNodeID() == -2 ? "total" : (pPFunctionProfile.getNodeID() == -3 ? "std. dev." : ParaProfUtils.getThreadLabel(pPFunctionProfile.getThread()))));
        return string;
    }

    public String getRowValueLabel(int n) {
        return null;
    }

    public double getValue(int n, int n2) {
        PPFunctionProfile pPFunctionProfile = (PPFunctionProfile)this.list.get(n);
        return pPFunctionProfile.getValue();
    }

    public String getValueLabel(int n, int n2) {
        PPFunctionProfile pPFunctionProfile = (PPFunctionProfile)this.list.get(n);
        double d = pPFunctionProfile.getValue();
        if (this.window.getDataSorter().getValueType() == ValueType.EXCLUSIVE_PERCENT || this.window.getDataSorter().getValueType() == ValueType.INCLUSIVE_PERCENT) {
            return UtilFncs.getOutputString((int)0, (double)d, (int)6, (boolean)pPFunctionProfile.getDataSorter().getSelectedMetric().isTimeDenominator()) + "%";
        }
        return UtilFncs.getOutputString((int)this.window.units(), (double)d, (int)ParaProf.defaultNumberPrecision, (boolean)pPFunctionProfile.getDataSorter().getSelectedMetric().isTimeDenominator());
    }

    public Color getValueColor(int n, int n2) {
        PPFunctionProfile pPFunctionProfile = (PPFunctionProfile)this.list.get(n);
        return pPFunctionProfile.getColor();
    }

    public Color getValueHighlightColor(int n, int n2) {
        PPFunctionProfile pPFunctionProfile = (PPFunctionProfile)this.list.get(n);
        Function function = pPFunctionProfile.getFunction();
        if (function == this.ppTrial.getHighlightedFunction()) {
            return this.ppTrial.getColorChooser().getHighlightColor();
        }
        if (function.isGroupMember(this.ppTrial.getHighlightedGroup())) {
            return this.ppTrial.getColorChooser().getGroupHighlightColor();
        }
        return Color.black;
    }

    public void reloadData() {
        this.list = this.window.isPhaseDisplay() ? this.dataSorter.getFunctionAcrossPhases(this.function, this.window.getThread()) : this.dataSorter.getFunctionData(this.function, true, true);
        this.fireModelChanged();
    }

    public String getValueToolTipText(int n, int n2) {
        return null;
    }

    public String getRowLabelToolTipText(int n) {
        return null;
    }

    public void fireRowLabelClick(int n, MouseEvent mouseEvent, JComponent jComponent) {
        PPFunctionProfile pPFunctionProfile = (PPFunctionProfile)this.list.get(n);
        if (this.window.isPhaseDisplay()) {
            if (ParaProfUtils.rightClick(mouseEvent)) {
                JPopupMenu jPopupMenu = ParaProfUtils.createFunctionClickPopUp(this.ppTrial, pPFunctionProfile.getFunction(), pPFunctionProfile.getThread(), jComponent);
                jPopupMenu.show(jComponent, mouseEvent.getX(), mouseEvent.getY());
            } else {
                this.ppTrial.toggleHighlightedFunction(pPFunctionProfile.getFunction());
            }
        } else if (ParaProfUtils.rightClick(mouseEvent)) {
            ParaProfUtils.handleThreadClick(this.window.getPpTrial(), this.function.getParentPhase(), pPFunctionProfile.getThread(), jComponent, mouseEvent);
        } else {
            FunctionBarChartWindow functionBarChartWindow = new FunctionBarChartWindow(this.window.getPpTrial(), pPFunctionProfile.getThread(), this.function.getParentPhase(), jComponent);
            functionBarChartWindow.setVisible(true);
        }
    }

    public void fireValueClick(int n, int n2, MouseEvent mouseEvent, JComponent jComponent) {
        PPFunctionProfile pPFunctionProfile = (PPFunctionProfile)this.list.get(n);
        Function function = pPFunctionProfile.getFunction();
        if (ParaProfUtils.rightClick(mouseEvent)) {
            JPopupMenu jPopupMenu = ParaProfUtils.createFunctionClickPopUp(this.window.getPpTrial(), function, pPFunctionProfile.getThread(), jComponent);
            jPopupMenu.show(jComponent, mouseEvent.getX(), mouseEvent.getY());
        } else {
            this.window.getPpTrial().toggleHighlightedFunction(function);
        }
    }

    public String getOtherToolTopText(int n) {
        return null;
    }

    public DataSorter getDataSorter() {
        return this.dataSorter;
    }
}

