/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof.barchart;

import edu.uoregon.tau.paraprof.DataSorter;
import edu.uoregon.tau.paraprof.FunctionBarChartWindow;
import edu.uoregon.tau.paraprof.PPUserEventProfile;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.UserEventWindow;
import edu.uoregon.tau.paraprof.barchart.AbstractBarChartModel;
import edu.uoregon.tau.perfdmf.UserEvent;
import edu.uoregon.tau.perfdmf.UtilFncs;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JComponent;

public class UserEventBarChartModel
extends AbstractBarChartModel {
    private UserEventWindow window;
    private DataSorter dataSorter;
    private UserEvent userEvent;
    private List list;

    public UserEventBarChartModel(UserEventWindow userEventWindow, DataSorter dataSorter, UserEvent userEvent) {
        this.window = userEventWindow;
        this.dataSorter = dataSorter;
        this.userEvent = userEvent;
        this.reloadData();
    }

    public int getNumRows() {
        return this.list.size();
    }

    public String getRowLabel(int n) {
        PPUserEventProfile pPUserEventProfile = (PPUserEventProfile)this.list.get(n);
        return ParaProfUtils.getThreadLabel(pPUserEventProfile.getThread());
    }

    public String getValueLabel(int n, int n2) {
        PPUserEventProfile pPUserEventProfile = (PPUserEventProfile)this.list.get(n);
        double d = this.window.getValueType().getValue(pPUserEventProfile.getUserEventProfile(), this.dataSorter.getSelectedSnapshot());
        return UtilFncs.getOutputString((int)0, (double)d, (int)ParaProf.defaultNumberPrecision, (boolean)false);
    }

    public double getValue(int n, int n2) {
        PPUserEventProfile pPUserEventProfile = (PPUserEventProfile)this.list.get(n);
        return this.window.getValueType().getValue(pPUserEventProfile.getUserEventProfile(), this.dataSorter.getSelectedSnapshot());
    }

    public Color getValueColor(int n, int n2) {
        PPUserEventProfile pPUserEventProfile = (PPUserEventProfile)this.list.get(n);
        return pPUserEventProfile.getColor();
    }

    public Color getValueHighlightColor(int n, int n2) {
        if (this.userEvent == this.window.getPpTrial().getHighlightedUserEvent()) {
            return this.window.getPpTrial().getColorChooser().getUserEventHighlightColor();
        }
        return null;
    }

    public void fireValueClick(int n, int n2, MouseEvent mouseEvent, JComponent jComponent) {
    }

    public void fireRowLabelClick(int n, MouseEvent mouseEvent, JComponent jComponent) {
        PPUserEventProfile pPUserEventProfile = (PPUserEventProfile)this.list.get(n);
        pPUserEventProfile.getThread();
        if (ParaProfUtils.rightClick(mouseEvent)) {
            ParaProfUtils.handleThreadClick(this.window.getPpTrial(), null, pPUserEventProfile.getThread(), jComponent, mouseEvent);
        } else {
            FunctionBarChartWindow functionBarChartWindow = new FunctionBarChartWindow(this.window.getPpTrial(), pPUserEventProfile.getThread(), null, jComponent);
            functionBarChartWindow.setVisible(true);
        }
    }

    public String getValueToolTipText(int n, int n2) {
        return null;
    }

    public String getRowLabelToolTipText(int n) {
        return null;
    }

    public String getOtherToolTopText(int n) {
        return null;
    }

    public void reloadData() {
        this.list = this.dataSorter.getUserEventData(this.userEvent);
        this.fireModelChanged();
    }

    public DataSorter getDataSorter() {
        return this.dataSorter;
    }
}

