/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.vis;

import edu.uoregon.tau.vis.HeatMap;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JLabel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;

class HeatMapScanner
extends MouseInputAdapter
implements KeyListener,
MouseWheelListener {
    private HeatMap heatmap;
    private JWindow toolTip;
    private JLabel label;
    private int maxSize = 0;
    private int viewportSize = 512;
    private int zoomMax = 0;

    public HeatMapScanner(HeatMap heatMap, int n) {
        this.heatmap = heatMap;
        this.initToolTip();
        this.maxSize = n;
        this.zoomMax = this.viewportSize * this.maxSize;
    }

    private void initToolTip() {
        this.label = new JLabel(" ");
        this.label.setOpaque(true);
        this.label.setBackground(UIManager.getColor("ToolTip.background"));
        this.toolTip = new JWindow(new Frame());
        this.toolTip.getContentPane().add(this.label);
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        String string = this.heatmap.getToolTip(point);
        this.label.setText(string);
        this.toolTip.pack();
        this.toolTip.setVisible(true);
        SwingUtilities.convertPointToScreen(point, this.heatmap);
        this.toolTip.setLocation(point.x + 5, point.y - this.toolTip.getHeight() - 5);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.toolTip.setVisible(false);
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        int n = mouseWheelEvent.getWheelRotation();
        if (n < 0) {
            this.zoomIn();
        } else {
            this.zoomOut();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        try {
            char c = keyEvent.getKeyChar();
            if (c == '+' || c == '=') {
                this.zoomIn();
            } else if (c == '-' || c == '_') {
                this.zoomOut();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int zoomOut() {
        int n;
        int n2 = n = this.heatmap.getPreferredSize().height;
        n2 = n <= this.viewportSize ? Math.min(n / 2, this.heatmap.getMapSize()) : (n > 576 ? Math.max(n / 2, this.viewportSize) : this.viewportSize);
        if (n2 != n && n2 >= this.viewportSize) {
            this.heatmap.setPreferredSize(new Dimension(n2, n2));
            this.heatmap.setSize(n2, n2);
        }
        return n2;
    }

    private int zoomIn() {
        int n;
        int n2 = n = this.heatmap.getPreferredSize().height;
        n2 = n <= this.viewportSize ? Math.max(n * 2, this.viewportSize) : (n >= 576 ? (n2 *= 2) : this.viewportSize);
        if (n2 != n && n2 <= this.zoomMax && n2 > 0) {
            this.heatmap.setPreferredSize(new Dimension(n2, n2));
            this.heatmap.setSize(n2, n2);
        }
        return n2;
    }
}

