/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.vis;

import edu.uoregon.tau.vis.Axes;
import edu.uoregon.tau.vis.ColorScale;
import edu.uoregon.tau.vis.Plot;
import edu.uoregon.tau.vis.Vec;
import edu.uoregon.tau.vis.VisRenderer;
import edu.uoregon.tau.vis.VisTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TriangleMeshPlot
implements Plot {
    private Vec[][] normals;
    private float[][] heightValues;
    private float[][] colorValues;
    private int nrows;
    private int ncols;
    private float xSize;
    private float ySize;
    private float zSize;
    private boolean dirty = true;
    private List<Integer> displayLists;
    private ColorScale colorScale;
    private Axes axes;
    private GL gl;
    private int selectedRow = -1;
    private int selectedCol = -1;
    private boolean translucent = false;
    private float translucency = 0.5f;

    public void initialize(Axes axes, float f, float f2, float f3, float[][] fArray, float[][] fArray2, ColorScale colorScale) {
        this.nrows = fArray.length;
        this.ncols = fArray[0].length;
        this.heightValues = fArray;
        this.colorValues = fArray2;
        this.setColorScale(colorScale);
        this.xSize = f;
        this.ySize = f2;
        this.zSize = f3;
        this.axes = axes;
        axes.setSize(f, f2, f3);
        this.processValues();
        this.generateNormals();
    }

    public void setValues(float f, float f2, float f3, float[][] fArray, float[][] fArray2) {
        this.nrows = fArray.length;
        this.ncols = fArray.length > 0 ? fArray[0].length : 0;
        this.heightValues = fArray;
        this.colorValues = fArray2;
        this.xSize = f;
        this.ySize = f2;
        this.zSize = f3;
        this.axes.setSize(f, f2, f3);
        this.processValues();
        this.generateNormals();
        this.dirty = true;
    }

    public String getName() {
        return "Mesh Plot";
    }

    public float getWidth() {
        return this.xSize;
    }

    public float getDepth() {
        return this.ySize;
    }

    public float getHeight() {
        return this.zSize;
    }

    private void processValues() {
        float f;
        float f2;
        int n;
        int n2;
        float f3 = Float.MIN_VALUE;
        float f4 = Float.MIN_VALUE;
        for (n2 = 0; n2 < this.nrows; ++n2) {
            for (n = 0; n < this.ncols; ++n) {
                f2 = this.heightValues[n2][n];
                f = this.colorValues[n2][n];
                f3 = Math.max(f3, f2);
                f4 = Math.max(f4, f);
            }
        }
        for (n2 = 0; n2 < this.nrows; ++n2) {
            for (n = 0; n < this.ncols; ++n) {
                f2 = this.heightValues[n2][n];
                f = this.colorValues[n2][n];
                this.heightValues[n2][n] = f2 / f3 * this.zSize;
                this.colorValues[n2][n] = f / f4;
            }
        }
    }

    private void generateNormals() {
        this.normals = new Vec[this.nrows][this.ncols];
        for (int i = 0; i < this.nrows; ++i) {
            for (int j = 0; j < this.ncols; ++j) {
                float f;
                float f2 = f = this.heightValues[i][j];
                float f3 = f;
                float f4 = f;
                if (j > 0) {
                    f4 = this.heightValues[i][j - 1];
                }
                if (i > 0) {
                    f = this.heightValues[i - 1][j];
                }
                if (j < this.ncols - 1) {
                    f3 = this.heightValues[i][j + 1];
                }
                if (i < this.nrows - 1) {
                    f2 = this.heightValues[i + 1][j];
                }
                float f5 = (f4 - f3) / 2.0f;
                float f6 = (f - f2) / 2.0f;
                Vec vec = new Vec(-f5, -f6, 1.0f);
                vec.normalize();
                this.normals[i][j] = vec;
            }
        }
    }

    public void setSize(float f, float f2, float f3) {
        this.xSize = f;
        this.ySize = f2;
        this.zSize = f3;
        this.axes.setSize(f, f2, f3);
        this.processValues();
        this.generateNormals();
        this.dirty = true;
    }

    public void cleanUp() {
        this.normals = null;
        this.heightValues = null;
        this.colorValues = null;
        if (this.displayLists != null) {
            for (int i = 0; i < this.displayLists.size(); ++i) {
                this.gl.glDeleteLists(this.displayLists.get(i).intValue(), 1);
            }
            this.displayLists = null;
        }
    }

    public void render(VisRenderer visRenderer) {
        GLAutoDrawable gLAutoDrawable = visRenderer.getGLAutoDrawable();
        GL gL = gLAutoDrawable.getGL();
        if (gL == null) {
            return;
        }
        this.gl = gL;
        if (this.translucent) {
            this.renderSelectionTranslucent(gL);
        }
        if (this.nrows == 1 || this.ncols == 1) {
            if (!this.axes.getOnEdge()) {
                this.axes.setOnEdge(true);
            }
            this.axes.render(visRenderer);
            this.renderLine(gL);
        } else {
            this.axes.render(visRenderer);
            this.renderDL(gL);
        }
        if (!this.translucent) {
            this.renderSelectionRegular(gL);
        }
    }

    private void renderLine(GL gL) {
        gL.glDisable(2896);
        gL.glEnable(2848);
        gL.glShadeModel(7425);
        if (this.nrows == 1) {
            float f = this.xSize / (float)(this.ncols - 1);
            gL.glBegin(3);
            for (int i = 0; i < this.nrows; ++i) {
                float f2 = this.colorValues[0][i];
                Color color = this.colorScale.getColor(f2);
                gL.glColor3f((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
                gL.glVertex3f((float)i * f, this.ySize / 2.0f, this.heightValues[0][i]);
            }
            gL.glEnd();
        } else {
            float f = this.ySize / (float)(this.nrows - 1);
            gL.glBegin(3);
            for (int i = 0; i < this.nrows; ++i) {
                float f3 = this.colorValues[i][0];
                Color color = this.colorScale.getColor(f3);
                gL.glColor3f((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
                gL.glVertex3f(this.xSize / 2.0f, (float)i * f, this.heightValues[i][0]);
            }
            gL.glEnd();
        }
    }

    private void renderDL(GL gL) {
        if (this.dirty || this.displayLists == null) {
            if (this.displayLists != null) {
                for (int i = 0; i < this.displayLists.size(); ++i) {
                    gL.glDeleteLists(this.displayLists.get(i).intValue(), 1);
                }
                this.displayLists = new ArrayList<Integer>();
            } else {
                this.displayLists = new ArrayList<Integer>();
            }
            Integer n = new Integer(gL.glGenLists(1));
            this.displayLists.add(n);
            gL.glNewList(n.intValue(), 4864);
            gL.glFrontFace(2304);
            gL.glEnable(2896);
            gL.glEnable(2884);
            gL.glDisable(2884);
            gL.glPushMatrix();
            gL.glShadeModel(7425);
            if (this.translucent) {
                gL.glBlendFunc(770, 771);
                gL.glEnable(3042);
            } else {
                gL.glBlendFunc(1, 0);
                gL.glDisable(3042);
            }
            float f = this.xSize / (float)(this.ncols - 1);
            float f2 = this.ySize / (float)(this.nrows - 1);
            int n2 = 0;
            for (int i = 0; i < this.nrows - 1; ++i) {
                gL.glBegin(5);
                for (int j = 0; j < this.ncols; ++j) {
                    float f3 = (float)j * f;
                    float f4 = (float)i * f2;
                    float f5 = this.heightValues[i][j];
                    float f6 = this.heightValues[i + 1][j];
                    float f7 = this.colorValues[i][j];
                    float f8 = this.colorValues[i + 1][j];
                    Vec vec = this.normals[i][j];
                    Vec vec2 = this.normals[i + 1][j];
                    Color color = this.colorScale.getColor(f7);
                    gL.glColor4f((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, this.translucency);
                    gL.glNormal3f(vec.x(), vec.y(), vec.z());
                    gL.glVertex3f(f3, f4, f5);
                    color = this.colorScale.getColor(f8);
                    gL.glColor4f((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, this.translucency);
                    gL.glNormal3f(vec2.x(), vec2.y(), vec2.z());
                    gL.glVertex3f(f3, f4 + f2, f6);
                    n2 += 2;
                }
                gL.glEnd();
                if (n2 <= 5000) continue;
                n2 = 0;
                gL.glEndList();
                n = new Integer(gL.glGenLists(1));
                this.displayLists.add(n);
                gL.glNewList(n.intValue(), 4864);
            }
            gL.glPopMatrix();
            gL.glShadeModel(7424);
            gL.glDisable(3042);
            gL.glDisable(2896);
            gL.glEndList();
            VisTools.vout(this, "Created " + this.displayLists.size() + " display lists");
            this.dirty = false;
        }
        for (int i = 0; i < this.displayLists.size(); ++i) {
            gL.glCallList(this.displayLists.get(i).intValue());
        }
    }

    private void renderSelectionTranslucent(GL gL) {
        Color color;
        float f;
        float f2;
        float f3;
        float f4;
        int n;
        int n2;
        if (this.selectedRow < 0 || this.selectedCol < 0) {
            return;
        }
        gL.glFrontFace(2304);
        gL.glDisable(2896);
        gL.glDisable(2884);
        gL.glShadeModel(7425);
        gL.glDisable(3042);
        float f5 = this.xSize / (float)(this.ncols - 1);
        float f6 = this.ySize / (float)(this.nrows - 1);
        gL.glBegin(5);
        for (n2 = 0; n2 < this.nrows; ++n2) {
            n = this.selectedCol;
            f4 = (float)n * f5;
            f3 = (float)n2 * f6;
            f2 = this.heightValues[n2][n];
            f = this.colorValues[n2][n];
            color = this.colorScale.getColor(f);
            gL.glColor3f((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
            gL.glVertex3f(f4, f3, f2);
            gL.glVertex3f(f4, f3, 0.0f);
        }
        gL.glEnd();
        gL.glBegin(5);
        for (n2 = 0; n2 < this.ncols; ++n2) {
            n = this.selectedRow;
            f4 = (float)n2 * f5;
            f3 = (float)n * f6;
            f2 = this.heightValues[n][n2];
            f = this.colorValues[n][n2];
            color = this.colorScale.getColor(f);
            gL.glColor3f((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
            gL.glVertex3f(f4, f3, f2);
            gL.glVertex3f(f4, f3, 0.0f);
        }
        gL.glEnd();
        gL.glDisable(2896);
        gL.glLineWidth(4.0f);
        gL.glColor3f(1.0f, 0.0f, 0.0f);
        gL.glBegin(3);
        for (n2 = 0; n2 < this.nrows; ++n2) {
            n = this.selectedCol;
            f4 = (float)n * f5;
            f3 = (float)n2 * f6;
            f2 = this.heightValues[n2][n];
            gL.glVertex3f(f4, f3, f2);
        }
        gL.glEnd();
        gL.glBegin(3);
        for (n2 = 0; n2 < this.ncols; ++n2) {
            n = this.selectedRow;
            f4 = (float)n2 * f5;
            f3 = (float)n * f6;
            f2 = this.heightValues[n][n2];
            gL.glVertex3f(f4, f3, f2);
        }
        gL.glEnd();
    }

    private void renderSelectionRegular(GL gL) {
        if (this.selectedRow < 0 || this.selectedCol < 0) {
            return;
        }
        if (this.selectedRow > this.heightValues.length - 1) {
            this.selectedRow = this.heightValues.length - 1;
        }
        if (this.selectedCol > this.heightValues[this.selectedRow].length - 1) {
            this.selectedCol = this.heightValues[this.selectedRow].length - 1;
        }
        float f = this.xSize / 2.0f;
        float f2 = this.ySize / 2.0f;
        if (this.ncols != 1) {
            f = this.xSize / (float)(this.ncols - 1);
        }
        if (this.nrows != 1) {
            f2 = this.ySize / (float)(this.nrows - 1);
        }
        gL.glDisable(2929);
        gL.glEnable(2848);
        gL.glBlendFunc(770, 771);
        gL.glHint(3154, 4354);
        gL.glEnable(3042);
        gL.glLineWidth(4.0f);
        float f3 = (float)this.selectedCol * f;
        float f4 = (float)this.selectedRow * f2;
        float f5 = this.heightValues[this.selectedRow][this.selectedCol];
        if (this.nrows == 1) {
            f4 += f2;
        }
        if (this.ncols == 1) {
            f3 += f;
        }
        gL.glBegin(1);
        gL.glColor4f(0.0f, 1.0f, 0.0f, 0.75f);
        gL.glVertex3f(f3, 0.0f, f5);
        gL.glVertex3f(f3, this.ySize, f5);
        gL.glColor4f(0.0f, 1.0f, 0.0f, 0.75f);
        gL.glVertex3f(0.0f, f4, f5);
        gL.glVertex3f(this.xSize, f4, f5);
        gL.glColor4f(1.0f, 1.0f, 0.0f, 0.75f);
        gL.glVertex3f(f3, f4, 0.0f);
        gL.glVertex3f(f3, f4, this.zSize);
        gL.glEnd();
        gL.glEnable(2929);
        gL.glLineWidth(1.0f);
    }

    public JPanel getControlPanel(final VisRenderer visRenderer) {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        final JSlider jSlider = new JSlider(0, 100, (int)(this.translucency * 100.0f));
        jSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                try {
                    TriangleMeshPlot.this.setTranslucencyRatio((float)jSlider.getValue() / 100.0f);
                    visRenderer.redraw();
                }
                catch (Exception exception) {
                    VisTools.handleException(exception);
                }
            }
        });
        final JSlider jSlider2 = new JSlider(5, 400, (int)this.xSize);
        final JSlider jSlider3 = new JSlider(5, 400, (int)this.ySize);
        final JSlider jSlider4 = new JSlider(2, 50, (int)this.zSize);
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                try {
                    TriangleMeshPlot.this.setSize(jSlider2.getValue(), jSlider3.getValue(), jSlider4.getValue());
                    visRenderer.redraw();
                }
                catch (Exception exception) {
                    VisTools.handleException(exception);
                }
            }
        };
        jSlider2.addChangeListener(changeListener);
        jSlider3.addChangeListener(changeListener);
        jSlider4.addChangeListener(changeListener);
        final JCheckBox jCheckBox = new JCheckBox("Transparency", this.translucent);
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    TriangleMeshPlot.this.setTranslucent(jCheckBox.isSelected());
                    visRenderer.redraw();
                }
                catch (Exception exception) {
                    VisTools.handleException(exception);
                }
            }
        });
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addCompItem(jPanel, new JLabel("Plot Width"), gridBagConstraints, 0, 0, 1, 1);
        this.addCompItem(jPanel, new JLabel("Plot Depth"), gridBagConstraints, 0, 1, 1, 1);
        this.addCompItem(jPanel, new JLabel("Plot Height"), gridBagConstraints, 0, 2, 1, 1);
        this.addCompItem(jPanel, jCheckBox, gridBagConstraints, 0, 3, 1, 1);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.addCompItem(jPanel, jSlider2, gridBagConstraints, 1, 0, 1, 1);
        this.addCompItem(jPanel, jSlider3, gridBagConstraints, 1, 1, 1, 1);
        this.addCompItem(jPanel, jSlider4, gridBagConstraints, 1, 2, 1, 1);
        this.addCompItem(jPanel, jSlider, gridBagConstraints, 1, 3, 1, 1);
        return jPanel;
    }

    private void addCompItem(JPanel jPanel, Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        jPanel.add(component, gridBagConstraints);
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof ColorScale) {
            this.dirty = true;
        }
    }

    public Axes getAxes() {
        return this.axes;
    }

    public void setAxes(Axes axes) {
        this.axes = axes;
    }

    public int getSelectedRow() {
        return this.selectedRow;
    }

    public void setSelectedRow(int n) {
        this.selectedRow = n;
        this.axes.setSelectedRow(n);
    }

    public int getSelectedCol() {
        return this.selectedCol;
    }

    public void setSelectedCol(int n) {
        this.selectedCol = n;
        this.axes.setSelectedCol(n);
    }

    public ColorScale getColorScale() {
        return this.colorScale;
    }

    public void setColorScale(ColorScale colorScale) {
        if (this.colorScale != null) {
            this.colorScale.deleteObserver(this);
        }
        this.colorScale = colorScale;
        if (colorScale != null) {
            colorScale.addObserver(this);
        }
    }

    public boolean getTranslucent() {
        return this.translucent;
    }

    public void setTranslucent(boolean bl) {
        this.translucent = bl;
        this.dirty = true;
    }

    public float getTranslucencyRatio() {
        return this.translucency;
    }

    public void setTranslucencyRatio(float f) {
        this.translucency = f;
        this.dirty = true;
    }

    public void resetCanvas() {
        this.dirty = true;
        this.displayLists.clear();
        this.displayLists = null;
        if (this.axes != null) {
            this.axes.resetCanvas();
        }
    }
}

