/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.paraprof.DataSorter;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.enums.SortType;
import edu.uoregon.tau.paraprof.enums.ValueType;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.Metric;
import java.util.HashMap;
import java.util.Map;

public class DataSorterWrapper
extends DataSorter {
    private DataSorter parentDataSorter;
    private Map<Metric, Metric> metricMap;
    private ParaProfTrial ppTrial;

    public DataSorterWrapper(DataSorter dataSorter, ParaProfTrial paraProfTrial) {
        super(paraProfTrial);
        this.parentDataSorter = dataSorter;
        this.ppTrial = paraProfTrial;
        ParaProfTrial paraProfTrial2 = dataSorter.getPpTrial();
        this.metricMap = new HashMap<Metric, Metric>();
        for (Metric metric : paraProfTrial2.getMetrics()) {
            for (Metric metric2 : paraProfTrial.getMetrics()) {
                if (metric.getName().compareTo(metric2.getName()) != 0) continue;
                this.metricMap.put(metric, metric2);
            }
        }
    }

    public boolean getDescendingOrder() {
        return this.parentDataSorter.getDescendingOrder();
    }

    public Function getPhase() {
        return this.parentDataSorter.getPhase();
    }

    public SortType getSortType() {
        return this.parentDataSorter.getSortType();
    }

    public ValueType getSortValueType() {
        return this.parentDataSorter.getSortValueType();
    }

    public boolean isDerivedMetric() {
        return this.parentDataSorter.isDerivedMetric();
    }

    public boolean isTimeMetric() {
        return this.parentDataSorter.isTimeMetric();
    }

    public ValueType getValueType() {
        return this.parentDataSorter.getValueType();
    }

    public Metric getSelectedMetric() {
        Metric metric = this.parentDataSorter.getSelectedMetric();
        Metric metric2 = this.metricMap.get(metric);
        if (metric2 == null) {
            return this.ppTrial.getMetrics().get(0);
        }
        return metric2;
    }

    public Metric getSortMetric() {
        Metric metric = this.parentDataSorter.getSortMetric();
        Metric metric2 = this.metricMap.get(metric);
        if (metric2 == null) {
            return this.ppTrial.getMetrics().get(0);
        }
        return metric2;
    }
}

