/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.perfdmf.Application;
import edu.uoregon.tau.perfdmf.DBDataSource;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.Database;
import edu.uoregon.tau.perfdmf.DatabaseAPI;
import edu.uoregon.tau.perfdmf.Experiment;
import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfdmf.UtilFncs;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.util.List;
import java.util.StringTokenizer;

public class ExternalController {
    public static void runController() {
        try {
            System.out.println("Control Mode Active!");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            String string = bufferedReader.readLine();
            while (string != null) {
                System.out.println("got input: " + string);
                if (string.startsWith("control ")) {
                    ExternalController.processCommand(string.substring(8));
                }
                string = bufferedReader.readLine();
            }
            ExternalController.exitController();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void exitController() {
        System.out.println("Control Mode Complete!");
        System.exit(0);
    }

    public static void processCommand(String string) throws Exception {
        System.out.println("processing command: " + string);
        if (string.equals("open manager")) {
            ParaProf.paraProfManagerWindow.setVisible(true);
        } else if (string.equals("list databases")) {
            ExternalController.listDatabases();
        } else if (string.startsWith("list applications")) {
            ExternalController.listApplications(string.substring("list applications".length() + 1));
        } else if (string.startsWith("list experiments")) {
            ExternalController.listExperiments(string.substring("list experiments".length() + 1));
        } else if (string.startsWith("list trials")) {
            ExternalController.listTrials(string.substring("list trials".length() + 1));
        } else if (string.startsWith("load")) {
            ExternalController.loadDBTrial(string.substring("load".length() + 1));
        } else if (string.startsWith("upload")) {
            ExternalController.uploadTauTrial(string.substring("upload".length() + 1));
        } else if (string.equals("exit")) {
            ExternalController.exitController();
        }
    }

    public static void loadDBTrial(String string) throws Exception {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        int n = Integer.parseInt(stringTokenizer.nextToken());
        int n2 = Integer.parseInt(stringTokenizer.nextToken());
        DatabaseAPI databaseAPI = new DatabaseAPI();
        databaseAPI.initialize((Database)Database.getDatabases().get(n));
        databaseAPI.setTrial(n2, false);
        DBDataSource dBDataSource = new DBDataSource(databaseAPI);
        dBDataSource.load();
        Trial trial = new Trial();
        trial.setDataSource((DataSource)dBDataSource);
        ParaProfTrial paraProfTrial = new ParaProfTrial(trial);
        paraProfTrial.finishLoad();
        paraProfTrial.showMainWindow();
    }

    public static void uploadTauTrial(String string) throws Exception {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        String string2 = stringTokenizer.nextToken();
        int n = Integer.parseInt(stringTokenizer.nextToken());
        String string3 = stringTokenizer.nextToken();
        String string4 = stringTokenizer.nextToken();
        String string5 = stringTokenizer.nextToken();
        File file = new File(string2);
        File[] fileArray = new File[]{file};
        int n2 = 1;
        if (!file.isDirectory()) {
            n2 = UtilFncs.identifyData((File)file);
        }
        DataSource dataSource = UtilFncs.initializeDataSource((File[])fileArray, (int)n2, (boolean)false);
        dataSource.load();
        Trial trial = new Trial();
        trial.setDataSource(dataSource);
        DatabaseAPI databaseAPI = new DatabaseAPI();
        databaseAPI.initialize((Database)Database.getDatabases().get(n));
        Experiment experiment = databaseAPI.getExperiment(string3, string4, true);
        trial.setName(string5);
        trial.setExperimentID(experiment.getID());
        int n3 = databaseAPI.uploadTrial(trial, false);
        ExternalController.outputCommand("return " + n3);
        ExternalController.outputCommand("endreturn");
    }

    public static void listApplications(String string) throws SQLException {
        int n = Integer.parseInt(string);
        List list = Database.getDatabases();
        DatabaseAPI databaseAPI = new DatabaseAPI();
        databaseAPI.initialize((Database)list.get(n));
        List list2 = databaseAPI.getApplicationList();
        for (Application application : list2) {
            ExternalController.outputCommand("return " + application.getID() + " " + application.getName());
        }
        ExternalController.outputCommand("endreturn");
    }

    public static void listExperiments(String string) throws SQLException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        int n = Integer.parseInt(stringTokenizer.nextToken());
        int n2 = Integer.parseInt(stringTokenizer.nextToken());
        DatabaseAPI databaseAPI = new DatabaseAPI();
        databaseAPI.initialize((Database)Database.getDatabases().get(n));
        databaseAPI.setApplication(n2);
        List list = databaseAPI.getExperimentList();
        for (Experiment experiment : list) {
            ExternalController.outputCommand("return " + experiment.getID() + " " + experiment.getName());
        }
        ExternalController.outputCommand("endreturn");
    }

    public static void listTrials(String string) throws SQLException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        int n = Integer.parseInt(stringTokenizer.nextToken());
        int n2 = Integer.parseInt(stringTokenizer.nextToken());
        DatabaseAPI databaseAPI = new DatabaseAPI();
        databaseAPI.initialize((Database)Database.getDatabases().get(n));
        databaseAPI.setExperiment(n2);
        List list = databaseAPI.getTrialList(false);
        for (Trial trial : list) {
            ExternalController.outputCommand("return " + trial.getID() + " " + trial.getName());
        }
        ExternalController.outputCommand("endreturn");
    }

    public static void listDatabases() {
        List list = Database.getDatabases();
        int n = 0;
        for (Database database : list) {
            ExternalController.outputCommand("return " + n + " " + database.getName());
            ++n;
        }
        ExternalController.outputCommand("endreturn");
    }

    public static void outputCommand(String string) {
        System.out.println("control " + string);
    }
}

