/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.common.StoppableThread;
import edu.uoregon.tau.common.Utility;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.ThreeDeeImageProvider;
import edu.uoregon.tau.paraprof.ThreeDeeScalePanel;
import edu.uoregon.tau.paraprof.WindowPlacer;
import edu.uoregon.tau.paraprof.interfaces.ParaProfWindow;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.UserEventProfile;
import edu.uoregon.tau.perfdmf.UtilFncs;
import edu.uoregon.tau.vis.Axes;
import edu.uoregon.tau.vis.BarPlot;
import edu.uoregon.tau.vis.ColorScale;
import edu.uoregon.tau.vis.HeatMapData;
import edu.uoregon.tau.vis.PlotFactory;
import edu.uoregon.tau.vis.Shape;
import edu.uoregon.tau.vis.SteppedComboBox;
import edu.uoregon.tau.vis.Vec;
import edu.uoregon.tau.vis.VisCanvas;
import edu.uoregon.tau.vis.VisCanvasListener;
import edu.uoregon.tau.vis.VisRenderer;
import edu.uoregon.tau.vis.VisTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreeDeeCommMatrixWindow
extends JFrame
implements ParaProfWindow,
Observer,
ActionListener,
ThreeDeeImageProvider,
VisCanvasListener,
Printable {
    private static final long serialVersionUID = -6148136561801423543L;
    private ParaProfTrial ppTrial;
    private SteppedComboBox pathSelector;
    private SteppedComboBox heightComboBox;
    private SteppedComboBox colorComboBox;
    private JSplitPane splitPane;
    private HeatMapData mapData;
    private static final String allPaths = "All Paths";
    private static final int CALLS = 0;
    private static final int MAX = 1;
    private static final int MIN = 2;
    private static final int MEAN = 3;
    private static final int STDDEV = 4;
    private static final int VOLUME = 5;
    private static final String[] metricStrings = new String[]{"Number of calls", "Max message size (bytes)", "Min message size (bytes)", "Mean message size (bytes)", "Std. dev. message size (bytes)", "Message volume (bytes)"};
    private String currentPath = "All Paths";
    private int heightMetric = 5;
    private int colorMetric = 1;
    private List<String> threadNames;
    private BarPlot barPlot;
    private Axes axes;
    private VisRenderer visRenderer;
    private VisCanvas visCanvas;
    private ColorScale colorScale;
    private float[][] oldHeightValues;
    private float[][] oldColorValues;
    private float[][] curHeightValues;
    private float[][] curColorValues;
    private float[][] newHeightValues;
    private float[][] newColorValues;
    private StoppableThread animator;
    private int[] selections = new int[2];
    private JTextField heightValueField = new JTextField("");
    private JTextField colorValueField = new JTextField("");
    private ThreeDeeScalePanel scalePanel;

    public ThreeDeeCommMatrixWindow(String string, HeatMapData heatMapData, ParaProfTrial paraProfTrial, Component component) {
        this.ppTrial = paraProfTrial;
        this.mapData = heatMapData;
        this.selections[0] = -1;
        this.buildPanels();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ThreeDeeCommMatrixWindow.this.closeThisWindow();
            }
        });
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = ParaProfUtils.createFileMenu(this, this, this);
        jMenu.getPopupMenu().setLightWeightPopupEnabled(false);
        jMenuBar.add(jMenu);
        JMenu jMenu2 = ParaProfUtils.createWindowsMenu(paraProfTrial, this);
        jMenu2.getPopupMenu().setLightWeightPopupEnabled(false);
        jMenuBar.add(jMenu2);
        JMenu jMenu3 = ParaProfUtils.createHelpMenu(this, this);
        jMenu3.getPopupMenu().setLightWeightPopupEnabled(false);
        jMenuBar.add(jMenu3);
        this.setJMenuBar(jMenuBar);
        if (ParaProf.getHelpWindow().isVisible()) {
            this.help(false);
        }
        ParaProf.incrementNumWindows();
        this.setSize(ParaProfUtils.checkSize(new Dimension(1000, 750)));
        this.setSize(new Dimension(1000, 750));
        this.setLocation(WindowPlacer.getNewLocation(this, component));
        ParaProfUtils.setFrameIcon(this);
        this.setTitle("TAU: ParaProf: 3D Communication Matrix: " + paraProfTrial.getTrialIdentifier(ParaProf.preferences.getShowPathTitleInReverse()));
        paraProfTrial.addObserver(this);
    }

    public static ThreeDeeCommMatrixWindow createCommunicationMatrixWindow(ParaProfTrial paraProfTrial, JFrame jFrame) {
        HeatMapData heatMapData = ThreeDeeCommMatrixWindow.generateData(paraProfTrial.getDataSource(), jFrame, paraProfTrial.getSelectedSnapshot());
        if (heatMapData == null) {
            return null;
        }
        ThreeDeeCommMatrixWindow threeDeeCommMatrixWindow = new ThreeDeeCommMatrixWindow("3D Communication Matrix", heatMapData, paraProfTrial, jFrame);
        return threeDeeCommMatrixWindow;
    }

    public double getSelectedHeightValue() {
        if (this.selections[1] < 0 || this.selections[0] < 0) {
            return 0.0;
        }
        int n = this.selections[0];
        int n2 = this.selections[1];
        double d = this.mapData.get(n2, n, this.currentPath, this.heightMetric);
        return d;
    }

    public double getSelectedColorValue() {
        if (this.selections[1] < 0 || this.selections[0] < 0) {
            return 0.0;
        }
        int n = this.selections[0];
        int n2 = this.selections[1];
        double d = this.mapData.get(n2, n, this.currentPath, this.colorMetric);
        return d;
    }

    public String getSelectedHeightValueString() {
        if (this.selections[1] < 0 || this.selections[0] < 0) {
            return "";
        }
        int n = this.selections[0];
        int n2 = this.selections[1];
        double d = this.mapData.get(n2, n, this.currentPath, this.heightMetric);
        int n3 = 0;
        String string = UtilFncs.getOutputString((int)n3, (double)d, (int)6, (boolean)false);
        return string;
    }

    public String getSelectedColorValueString() {
        if (this.selections[1] < 0 || this.selections[0] < 0) {
            return "";
        }
        int n = this.selections[0];
        int n2 = this.selections[1];
        double d = this.mapData.get(n2, n, this.currentPath, this.colorMetric);
        int n3 = 0;
        String string = UtilFncs.getOutputString((int)n3, (double)d, (int)6, (boolean)false);
        return string;
    }

    private JPanel createSelectorPanel(int n, int n2, final List<String> list, final int n3) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.selections[n3] = Math.min(this.selections[n3], n2);
        this.selections[n3] = Math.max(this.selections[n3], n);
        final JScrollBar jScrollBar = new JScrollBar(0, this.selections[n3], 1, n, n2);
        jScrollBar.setBlockIncrement((n2 - n) / 10);
        final JTextField jTextField = new JTextField("<none>");
        jTextField.setHorizontalAlignment(0);
        if (this.selections[n3] >= 0 && list != null) {
            jTextField.setText(list.get(this.selections[n3]));
        }
        jTextField.setEditable(false);
        jTextField.setCaretPosition(0);
        jScrollBar.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                int n;
                ((ThreeDeeCommMatrixWindow)ThreeDeeCommMatrixWindow.this).selections[n3] = n = jScrollBar.getValue();
                if (n >= 0 && list != null) {
                    jTextField.setText((String)list.get(n));
                } else {
                    jTextField.setText("<none>");
                }
                jTextField.setCaretPosition(0);
                ThreeDeeCommMatrixWindow.this.scalePanel.setPosition(0, ThreeDeeCommMatrixWindow.this.getSelectedHeightRatio());
                ThreeDeeCommMatrixWindow.this.scalePanel.setPosition(1, ThreeDeeCommMatrixWindow.this.getSelectedColorRatio());
                ThreeDeeCommMatrixWindow.this.redraw();
            }
        });
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        Utility.addCompItem((Container)jPanel, (Component)jTextField, (GridBagConstraints)gridBagConstraints, (int)1, (int)0, (int)1, (int)1);
        Utility.addCompItem((Container)jPanel, (Component)jScrollBar, (GridBagConstraints)gridBagConstraints, (int)1, (int)1, (int)1, (int)1);
        return jPanel;
    }

    private void setSelections() {
        this.heightValueField.setText(this.getSelectedHeightValueString());
        this.colorValueField.setText(this.getSelectedColorValueString());
        this.barPlot.setSelectedCol(this.selections[1]);
        this.barPlot.setSelectedRow(this.selections[0]);
    }

    public void redraw() {
        this.setSelections();
        this.visRenderer.redraw();
    }

    private String getScaleString(double d) {
        return UtilFncs.getOutputString((int)0, (double)d, (int)6, (boolean)false).trim();
    }

    float getSelectedHeightRatio() {
        float f = (float)this.mapData.getMax(this.currentPath, this.heightMetric);
        float f2 = (float)this.getSelectedHeightValue() / f;
        return f2;
    }

    float getSelectedColorRatio() {
        float f = (float)this.mapData.getMax(this.currentPath, this.colorMetric);
        float f2 = (float)this.getSelectedColorValue() / f;
        return f2;
    }

    private void updateScalePanel() {
        String[] stringArray = new String[2];
        String[] stringArray2 = new String[2];
        float f = (float)this.mapData.getMax(this.currentPath, this.colorMetric);
        float f2 = (float)this.mapData.getMax(this.currentPath, this.heightMetric);
        stringArray[0] = "0";
        stringArray[1] = "0";
        stringArray2[0] = this.getScaleString(f2);
        stringArray2[1] = this.getScaleString(f);
        String[] stringArray3 = new String[]{"height", "color"};
        String string = "bytes";
        String string2 = "bytes";
        if (this.heightMetric == 0) {
            string = "calls";
        }
        if (this.colorMetric == 0) {
            string2 = "calls";
        }
        String[] stringArray4 = new String[]{string, string2};
        this.scalePanel.setRanges(stringArray, stringArray2, stringArray3, stringArray4);
        this.scalePanel.setPosition(0, this.getSelectedHeightRatio());
        this.scalePanel.setPosition(1, this.getSelectedColorRatio());
    }

    private JPanel createScalePanel() {
        if (this.scalePanel == null) {
            this.scalePanel = ThreeDeeScalePanel.CreateScalePanel();
            this.updateScalePanel();
        }
        return this.scalePanel.getJPanel();
    }

    private void buildPanels() {
        JPanel jPanel = this.buildGraphicsPanel();
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.setTabLayoutPolicy(1);
        jTabbedPane.addTab("Scales", this.createScalePanel());
        jTabbedPane.addTab("Plot", this.barPlot.getControlPanel(this.visRenderer));
        jTabbedPane.addTab("Axes", this.barPlot.getAxes().getControlPanel(this.visRenderer));
        jTabbedPane.addTab("ColorScale", this.colorScale.getControlPanel(this.visRenderer));
        jTabbedPane.addTab("Render", this.visRenderer.getControlPanel());
        jTabbedPane.setMinimumSize(new Dimension(300, 260));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        jPanel2.add(this.buildOptionPanel("Display Options"), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weighty = 0.0;
        jPanel2.add((Component)jTabbedPane, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.anchor = 10;
        gridBagConstraints2.weightx = 0.99;
        gridBagConstraints2.weighty = 0.99;
        gridBagConstraints2.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        this.splitPane = new JSplitPane(1, jPanel, jPanel2);
        this.splitPane.setResizeWeight(1.0);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setContinuousLayout(true);
        this.getContentPane().add(this.splitPane);
    }

    @Override
    public void closeThisWindow() {
        this.setVisible(false);
        if (this.barPlot != null) {
            this.barPlot.cleanUp();
        }
        if (this.visRenderer != null) {
            this.visRenderer.cleanUp();
        }
        this.visRenderer = null;
        this.dispose();
        ParaProf.decrementNumWindows();
    }

    @Override
    public void help(boolean bl) {
        ParaProf.getHelpWindow().clearText();
        if (bl) {
            ParaProf.getHelpWindow().setVisible(true);
        }
        ParaProf.getHelpWindow().writeText("3D Communication Matrix Window");
        ParaProf.getHelpWindow().writeText("");
        ParaProf.getHelpWindow().writeText("This window shows communication data between nodes.");
    }

    private static HeatMapData generateData(DataSource dataSource, int n) {
        return ThreeDeeCommMatrixWindow.generateData(dataSource, null, n);
    }

    private static HeatMapData generateData(DataSource dataSource, JFrame jFrame, int n) {
        boolean bl = false;
        int n2 = 0;
        int n3 = dataSource.getNodeMap().size();
        HeatMapData heatMapData = new HeatMapData(n3);
        for (edu.uoregon.tau.perfdmf.Thread thread : dataSource.getAllThreads()) {
            if (thread.getThreadID() != 0 || thread.getContextID() != 0) continue;
            Iterator iterator = thread.getUserEventProfiles();
            while (iterator.hasNext()) {
                UserEventProfile userEventProfile = (UserEventProfile)iterator.next();
                if (userEventProfile == null || !(userEventProfile.getNumSamples() > 0.0)) continue;
                String string = userEventProfile.getName();
                if (string.startsWith("Message size sent to node ") && string.indexOf("=>") == -1) {
                    bl = true;
                    ThreeDeeCommMatrixWindow.extractData(heatMapData, userEventProfile, n, n2, string, string, allPaths);
                    continue;
                }
                if (!string.startsWith("Message size sent to node ") || string.indexOf("=>") < 0) continue;
                bl = true;
                StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
                String string2 = stringTokenizer.nextToken().trim();
                String string3 = stringTokenizer.nextToken().trim();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string3, "=>");
                String string4 = null;
                while (stringTokenizer2.hasMoreTokens()) {
                    string4 = stringTokenizer2.nextToken().trim();
                    ThreeDeeCommMatrixWindow.extractData(heatMapData, userEventProfile, n, n2, string, string2, string4);
                }
            }
            ++n2;
        }
        if (!bl) {
            JOptionPane.showMessageDialog(jFrame, "This trial does not have communication matrix data.\nTo collect communication matrix data, set the environment variable TAU_COMM_MATRIX=1 before executing your application.", "No Communication Matrix Data", 0);
            return null;
        }
        heatMapData.massageData();
        return heatMapData;
    }

    private static void extractData(HeatMapData heatMapData, UserEventProfile userEventProfile, int n, int n2, String string, String string2, String string3) {
        double d = 0.0;
        double[] dArray = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "Message size sent to node ");
        if (stringTokenizer.hasMoreTokens()) {
            int n3 = Integer.parseInt(stringTokenizer.nextToken());
            double[] dArray2 = heatMapData.get(n2, n3, string3);
            if (dArray2 == null) {
                dArray2 = dArray;
            }
            double d2 = userEventProfile.getNumSamples(n);
            dArray2[0] = dArray2[0] + d2;
            double d3 = userEventProfile.getMaxValue(n);
            dArray2[1] = Math.max(d3, dArray2[1]);
            double d4 = userEventProfile.getMinValue(n);
            dArray2[2] = dArray2[2] > 0.0 ? Math.min(dArray2[2], d4) : d4;
            double d5 = userEventProfile.getMeanValue(n);
            dArray2[3] = dArray2[3] + d5;
            double d6 = userEventProfile.getStdDev(n);
            dArray2[4] = dArray2[4] + d6;
            d = d2 * d5;
            dArray2[5] = dArray2[5] + d;
            heatMapData.put(n2, n3, string3, dArray2);
        }
    }

    private void copyMatrix(float[][] fArray, float[][] fArray2, int n) {
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                fArray[i][j] = fArray2[i][j];
            }
        }
    }

    private void zeroMatrix(float[][] fArray, int n) {
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                fArray[i][j] = 0.0f;
            }
        }
    }

    private Component buildOptionPanel(String string) {
        this.pathSelector = new SteppedComboBox(this.mapData.getPaths().toArray());
        this.heightComboBox = new SteppedComboBox((Object[])metricStrings);
        this.heightComboBox.setSelectedIndex(this.heightMetric);
        this.colorComboBox = new SteppedComboBox((Object[])metricStrings);
        this.colorComboBox.setSelectedIndex(this.colorMetric);
        this.colorComboBox.setWidth(50);
        this.pathSelector.setWidth(50);
        this.heightComboBox.setWidth(50);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.01;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 5;
        JLabel jLabel = new JLabel(string, 0);
        jLabel.setFont(new Font("PE", jLabel.getFont().getStyle(), jLabel.getFont().getSize() * 2));
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.pathSelector.setSelectedItem((Object)this.currentPath);
        this.pathSelector.addActionListener((ActionListener)this);
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)new JLabel("Callpath:"), gridBagConstraints);
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)this.pathSelector, gridBagConstraints);
        this.heightComboBox.setSelectedItem((Object)this.currentPath);
        this.heightComboBox.addActionListener((ActionListener)this);
        gridBagConstraints.gridy = 3;
        jPanel.add((Component)new JLabel("Height Value:"), gridBagConstraints);
        gridBagConstraints.gridy = 4;
        jPanel.add((Component)this.heightComboBox, gridBagConstraints);
        this.colorComboBox.setSelectedItem((Object)this.currentPath);
        this.colorComboBox.addActionListener((ActionListener)this);
        gridBagConstraints.gridy = 5;
        jPanel.add((Component)new JLabel("Color Value:"), gridBagConstraints);
        gridBagConstraints.gridy = 6;
        jPanel.add((Component)this.colorComboBox, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        this.heightValueField.setEditable(false);
        this.colorValueField.setEditable(false);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        VisTools.addCompItem((Container)jPanel2, (Component)new JLabel("Sender"), (GridBagConstraints)gridBagConstraints, (int)0, (int)0, (int)1, (int)1);
        VisTools.addCompItem((Container)jPanel2, (Component)new JLabel("Receiver"), (GridBagConstraints)gridBagConstraints, (int)0, (int)1, (int)1, (int)1);
        VisTools.addCompItem((Container)jPanel2, (Component)new JLabel("Height value"), (GridBagConstraints)gridBagConstraints, (int)0, (int)2, (int)1, (int)1);
        VisTools.addCompItem((Container)jPanel2, (Component)new JLabel("Color value"), (GridBagConstraints)gridBagConstraints, (int)0, (int)3, (int)1, (int)1);
        JPanel jPanel3 = this.createSelectorPanel(-1, this.threadNames.size(), this.threadNames, 0);
        JPanel jPanel4 = this.createSelectorPanel(0, this.threadNames.size(), this.threadNames, 1);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        VisTools.addCompItem((Container)jPanel2, (Component)jPanel3, (GridBagConstraints)gridBagConstraints, (int)1, (int)0, (int)1, (int)1);
        VisTools.addCompItem((Container)jPanel2, (Component)jPanel4, (GridBagConstraints)gridBagConstraints, (int)1, (int)1, (int)1, (int)1);
        VisTools.addCompItem((Container)jPanel2, (Component)this.heightValueField, (GridBagConstraints)gridBagConstraints, (int)1, (int)2, (int)1, (int)1);
        VisTools.addCompItem((Container)jPanel2, (Component)this.colorValueField, (GridBagConstraints)gridBagConstraints, (int)1, (int)3, (int)1, (int)1);
        VisTools.addCompItem((Container)jPanel, (Component)jPanel2, (GridBagConstraints)gridBagConstraints, (int)0, (int)7, (int)1, (int)1);
        return jPanel;
    }

    private void processData() {
        int n;
        int n2;
        if (this.animator != null) {
            this.animator.requestStop();
            try {
                this.animator.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        float f = (float)this.mapData.getMin(this.currentPath, this.colorMetric);
        float f2 = (float)this.mapData.getMax(this.currentPath, this.colorMetric);
        float f3 = (float)this.mapData.getMax(this.currentPath, this.heightMetric);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("0");
        arrayList.add(PlotFactory.getSaneDoubleString((double)((double)f3 * 0.25)));
        arrayList.add(PlotFactory.getSaneDoubleString((double)((double)f3 * 0.5)));
        arrayList.add(PlotFactory.getSaneDoubleString((double)((double)f3 * 0.75)));
        arrayList.add(PlotFactory.getSaneDoubleString((double)f3));
        this.axes.setStrings("receiver", "sender", metricStrings[this.heightMetric], this.threadNames, this.threadNames, arrayList);
        this.axes.setOnEdge(true);
        UtilFncs.formatDouble((double)f, (int)6, (boolean)true);
        this.colorScale.setStrings(UtilFncs.formatDouble((double)f, (int)6, (boolean)true).trim(), UtilFncs.formatDouble((double)f2, (int)6, (boolean)true).trim(), metricStrings[this.colorMetric]);
        int n3 = this.mapData.getSize();
        this.zeroMatrix(this.newHeightValues, n3);
        this.zeroMatrix(this.newColorValues, n3);
        this.mapData.reset();
        while (this.mapData.hasNext()) {
            HeatMapData.NextValue nextValue = this.mapData.next();
            n2 = nextValue.receiver;
            n = nextValue.sender;
            this.newHeightValues[n2][n] = (float)nextValue.getValue(this.currentPath, this.heightMetric) / f3;
            this.newColorValues[n2][n] = (float)nextValue.getValue(this.currentPath, this.colorMetric) - f;
        }
        boolean bl = false;
        if (!bl) {
            this.barPlot.setValues(this.newHeightValues, this.newColorValues);
            if (this.visRenderer == null) {
                this.buildGraphicsPanel();
            }
            this.visRenderer.redraw();
        } else {
            n2 = 0;
            if (this.animator != null) {
                for (n = 0; n < n3; ++n) {
                    for (int i = 0; i < n3; ++i) {
                        this.oldHeightValues[n][i] = this.curHeightValues[n][i];
                        this.oldColorValues[n][i] = this.curColorValues[n][i];
                    }
                }
            } else {
                n2 = 1;
            }
            n = n2;
            this.animator = new StoppableThread(n != 0){
                private float ratio = 0.0f;
                private float scaleZTarget = 1.0f;
                private long duration = 350L;
                final /* synthetic */ boolean val$fromZero;
                {
                    this.val$fromZero = bl;
                }

                public void run() {
                    try {
                        if (this.val$fromZero) {
                            ThreeDeeCommMatrixWindow.this.barPlot.setScaleZ(0.0f);
                        }
                        while (!ThreeDeeCommMatrixWindow.this.visRenderer.isReadyToDraw()) {
                            3.sleep((long)100L);
                        }
                        int n = ThreeDeeCommMatrixWindow.this.mapData.getSize();
                        long l = System.currentTimeMillis();
                        while (!this.stopRequested()) {
                            long l2;
                            long l3;
                            3.sleep((long)10L);
                            long l4 = System.currentTimeMillis();
                            ThreeDeeCommMatrixWindow.this.visRenderer.redraw();
                            long l5 = System.currentTimeMillis();
                            long l6 = l5 - l4;
                            if (l6 <= 0L) {
                                l6 = 1L;
                            }
                            if ((l3 = (this.duration - (l2 = l5 - l)) / l6) != 0L) {
                                float f = (this.scaleZTarget - this.ratio) / (float)l3;
                                this.ratio += f;
                            } else {
                                this.ratio = 1.0f;
                            }
                            float f = (float)Math.log(this.ratio * 9.0f + 1.0f) / (float)Math.log(10.0);
                            for (int i = 0; i < n; ++i) {
                                for (int j = 0; j < n; ++j) {
                                    float f2 = ThreeDeeCommMatrixWindow.this.newHeightValues[i][j] - ThreeDeeCommMatrixWindow.this.oldHeightValues[i][j];
                                    float f3 = ThreeDeeCommMatrixWindow.this.newColorValues[i][j] - ThreeDeeCommMatrixWindow.this.oldColorValues[i][j];
                                    ((ThreeDeeCommMatrixWindow)ThreeDeeCommMatrixWindow.this).curHeightValues[i][j] = ThreeDeeCommMatrixWindow.this.oldHeightValues[i][j] + f * f2;
                                    ((ThreeDeeCommMatrixWindow)ThreeDeeCommMatrixWindow.this).curColorValues[i][j] = ThreeDeeCommMatrixWindow.this.oldColorValues[i][j] + f * f3;
                                }
                            }
                            ThreeDeeCommMatrixWindow.this.barPlot.setValues(ThreeDeeCommMatrixWindow.this.curHeightValues, ThreeDeeCommMatrixWindow.this.curColorValues);
                            if (this.val$fromZero) {
                                ThreeDeeCommMatrixWindow.this.barPlot.setScaleZ(f);
                            }
                            if (!(this.ratio >= 1.0f)) continue;
                            ThreeDeeCommMatrixWindow.this.copyMatrix(ThreeDeeCommMatrixWindow.this.curHeightValues, ThreeDeeCommMatrixWindow.this.newHeightValues, n);
                            ThreeDeeCommMatrixWindow.this.copyMatrix(ThreeDeeCommMatrixWindow.this.curColorValues, ThreeDeeCommMatrixWindow.this.newColorValues, n);
                            ThreeDeeCommMatrixWindow.this.barPlot.setValues(ThreeDeeCommMatrixWindow.this.newHeightValues, ThreeDeeCommMatrixWindow.this.newColorValues);
                            ThreeDeeCommMatrixWindow.this.barPlot.setScaleZ(1.0f);
                            ThreeDeeCommMatrixWindow.this.visRenderer.redraw();
                            return;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            };
            this.animator.start();
        }
    }

    private JPanel buildGraphicsPanel() {
        this.visRenderer = new VisRenderer();
        this.visCanvas = new VisCanvas(this.visRenderer);
        this.visCanvas.getActualCanvas().setSize(9100, 9100);
        this.visRenderer.setVisCanvasListener((VisCanvasListener)this);
        this.colorScale = new ColorScale();
        this.axes = new Axes();
        int n = this.mapData.getSize();
        this.newHeightValues = new float[n][n];
        this.newColorValues = new float[n][n];
        this.oldHeightValues = new float[n][n];
        this.oldColorValues = new float[n][n];
        this.curHeightValues = new float[n][n];
        this.curColorValues = new float[n][n];
        this.threadNames = this.ppTrial.getThreadNames();
        this.barPlot = new BarPlot(this.axes, this.colorScale);
        this.barPlot.setValues(18.0f, 18.0f, 8.0f, this.oldHeightValues, this.oldColorValues);
        this.processData();
        this.visRenderer.setAim(new Vec(5.0f, 5.0f, 0.0f));
        this.visRenderer.addShape((Shape)this.barPlot);
        this.visRenderer.addShape((Shape)this.colorScale);
        JPanel jPanel = new JPanel(){
            private static final long serialVersionUID = 4335157098523851633L;

            public Dimension getMinimumSize() {
                return new Dimension(10, 10);
            }
        };
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)this.visCanvas.getActualCanvas(), gridBagConstraints);
        return jPanel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            String string;
            Object object = actionEvent.getSource();
            if (object.equals(this.pathSelector) && !(string = (String)this.pathSelector.getSelectedItem()).equals(this.currentPath)) {
                this.currentPath = string;
                this.redrawHeatMap();
            }
            if (object.equals(this.heightComboBox) && this.heightComboBox.getSelectedIndex() != this.heightMetric) {
                this.heightMetric = this.heightComboBox.getSelectedIndex();
                this.redrawHeatMap();
            }
            if (object.equals(this.colorComboBox) && this.colorComboBox.getSelectedIndex() != this.colorMetric) {
                this.colorMetric = this.colorComboBox.getSelectedIndex();
                this.redrawHeatMap();
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    private void redrawHeatMap() {
        this.setSelections();
        this.updateScalePanel();
        Thread thread = new Thread(new Runnable(){

            public void run() {
                ThreeDeeCommMatrixWindow.this.processData();
            }
        });
        thread.start();
    }

    public void createNewCanvas() {
        this.visCanvas = new VisCanvas(this.visRenderer);
        this.visCanvas.getActualCanvas().setSize(9900, 9900);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)this.visCanvas.getActualCanvas(), gridBagConstraints);
        this.splitPane.setLeftComponent(jPanel);
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public BufferedImage getImage() {
        return this.visRenderer.createScreenShot();
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        try {
            if (n >= 1) {
                return 1;
            }
            ParaProfUtils.scaleForPrint(graphics, pageFormat, this.visCanvas.getWidth(), this.visCanvas.getHeight());
            BufferedImage bufferedImage = this.visRenderer.createScreenShot();
            ImageObserver imageObserver = new ImageObserver(){

                public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
                    return false;
                }
            };
            graphics.drawImage(bufferedImage, 0, 0, Color.black, imageObserver);
            return 0;
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
            return 1;
        }
    }

    @Override
    public JFrame getFrame() {
        return this;
    }

    @Override
    public void update(Observable observable, Object object) {
        String string = (String)object;
        if (string.equals("subWindowCloseEvent")) {
            this.closeThisWindow();
        } else if (!string.equals("prefEvent") && !string.equals("colorEvent") && string.equals("dataEvent")) {
            HeatMapData heatMapData = ThreeDeeCommMatrixWindow.generateData(this.ppTrial.getDataSource(), this.ppTrial.getSelectedSnapshot());
            if (heatMapData == null) {
                return;
            }
            this.mapData = heatMapData;
            this.processData();
        }
    }
}

