/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof.sourceview;

import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.WindowPlacer;
import edu.uoregon.tau.paraprof.sourceview.SourceViewer;
import edu.uoregon.tau.perfdmf.SourceRegion;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceManager
extends JFrame {
    private static final long serialVersionUID = -2806416317097108083L;
    private DefaultListModel listModel;
    private JList dirList;
    private SourceRegion toFind;
    private Map<File, SourceViewer> sourceViewers = new TreeMap<File, SourceViewer>();

    public ArrayList<Object> getCurrentElements() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            arrayList.add(this.listModel.getElementAt(i));
        }
        return arrayList;
    }

    private boolean matchFiles(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        if (string.equals(string2)) {
            return true;
        }
        File file = new File(string);
        File file2 = new File(string2);
        if (file.exists() && file2.exists()) {
            try {
                if (file.getCanonicalFile().equals(file2.getCanonicalFile())) {
                    return true;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return false;
    }

    private void launchSourceViewer(File file, SourceRegion sourceRegion) {
        SourceViewer sourceViewer = this.sourceViewers.get(file);
        if (sourceViewer == null) {
            sourceViewer = new SourceViewer(file);
            this.sourceViewers.put(file, sourceViewer);
        }
        sourceViewer.highlightRegion(sourceRegion);
        sourceViewer.setVisible(true);
    }

    private boolean searchLocations(SourceRegion sourceRegion, File[] fileArray, boolean bl) {
        int n;
        if (fileArray == null) {
            return false;
        }
        for (n = 0; n < fileArray.length; ++n) {
            if (!this.matchFiles(sourceRegion.getFilename(), fileArray[n].getName())) continue;
            this.launchSourceViewer(fileArray[n], sourceRegion);
            return true;
        }
        if (bl) {
            for (n = 0; n < fileArray.length; ++n) {
                if (!fileArray[n].isDirectory() || !this.searchLocations(sourceRegion, fileArray[n].listFiles(), bl)) continue;
                return true;
            }
        }
        return false;
    }

    public void showSourceCode(SourceRegion sourceRegion) {
        int n;
        String string = sourceRegion.getFilename();
        File file = new File(string);
        if (file.exists()) {
            this.launchSourceViewer(file, sourceRegion);
            return;
        }
        File file2 = new File(".");
        if (this.searchLocations(sourceRegion, file2.listFiles(), false)) {
            return;
        }
        for (n = 0; n < this.listModel.getSize(); ++n) {
            String string2 = (String)this.listModel.getElementAt(n);
            File file3 = new File(string2);
            File[] fileArray = file3.listFiles();
            if (fileArray == null || !this.searchLocations(sourceRegion, fileArray, true)) continue;
            return;
        }
        n = JOptionPane.showOptionDialog(this, "ParaProf could not find \"" + string + "\", would you like to add the containing directory to the search list?", "Looking for \"" + string + "\"", 0, 3, null, null, null);
        this.toFind = null;
        if (n == 0) {
            this.toFind = sourceRegion;
            this.display(null);
        }
    }

    public SourceManager(List<Object> list) {
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        JLabel jLabel = new JLabel("Current Source Directories (directories are searched recursively)");
        jLabel.setFont(new Font("SansSerif", 0, 14));
        this.addCompItem(jLabel, gridBagConstraints, 0, 0, 1, 1);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.listModel = new DefaultListModel();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                this.listModel.addElement(list.get(i));
            }
        }
        this.dirList = new JList(this.listModel);
        this.dirList.setSelectionMode(0);
        this.dirList.setSize(500, 300);
        JScrollPane jScrollPane = new JScrollPane(this.dirList);
        this.addCompItem(jScrollPane, gridBagConstraints, 0, 1, 1, 3);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        JButton jButton = new JButton("Add");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setFileSelectionMode(1);
                jFileChooser.setMultiSelectionEnabled(false);
                jFileChooser.setDialogTitle("Select Directory");
                jFileChooser.setApproveButtonText("Select");
                if (jFileChooser.showOpenDialog(SourceManager.this) != 0) {
                    return;
                }
                try {
                    SourceManager.this.listModel.addElement(jFileChooser.getSelectedFile().getCanonicalPath());
                }
                catch (Exception exception) {
                    ParaProfUtils.handleException(exception);
                }
            }
        });
        this.addCompItem(jButton, gridBagConstraints, 1, 1, 1, 1);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        jButton = new JButton("Remove");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = SourceManager.this.dirList.getSelectedIndex();
                if (n >= 0) {
                    SourceManager.this.listModel.removeElementAt(n);
                }
            }
        });
        this.addCompItem(jButton, gridBagConstraints, 1, 2, 1, 1);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        jButton = new JButton("Close");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SourceManager.this.toFind != null) {
                    SourceManager.this.showSourceCode(SourceManager.this.toFind);
                }
                SourceManager.this.setVisible(false);
            }
        });
        this.addCompItem(jButton, gridBagConstraints, 1, 3, 1, 1);
    }

    public void display(Component component) {
        this.setSize(new Dimension(855, 450));
        this.setLocation(WindowPlacer.getNewLocation(this, component));
        this.setTitle("TAU: ParaProf: Source Directory Manager");
        ParaProfUtils.setFrameIcon(this);
        this.setVisible(true);
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        this.getContentPane().add(component, gridBagConstraints);
    }
}

