/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof.tablemodel;

import edu.uoregon.tau.paraprof.ParaProfManagerWindow;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.perfdmf.DatabaseAPI;
import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfdmf.database.DBConnector;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultTreeModel;

public class TrialTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -5610815635456731795L;
    private ParaProfTrial ppTrial;
    private Trial trial;
    private String[] columnNames = new String[]{"TrialField", "Value"};
    private ParaProfManagerWindow paraProfManager;
    private DefaultTreeModel defaultTreeModel;
    private List<String> fieldNames;
    private Map<String, String> metaData = new TreeMap<String, String>();

    public TrialTableModel(ParaProfManagerWindow paraProfManagerWindow, ParaProfTrial paraProfTrial, DefaultTreeModel defaultTreeModel) {
        this.ppTrial = paraProfTrial;
        this.trial = paraProfTrial.getTrial();
        this.paraProfManager = paraProfManagerWindow;
        this.defaultTreeModel = defaultTreeModel;
        this.fieldNames = new ArrayList<String>();
        this.fieldNames.add("Name");
        this.fieldNames.add("Application ID");
        this.fieldNames.add("Experiment ID");
        this.fieldNames.add("Trial ID");
        for (int i = 0; i < paraProfTrial.getTrial().getNumFields(); ++i) {
            this.fieldNames.add(paraProfTrial.getTrial().getFieldName(i));
        }
        this.metaData.putAll(paraProfTrial.getTrial().getMetaData());
        this.metaData.putAll(paraProfTrial.getTrial().getUncommonMetaData());
        for (String string : this.metaData.keySet()) {
            this.fieldNames.add(string);
        }
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    public int getRowCount() {
        return this.fieldNames.size();
    }

    public Object getValueAt(int n, int n2) {
        if (n2 == 0) {
            return this.fieldNames.get(n);
        }
        if (n == 0) {
            return this.ppTrial.getName();
        }
        if (n == 1) {
            return new Integer(this.ppTrial.getApplicationID());
        }
        if (n == 2) {
            return new Integer(this.ppTrial.getExperimentID());
        }
        if (n == 3) {
            return new Integer(this.ppTrial.getID());
        }
        int n3 = n - 4;
        if (n3 < this.trial.getNumFields()) {
            return this.ppTrial.getTrial().getField(n3);
        }
        return this.metaData.get(this.fieldNames.get(n));
    }

    public boolean isCellEditable(int n, int n2) {
        if (n2 != 1) {
            return false;
        }
        if (n == 0) {
            return true;
        }
        if (n >= 1 && n <= 3) {
            return false;
        }
        int n3 = n - 4;
        if (n3 < this.trial.getNumFields()) {
            return DBConnector.isWritableType((int)this.ppTrial.getTrial().getFieldType(n - 4));
        }
        return true;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        if (!(object instanceof String)) {
            return;
        }
        String string = (String)object;
        if (n == 0) {
            this.ppTrial.getTrial().setName(string);
        } else {
            int n3 = n - 4;
            if (n3 < this.trial.getNumFields()) {
                this.ppTrial.getTrial().setField(n - 4, string);
            } else {
                this.metaData.put(this.fieldNames.get(n), string);
                this.trial.getMetaData().put(this.fieldNames.get(n), string);
            }
        }
        this.updateDB();
        this.defaultTreeModel.nodeChanged(this.ppTrial.getDMTN());
    }

    private void updateDB() {
        DatabaseAPI databaseAPI;
        if (this.ppTrial.dBTrial() && (databaseAPI = this.paraProfManager.getDatabaseAPI(this.ppTrial.getDatabase())) != null) {
            databaseAPI.saveTrial(this.ppTrial.getTrial());
            databaseAPI.terminate();
        }
    }

    public MouseListener getMouseListener(final JTable jTable) {
        return new MouseListener(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (ParaProfUtils.rightClick(mouseEvent)) {
                    JPopupMenu jPopupMenu;
                    int n = jTable.rowAtPoint(mouseEvent.getPoint());
                    int n2 = jTable.columnAtPoint(mouseEvent.getPoint());
                    if (TrialTableModel.this.getValueAt(n, 0).toString().startsWith("BACKTRACE") && (jPopupMenu = ParaProfUtils.createMetadataClickPopUp(TrialTableModel.this.getValueAt(n, n2).toString(), jTable)) != null) {
                        jPopupMenu.show(jTable, mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }
        };
    }
}

