/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof.treetable;

import edu.uoregon.tau.common.ImageExport;
import edu.uoregon.tau.common.Utility;
import edu.uoregon.tau.common.treetable.AbstractTreeTableModel;
import edu.uoregon.tau.common.treetable.JTreeTable;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.WindowPlacer;
import edu.uoregon.tau.paraprof.interfaces.ParaProfWindow;
import edu.uoregon.tau.paraprof.treetable.ContextEventModel;
import edu.uoregon.tau.paraprof.treetable.ContextEventTreeNode;
import edu.uoregon.tau.perfdmf.Thread;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;

public class ContextEventWindow
extends JFrame
implements Observer,
ParaProfWindow,
Printable,
ImageExport {
    private static final long serialVersionUID = 1234017079628001497L;
    private ParaProfTrial ppTrial;
    private Thread thread;
    private ContextEventModel model;
    private JTreeTable treeTable;
    private JScrollPane scrollPane;

    public ContextEventWindow(ParaProfTrial paraProfTrial, Thread thread) {
        this(paraProfTrial, thread, null);
    }

    public ContextEventWindow(ParaProfTrial paraProfTrial, Thread thread, Component component) {
        this.ppTrial = paraProfTrial;
        this.thread = thread;
        paraProfTrial.addObserver(this);
        this.setSize(ParaProfUtils.checkSize(new Dimension(1000, 600)));
        this.setLocation(WindowPlacer.getNewLocation(this, component));
        if (thread.getNodeID() == -1) {
            this.setTitle("TAU: ParaProf: Mean Context Events - " + paraProfTrial.getTrialIdentifier(ParaProf.preferences.getShowPathTitleInReverse()));
        } else if (thread.getNodeID() == -2) {
            this.setTitle("TAU: ParaProf: Total Context Events - " + paraProfTrial.getTrialIdentifier(ParaProf.preferences.getShowPathTitleInReverse()));
        } else if (thread.getNodeID() == -3) {
            this.setTitle("TAU: ParaProf: Std. Dev. Context Events - " + paraProfTrial.getTrialIdentifier(ParaProf.preferences.getShowPathTitleInReverse()));
        } else {
            this.setTitle("TAU: ParaProf: Context Events for: " + ParaProfUtils.getThreadLabel(thread) + " - " + paraProfTrial.getTrialIdentifier(ParaProf.preferences.getShowPathTitleInReverse()));
        }
        ParaProfUtils.setFrameIcon(this);
        if (ParaProf.getHelpWindow().isVisible()) {
            this.help(false);
        }
        this.setupMenus();
        this.setupData();
        ParaProf.incrementNumWindows();
    }

    private void setupMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(ParaProfUtils.createFileMenu(this, this, this));
        jMenuBar.add(ParaProfUtils.createWindowsMenu(this.ppTrial, this));
        jMenuBar.add(ParaProfUtils.createHelpMenu(this, this));
        this.setJMenuBar(jMenuBar);
    }

    private void setupData() {
        this.model = new ContextEventModel(this, this.ppTrial, this.thread, false);
        this.createTreeTable(this.model);
        this.addComponents();
    }

    private void createTreeTable(AbstractTreeTableModel abstractTreeTableModel) {
        this.treeTable = new JTreeTable(abstractTreeTableModel, true, true);
        final JTree jTree = this.treeTable.getTree();
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                try {
                    TreePath treePath = jTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                    if (treePath != null) {
                        ContextEventTreeNode contextEventTreeNode = (ContextEventTreeNode)treePath.getLastPathComponent();
                        if (ParaProfUtils.rightClick(mouseEvent) && contextEventTreeNode.getUserEventProfile() != null) {
                            ParaProfUtils.handleUserEventClick(ContextEventWindow.this.ppTrial, contextEventTreeNode.getUserEventProfile().getUserEvent(), (JComponent)ContextEventWindow.this.treeTable, mouseEvent);
                        }
                    }
                }
                catch (Exception exception) {
                    ParaProfUtils.handleException(exception);
                }
            }
        };
        this.treeTable.addMouseListener((MouseListener)mouseAdapter);
        DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer(){
            private static final long serialVersionUID = 2780103869814842355L;

            public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
                this.setIcon(null);
                this.setBackgroundNonSelectionColor(null);
                if (n % 2 == 0) {
                    this.setBackgroundNonSelectionColor(new Color(235, 235, 235));
                } else {
                    this.setBackground(jTree.getBackground());
                }
                return this;
            }
        };
        this.treeTable.getTree().setCellRenderer(defaultTreeCellRenderer);
        Font font = ParaProf.preferencesWindow.getFont();
        this.treeTable.setFont(font);
        defaultTreeCellRenderer.setFont(font);
        FontMetrics fontMetrics = this.getFontMetrics(font);
        this.treeTable.setRowHeight(fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent() + 3);
        this.treeTable.setAutoResizeMode(0);
        this.treeTable.setAutoResizeMode(2);
        TableColumn tableColumn = this.treeTable.getColumnModel().getColumn(0);
        int n = 450;
        tableColumn.setPreferredWidth(n);
    }

    private void addComponents() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.getContentPane().removeAll();
        this.getContentPane().setLayout(new GridBagLayout());
        this.scrollPane = new JScrollPane((Component)this.treeTable);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        Utility.addCompItem((JFrame)this, (Component)this.scrollPane, (GridBagConstraints)gridBagConstraints, (int)0, (int)0, (int)0, (int)0);
        this.validate();
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        try {
            if (n >= 1) {
                return 1;
            }
            ParaProfUtils.scaleForPrint(graphics, pageFormat, (int)this.treeTable.getSize().getWidth(), (int)this.treeTable.getSize().getHeight());
            this.export((Graphics2D)graphics, false, true, false);
            return 0;
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
            return 1;
        }
    }

    public void setUnits(int n) {
    }

    public void export(Graphics2D graphics2D, boolean bl, boolean bl2, boolean bl3) {
        if (bl2) {
            this.scrollPane.getColumnHeader().paintAll(graphics2D);
            graphics2D.translate(0, this.scrollPane.getColumnHeader().getHeight());
            this.treeTable.paintAll((Graphics)graphics2D);
        } else {
            this.scrollPane.paintAll(graphics2D);
        }
    }

    public Dimension getImageSize(boolean bl, boolean bl2) {
        if (bl) {
            Dimension dimension = this.treeTable.getSize();
            dimension.setSize(dimension.getWidth(), dimension.getHeight() + (double)this.scrollPane.getColumnHeader().getHeight());
            return dimension;
        }
        return this.scrollPane.getSize();
    }

    public boolean getTreeMode() {
        return true;
    }

    public void update(Observable observable, Object object) {
        if (this.thread.getNodeID() >= 0) {
            this.setTitle("TAU: ParaProf: Context Events for: " + ParaProfUtils.getThreadLabel(this.thread) + " - " + this.ppTrial.getTrialIdentifier(ParaProf.preferences.getShowPathTitleInReverse()));
        }
        this.treeTable.repaint();
    }

    public void closeThisWindow() {
        this.setVisible(false);
        this.ppTrial.deleteObserver(this);
        ParaProf.decrementNumWindows();
        this.dispose();
    }

    public void help(boolean bl) {
        ParaProf.getHelpWindow().clearText();
        if (bl) {
            ParaProf.getHelpWindow().setVisible(true);
        }
        ParaProf.getHelpWindow().writeText("This is the Context Event Window.\n");
        ParaProf.getHelpWindow().writeText("This window shows context events in a tree-table.)\n");
    }

    public JFrame getFrame() {
        return this;
    }
}

