/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof.treetable;

import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.treetable.TransferableTreeNode;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class TreeDragSource
implements DragSourceListener,
DragGestureListener {
    DragSource source;
    DragGestureRecognizer recognizer;
    TransferableTreeNode transferable;
    DefaultMutableTreeNode oldNode;
    JTree sourceTree;

    public TreeDragSource(JTree jTree, int n) {
        this.sourceTree = jTree;
        this.source = new DragSource();
        this.recognizer = this.source.createDefaultDragGestureRecognizer(this.sourceTree, n, this);
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        TreePath treePath = this.sourceTree.getSelectionPath();
        if (treePath == null || treePath.getPathCount() <= 1) {
            return;
        }
        this.oldNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        if (this.oldNode.getUserObject() instanceof ParaProfTrial) {
            ParaProf.paraProfManagerWindow.expand(this.oldNode);
        }
        this.transferable = new TransferableTreeNode(this.oldNode);
        this.source.startDrag(dragGestureEvent, DragSource.DefaultMoveDrop, this.transferable, this);
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        if (!dragSourceDropEvent.getDropSuccess() || dragSourceDropEvent.getDropAction() == 2) {
            // empty if block
        }
    }
}

