/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof.treetable;

import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfApplication;
import edu.uoregon.tau.paraprof.ParaProfExperiment;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.perfdmf.Application;
import edu.uoregon.tau.perfdmf.DBDataSource;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.DataSourceException;
import edu.uoregon.tau.perfdmf.Database;
import edu.uoregon.tau.perfdmf.DatabaseAPI;
import edu.uoregon.tau.perfdmf.DatabaseException;
import edu.uoregon.tau.perfdmf.Experiment;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Enumeration;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeDropTarget
implements DropTargetListener {
    DropTarget target;
    JTree targetTree;

    public TreeDropTarget(JTree jTree) {
        this.targetTree = jTree;
        this.target = new DropTarget(this.targetTree, this);
    }

    private TreeNode getNodeForEvent(DropTargetDragEvent dropTargetDragEvent) {
        Point point = dropTargetDragEvent.getLocation();
        DropTargetContext dropTargetContext = dropTargetDragEvent.getDropTargetContext();
        JTree jTree = (JTree)dropTargetContext.getComponent();
        TreePath treePath = jTree.getClosestPathForLocation(point.x, point.y);
        return (TreeNode)treePath.getLastPathComponent();
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        TreeNode treeNode = this.getNodeForEvent(dropTargetDragEvent);
        if (treeNode.isLeaf()) {
            dropTargetDragEvent.rejectDrag();
        } else {
            dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        TreeNode treeNode = this.getNodeForEvent(dropTargetDragEvent);
        dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        Point point = dropTargetDropEvent.getLocation();
        DropTargetContext dropTargetContext = dropTargetDropEvent.getDropTargetContext();
        JTree jTree = (JTree)dropTargetContext.getComponent();
        TreePath treePath = jTree.getClosestPathForLocation(point.x, point.y);
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        boolean bl = dropTargetDropEvent.getDropAction() == 1;
        bl = !bl;
        try {
            Transferable transferable = dropTargetDropEvent.getTransferable();
            DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (!transferable.isDataFlavorSupported(dataFlavorArray[i])) continue;
                dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)transferable.getTransferData(dataFlavorArray[i]);
                Object object = defaultMutableTreeNode2.getUserObject();
                if (defaultMutableTreeNode2.getParent() == defaultMutableTreeNode) {
                    return;
                }
                if (object instanceof ParaProfApplication) {
                    TreePath treePath2;
                    if (!(defaultMutableTreeNode.getUserObject() instanceof Database)) {
                        return;
                    }
                    ParaProfApplication paraProfApplication = (ParaProfApplication)object;
                    DatabaseAPI databaseAPI = ParaProf.paraProfManagerWindow.getDatabaseAPI((Database)defaultMutableTreeNode.getUserObject());
                    this.expand(defaultMutableTreeNode2);
                    String string = this.getAppName(paraProfApplication);
                    String string2 = ((Database)defaultMutableTreeNode.getUserObject()).getName();
                    if (JOptionPane.showConfirmDialog(ParaProf.paraProfManagerWindow, "Are you sure you want to " + (bl ? "copy " : "move ") + string + " to " + string2 + " ?", (bl ? "Copy " : "Move ") + "Application", 0) == 1) {
                        return;
                    }
                    this.uploadApplication(databaseAPI, paraProfApplication, defaultMutableTreeNode2.children());
                    if (!bl) {
                        this.deleteObject(defaultMutableTreeNode2.getUserObject());
                    }
                    if (this.targetTree.isExpanded(treePath2 = new TreePath(defaultMutableTreeNode.getPath()))) {
                        this.targetTree.collapsePath(treePath2);
                    }
                    this.targetTree.expandPath(treePath2);
                } else if (object instanceof ParaProfExperiment) {
                    Object object2;
                    if (!(defaultMutableTreeNode.getUserObject() instanceof ParaProfApplication)) {
                        return;
                    }
                    ParaProfExperiment paraProfExperiment = (ParaProfExperiment)object;
                    ParaProfApplication paraProfApplication = (ParaProfApplication)defaultMutableTreeNode.getUserObject();
                    if (!paraProfApplication.dBApplication() && paraProfExperiment.dBExperiment()) {
                        return;
                    }
                    String string = this.getAppName(paraProfExperiment.getApplication()) + ":" + paraProfExperiment.getName();
                    String string3 = this.getAppName(paraProfApplication);
                    if (JOptionPane.showConfirmDialog(ParaProf.paraProfManagerWindow, "Are you sure you want to " + (bl ? "copy " : "move ") + string + " to " + string3 + "?", (bl ? "Copy " : "Move ") + " Experiment", 0) == 1) {
                        return;
                    }
                    this.expand(defaultMutableTreeNode2);
                    if (!paraProfApplication.dBApplication()) {
                        object2 = paraProfExperiment.getApplication();
                        DefaultMutableTreeNode defaultMutableTreeNode3 = paraProfExperiment.getDMTN();
                        this.uploadExperment(paraProfApplication, paraProfExperiment, defaultMutableTreeNode2.children());
                        ParaProf.paraProfManagerWindow.getTreeModel().removeNodeFromParent(defaultMutableTreeNode3);
                        if (!bl) {
                            ((ParaProfApplication)object2).removeExperiment(paraProfExperiment);
                        }
                    } else {
                        object2 = ParaProf.paraProfManagerWindow.getDatabaseAPI((Database)((DefaultMutableTreeNode)defaultMutableTreeNode.getParent()).getUserObject());
                        this.uploadExperiment(paraProfApplication, paraProfExperiment, (DatabaseAPI)object2, defaultMutableTreeNode2.children());
                        if (!bl) {
                            this.deleteObject(defaultMutableTreeNode2.getUserObject());
                        }
                    }
                    object2 = new TreePath(defaultMutableTreeNode.getPath());
                    if (this.targetTree.isExpanded((TreePath)object2)) {
                        this.targetTree.collapsePath((TreePath)object2);
                    }
                    this.targetTree.expandPath((TreePath)object2);
                } else if (object instanceof ParaProfTrial) {
                    Object object3;
                    if (!(defaultMutableTreeNode.getUserObject() instanceof ParaProfExperiment)) {
                        return;
                    }
                    ParaProfTrial paraProfTrial = (ParaProfTrial)defaultMutableTreeNode2.getUserObject();
                    ParaProfExperiment paraProfExperiment = (ParaProfExperiment)defaultMutableTreeNode.getUserObject();
                    if (!paraProfExperiment.dBExperiment() && paraProfTrial.dBTrial()) {
                        return;
                    }
                    String string = this.getAppName(paraProfTrial.getExperiment().getApplication()) + ":" + paraProfTrial.getExperiment().getName() + ":" + paraProfTrial.getName();
                    String string4 = this.getAppName(paraProfExperiment.getApplication()) + ":" + paraProfExperiment.getName();
                    if (JOptionPane.showConfirmDialog(ParaProf.paraProfManagerWindow, "Are you sure you want to " + (bl ? "copy " : "move ") + string + " to " + string4 + "?", (bl ? "Copy " : "Move ") + " Trial", 0) == 1) {
                        return;
                    }
                    this.expand(defaultMutableTreeNode2);
                    if (!paraProfExperiment.dBExperiment()) {
                        object3 = paraProfTrial.getExperiment();
                        ParaProf.paraProfManagerWindow.getTreeModel().removeNodeFromParent(paraProfTrial.getDMTN());
                        this.uploadTrial(paraProfTrial, paraProfExperiment);
                        if (!bl) {
                            ((ParaProfExperiment)object3).removeTrial(paraProfTrial);
                        }
                    } else {
                        object3 = ParaProf.paraProfManagerWindow.getDatabaseAPI((Database)((DefaultMutableTreeNode)defaultMutableTreeNode.getParent().getParent()).getUserObject());
                        this.uploadTrial(paraProfTrial, paraProfExperiment, (DatabaseAPI)object3);
                        if (!bl) {
                            this.deleteObject(defaultMutableTreeNode2.getUserObject());
                        }
                    }
                    object3 = new TreePath(defaultMutableTreeNode.getPath());
                    if (this.targetTree.isExpanded((TreePath)object3)) {
                        this.targetTree.collapsePath((TreePath)object3);
                    }
                    this.targetTree.expandPath((TreePath)object3);
                } else {
                    return;
                }
                dropTargetDropEvent.dropComplete(true);
                return;
            }
            dropTargetDropEvent.rejectDrop();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String getAppName(ParaProfApplication paraProfApplication) {
        if (paraProfApplication.getDatabase() != null) {
            return paraProfApplication.getDatabase().getName() + ":" + paraProfApplication.getName();
        }
        return "Standard Applications:" + paraProfApplication.getName();
    }

    private void uploadExperment(ParaProfApplication paraProfApplication, ParaProfExperiment paraProfExperiment, Enumeration<DefaultMutableTreeNode> enumeration) throws FileNotFoundException, DataSourceException, InterruptedException, IOException, SQLException {
        ParaProfExperiment paraProfExperiment2 = paraProfApplication.addExperiment();
        paraProfExperiment2.setName(paraProfExperiment.getName());
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode = enumeration.nextElement();
                this.expand(defaultMutableTreeNode);
                this.uploadTrial((ParaProfTrial)defaultMutableTreeNode.getUserObject(), paraProfExperiment2);
            }
        }
    }

    private void uploadTrial(ParaProfTrial paraProfTrial, ParaProfExperiment paraProfExperiment) {
        paraProfExperiment.addTrial(paraProfTrial);
        paraProfTrial.setApplicationID(paraProfExperiment.getApplicationID());
        paraProfTrial.setExperimentID(paraProfExperiment.getID());
    }

    private void expand(DefaultMutableTreeNode defaultMutableTreeNode) throws InterruptedException, FileNotFoundException, DataSourceException, IOException, SQLException {
        if (defaultMutableTreeNode.getUserObject() instanceof ParaProfTrial) {
            this.trialWillExpand(defaultMutableTreeNode);
            this.waitForLoad((ParaProfTrial)defaultMutableTreeNode.getUserObject());
        } else {
            this.targetTree.expandPath(new TreePath(defaultMutableTreeNode.getPath()));
        }
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
                this.expand(defaultMutableTreeNode2);
            }
        }
    }

    private void uploadApplication(DatabaseAPI databaseAPI, ParaProfApplication paraProfApplication, Enumeration<DefaultMutableTreeNode> enumeration) throws DatabaseException, SQLException, InterruptedException, FileNotFoundException, DataSourceException, IOException {
        Application application = new Application((Application)paraProfApplication);
        application.setID(-1);
        ParaProfApplication paraProfApplication2 = new ParaProfApplication(application);
        paraProfApplication2.setID(-1);
        paraProfApplication2.setDBApplication(true);
        paraProfApplication2.setID(databaseAPI.saveApplication((Application)paraProfApplication2));
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = enumeration.nextElement();
            ParaProfExperiment paraProfExperiment = (ParaProfExperiment)defaultMutableTreeNode.getUserObject();
            this.uploadExperiment(paraProfApplication2, paraProfExperiment, databaseAPI, defaultMutableTreeNode.children());
        }
    }

    private void uploadTrial(ParaProfTrial paraProfTrial, ParaProfExperiment paraProfExperiment, DatabaseAPI databaseAPI) throws FileNotFoundException, DataSourceException, IOException, SQLException, InterruptedException {
        this.waitForLoad(paraProfTrial);
        if (paraProfTrial.getTrial().getDataSource().getMetadataString().equals("")) {
            paraProfTrial.getTrial().getDataSource().buildXMLMetaData();
        }
        while (paraProfTrial.loading()) {
            Thread.sleep(10L);
        }
        paraProfTrial.setExperiment(paraProfExperiment);
        ParaProfTrial paraProfTrial2 = new ParaProfTrial(paraProfTrial.getTrial());
        paraProfTrial2.setID(-1);
        paraProfTrial2.setExperimentID(paraProfExperiment.getID());
        paraProfTrial2.setApplicationID(paraProfExperiment.getApplicationID());
        paraProfTrial2.getTrial().setDataSource(paraProfTrial.getDataSource());
        paraProfTrial2.setExperiment(paraProfExperiment);
        paraProfTrial2.setUpload(true);
        paraProfTrial2.setDatabaseAPI(databaseAPI);
        paraProfTrial2.getTrial().setID(-1);
        if (databaseAPI != null) {
            paraProfTrial2.setID(databaseAPI.uploadTrial(paraProfTrial2.getTrial()));
        }
        paraProfTrial2.setDBTrial(true);
    }

    private void uploadExperiment(ParaProfApplication paraProfApplication, ParaProfExperiment paraProfExperiment, DatabaseAPI databaseAPI, Enumeration<DefaultMutableTreeNode> enumeration) throws DatabaseException, SQLException, InterruptedException, FileNotFoundException, DataSourceException, IOException {
        Experiment experiment = new Experiment((Experiment)paraProfExperiment);
        ParaProfExperiment paraProfExperiment2 = new ParaProfExperiment(experiment);
        experiment.setID(-1);
        paraProfExperiment2.setID(-1);
        paraProfExperiment2.setDBExperiment(true);
        paraProfExperiment2.setApplicationID(paraProfApplication.getID());
        paraProfExperiment2.setApplication(paraProfApplication);
        paraProfExperiment2.setID(databaseAPI.saveExperiment((Experiment)paraProfExperiment2));
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = enumeration.nextElement();
            ParaProfTrial paraProfTrial = (ParaProfTrial)defaultMutableTreeNode.getUserObject();
            DatabaseAPI databaseAPI2 = ParaProf.paraProfManagerWindow.getDatabaseAPI(paraProfExperiment2.getDatabase());
            this.uploadTrial(paraProfTrial, paraProfExperiment2, databaseAPI);
        }
    }

    private void waitForLoad(ParaProfTrial paraProfTrial) throws InterruptedException {
        while (paraProfTrial.loading()) {
            Thread.sleep(10L);
        }
    }

    private void trialWillExpand(DefaultMutableTreeNode defaultMutableTreeNode) throws FileNotFoundException, DataSourceException, IOException, SQLException {
        Object object = defaultMutableTreeNode.getUserObject();
        ParaProfTrial paraProfTrial = (ParaProfTrial)object;
        if (paraProfTrial.dBTrial()) {
            ParaProfTrial paraProfTrial2;
            boolean bl = false;
            Object object2 = ParaProf.paraProfManagerWindow.getLoadedDBTrials().elements();
            while (object2.hasMoreElements()) {
                paraProfTrial2 = object2.nextElement();
                if (paraProfTrial.getID() != paraProfTrial2.getID() || paraProfTrial.getExperimentID() != paraProfTrial2.getExperimentID() || paraProfTrial.getApplicationID() != paraProfTrial2.getApplicationID()) continue;
                defaultMutableTreeNode.setUserObject(paraProfTrial2);
                paraProfTrial2.setDMTN(defaultMutableTreeNode);
                paraProfTrial = paraProfTrial2;
                bl = true;
            }
            object2 = paraProfTrial;
            if (!bl) {
                if (((ParaProfTrial)object2).loading()) {
                    return;
                }
                ((ParaProfTrial)object2).setLoading(true);
                paraProfTrial2 = ParaProf.paraProfManagerWindow.getDatabaseAPI(((ParaProfTrial)object2).getDatabase());
                if (paraProfTrial2 != null) {
                    paraProfTrial2.setApplication(((ParaProfTrial)object2).getApplicationID());
                    paraProfTrial2.setExperiment(((ParaProfTrial)object2).getExperimentID());
                    paraProfTrial2.setTrial(((ParaProfTrial)object2).getID(), true);
                    DBDataSource dBDataSource = new DBDataSource((DatabaseAPI)paraProfTrial2);
                    dBDataSource.setGenerateIntermediateCallPathData(ParaProf.preferences.getGenerateIntermediateCallPathData());
                    ((ParaProfTrial)object2).getTrial().setDataSource((DataSource)dBDataSource);
                    DBDataSource dBDataSource2 = dBDataSource;
                    Object object3 = object2;
                    dBDataSource2.load();
                    ((ParaProfTrial)object3).finishLoad();
                    ParaProf.paraProfManagerWindow.getLoadedTrials().add((ParaProfTrial)object2);
                    ParaProf.paraProfManagerWindow.getLoadedDBTrials().add((ParaProfTrial)object2);
                }
            }
        }
    }

    private void deleteObject(Object object) {
        try {
            ParaProf.paraProfManagerWindow.handleDelete(object);
        }
        catch (DatabaseException databaseException) {
            databaseException.printStackTrace();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }
}

