/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.common;

import edu.uoregon.tau.common.ImageFormatFileFilter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

public class ImageOptionsPanel
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = -4236392653580823777L;
    private JCheckBox fullScreen = new JCheckBox("Full Window", true);
    private JCheckBox prependHeader = new JCheckBox("Show Meta-Data", true);
    private JLabel imageQualityLabel = new JLabel("Image Quality");
    private String[] imageQualityStrings = new String[]{"1.0", "0.75", "0.5", "0.25", "0.15", "0.1"};
    private JComboBox imageQuality = new JComboBox<String>(this.imageQualityStrings);
    private JCheckBox textAsShapes = new JCheckBox("Draw text as shapes", true);
    private boolean imageQualityEnabled = true;

    public ImageOptionsPanel(Component component, boolean bl, boolean bl2) {
        int n = 200;
        int n2 = 500;
        this.setSize(new Dimension(n, n2));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        if (bl) {
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            this.addCompItem(this.fullScreen, gridBagConstraints, 0, 0, 1, 1);
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            this.addCompItem(this.prependHeader, gridBagConstraints, 0, 1, 1, 1);
        }
        if (bl2) {
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            this.addCompItem(this.textAsShapes, gridBagConstraints, 0, 2, 1, 1);
        } else {
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            this.addCompItem(this.imageQualityLabel, gridBagConstraints, 0, 2, 1, 1);
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 100.0;
            gridBagConstraints.weighty = 0.0;
            this.addCompItem(this.imageQuality, gridBagConstraints, 1, 2, 1, 1);
        }
    }

    public boolean isFullScreen() {
        return this.fullScreen.isSelected();
    }

    public boolean isPrependHeader() {
        return this.prependHeader.isSelected();
    }

    public float getImageQuality() {
        return Float.valueOf((String)this.imageQuality.getSelectedItem()).floatValue();
    }

    public boolean imageQualityEnabled() {
        return this.imageQualityEnabled;
    }

    public boolean getTextAsShapes() {
        return this.textAsShapes.isSelected();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        JFileChooser jFileChooser;
        FileFilter fileFilter;
        Object object;
        if (propertyChangeEvent.getPropertyName().equals("fileFilterChanged") && (object = propertyChangeEvent.getSource()) instanceof JFileChooser && (fileFilter = (jFileChooser = (JFileChooser)object).getFileFilter()) instanceof ImageFormatFileFilter) {
            String string = ((ImageFormatFileFilter)fileFilter).getExtension();
            if (string.equals(ImageFormatFileFilter.PNG)) {
                this.imageQuality.setEnabled(false);
                this.imageQualityEnabled = false;
            } else {
                this.imageQuality.setEnabled(true);
                this.imageQualityEnabled = true;
            }
        }
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        this.add(component, gridBagConstraints);
    }
}

