/*
 * Decompiled with CFR 0.152.
 */
package com.graphbuilder.struc;

public class Bag {
    protected Object[] data = null;
    protected int size = 0;

    public Bag() {
        this.data = new Object[2];
    }

    public Bag(int n) {
        this.data = new Object[n];
    }

    public void add(Object object) {
        this.insert(object, this.size);
    }

    public int size() {
        return this.size;
    }

    public void insert(Object object, int n) {
        if (n < 0 || n > this.size) {
            throw new IllegalArgumentException("required: (i >= 0 && i <= size) but: (i = " + n + ", size = " + this.size + ")");
        }
        this.ensureCapacity(this.size + 1);
        for (int i = this.size; i > n; --i) {
            this.data[i] = this.data[i - 1];
        }
        this.data[n] = object;
        ++this.size;
    }

    public void ensureCapacity(int n) {
        if (n > this.data.length) {
            int n2 = 2 * this.data.length;
            if (n2 < n) {
                n2 = n;
            }
            Object[] objectArray = new Object[n2];
            for (int i = 0; i < this.size; ++i) {
                objectArray[i] = this.data[i];
            }
            this.data = objectArray;
        }
    }

    public int getCapacity() {
        return this.data.length;
    }

    private int indexOf(Object object, int n, boolean bl) {
        if (this.size == 0) {
            return -1;
        }
        if (n < 0 || n >= this.size) {
            throw new IllegalArgumentException("required: (i >= 0 && i < size) when: (size > 0) but: (i = " + n + ", size = " + this.size + ")");
        }
        if (bl) {
            if (object == null) {
                while (n < this.size) {
                    if (this.data[n] == null) {
                        return n;
                    }
                    ++n;
                }
            } else {
                while (n < this.size) {
                    if (object.equals(this.data[n])) {
                        return n;
                    }
                    ++n;
                }
            }
        } else if (object == null) {
            while (n >= 0) {
                if (this.data[n] == null) {
                    return n;
                }
                --n;
            }
        } else {
            while (n >= 0) {
                if (object.equals(this.data[n])) {
                    return n;
                }
                --n;
            }
        }
        return -1;
    }

    public int remove(Object object) {
        int n = this.indexOf(object, 0, true);
        if (n >= 0) {
            this.remove(n);
        }
        return n;
    }

    public Object remove(int n) {
        if (n < 0 || n >= this.size) {
            throw new IllegalArgumentException("required: (i >= 0 && i < size) but: (i = " + n + ", size = " + this.size + ")");
        }
        Object object = this.data[n];
        for (int i = n + 1; i < this.size; ++i) {
            this.data[i - 1] = this.data[i];
        }
        this.data[--this.size] = null;
        return object;
    }

    public Object get(int n) {
        if (n < 0 || n >= this.size) {
            throw new IllegalArgumentException("required: (i >= 0 && i < size) but: (i = " + n + ", size = " + this.size + ")");
        }
        return this.data[n];
    }

    public boolean contains(Object object) {
        return this.indexOf(object, 0, true) >= 0;
    }
}

