/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.trace;

import edu.uoregon.tau.trace.Event;
import edu.uoregon.tau.trace.EventDescr;
import edu.uoregon.tau.trace.TraceFile;
import edu.uoregon.tau.trace.TraceReaderCallbacks;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;

public class TraceReader
extends TraceFile {
    private static final int FORMAT_NATIVE = 0;
    private static final int FORMAT_32 = 1;
    private static final int FORMAT_32_SWAP = 2;
    private static final int FORMAT_64 = 3;
    private static final int FORMAT_64_SWAP = 4;
    boolean ClkInitialized;
    boolean subtractFirstTimestamp = true;
    boolean nonBlocking = false;
    boolean definitionsOnly = false;
    boolean done = false;
    int format;
    long totalRecords = 0L;
    long totalRead = 0L;
    HashSet<Integer> nidTidSeen = new HashSet();
    HashSet<Integer> nidTidDone = new HashSet();
    DataInputStream Fiid;
    private static final int TAU_MESSAGE_SEND_EVENT = -7;
    private static final int TAU_MESSAGE_RECV_EVENT = -8;
    long FirstTimestamp = 0L;

    public TraceReader(String string, String string2) {
        String[] stringArray;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            stringArray = new BufferedInputStream(fileInputStream);
            this.Fiid = new DataInputStream((InputStream)stringArray);
            this.format = TraceReader.determineFormat(this.Fiid);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.totalRecords = TraceReader.getNumRecords(string);
        this.EdfFile = string2;
        this.TrcFile = string;
        stringArray = string.split(".");
        if (stringArray.length == 5) {
            this.node = Integer.parseInt(stringArray[1]);
            this.context = Integer.parseInt(stringArray[2]);
            this.thread = Integer.parseInt(stringArray[3]);
        }
        this.EventIdMap = new HashMap();
        this.GroupIdMap = new HashMap();
        this.ClkInitialized = false;
    }

    public static long getNumRecords(String string) {
        File file = new File(string);
        return file.length() / 24L;
    }

    public long getNumRecords() {
        return this.totalRecords;
    }

    public String getTraceFile() {
        return this.TrcFile;
    }

    private static int CharPair(int n, int n2) {
        return (n << 16) + n2;
    }

    private static final char charReverseBytes(char c) {
        return (char)(c >> 8 & 0xFF | c << 8 & 0xFF00);
    }

    private static final int intReverseBytes(int n) {
        return TraceReader.charReverseBytes((char)n) << 16 | TraceReader.charReverseBytes((char)(n >>> 16));
    }

    public static long longReverseBytes(long l) {
        l = (l & 0xFF00FF00FF00FFL) << 8 | l >>> 8 & 0xFF00FF00FF00FFL;
        return l << 48 | (l & 0xFFFF0000L) << 16 | l >>> 16 & 0xFFFF0000L | l >>> 48;
    }

    static int determineFormat(DataInputStream dataInputStream) throws IOException {
        Event event = new Event();
        dataInputStream.mark(128);
        event.setEventID(dataInputStream.readInt());
        event.setNodeID(dataInputStream.readChar());
        event.setThreadID(dataInputStream.readChar());
        event.setParameter(dataInputStream.readLong());
        event.setTime(dataInputStream.readLong());
        int n = 0;
        if (event.getParameter() == 3L) {
            n = 1;
        } else if (TraceReader.longReverseBytes(event.getParameter()) == 3L) {
            n = 2;
        } else {
            dataInputStream.reset();
            event.setEventID((int)dataInputStream.readLong());
            event.setNodeID(dataInputStream.readChar());
            event.setThreadID(dataInputStream.readChar());
            dataInputStream.readInt();
            event.setParameter(dataInputStream.readLong());
            event.setTime(dataInputStream.readLong());
            if (event.getParameter() == 3L) {
                n = 3;
            } else if (TraceReader.longReverseBytes(event.getParameter()) == 3L) {
                n = 4;
            } else {
                System.out.println("Could not determine trace format, using native.");
            }
        }
        dataInputStream.reset();
        return n;
    }

    private static Event readEvent(int n, DataInputStream dataInputStream) throws IOException {
        Event event = new Event();
        try {
            if (n < 2) {
                event.setEventID(dataInputStream.readInt());
                event.setNodeID(dataInputStream.readChar());
                event.setThreadID(dataInputStream.readChar());
                event.setParameter(dataInputStream.readLong());
                event.setTime(dataInputStream.readLong());
            } else if (n == 2) {
                event = new Event();
                event.setEventID(TraceReader.intReverseBytes(dataInputStream.readInt()));
                event.setNodeID(TraceReader.charReverseBytes(dataInputStream.readChar()));
                event.setThreadID(TraceReader.charReverseBytes(dataInputStream.readChar()));
                event.setParameter(TraceReader.longReverseBytes(dataInputStream.readLong()));
                event.setTime(TraceReader.longReverseBytes(dataInputStream.readLong()));
            } else if (n == 3) {
                event = new Event();
                event.setEventID((int)dataInputStream.readLong());
                event.setNodeID(dataInputStream.readChar());
                event.setThreadID(dataInputStream.readChar());
                dataInputStream.readInt();
                event.setParameter(dataInputStream.readLong());
                event.setTime(dataInputStream.readLong());
            } else if (n == 4) {
                event = new Event();
                event.setEventID((int)TraceReader.longReverseBytes(dataInputStream.readLong()));
                event.setNodeID(TraceReader.charReverseBytes(dataInputStream.readChar()));
                event.setThreadID(TraceReader.charReverseBytes(dataInputStream.readChar()));
                dataInputStream.readInt();
                event.setParameter(TraceReader.longReverseBytes(dataInputStream.readLong()));
                event.setTime(TraceReader.longReverseBytes(dataInputStream.readLong()));
            }
        }
        catch (EOFException eOFException) {
            System.out.println("Reached end of trace file.");
            return null;
        }
        return event;
    }

    private boolean refreshTables(TraceReaderCallbacks traceReaderCallbacks, Object object) {
        boolean bl = false;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.EdfFile));
            String string = bufferedReader.readLine();
            String[] stringArray = string.split(" ");
            String string2 = stringArray[1];
            int n = Integer.parseInt(stringArray[0]);
            if (string2 != null && string2.equals("dynamic_trace_events")) {
                bl = true;
            }
            for (int i = 0; i < n; ++i) {
                String string3;
                String string4;
                long l;
                String string5;
                string = bufferedReader.readLine();
                if (string == null) {
                    int n2 = i - 1;
                    System.out.println("Warning: Expected " + n + " event definitions. Found " + n2);
                    return false;
                }
                if (string.charAt(0) == '\n' || string.charAt(0) == '#') {
                    --i;
                    continue;
                }
                int n3 = -1;
                if (bl) {
                    stringArray = string.split(" ");
                    n3 = Integer.parseInt(stringArray[0]);
                    string5 = stringArray[1];
                    l = Long.parseLong(stringArray[2]);
                    int n4 = string.indexOf(34);
                    int n5 = string.indexOf(34, n4 + 1);
                    string4 = string.substring(n4, n5 + 1);
                    string3 = string.substring(n5 + 2);
                    if (string4.startsWith("\"") && string4.endsWith("\"")) {
                        string4 = string4.substring(1, string4.length() - 1);
                    }
                    if (!this.EventIdMap.containsKey(new Integer(n3))) {
                        int n6;
                        EventDescr eventDescr = new EventDescr(n3, new String(string5), new String(string4), l, new String(string3));
                        this.EventIdMap.put(new Integer(n3), eventDescr);
                        if (!this.GroupIdMap.containsKey(eventDescr.getGroup())) {
                            n6 = this.GroupIdMap.size() + 1;
                            if (eventDescr.getParameter().equals("EntryExit")) {
                                this.GroupIdMap.put(eventDescr.getGroup(), new Integer(n6));
                                traceReaderCallbacks.defStateGroup(object, n6, eventDescr.getGroup());
                            }
                        } else {
                            n6 = (Integer)this.GroupIdMap.get(eventDescr.getGroup());
                        }
                        if (eventDescr.getParameter().equals("TriggerValue")) {
                            traceReaderCallbacks.defUserEvent(object, n3, eventDescr.getEventName(), (int)eventDescr.getTag());
                        } else if (eventDescr.getParameter().equals("EntryExit")) {
                            traceReaderCallbacks.defState(object, n3, eventDescr.getEventName(), n6);
                        }
                    }
                } else {
                    stringArray = string.split(" ");
                    n3 = Integer.parseInt(stringArray[0]);
                    string5 = stringArray[1];
                    l = Integer.parseInt(stringArray[2]);
                    string4 = stringArray[3];
                    if (string4 != null && string4.startsWith("\"") && string4.endsWith("\"")) {
                        string4 = string4.substring(1, string4.length() - 2);
                    }
                    string3 = stringArray[4];
                }
                if (n3 >= 0 && string4 != null) continue;
                System.out.println("Blurb error?");
                return false;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return true;
    }

    public void setSubtractFirstTimestamp(boolean bl) {
        this.subtractFirstTimestamp = bl;
    }

    public void setNonBlocking(boolean bl) {
        this.nonBlocking = bl;
    }

    public int absSeek(int n) {
        return 0;
    }

    public int relSeek(int n) {
        return 0;
    }

    public void setDefsOnly(boolean bl) {
        this.definitionsOnly = bl;
    }

    public boolean isDone() {
        return this.done;
    }

    public long peekTime() {
        if (this.totalRecords == this.totalRead) {
            return -1L;
        }
        this.Fiid.mark(64);
        Event event = null;
        try {
            event = TraceReader.readEvent(this.format, this.Fiid);
            this.Fiid.reset();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (event == null) {
            return -1L;
        }
        return event.getTime();
    }

    public int readNumEvents(TraceReaderCallbacks traceReaderCallbacks, int n, Object object) {
        int n2 = 0;
        if (!this.ClkInitialized) {
            this.refreshTables(traceReaderCallbacks, object);
            traceReaderCallbacks.defClkPeriod(object, 1.0E-6);
            if (this.definitionsOnly) {
                return 0;
            }
            this.ClkInitialized = true;
            this.FirstTimestamp = this.peekTime();
        }
        long l = n <= 0 ? this.totalRecords - this.totalRead : (long)n;
        String string = "";
        int n3 = 0;
        while ((long)n3 < l) {
            EventDescr eventDescr;
            Event event = null;
            try {
                event = TraceReader.readEvent(this.format, this.Fiid);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return -1;
            }
            if (event == null) break;
            ++n2;
            ++this.totalRead;
            Integer n4 = new Integer(TraceReader.CharPair(event.nid, event.tid));
            if (!this.nidTidSeen.contains(n4)) {
                string = "process " + event.nid + ":" + event.tid;
                traceReaderCallbacks.defThread(object, event.nid, event.tid, string);
                this.nidTidSeen.add(n4);
            }
            if (this.subtractFirstTimestamp) {
                event.time -= this.FirstTimestamp;
            }
            if ((eventDescr = (EventDescr)this.EventIdMap.get(new Integer(event.evid))) == null) {
                System.out.println("Warning: no event definiton for event ID " + event.evid);
            } else {
                if (eventDescr.getParameter() != null && eventDescr.getParameter().equals("EntryExit")) {
                    if (event.parameter == 1L) {
                        traceReaderCallbacks.enterState(object, event.time, event.nid, event.tid, event.evid);
                    } else if (event.parameter == -1L) {
                        traceReaderCallbacks.leaveState(object, event.time, event.nid, event.tid, event.evid);
                    }
                } else {
                    long l2;
                    long l3;
                    long l4;
                    long l5;
                    long l6;
                    long l7;
                    if (eventDescr.getParameter() != null && eventDescr.getParameter().equals("TriggerValue")) {
                        traceReaderCallbacks.eventTrigger(object, event.time, event.nid, event.tid, event.evid, event.parameter);
                    }
                    if (eventDescr.getTag() == -7L || eventDescr.getEventId() == 60007) {
                        l7 = event.parameter;
                        l6 = l7 >> 16 & 0xFFL | (l7 >> 48 & 0xFFL) << 8;
                        l5 = l7 >> 24 & 0xFFL | (l7 >> 56 & 0xFFL) << 8;
                        l4 = l7 & 0xFFFFL | l7 << 22 >> 54 << 16;
                        l3 = l7 << 16 >> 58;
                        l2 = event.parameter;
                        traceReaderCallbacks.sendMessage(object, event.time, event.nid, event.tid, (int)l5, (int)l2, (int)l4, (int)l6, (int)l3);
                    } else if (eventDescr.getTag() == -8L || eventDescr.getEventId() == 60008) {
                        l7 = event.parameter;
                        l6 = l7 >> 16 & 0xFFL | (l7 >> 48 & 0xFFL) << 8;
                        l5 = l7 >> 24 & 0xFFL | (l7 >> 56 & 0xFFL) << 8;
                        l4 = l7 & 0xFFFFL | l7 << 22 >> 54 << 16;
                        l3 = l7 << 16 >> 58;
                        l2 = event.parameter;
                        traceReaderCallbacks.recvMessage(object, event.time, (int)l5, (int)l2, event.nid, event.tid, (int)l4, (int)l6, (int)l3);
                    }
                }
                if (event.parameter == 0L && eventDescr.getEventName() != null && eventDescr.getEventName().equals("\"FLUSH_CLOSE\"")) {
                    this.nidTidDone.add(n4);
                } else if (event.parameter != 1L && event.parameter != -1L && eventDescr.getEventName() != null && eventDescr.getEventName().equals("\"WALL_CLOCK\"") && this.nidTidDone.contains(n4)) {
                    traceReaderCallbacks.endTrace(object, event.nid, event.tid);
                    this.done = true;
                    return n2;
                }
            }
            ++n3;
        }
        return n2;
    }

    public void closeTrace() {
        try {
            if (this.Fiid != null) {
                this.Fiid.close();
            } else {
                System.out.println("Warning: tried to close null file handle");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

