/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.common.PrintfFormat;
import edu.uoregon.tau.paraprof.DataSorter;
import edu.uoregon.tau.paraprof.PPFunctionProfile;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Thread;
import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfdmf.UtilFncs;
import java.util.ArrayList;
import java.util.List;

public class OSSWriter {
    public static void writeOSS(DataSource dataSource, boolean bl) {
        Trial trial = new Trial();
        trial.setDataSource(dataSource);
        ParaProfTrial paraProfTrial = new ParaProfTrial();
        DataSorter dataSorter = new DataSorter(paraProfTrial);
        int n = dataSource.getNumberOfMetrics();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Metric metric = dataSource.getMetric(i);
            if (!metric.isTimeMetric()) continue;
            n2 = i;
        }
        List<Thread> list = new ArrayList();
        if (!bl) {
            list = dataSource.getAllThreads();
        }
        if (dataSource.getAllThreads().size() > 1 || bl) {
            list.add(dataSource.getTotalData());
            list.add(dataSource.getMeanData());
        }
        for (int i = 0; i < list.size(); ++i) {
            Thread thread = (Thread)list.get(i);
            System.out.println("\n-------------------------------------------------------------------------------");
            if (thread.getNodeID() == -2) {
                System.out.println("Thread: Total");
            } else {
                System.out.println("Thread: " + thread);
            }
            System.out.println("-------------------------------------------------------------------------------");
            String string = " excl.secs  excl.%   cum.%";
            for (int j = 0; j < n; ++j) {
                if (j == n2) continue;
                Metric metric = trial.getDataSource().getMetric(j);
                String string2 = metric.getName();
                int n3 = Math.max(16, string2.length() + 2);
                string = string + UtilFncs.lpad((String)string2, (int)n3);
            }
            string = string + "     calls  function";
            System.out.println(string);
            List<PPFunctionProfile> list2 = dataSorter.getFunctionProfiles(thread);
            double d = 0.0;
            for (PPFunctionProfile pPFunctionProfile : list2) {
                FunctionProfile functionProfile = pPFunctionProfile.getFunctionProfile();
                double d2 = functionProfile.getExclusive(n2) / 1000.0 / 1000.0;
                double d3 = functionProfile.getExclusivePercent(n2);
                String string3 = new PrintfFormat("%10.3G ").sprintf(d2) + new PrintfFormat("%6.1f%% ").sprintf(d3) + new PrintfFormat("%6.1f%%").sprintf(d += d3);
                for (int j = 0; j < n; ++j) {
                    if (j == n2) continue;
                    double d4 = functionProfile.getExclusive(j);
                    Metric metric = trial.getDataSource().getMetric(j);
                    String string4 = metric.getName();
                    string3 = string3 + new PrintfFormat("%" + Math.max(16, string4.length() + 2) + ".0f").sprintf(d4);
                }
                string3 = string3 + new PrintfFormat("%10.0f").sprintf(functionProfile.getNumCalls());
                string3 = string3 + "  " + functionProfile.getName();
                System.out.println(string3);
            }
        }
    }
}

