/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.common.TauRuntimeException;
import edu.uoregon.tau.common.Utility;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.Group;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class SelectiveFileGenerator
extends JFrame {
    private static final long serialVersionUID = 363488285988461673L;
    private JCheckBox excludeThrottled = new JCheckBox("Exclude Throttled Routines", true);
    private JCheckBox excludeLightweight = new JCheckBox("Exclude Lightweight Routines", true);
    private JTextField percall = new JTextField("10");
    private JTextField numcalls = new JTextField("100000");
    private JTextArea excludedFunctions = new JTextArea();
    private JLabel location = new JLabel("Output File:");
    private JLabel percallLabel = new JLabel("Microseconds per call:");
    private JLabel numcallsLabel = new JLabel("Number of calls:");
    private JTextField fileLocation = new JTextField();
    private JButton chooseFileButton = new JButton("...");
    private JButton saveButton = new JButton("save");
    private JButton closeButton = new JButton("close");
    private JCheckBox mergeFile = new JCheckBox("Merge", true);
    private String lastDirectory;
    private ParaProfTrial ppTrial;

    public static void showWindow(ParaProfTrial paraProfTrial, JFrame jFrame) {
        SelectiveFileGenerator selectiveFileGenerator = new SelectiveFileGenerator(paraProfTrial, jFrame);
        selectiveFileGenerator.setVisible(true);
    }

    private void updateExcluded() {
        double d = 0.0;
        double d2 = 0.0;
        try {
            d = Double.parseDouble(this.numcalls.getText());
            d2 = Double.parseDouble(this.percall.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        StringBuffer stringBuffer = new StringBuffer();
        Group group = this.ppTrial.getGroup("TAU_DISABLE");
        Group group2 = this.ppTrial.getGroup("MPI");
        Group group3 = this.ppTrial.getGroup("TAU_CALLPATH");
        Group group4 = this.ppTrial.getGroup("TAU_SAMPLE");
        for (FunctionProfile functionProfile : this.ppTrial.getMeanThread().getFunctionProfiles()) {
            if (this.excludeThrottled.isSelected() && functionProfile.getFunction().isGroupMember(group)) {
                stringBuffer.append(ParaProfUtils.removeThrottledTag(ParaProfUtils.removeSourceLocation(functionProfile.getName())) + "\n");
                continue;
            }
            if (!this.excludeLightweight.isSelected() || functionProfile.getFunction().isGroupMember(group2) || functionProfile.getFunction().isGroupMember(group3) || functionProfile.getFunction().isGroupMember(group4) || !(functionProfile.getNumCalls() >= d) || !(functionProfile.getInclusivePerCall(0) <= d2)) continue;
            stringBuffer.append(ParaProfUtils.removeThrottledTag(ParaProfUtils.removeSourceLocation(functionProfile.getName())) + "\n");
        }
        this.excludedFunctions.setText(stringBuffer.toString());
    }

    public SelectiveFileGenerator(ParaProfTrial paraProfTrial, final JFrame jFrame) {
        this.ppTrial = paraProfTrial;
        this.setTitle("TAU: ParaProf: Selective Instrumentation File Generator");
        ParaProfUtils.setFrameIcon(this);
        int n = 650;
        int n2 = 520;
        this.setSize(new Dimension(n, n2));
        this.setResizable(true);
        this.excludeThrottled.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SelectiveFileGenerator.this.updateExcluded();
            }
        });
        this.excludeLightweight.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SelectiveFileGenerator.this.updateExcluded();
            }
        });
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        Utility.addCompItem((Container)this.getContentPane(), (Component)this.location, (GridBagConstraints)gridBagConstraints, (int)0, (int)0, (int)1, (int)1);
        gridBagConstraints.weightx = 1.0;
        Utility.addCompItem((Container)this.getContentPane(), (Component)this.fileLocation, (GridBagConstraints)gridBagConstraints, (int)1, (int)0, (int)1, (int)1);
        gridBagConstraints.weightx = 0.0;
        Utility.addCompItem((Container)this.getContentPane(), (Component)this.chooseFileButton, (GridBagConstraints)gridBagConstraints, (int)2, (int)0, (int)1, (int)1);
        gridBagConstraints.weightx = 1.0;
        Utility.addCompItem((Container)this.getContentPane(), (Component)this.excludeThrottled, (GridBagConstraints)gridBagConstraints, (int)0, (int)1, (int)3, (int)1);
        Utility.addCompItem((Container)this.getContentPane(), (Component)this.excludeLightweight, (GridBagConstraints)gridBagConstraints, (int)0, (int)2, (int)3, (int)1);
        final JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Lightweight Routine Exclusion Rules"));
        jPanel.setLayout(new GridBagLayout());
        this.percall.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
            }

            public void keyReleased(KeyEvent keyEvent) {
                SelectiveFileGenerator.this.updateExcluded();
            }

            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        this.numcalls.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
            }

            public void keyReleased(KeyEvent keyEvent) {
                SelectiveFileGenerator.this.updateExcluded();
            }

            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        gridBagConstraints.fill = 1;
        Utility.addCompItem((Container)jPanel, (Component)this.percallLabel, (GridBagConstraints)gridBagConstraints, (int)0, (int)0, (int)1, (int)1);
        Utility.addCompItem((Container)jPanel, (Component)this.percall, (GridBagConstraints)gridBagConstraints, (int)1, (int)0, (int)1, (int)1);
        Utility.addCompItem((Container)jPanel, (Component)this.numcallsLabel, (GridBagConstraints)gridBagConstraints, (int)0, (int)1, (int)1, (int)1);
        Utility.addCompItem((Container)jPanel, (Component)this.numcalls, (GridBagConstraints)gridBagConstraints, (int)1, (int)1, (int)1, (int)1);
        Utility.addCompItem((Container)this.getContentPane(), (Component)jPanel, (GridBagConstraints)gridBagConstraints, (int)0, (int)3, (int)3, (int)1);
        this.excludeLightweight.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SelectiveFileGenerator.setEnabledRecursively(jPanel, SelectiveFileGenerator.this.excludeLightweight.isSelected());
            }
        });
        this.lastDirectory = System.getProperty("user.dir");
        this.fileLocation.setText(this.lastDirectory + "/select.tau");
        this.chooseFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser(SelectiveFileGenerator.this.lastDirectory);
                jFileChooser.setSelectedFile(new File("select.tau"));
                jFileChooser.setFileSelectionMode(0);
                jFileChooser.setMultiSelectionEnabled(false);
                jFileChooser.setDialogTitle("Choose Output File");
                jFileChooser.setApproveButtonText("Select");
                if (jFileChooser.showOpenDialog(SelectiveFileGenerator.this) != 0) {
                    return;
                }
                SelectiveFileGenerator.this.lastDirectory = jFileChooser.getSelectedFile().getParent();
                SelectiveFileGenerator.this.fileLocation.setText(jFileChooser.getSelectedFile().getAbsolutePath());
            }
        });
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    File file = new File(SelectiveFileGenerator.this.fileLocation.getText());
                    FileOutputStream fileOutputStream = new FileOutputStream(file, SelectiveFileGenerator.this.mergeFile.isSelected());
                    OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream);
                    BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
                    bufferedWriter.write("\nBEGIN_EXCLUDE_LIST\n");
                    bufferedWriter.write(SelectiveFileGenerator.this.excludedFunctions.getText());
                    bufferedWriter.write("END_EXCLUDE_LIST\n\n");
                    bufferedWriter.close();
                    outputStreamWriter.close();
                    fileOutputStream.close();
                    JOptionPane.showMessageDialog(jFrame, "Selective Instrumentation file written to \"" + SelectiveFileGenerator.this.fileLocation.getText() + "\"");
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new TauRuntimeException((Exception)fileNotFoundException);
                }
                catch (IOException iOException) {
                    throw new TauRuntimeException((Exception)iOException);
                }
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SelectiveFileGenerator.this.setVisible(false);
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Excluded Routines"));
        jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        Utility.addCompItem((Container)jPanel2, (Component)new JScrollPane(this.excludedFunctions), (GridBagConstraints)gridBagConstraints, (int)0, (int)0, (int)1, (int)1);
        Utility.addCompItem((Container)this.getContentPane(), (Component)jPanel2, (GridBagConstraints)gridBagConstraints, (int)0, (int)4, (int)3, (int)1);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        Utility.addCompItem((Container)this.getContentPane(), (Component)this.saveButton, (GridBagConstraints)gridBagConstraints, (int)0, (int)5, (int)1, (int)1);
        Utility.addCompItem((Container)this.getContentPane(), (Component)this.mergeFile, (GridBagConstraints)gridBagConstraints, (int)1, (int)5, (int)1, (int)1);
        Utility.addCompItem((Container)this.getContentPane(), (Component)this.closeButton, (GridBagConstraints)gridBagConstraints, (int)2, (int)5, (int)1, (int)1);
        this.updateExcluded();
    }

    public static void setEnabledRecursively(Container container, boolean bl) {
        Component component;
        container.setEnabled(bl);
        if (container instanceof JPanel) {
            Color color = bl ? new Color(0, 0, 0) : new Color(128, 128, 128);
            component = (JPanel)container;
            ((TitledBorder)((JComponent)component).getBorder()).setTitleColor(color);
        }
        for (int i = 0; i < container.getComponentCount(); ++i) {
            component = container.getComponent(i);
            if (component instanceof Container) {
                SelectiveFileGenerator.setEnabledRecursively((Container)component, bl);
                continue;
            }
            component.setEnabled(bl);
        }
    }
}

