/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.common.ImageExport;
import edu.uoregon.tau.paraprof.PPFunctionProfile;
import edu.uoregon.tau.paraprof.PPUserEventProfile;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.Searcher;
import edu.uoregon.tau.paraprof.StatWindow;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.UserEvent;
import edu.uoregon.tau.perfdmf.UtilFncs;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JPanel;

public class StatWindowPanel
extends JPanel
implements MouseListener,
Printable,
ImageExport {
    private static final long serialVersionUID = -525538914597587767L;
    private int xPanelSize = 800;
    private int yPanelSize = 600;
    private int newYPanelSize = 0;
    private int startLocation = 0;
    private int maxFontAscent = 0;
    private int maxFontDescent = 0;
    private int spacing = 0;
    private ParaProfTrial ppTrial = null;
    private StatWindow window = null;
    private boolean userEventWindow;
    private List<PPUserEventProfile> uepList = new ArrayList<PPUserEventProfile>();
    private List<PPFunctionProfile> fpList = new ArrayList<PPFunctionProfile>();
    private Font monoFont = null;
    private FontMetrics fmMonoFont = null;
    private int lastHeaderEndPosition = 0;
    private int maxLinePixelWidth = 0;
    private Searcher searcher;
    private int charWidth = 0;
    private int xOffset = 20;

    public StatWindowPanel(ParaProfTrial paraProfTrial, StatWindow statWindow, boolean bl) {
        this.setSize(new Dimension(this.xPanelSize, this.yPanelSize));
        this.setBackground(Color.white);
        this.setAutoscrolls(true);
        this.searcher = new Searcher(this, statWindow);
        this.addMouseListener(this.searcher);
        this.addMouseMotionListener(this.searcher);
        this.ppTrial = paraProfTrial;
        this.window = statWindow;
        this.userEventWindow = bl;
        this.addMouseListener(this);
        this.repaint();
    }

    public void paintComponent(Graphics graphics) {
        try {
            super.paintComponent(graphics);
            this.export((Graphics2D)graphics, true, false, false);
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
            this.window.closeThisWindow();
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        try {
            if (n >= 1) {
                return 1;
            }
            ParaProfUtils.scaleForPrint(graphics, pageFormat, this.xPanelSize, this.yPanelSize);
            this.export((Graphics2D)graphics, false, true, false);
            return 0;
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
            return 1;
        }
    }

    public static String getUserEventStatStringHeading() {
        int n = 18;
        return UtilFncs.pad((String)"Total", (int)n) + UtilFncs.pad((String)"NumSamples", (int)n) + UtilFncs.pad((String)"Max", (int)n) + UtilFncs.pad((String)"Min", (int)n) + UtilFncs.pad((String)"Mean", (int)n) + UtilFncs.pad((String)"Std. Dev", (int)n);
    }

    public void setSearchLines(String string, String string2) {
        if (this.searcher.getSearchLines() == null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string2);
            arrayList.add(string);
            arrayList.add(string2);
            for (int i = 0; i < this.dataSize(); ++i) {
                String string3;
                String string4;
                if (this.userEventWindow) {
                    string4 = this.uepList.get(i).getUserEventName();
                    string3 = this.uepList.get(i).getUserEventStatString(ParaProf.defaultNumberPrecision);
                    string3 = string3 + string4;
                } else {
                    string4 = this.fpList.get(i).getDisplayName();
                    if (this.window.getPhase() != null) {
                        string4 = UtilFncs.getRightSide((String)string4);
                    }
                    string3 = this.fpList.get(i).getStatString(this.window.units());
                    string3 = string3 + "   " + string4;
                }
                this.maxLinePixelWidth = Math.max(this.maxLinePixelWidth, this.charWidth * string3.length() + this.xOffset);
                arrayList.add(string3);
            }
            this.searcher.setSearchLines(arrayList);
        }
    }

    private void setStatStringColor(Graphics2D graphics2D, PPUserEventProfile pPUserEventProfile, PPFunctionProfile pPFunctionProfile) {
        int n = -1;
        if (this.userEventWindow) {
            UserEvent userEvent = this.ppTrial.getHighlightedUserEvent();
            if (userEvent != null) {
                n = userEvent.getID();
            }
        } else {
            Function function = this.ppTrial.getHighlightedFunction();
            if (function != null) {
                n = function.getID();
            }
        }
        if (this.userEventWindow && pPUserEventProfile.getUserEvent().getID() == n || !this.userEventWindow && pPFunctionProfile.getFunction().getID() == n) {
            graphics2D.setColor(this.ppTrial.getColorChooser().getHighlightColor());
        } else if (!this.userEventWindow && pPFunctionProfile.isGroupMember(this.ppTrial.getHighlightedGroup())) {
            graphics2D.setColor(this.ppTrial.getColorChooser().getGroupHighlightColor());
        } else {
            graphics2D.setColor(Color.black);
        }
    }

    private int dataSize() {
        if (this.userEventWindow) {
            return this.uepList.size();
        }
        return this.fpList.size();
    }

    public void export(Graphics2D graphics2D, boolean bl, boolean bl2, boolean bl3) {
        Object object;
        Object object2;
        Object object3;
        if (this.userEventWindow) {
            this.uepList = this.window.getUserEventProfileData();
        } else {
            this.fpList = this.window.getFunctionProfileData();
        }
        if (this.dataSize() == 0) {
            return;
        }
        int n = 0;
        int n2 = this.ppTrial.getPreferencesWindow().getFontSize();
        this.monoFont = new Font("Monospaced", this.ppTrial.getPreferencesWindow().getFontStyle(), n2);
        this.fmMonoFont = graphics2D.getFontMetrics(this.monoFont);
        this.maxFontAscent = this.fmMonoFont.getMaxAscent();
        this.maxFontDescent = this.fmMonoFont.getMaxDescent();
        this.spacing = this.fmMonoFont.getHeight();
        graphics2D.setFont(this.monoFont);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        if (this.spacing <= this.maxFontAscent + this.maxFontDescent) {
            ++this.spacing;
        }
        this.searcher.setLineHeight(this.spacing);
        if (bl3) {
            object3 = this.getInsets();
            n += this.spacing;
            String string = this.window.getHeaderString();
            object2 = new StringTokenizer(string, "'\n'");
            while (((StringTokenizer)object2).hasMoreTokens()) {
                AttributedString attributedString = new AttributedString(((StringTokenizer)object2).nextToken());
                attributedString.addAttribute(TextAttribute.FONT, this.monoFont);
                AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
                LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedCharacterIterator, fontRenderContext);
                float f = this.getSize().width - ((Insets)object3).left - ((Insets)object3).right;
                float f2 = ((Insets)object3).left;
                while (lineBreakMeasurer.getPosition() < attributedCharacterIterator.getEndIndex()) {
                    object = lineBreakMeasurer.nextLayout(f);
                    ((TextLayout)object).draw(graphics2D, f2, n += this.spacing);
                    f2 = ((Insets)object3).left;
                }
            }
            this.lastHeaderEndPosition = n;
        }
        object3 = this.userEventWindow ? StatWindowPanel.getUserEventStatStringHeading() : (this.ppTrial.isTimeMetric() ? PPFunctionProfile.getStatStringHeading("Time") : PPFunctionProfile.getStatStringHeading("Counts"));
        int n3 = this.fmMonoFont.stringWidth((String)object3) + this.xOffset;
        object3 = (String)object3 + "Name";
        object2 = "";
        for (int i = 0; i < ((String)object3).length(); ++i) {
            object2 = (String)object2 + "-";
        }
        this.charWidth = this.fmMonoFont.stringWidth("A");
        this.setSearchLines((String)object3, (String)object2);
        this.searcher.setG2d(graphics2D);
        this.searcher.setXOffset(this.xOffset);
        graphics2D.setColor(Color.black);
        this.searcher.drawHighlights(graphics2D, this.xOffset, n += this.spacing, 0);
        graphics2D.setColor(Color.black);
        graphics2D.drawString((String)object2, this.xOffset, n);
        this.searcher.drawHighlights(graphics2D, this.xOffset, n += this.spacing, 1);
        graphics2D.setColor(Color.black);
        graphics2D.drawString((String)object3, this.xOffset, n);
        this.searcher.drawHighlights(graphics2D, this.xOffset, n += this.spacing, 2);
        graphics2D.setColor(Color.black);
        graphics2D.drawString((String)object2, this.xOffset, n);
        if (bl) {
            this.startLocation = n;
        }
        this.newYPanelSize = n + (this.dataSize() + 1) * this.spacing;
        int[] nArray = ParaProfUtils.computeClipping(graphics2D.getClipBounds(), this.window.getViewRect(), bl, bl2, this.dataSize(), this.spacing, n);
        int n4 = nArray[0];
        int n5 = nArray[1];
        n = nArray[2];
        this.searcher.setVisibleLines(n4, n5);
        for (int i = n4; i <= n5; ++i) {
            String string;
            Color color;
            String string2;
            object = null;
            PPUserEventProfile pPUserEventProfile = null;
            if (this.userEventWindow) {
                pPUserEventProfile = this.uepList.get(i);
                string2 = pPUserEventProfile.getUserEventStatString(ParaProf.defaultNumberPrecision);
            } else {
                object = this.fpList.get(i);
                string2 = ((PPFunctionProfile)object).getStatString(this.window.units());
            }
            n += this.spacing;
            if (this.userEventWindow) {
                color = pPUserEventProfile.getColor();
                string = pPUserEventProfile.getUserEventName();
            } else {
                color = ((PPFunctionProfile)object).getColor();
                string = ((PPFunctionProfile)object).getDisplayName();
                if (this.window.getPhase() != null) {
                    string = UtilFncs.getRightSide((String)string);
                }
            }
            this.searcher.drawHighlights(graphics2D, this.xOffset, n, i + 3);
            this.setStatStringColor(graphics2D, pPUserEventProfile, (PPFunctionProfile)object);
            new TextLayout(string2, this.monoFont, fontRenderContext).draw(graphics2D, this.xOffset, n);
            graphics2D.setColor(color);
            new TextLayout(string, this.monoFont, fontRenderContext).draw(graphics2D, n3, n);
        }
        if (this.newYPanelSize != this.yPanelSize || this.maxLinePixelWidth >= this.xPanelSize) {
            this.yPanelSize = this.newYPanelSize + 1;
            this.xPanelSize = this.maxLinePixelWidth + 5;
            this.revalidate();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        try {
            int n = mouseEvent.getY();
            int n2 = n - this.startLocation;
            int n3 = n2 / this.spacing;
            int n4 = (n3 + 1) * this.spacing;
            int n5 = n4 - this.maxFontAscent;
            if (n2 >= n5 && n2 <= n4 && n3 < this.dataSize()) {
                if (this.userEventWindow) {
                    PPUserEventProfile pPUserEventProfile = null;
                    pPUserEventProfile = this.uepList.get(n3);
                    if (ParaProfUtils.rightClick(mouseEvent)) {
                        ParaProfUtils.handleUserEventClick(this.ppTrial, pPUserEventProfile.getUserEvent(), this, mouseEvent);
                    } else {
                        this.ppTrial.toggleHighlightedUserEvent(pPUserEventProfile.getUserEvent());
                    }
                } else {
                    PPFunctionProfile pPFunctionProfile = null;
                    pPFunctionProfile = this.fpList.get(n3);
                    if (ParaProfUtils.rightClick(mouseEvent)) {
                        ParaProfUtils.createFunctionClickPopUp(this.ppTrial, pPFunctionProfile.getFunction(), pPFunctionProfile.getThread(), this).show(this, mouseEvent.getX(), mouseEvent.getY());
                    } else {
                        this.ppTrial.toggleHighlightedFunction(pPFunctionProfile.getFunction());
                    }
                }
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void resetStringSize() {
        this.maxLinePixelWidth = 0;
        this.searcher.setSearchLines(null);
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public Dimension getImageSize(boolean bl, boolean bl2) {
        Dimension dimension = null;
        dimension = bl ? this.getSize() : this.window.getSize();
        dimension.setSize(dimension.getWidth(), dimension.getHeight() + (double)this.lastHeaderEndPosition);
        return dimension;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.xPanelSize, this.yPanelSize + 10);
    }

    public Searcher getSearcher() {
        return this.searcher;
    }
}

