/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import com.graphbuilder.math.Expression;
import com.graphbuilder.math.ExpressionTree;
import com.graphbuilder.math.FuncMap;
import com.graphbuilder.math.VarMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreeDeeGeneralPlotUtils {
    static final String BEGIN = "BEGIN_VIZ";
    static final String END = "END_VIZ";

    public static VarMap getEvaluation(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, float[] fArray5, int[] nArray, Map<String, String> map) {
        FuncMap funcMap = new FuncMap();
        funcMap.loadDefaultFunctions();
        VarMap varMap = new VarMap(false);
        varMap.setValue("maxRank", (double)n2);
        varMap.setValue("rank", (double)n);
        varMap.setValue("color", (double)fArray[3]);
        varMap.setValue("node", (double)n3);
        varMap.setValue("context", (double)n4);
        varMap.setValue("thread", (double)n5);
        varMap.setValue("event0.val", (double)fArray[0]);
        varMap.setValue("event1.val", (double)fArray[1]);
        varMap.setValue("event2.val", (double)fArray[2]);
        varMap.setValue("event3.val", (double)fArray[3]);
        varMap.setValue("event0.min", (double)fArray2[0]);
        varMap.setValue("event1.min", (double)fArray2[1]);
        varMap.setValue("event2.min", (double)fArray2[2]);
        varMap.setValue("event3.min", (double)fArray2[3]);
        varMap.setValue("event0.max", (double)fArray3[0]);
        varMap.setValue("event1.max", (double)fArray3[1]);
        varMap.setValue("event2.max", (double)fArray3[2]);
        varMap.setValue("event3.max", (double)fArray3[3]);
        varMap.setValue("event0.mean", (double)fArray4[0]);
        varMap.setValue("event1.mean", (double)fArray4[1]);
        varMap.setValue("event2.mean", (double)fArray4[2]);
        varMap.setValue("event3.mean", (double)fArray4[3]);
        varMap.setValue("atomic0", (double)fArray5[0]);
        varMap.setValue("atomic1", (double)fArray5[1]);
        varMap.setValue("atomic2", (double)fArray5[2]);
        varMap.setValue("atomic3", (double)fArray5[3]);
        varMap.setValue("axisDimX", (double)nArray[0]);
        varMap.setValue("axisDimY", (double)nArray[1]);
        varMap.setValue("axisDimZ", (double)nArray[2]);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            Expression expression = ExpressionTree.parse((String)entry.getValue());
            double d = expression.eval(varMap, funcMap);
            varMap.setValue(entry.getKey(), d);
        }
        return varMap;
    }

    private static String[] splitEQ(String string) {
        String[] stringArray = new String[2];
        int n = string.indexOf(61);
        stringArray[0] = string.substring(0, n).trim();
        stringArray[1] = string.substring(n + 1).trim();
        return stringArray;
    }

    public static Map<String, String> getExpressions(String string, String string2) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        try {
            String string3;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(string)));
            boolean bl = false;
            while ((string3 = bufferedReader.readLine()) != null) {
                if (!bl && string3.startsWith(BEGIN) && ThreeDeeGeneralPlotUtils.splitEQ(string3)[1].equals(string2)) {
                    bl = true;
                    continue;
                }
                if (!bl) continue;
                if (!string3.equals(END)) {
                    if (!string3.contains("=") || string3.startsWith("#")) continue;
                    String[] stringArray = ThreeDeeGeneralPlotUtils.splitEQ(string3);
                    linkedHashMap.put(stringArray[0], stringArray[1]);
                    continue;
                }
                break;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return linkedHashMap;
    }

    public static boolean checkSet(VarMap varMap, String string) {
        String[] stringArray = varMap.getVariableNames();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public static int getPointsPerRank(VarMap varMap) {
        int n = 0;
        boolean bl = ThreeDeeGeneralPlotUtils.checkSet(varMap, "x");
        if (!bl) {
            bl = true;
            while (bl && (bl = ThreeDeeGeneralPlotUtils.checkSet(varMap, "x" + n))) {
                ++n;
            }
        }
        return n;
    }

    public static double[][] getRankCoordinate(VarMap varMap, int n, boolean bl) {
        double[][] dArray = null;
        if (n == 0) {
            dArray = new double[1][4];
            dArray[0][0] = varMap.getValue("x");
            dArray[0][1] = varMap.getValue("y");
            dArray[0][2] = varMap.getValue("z");
            dArray[0][3] = varMap.getValue("color");
        } else {
            dArray = new double[n][4];
            --n;
            for (int i = 0; i <= n; ++i) {
                dArray[i][0] = varMap.getValue("x" + i);
                dArray[i][1] = varMap.getValue("y" + i);
                dArray[i][2] = varMap.getValue("z" + i);
                dArray[i][3] = bl ? varMap.getValue("color" + i) : varMap.getValue("color");
            }
        }
        return dArray;
    }

    public static int[] parseTuple(String string) {
        string = string.substring(1, string.length() - 1);
        String[] stringArray = string.split(",");
        int[] nArray = new int[3];
        for (int i = 0; i < stringArray.length; ++i) {
            nArray[i] = i <= stringArray.length ? Integer.parseInt(stringArray[i]) : 0;
        }
        return nArray;
    }

    public static List<String> getCustomTopoNames(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(string)));
            while ((string2 = bufferedReader.readLine()) != null) {
                if (!string2.startsWith(BEGIN)) continue;
                int n = string2.indexOf(61);
                String string3 = string2.substring(n + 1);
                arrayList.add(string3);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return arrayList;
    }
}

