/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import com.graphbuilder.math.VarMap;
import edu.uoregon.tau.paraprof.DataSorter;
import edu.uoregon.tau.paraprof.PPFunctionProfile;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfMetric;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.ThreeDeeControlPanel;
import edu.uoregon.tau.paraprof.ThreeDeeGeneralPlotUtils;
import edu.uoregon.tau.paraprof.ThreeDeeImageProvider;
import edu.uoregon.tau.paraprof.ThreeDeeSettings;
import edu.uoregon.tau.paraprof.WindowPlacer;
import edu.uoregon.tau.paraprof.enums.SortType;
import edu.uoregon.tau.paraprof.enums.UserEventValueType;
import edu.uoregon.tau.paraprof.enums.ValueType;
import edu.uoregon.tau.paraprof.enums.VisType;
import edu.uoregon.tau.paraprof.graph.Layout;
import edu.uoregon.tau.paraprof.graph.Vertex;
import edu.uoregon.tau.paraprof.interfaces.ParaProfWindow;
import edu.uoregon.tau.paraprof.interfaces.SortListener;
import edu.uoregon.tau.paraprof.interfaces.UnitListener;
import edu.uoregon.tau.perfdmf.CallPathUtilFuncs;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Thread;
import edu.uoregon.tau.perfdmf.UserEvent;
import edu.uoregon.tau.perfdmf.UserEventProfile;
import edu.uoregon.tau.perfdmf.UtilFncs;
import edu.uoregon.tau.vis.Axes;
import edu.uoregon.tau.vis.BarPlot;
import edu.uoregon.tau.vis.ColorScale;
import edu.uoregon.tau.vis.ExceptionHandler;
import edu.uoregon.tau.vis.Plot;
import edu.uoregon.tau.vis.ScatterPlot;
import edu.uoregon.tau.vis.Shape;
import edu.uoregon.tau.vis.TopoPlot;
import edu.uoregon.tau.vis.TriangleMeshPlot;
import edu.uoregon.tau.vis.Vec;
import edu.uoregon.tau.vis.VisCanvas;
import edu.uoregon.tau.vis.VisCanvasListener;
import edu.uoregon.tau.vis.VisRenderer;
import edu.uoregon.tau.vis.VisTools;
import edu.uoregon.tau.vis.XmasTree;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Stack;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreeDeeWindow
extends JFrame
implements ActionListener,
KeyListener,
Observer,
Printable,
ParaProfWindow,
UnitListener,
SortListener,
VisCanvasListener,
ThreeDeeImageProvider {
    private static final long serialVersionUID = 5841023264079846115L;
    private final int defaultToScatter = 4000;
    private VisCanvas visCanvas;
    private VisRenderer visRenderer = new VisRenderer();
    private Plot plot;
    private Axes axes;
    private ColorScale colorScale = new ColorScale();
    private ParaProfTrial ppTrial;
    private JMenu optionsMenu = null;
    private DataSorter dataSorter;
    private ThreeDeeControlPanel controlPanel;
    private ThreeDeeSettings settings = new ThreeDeeSettings();
    private ThreeDeeSettings oldSettings;
    private Timer fpsTimer;
    private JSplitPane jSplitPane;
    private TriangleMeshPlot triangleMeshPlot;
    private BarPlot barPlot;
    private ScatterPlot scatterPlot;
    private TopoPlot topoPlot;
    private Axes fullDataPlotAxes;
    private Axes scatterPlotAxes;
    private List<String> functionNames;
    private List<String> threadNames;
    private List<Function> functions;
    private List<Thread> threads;
    private int units = ParaProf.preferences.getUnits();
    float minHeightValue = 0.0f;
    float minColorValue = 0.0f;
    float maxHeightValue = 0.0f;
    float maxColorValue = 0.0f;
    float[] minScatterValues;
    float[] maxScatterValues;
    int[] tsizes = new int[]{0, 0, 0};
    boolean restrict = false;
    private long lastCall = 0L;

    public ThreeDeeWindow(ParaProfTrial paraProfTrial, Component component) {
        Object object;
        VisTools.setSwingExceptionHandler((ExceptionHandler)new ExceptionHandler(){

            public void handleException(Exception exception) {
                ParaProfUtils.handleException(exception);
            }
        });
        this.ppTrial = paraProfTrial;
        this.settings.setColorMetric(paraProfTrial.getDefaultMetric());
        this.settings.setHeightMetric(paraProfTrial.getDefaultMetric());
        this.settings.setScatterMetric(paraProfTrial.getDefaultMetric(), 0);
        this.settings.setScatterMetric(paraProfTrial.getDefaultMetric(), 1);
        this.settings.setScatterMetric(paraProfTrial.getDefaultMetric(), 2);
        this.settings.setScatterMetric(paraProfTrial.getDefaultMetric(), 3);
        this.settings.setTopoMetric(paraProfTrial.getDefaultMetric(), 0);
        this.settings.setTopoMetric(paraProfTrial.getDefaultMetric(), 1);
        this.settings.setTopoMetric(paraProfTrial.getDefaultMetric(), 2);
        this.settings.setTopoMetric(paraProfTrial.getDefaultMetric(), 3);
        Vector<String> vector = paraProfTrial.getTopologyArray();
        String string = null;
        if (vector != null && vector.size() > 0) {
            string = (String)vector.get(0);
        }
        if (string != null) {
            this.settings.setTopoCart(string);
        } else {
            this.settings.setTopoCart("Custom");
        }
        this.dataSorter = new DataSorter(paraProfTrial);
        this.dataSorter.setSortType(SortType.NAME);
        this.setTitle("TAU: ParaProf: 3D Visualizer: " + paraProfTrial.getTrialIdentifier(ParaProf.preferences.getShowPathTitleInReverse()));
        ParaProfUtils.setFrameIcon(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ThreeDeeWindow.this.thisWindowClosing(windowEvent);
            }
        });
        this.setupMenus();
        this.validate();
        String string2 = System.getProperty("os.name").toLowerCase();
        String string3 = System.getProperty("os.arch").toLowerCase();
        if (string2.startsWith("linux") && string3.equals("ia64")) {
            this.setVisible(true);
        }
        DataSource dataSource = paraProfTrial.getDataSource();
        int n = dataSource.getNumThreads();
        DataSorter dataSorter = new DataSorter(paraProfTrial);
        dataSorter.setSelectedMetric(paraProfTrial.getDefaultMetric());
        dataSorter.setDescendingOrder(true);
        List<PPFunctionProfile> list = dataSorter.getFunctionProfiles(dataSource.getStdDevData());
        int n2 = 0;
        Object object2 = list.iterator();
        while (object2.hasNext() && n2 < 4) {
            object = object2.next();
            if (((PPFunctionProfile)object).isCallPathObject()) continue;
            if (n2 == 0) {
                this.settings.setTopoFunction(((PPFunctionProfile)object).getFunction(), 3);
            }
            this.settings.setScatterFunction(((PPFunctionProfile)object).getFunction(), n2);
            ++n2;
        }
        if (n > 4000) {
            this.settings.setVisType(VisType.SCATTER_PLOT);
        }
        this.generate3dModel(true, this.settings);
        this.oldSettings = (ThreeDeeSettings)this.settings.clone();
        this.visRenderer.addShape((Shape)this.plot);
        this.visRenderer.addShape((Shape)this.colorScale);
        this.visRenderer.setVisCanvasListener((VisCanvasListener)this);
        this.visCanvas = new VisCanvas(this.visRenderer);
        this.visCanvas.addKeyListener((KeyListener)this);
        object2 = new JPanel(){
            private static final long serialVersionUID = 7050395373997175369L;

            public Dimension getMinimumSize() {
                return new Dimension(10, 10);
            }
        };
        ((Component)object2).addKeyListener(this);
        ((Container)object2).setLayout(new GridBagLayout());
        object = new GridBagConstraints();
        ((GridBagConstraints)object).fill = 1;
        ((GridBagConstraints)object).anchor = 17;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).weighty = 1.0;
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).gridwidth = 1;
        ((GridBagConstraints)object).gridheight = 1;
        ((Container)object2).add((Component)this.visCanvas.getActualCanvas(), object);
        ((JComponent)object2).setPreferredSize(new Dimension(5, 5));
        this.controlPanel = new ThreeDeeControlPanel(this, this.settings, paraProfTrial, this.visRenderer);
        this.jSplitPane = new JSplitPane(1, (Component)object2, this.controlPanel);
        this.jSplitPane.setContinuousLayout(true);
        this.jSplitPane.setResizeWeight(1.0);
        this.jSplitPane.setOneTouchExpandable(true);
        this.jSplitPane.addKeyListener(this);
        this.getContentPane().add(this.jSplitPane);
        this.setSize(ParaProfUtils.checkSize(new Dimension(1000, 750)));
        this.setLocation(WindowPlacer.getNewLocation(this, component));
        if (string2.startsWith("linux") && string3.equals("ia64")) {
            this.validate();
        }
        this.setVisible(true);
        if (System.getProperty("vis.fps") != null) {
            this.fpsTimer = new Timer(1000, this);
            this.fpsTimer.start();
        }
        ParaProf.incrementNumWindows();
        paraProfTrial.addObserver(this);
    }

    public static ThreeDeeWindow createThreeDeeWindow(ParaProfTrial paraProfTrial, JFrame jFrame) {
        return new ThreeDeeWindow(paraProfTrial, jFrame);
    }

    private void generateScatterPlot(boolean bl, ThreeDeeSettings threeDeeSettings) {
        Function[] functionArray = threeDeeSettings.getScatterFunctions();
        ValueType[] valueTypeArray = threeDeeSettings.getScatterValueTypes();
        Metric[] metricArray = threeDeeSettings.getScatterMetrics();
        DataSource dataSource = this.ppTrial.getDataSource();
        int n = dataSource.getNumThreads();
        float[][] fArray = new float[n][4];
        int n2 = 0;
        this.minScatterValues = new float[4];
        this.maxScatterValues = new float[4];
        for (int i = 0; i < 4; ++i) {
            this.minScatterValues[i] = Float.MAX_VALUE;
        }
        for (Thread thread : this.ppTrial.getDataSource().getAllThreads()) {
            for (int i = 0; i < functionArray.length; ++i) {
                FunctionProfile functionProfile;
                if (functionArray[i] == null || (functionProfile = thread.getFunctionProfile(functionArray[i])) == null) continue;
                fArray[n2][i] = (float)valueTypeArray[i].getValue(functionProfile, metricArray[i], this.ppTrial.getSelectedSnapshot());
                this.maxScatterValues[i] = Math.max(this.maxScatterValues[i], fArray[n2][i]);
                this.minScatterValues[i] = Math.min(this.minScatterValues[i], fArray[n2][i]);
            }
            ++n2;
        }
        if (this.scatterPlotAxes == null) {
            this.scatterPlotAxes = new Axes();
        }
        this.setAxisStrings();
        this.axes = this.scatterPlotAxes;
        if (this.scatterPlot == null) {
            this.scatterPlot = new ScatterPlot();
            if (n > 4000) {
                this.scatterPlot.setSphereSize(0.0f);
            }
        }
        this.scatterPlot.setSize(15.0f, 15.0f, 15.0f);
        this.scatterPlot.setAxes(this.axes);
        this.scatterPlot.setValues(fArray);
        this.scatterPlot.setColorScale(this.colorScale);
        this.plot = this.scatterPlot;
    }

    private void generateGeneralPlot(boolean bl, ThreeDeeSettings threeDeeSettings) {
        this.minScatterValues = new float[4];
        this.maxScatterValues = new float[4];
        for (int i = 0; i < 4; ++i) {
            this.minScatterValues[i] = Float.MAX_VALUE;
            this.maxScatterValues[i] = Float.MIN_VALUE;
        }
        DataSource dataSource = this.ppTrial.getDataSource();
        int n = dataSource.getNumThreads();
        float[][] fArray = this.defaultTopology(n);
        if (this.scatterPlotAxes == null) {
            this.scatterPlotAxes = new Axes();
        }
        this.setAxisStrings();
        this.axes = this.scatterPlotAxes;
        if (this.topoPlot == null) {
            this.topoPlot = new TopoPlot();
            if (n > 4000) {
                this.topoPlot.setSphereSize(0.0f);
            }
        }
        this.topoPlot.setMinMax(this.minScatterValues, this.maxScatterValues);
        if (this.restrict) {
            this.topoPlot.setSize(15.0f, 15.0f, 15.0f);
        } else {
            this.topoPlot.setSize((float)this.tsizes[0], (float)this.tsizes[1], (float)this.tsizes[2]);
        }
        this.topoPlot.setIsTopo(true);
        this.topoPlot.setAxes(this.axes);
        this.topoPlot.setTopoVis(threeDeeSettings.getTopoVisAxes());
        this.topoPlot.setValues(fArray);
        this.topoPlot.setColorScale(this.colorScale);
        this.topoPlot.setVisRange(threeDeeSettings.getMinTopoRange(), threeDeeSettings.getMaxTopoRange());
        this.plot = this.topoPlot;
    }

    private float[][] defaultTopology(int n) {
        float[][] fArray = new float[n][4];
        String string = this.settings.getTopoCart();
        if (string == null || string.equals("Custom")) {
            Function function = this.settings.getTopoFunction(3);
            ValueType valueType = this.settings.getTopoValueType(3);
            Metric metric = this.settings.getTopoMetric(3);
            int n2 = this.settings.getCustomTopoAxis(0);
            int n3 = this.settings.getCustomTopoAxis(1);
            int n4 = this.settings.getCustomTopoAxis(2);
            if (n2 <= 0) {
                n2 = 1;
            }
            if (n3 <= 0) {
                n3 = 1;
            }
            if (n3 <= 0) {
                n3 = 1;
            }
            if (n2 * n3 * n4 < n) {
                n4 = (int)Math.ceil((double)n / (double)n2 / (double)n3);
            }
            int n5 = 0;
            for (Thread thread : this.ppTrial.getDataSource().getAllThreads()) {
                for (int i = 0; i < 4; ++i) {
                    FunctionProfile functionProfile;
                    if (i == 0) {
                        fArray[n5][i] = n5 % n2;
                    }
                    if (i == 1) {
                        fArray[n5][i] = n5 / n2 % n3;
                    } else if (i == 2) {
                        fArray[n5][i] = n5 / n2 / n3 % n4;
                    } else if (i == 3 && function != null && (functionProfile = thread.getFunctionProfile(function)) != null) {
                        fArray[n5][3] = (float)valueType.getValue(functionProfile, metric, this.ppTrial.getSelectedSnapshot());
                        this.maxScatterValues[3] = Math.max(this.maxScatterValues[3], fArray[n5][3]);
                        this.minScatterValues[3] = Math.min(this.minScatterValues[3], fArray[n5][3]);
                    }
                    this.maxScatterValues[i] = Math.max(this.maxScatterValues[i], fArray[n5][i]);
                    this.minScatterValues[i] = Math.min(this.minScatterValues[i], fArray[n5][i]);
                }
                ++n5;
            }
            for (int i = 0; i < 3; ++i) {
                this.tsizes[i] = (int)this.maxScatterValues[i];
            }
        } else if (this.settings.isCustomTopo()) {
            ValueType valueType;
            Metric metric;
            FunctionProfile functionProfile;
            Function function;
            int n6;
            Thread thread2;
            String string2 = this.settings.getTopoDefFile();
            Map<String, String> map = ThreeDeeGeneralPlotUtils.getExpressions(string2, string);
            int n7 = this.settings.getCustomTopoAxis(0);
            int n8 = this.settings.getCustomTopoAxis(1);
            int n9 = this.settings.getCustomTopoAxis(2);
            if (n7 <= 0) {
                n7 = 1;
            }
            if (n8 <= 0) {
                n8 = 1;
            }
            if (n8 <= 0) {
                n8 = 1;
            }
            if (n7 * n8 * n9 < n) {
                n9 = (int)Math.ceil((double)n / (double)n7 / (double)n8);
            }
            float[] fArray2 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
            float[] fArray3 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
            boolean bl = true;
            for (Thread thread2 : this.ppTrial.getDataSource().getAllThreads()) {
                for (n6 = 0; n6 < 4; ++n6) {
                    function = this.settings.getScatterFunctions()[n6];
                    if (function == null || (functionProfile = thread2.getFunctionProfile(function)) == null) continue;
                    metric = this.settings.getScatterMetrics()[n6];
                    valueType = this.settings.getScatterValueTypes()[n6];
                    if (bl) {
                        fArray2[n6] = (float)valueType.getValue(functionProfile, metric, this.ppTrial.getSelectedSnapshot());
                        fArray3[n6] = (float)valueType.getValue(functionProfile, metric, this.ppTrial.getSelectedSnapshot());
                        bl = false;
                        continue;
                    }
                    fArray2[n6] = Math.min(fArray2[n6], (float)valueType.getValue(functionProfile, metric, this.ppTrial.getSelectedSnapshot()));
                    fArray3[n6] = Math.max(fArray3[n6], (float)valueType.getValue(functionProfile, metric, this.ppTrial.getSelectedSnapshot()));
                }
            }
            Object object = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
            thread2 = this.ppTrial.getMeanThread();
            for (n6 = 0; n6 < 4; ++n6) {
                function = this.settings.getScatterFunctions()[n6];
                if (function == null || (functionProfile = thread2.getFunctionProfile(function)) == null) continue;
                metric = this.settings.getScatterMetrics()[n6];
                valueType = this.settings.getScatterValueTypes()[n6];
                object[n6] = (float)valueType.getValue(functionProfile, metric, this.ppTrial.getSelectedSnapshot());
            }
            n6 = 0;
            int n10 = 0;
            functionProfile = null;
            int n11 = -1;
            int n12 = 1;
            for (Thread thread3 : this.ppTrial.getDataSource().getAllThreads()) {
                boolean bl2;
                Object object2;
                Metric metric2;
                Object object3;
                float[] fArray4 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                for (int i = 0; i < 4; ++i) {
                    Function function2 = this.settings.getTopoFunction(i);
                    if (function2 == null || (object3 = thread3.getFunctionProfile(function2)) == null) continue;
                    metric2 = this.settings.getTopoMetric(i);
                    object2 = this.settings.getTopoValueType(i);
                    fArray4[i] = (float)((ValueType)object2).getValue((FunctionProfile)object3, metric2, this.ppTrial.getSelectedSnapshot());
                }
                float[] fArray5 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                for (bl2 = false; bl2 < 4 != 0; bl2 += 1) {
                    object3 = this.settings.getTopoAtomic(bl2 ? 1 : 0);
                    if (object3 == null || (metric2 = thread3.getUserEventProfile((UserEvent)object3)) == null || (object2 = this.settings.getTopoUserEventValueType(bl2 ? 1 : 0)) == null) continue;
                    fArray5[bl2] = (float)((UserEventValueType)object2).getValue((UserEventProfile)metric2, this.ppTrial.getSelectedSnapshot());
                }
                functionProfile = ThreeDeeGeneralPlotUtils.getEvaluation(n6, n, thread3.getNodeID(), thread3.getContextID(), thread3.getThreadID(), this.ppTrial.getDataSource().getNumberOfNodes(), this.ppTrial.getDataSource().getNumberOfContexts(thread3.getNodeID()), this.ppTrial.getDataSource().getNumberOfThreads(thread3.getNodeID(), thread3.getContextID()), fArray4, fArray2, fArray3, (float[])object, fArray5, this.settings.getCustomTopoAxes(), map);
                if (n11 == -1 && (n11 = ThreeDeeGeneralPlotUtils.getPointsPerRank((VarMap)functionProfile)) > 1) {
                    fArray = new float[n * n11][4];
                    n12 = n11;
                }
                bl2 = ThreeDeeGeneralPlotUtils.checkSet((VarMap)functionProfile, "color0");
                object3 = ThreeDeeGeneralPlotUtils.getRankCoordinate((VarMap)functionProfile, n11, bl2);
                for (int i = 0; i < n12; ++i) {
                    for (int j = 0; j < 4; ++j) {
                        fArray[n10 + i][j] = (float)object3[i][j];
                        this.maxScatterValues[j] = Math.max(this.maxScatterValues[j], fArray[n10 + i][j]);
                        this.minScatterValues[j] = Math.min(this.minScatterValues[j], fArray[n10 + i][j]);
                    }
                }
                n10 += n12;
                ++n6;
            }
            this.restrict = ThreeDeeGeneralPlotUtils.checkSet((VarMap)functionProfile, "restrictDim");
            for (int i = 0; i < 3; ++i) {
                this.tsizes[i] = (int)this.maxScatterValues[i];
            }
        } else {
            int n13;
            String string3 = string + " Coords";
            String string4 = string + " Size";
            String string5 = (String)this.ppTrial.getDataSource().getMetaData().get(string4);
            this.tsizes = ThreeDeeGeneralPlotUtils.parseTuple(string5);
            for (n13 = 0; n13 < 3; ++n13) {
                this.maxScatterValues[n13] = this.tsizes[n13];
                this.minScatterValues[n13] = 0.0f;
            }
            n13 = 0;
            for (Thread thread : this.ppTrial.getDataSource().getAllThreads()) {
                FunctionProfile functionProfile;
                String string6 = (String)thread.getMetaData().get(string3);
                if (string6 == null) continue;
                int[] nArray = ThreeDeeGeneralPlotUtils.parseTuple(string6);
                fArray[n13][0] = nArray[0];
                fArray[n13][1] = nArray[1];
                fArray[n13][2] = nArray[2];
                Function function = this.settings.getTopoFunction(3);
                ValueType valueType = this.settings.getTopoValueType(3);
                Metric metric = this.settings.getTopoMetric(3);
                if (function != null && (functionProfile = thread.getFunctionProfile(function)) != null) {
                    fArray[n13][3] = (float)valueType.getValue(functionProfile, metric, this.ppTrial.getSelectedSnapshot());
                    this.maxScatterValues[3] = Math.max(this.maxScatterValues[3], fArray[n13][3]);
                    this.minScatterValues[3] = Math.min(this.minScatterValues[3], fArray[n13][3]);
                }
                ++n13;
            }
        }
        return fArray;
    }

    private List<List<Vertex>> createGraph(DataSource dataSource, ThreeDeeSettings threeDeeSettings) {
        int n;
        Object object;
        Object object2;
        Object object3;
        HashMap<FunctionProfile, Vertex> hashMap = new HashMap<FunctionProfile, Vertex>();
        ArrayList<Vertex.BackEdge> arrayList = new ArrayList<Vertex.BackEdge>();
        Thread thread = threeDeeSettings.getSelectedThread();
        if (thread == null) {
            thread = dataSource.getMeanData();
        }
        CallPathUtilFuncs.buildThreadRelations((DataSource)dataSource, (Thread)thread);
        List list = thread.getFunctionProfiles();
        for (int i = 0; i < list.size(); ++i) {
            object3 = (FunctionProfile)list.get(i);
            if (object3 == null || object3.isCallPathFunction()) continue;
            Vertex vertex = new Vertex(object3, 1, 1);
            vertex.setColorRatio(1.0f);
            hashMap.put((FunctionProfile)object3, vertex);
        }
        Stack<FunctionProfile> stack = new Stack<FunctionProfile>();
        object3 = new Stack();
        for (int i = 0; i < list.size(); ++i) {
            Object object4;
            FunctionProfile functionProfile = (FunctionProfile)list.get(i);
            if (functionProfile == null || functionProfile.isCallPathFunction() || ((Vertex)(object2 = (Vertex)hashMap.get(functionProfile))).getVisited()) continue;
            ((Vector)object3).add(functionProfile);
            stack.add(null);
            object = functionProfile.getChildProfiles();
            while (object.hasNext()) {
                object4 = (FunctionProfile)object.next();
                stack.add((FunctionProfile)object4);
            }
            while (!stack.empty()) {
                int n2;
                object = (FunctionProfile)stack.pop();
                if (object == null) {
                    ((Stack)object3).pop();
                    continue;
                }
                object4 = (Vertex)hashMap.get(object);
                FunctionProfile functionProfile2 = (FunctionProfile)((Stack)object3).peek();
                Vertex vertex = (Vertex)hashMap.get(functionProfile2);
                boolean bl = false;
                Iterator iterator = ((Vector)object3).iterator();
                while (iterator.hasNext()) {
                    if (iterator.next() != object) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    arrayList.add(new Vertex.BackEdge(vertex, (Vertex)object4));
                    continue;
                }
                boolean bl2 = false;
                for (n2 = 0; n2 < vertex.getChildren().size(); ++n2) {
                    if (vertex.getChildren().get(n2) != object4) continue;
                    bl2 = true;
                }
                if (!bl2) {
                    vertex.getChildren().add((Vertex)object4);
                }
                bl2 = false;
                for (n2 = 0; n2 < ((Vertex)object4).getParents().size(); ++n2) {
                    if (((Vertex)object4).getParents().get(n2) != vertex) continue;
                    bl2 = true;
                }
                if (!bl2) {
                    ((Vertex)object4).getParents().add(vertex);
                }
                if (((Vertex)object4).getVisited()) continue;
                ((Vertex)object4).setVisited(true);
                ((Vector)object3).add(object);
                stack.add(null);
                Iterator iterator2 = object.getChildProfiles();
                while (iterator2.hasNext()) {
                    FunctionProfile functionProfile3 = (FunctionProfile)iterator2.next();
                    stack.add(functionProfile3);
                }
            }
        }
        List<Vertex> list2 = Layout.findRoots(hashMap);
        for (n = 0; n < list.size(); ++n) {
            object2 = (FunctionProfile)list.get(n);
            if (object2 == null || object2.isCallPathFunction() || ((Vertex)(object = (Vertex)hashMap.get(object2))).getLevel() != -1) continue;
            Layout.assignLevel((Vertex)object);
        }
        for (n = 0; n < list.size(); ++n) {
            object2 = (FunctionProfile)list.get(n);
            if (object2 == null || object2.isCallPathFunction()) continue;
            object = (Vertex)hashMap.get(object2);
            Layout.insertDummies((Vertex)object);
        }
        for (n = 0; n < list.size(); ++n) {
            object2 = (FunctionProfile)list.get(n);
            if (object2 == null || object2.isCallPathFunction()) continue;
            object = (Vertex)hashMap.get(object2);
            ((Vertex)object).setVisited(false);
        }
        ArrayList<List<Vertex>> arrayList2 = new ArrayList<List<Vertex>>();
        for (int i = 0; i < list2.size(); ++i) {
            object = list2.get(i);
            Layout.fillLevels((Vertex)object, arrayList2, 0);
        }
        Layout.runSugiyama(arrayList2);
        Layout.assignPositions(arrayList2);
        return arrayList2;
    }

    private List<List<XmasTree.Ornament>> decorateTree(List<List<Vertex>> list, DataSource dataSource, ThreeDeeSettings threeDeeSettings) {
        FunctionProfile functionProfile;
        List<Vertex> list2;
        int n;
        HashMap<Vertex, XmasTree.Ornament> hashMap = new HashMap<Vertex, XmasTree.Ornament>();
        ArrayList<List<XmasTree.Ornament>> arrayList = new ArrayList<List<XmasTree.Ornament>>();
        Thread thread = threeDeeSettings.getSelectedThread();
        if (thread == null) {
            thread = dataSource.getMeanData();
        }
        for (n = 0; n < list.size(); ++n) {
            int n2;
            list2 = list.get(n);
            ArrayList<XmasTree.Ornament> arrayList2 = new ArrayList<XmasTree.Ornament>();
            int n3 = 0;
            for (n2 = 0; n2 < list2.size(); ++n2) {
                Vertex vertex = list2.get(n2);
                if (vertex.getUserObject() == null) continue;
                ++n3;
            }
            n2 = 0;
            for (int i = 0; i < list2.size(); ++i) {
                Vertex vertex2 = list2.get(i);
                if (vertex2.getUserObject() == null) continue;
                functionProfile = (FunctionProfile)vertex2.getUserObject();
                XmasTree.Ornament ornament = new XmasTree.Ornament(functionProfile.getName(), (Object)vertex2);
                float f = (float)(functionProfile.getInclusive(0) / thread.getMaxInclusive(0, 0));
                float f2 = (float)(functionProfile.getExclusive(0) / thread.getMaxExclusive(0, 0));
                ornament.setSize(f);
                ornament.setColor(f2);
                vertex2.setGraphObject(ornament);
                hashMap.put(vertex2, ornament);
                ornament.setPosition((float)n2++ / (float)n3);
                arrayList2.add(ornament);
            }
            arrayList.add(arrayList2);
        }
        for (n = 0; n < list.size(); ++n) {
            list2 = list.get(n);
            for (int i = 0; i < list2.size(); ++i) {
                Vertex vertex = list2.get(i);
                if (vertex.getUserObject() == null) continue;
                XmasTree.Ornament ornament = (XmasTree.Ornament)vertex.getGraphObject();
                for (Vertex vertex2 : vertex.getChildren()) {
                    functionProfile = (XmasTree.Ornament)vertex2.getGraphObject();
                    if (functionProfile == null || functionProfile.getUserObject() == null) continue;
                    ornament.addChild((XmasTree.Ornament)functionProfile);
                }
            }
        }
        return arrayList;
    }

    private void generateCallGraph(boolean bl, ThreeDeeSettings threeDeeSettings) {
        if (this.plot != null) {
            this.plot.cleanUp();
        }
        List<List<Vertex>> list = this.createGraph(this.ppTrial.getDataSource(), threeDeeSettings);
        List<List<XmasTree.Ornament>> list2 = this.decorateTree(list, this.ppTrial.getDataSource(), threeDeeSettings);
        XmasTree xmasTree = new XmasTree(list2);
        xmasTree.setColorScale(this.colorScale);
        this.plot = xmasTree;
    }

    private void generate3dModel(boolean bl, ThreeDeeSettings threeDeeSettings) {
        int n;
        this.visRenderer.setCameraMode(0);
        if (this.plot != null) {
            this.plot.cleanUp();
        }
        if (threeDeeSettings.getVisType() == VisType.SCATTER_PLOT) {
            this.generateScatterPlot(bl, threeDeeSettings);
            return;
        }
        if (threeDeeSettings.getVisType() == VisType.TOPO_PLOT) {
            this.generateGeneralPlot(bl, threeDeeSettings);
            return;
        }
        if (threeDeeSettings.getVisType() == VisType.CALLGRAPH) {
            this.generateCallGraph(bl, threeDeeSettings);
            this.visRenderer.setCameraMode(1);
            return;
        }
        if (this.triangleMeshPlot == null && this.barPlot == null) {
            bl = true;
        }
        DataSource dataSource = this.ppTrial.getDataSource();
        int n2 = dataSource.getNumThreads();
        int n3 = 0;
        List<PPFunctionProfile> list = this.dataSorter.getFunctionProfiles(this.ppTrial.getDataSource().getMeanData());
        n3 = list.size();
        float[][] fArray = new float[n3][n2];
        float[][] fArray2 = new float[n3][n2];
        boolean bl2 = false;
        if (this.functionNames == null) {
            this.functionNames = new ArrayList<String>();
            this.functions = new ArrayList<Function>();
            bl2 = true;
        }
        if (this.threadNames == null) {
            this.threadNames = this.ppTrial.getThreadNames();
            this.threads = this.ppTrial.getThreads();
        }
        this.maxHeightValue = 0.0f;
        this.maxColorValue = 0.0f;
        this.minHeightValue = Float.MAX_VALUE;
        this.minColorValue = Float.MAX_VALUE;
        int n4 = 0;
        for (n = 0; n < list.size(); ++n) {
            PPFunctionProfile pPFunctionProfile = list.get(n);
            Function function = pPFunctionProfile.getFunction();
            if (bl2) {
                this.functionNames.add(ParaProfUtils.getDisplayName(function));
                this.functions.add(function);
            }
            int n5 = 0;
            for (Thread thread : this.ppTrial.getDataSource().getAllThreads()) {
                FunctionProfile functionProfile = thread.getFunctionProfile(function);
                if (functionProfile != null) {
                    fArray[n4][n5] = (float)threeDeeSettings.getHeightValue().getValue(functionProfile, threeDeeSettings.getHeightMetric().getID(), this.ppTrial.getSelectedSnapshot());
                    fArray2[n4][n5] = (float)threeDeeSettings.getColorValue().getValue(functionProfile, threeDeeSettings.getColorMetric().getID(), this.ppTrial.getSelectedSnapshot());
                    this.maxHeightValue = Math.max(this.maxHeightValue, fArray[n4][n5]);
                    this.maxColorValue = Math.max(this.maxColorValue, fArray2[n4][n5]);
                    this.minHeightValue = Math.min(this.minHeightValue, fArray[n4][n5]);
                    this.minColorValue = Math.min(this.minColorValue, fArray2[n4][n5]);
                }
                ++n5;
            }
            ++n4;
        }
        if (bl) {
            n = 20;
            int n6 = 20;
            int n7 = 20;
            float f = (float)this.threadNames.size() / (float)this.functionNames.size();
            if (f > 2.0f) {
                f = 2.0f;
            }
            if (f < 0.5f) {
                f = 0.5f;
            }
            if (f > 1.0f) {
                n6 = (int)(30.0f * (1.0f / f));
                n = 30;
            } else if (f < 1.0f) {
                n6 = 30;
                n = (int)(30.0f * f);
            } else {
                n = 30;
                n6 = 30;
            }
            n7 = 6;
            threeDeeSettings.setSize(n, n6, n7);
            this.visRenderer.setAim(new Vec(threeDeeSettings.getPlotWidth() / 2.0f, threeDeeSettings.getPlotDepth() / 2.0f, 0.0f));
            threeDeeSettings.setRegularAim(this.visRenderer.getAim());
        }
        if (this.fullDataPlotAxes == null) {
            this.fullDataPlotAxes = new Axes();
            this.fullDataPlotAxes.setHighlightColor(this.ppTrial.getColorChooser().getHighlightColor());
        }
        this.setAxisStrings();
        this.axes = this.fullDataPlotAxes;
        if (threeDeeSettings.getVisType() == VisType.TRIANGLE_MESH_PLOT) {
            this.axes.setOnEdge(false);
            if (this.triangleMeshPlot == null) {
                this.triangleMeshPlot = new TriangleMeshPlot();
                this.triangleMeshPlot.initialize(this.axes, threeDeeSettings.getPlotWidth(), threeDeeSettings.getPlotDepth(), threeDeeSettings.getPlotHeight(), fArray, fArray2, this.colorScale);
                this.plot = this.triangleMeshPlot;
            } else {
                this.triangleMeshPlot.setValues(threeDeeSettings.getPlotWidth(), threeDeeSettings.getPlotDepth(), threeDeeSettings.getPlotHeight(), fArray, fArray2);
                this.plot = this.triangleMeshPlot;
            }
        } else {
            this.axes.setOnEdge(true);
            if (this.barPlot == null) {
                this.barPlot = new BarPlot(this.axes, this.colorScale);
            }
            this.barPlot.setValues(threeDeeSettings.getPlotWidth(), threeDeeSettings.getPlotDepth(), threeDeeSettings.getPlotHeight(), fArray, fArray2);
            this.plot = this.barPlot;
        }
    }

    private void updateSettings(ThreeDeeSettings threeDeeSettings) {
        if (this.oldSettings.getAxisOrientation() != threeDeeSettings.getAxisOrientation()) {
            this.axes.setOrientation(threeDeeSettings.getAxisOrientation());
        }
        if (this.oldSettings.getVisType() != threeDeeSettings.getVisType()) {
            this.visRenderer.removeShape((Shape)this.plot);
            this.visRenderer.removeShape((Shape)this.colorScale);
            this.generate3dModel(false, threeDeeSettings);
            this.visRenderer.addShape((Shape)this.plot);
            this.visRenderer.addShape((Shape)this.colorScale);
            this.plot.setSelectedCol(threeDeeSettings.getSelections()[1]);
            this.plot.setSelectedRow(threeDeeSettings.getSelections()[0]);
            if (threeDeeSettings.getVisType() == VisType.SCATTER_PLOT || threeDeeSettings.getVisType() == VisType.TOPO_PLOT) {
                this.visRenderer.setAim(this.settings.getScatterAim());
            } else if (threeDeeSettings.getVisType() == VisType.TRIANGLE_MESH_PLOT || threeDeeSettings.getVisType() == VisType.BAR_PLOT) {
                this.visRenderer.setAim(this.settings.getRegularAim());
            }
        } else if (threeDeeSettings.getVisType() == VisType.SCATTER_PLOT || threeDeeSettings.getVisType() == VisType.TOPO_PLOT) {
            this.visRenderer.removeShape((Shape)this.plot);
            this.visRenderer.removeShape((Shape)this.colorScale);
            this.generate3dModel(false, threeDeeSettings);
            this.visRenderer.addShape((Shape)this.plot);
            this.visRenderer.addShape((Shape)this.colorScale);
        } else if (threeDeeSettings.getVisType() == VisType.TRIANGLE_MESH_PLOT || threeDeeSettings.getVisType() == VisType.BAR_PLOT) {
            this.settings.setSize((int)this.plot.getWidth(), (int)this.plot.getDepth(), (int)this.plot.getHeight());
            if (this.oldSettings.getHeightMetric() != threeDeeSettings.getHeightMetric() || this.oldSettings.getHeightValue() != threeDeeSettings.getHeightValue() || this.oldSettings.getColorValue() != threeDeeSettings.getColorValue() || this.oldSettings.getColorMetric() != threeDeeSettings.getColorMetric()) {
                this.generate3dModel(false, threeDeeSettings);
            } else {
                this.plot.setSelectedCol(threeDeeSettings.getSelections()[1]);
                this.plot.setSelectedRow(threeDeeSettings.getSelections()[0]);
            }
        } else if (threeDeeSettings.getVisType() == VisType.CALLGRAPH) {
            this.visRenderer.removeShape((Shape)this.plot);
            this.visRenderer.removeShape((Shape)this.colorScale);
            this.generate3dModel(false, threeDeeSettings);
            this.visRenderer.addShape((Shape)this.plot);
            this.visRenderer.addShape((Shape)this.colorScale);
        }
        this.oldSettings = (ThreeDeeSettings)threeDeeSettings.clone();
    }

    public void redraw() {
        this.jSplitPane.revalidate();
        this.jSplitPane.validate();
        this.updateSettings(this.settings);
        this.visRenderer.redraw();
    }

    public void resetSplitPane() {
        this.jSplitPane.revalidate();
        this.jSplitPane.validate();
        this.jSplitPane.resetToPreferredSizes();
        this.updateSettings(this.settings);
        this.visRenderer.redraw();
    }

    private void setupMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        this.optionsMenu = new JMenu("Options");
        this.optionsMenu.getPopupMenu().setLightWeightPopupEnabled(false);
        JMenu jMenu = ParaProfUtils.createUnitsMenu(this, this.units, true);
        jMenu.getPopupMenu().setLightWeightPopupEnabled(false);
        this.optionsMenu.add(jMenu);
        JMenu jMenu2 = ParaProfUtils.createMetricSelectionMenu(this.ppTrial, "Sort by...", true, false, this.dataSorter, this, false);
        jMenu2.getPopupMenu().setLightWeightPopupEnabled(false);
        this.optionsMenu.add(jMenu2);
        JMenu jMenu3 = ParaProfUtils.createFileMenu(this, this, this);
        JMenu jMenu4 = ParaProfUtils.createWindowsMenu(this.ppTrial, this);
        JMenu jMenu5 = ParaProfUtils.createHelpMenu(this, this);
        jMenu3.getPopupMenu().setLightWeightPopupEnabled(false);
        jMenu4.getPopupMenu().setLightWeightPopupEnabled(false);
        jMenu5.getPopupMenu().setLightWeightPopupEnabled(false);
        jMenuBar.add(jMenu3);
        jMenuBar.add(this.optionsMenu);
        jMenuBar.add(jMenu4);
        jMenuBar.add(jMenu5);
        this.setJMenuBar(jMenuBar);
    }

    public int getUnits() {
        return this.units;
    }

    @Override
    public void update(Observable observable, Object object) {
        String string = (String)object;
        if (string.equals("subWindowCloseEvent")) {
            this.closeThisWindow();
        } else if (!string.equals("prefEvent")) {
            if (string.equals("colorEvent")) {
                if (this.fullDataPlotAxes != null) {
                    this.fullDataPlotAxes.setHighlightColor(this.ppTrial.getColorChooser().getHighlightColor());
                    this.visRenderer.redraw();
                }
            } else if (string.equals("dataEvent")) {
                this.sortLocalData();
            }
        }
    }

    void thisWindowClosing(WindowEvent windowEvent) {
        this.closeThisWindow();
    }

    @Override
    public void closeThisWindow() {
        this.setVisible(false);
        this.ppTrial.deleteObserver(this);
        ParaProf.decrementNumWindows();
        if (this.plot != null) {
            this.plot.cleanUp();
        }
        if (this.visRenderer != null) {
            this.visRenderer.cleanUp();
        }
        this.visRenderer = null;
        this.plot = null;
        this.dispose();
    }

    private void sortLocalData() {
        this.functionNames = null;
        if (this.settings.getVisType() == VisType.BAR_PLOT || this.settings.getVisType() == VisType.TRIANGLE_MESH_PLOT) {
            this.settings.setSize((int)this.plot.getWidth(), (int)this.plot.getDepth(), (int)this.plot.getHeight());
            this.settings.setRegularAim(this.visRenderer.getAim());
            this.settings.setRegularEye(this.visRenderer.getEye());
        } else if (this.settings.getVisType() == VisType.SCATTER_PLOT || this.settings.getVisType() == VisType.TOPO_PLOT) {
            this.settings.setScatterAim(this.visRenderer.getAim());
            this.settings.setScatterEye(this.visRenderer.getEye());
        }
        this.generate3dModel(false, this.settings);
        this.controlPanel.dataChanged();
    }

    @Override
    public void help(boolean bl) {
        ParaProf.getHelpWindow().clearText();
        if (bl) {
            ParaProf.getHelpWindow().setVisible(true);
        }
        ParaProf.getHelpWindow().writeText("This is the 3D Window");
        ParaProf.getHelpWindow().writeText("");
        ParaProf.getHelpWindow().writeText("This window displays profile data in three dimensions through the Triangle Mesh Plot, the Bar Plot, and the ScatterPlot");
        ParaProf.getHelpWindow().writeText("");
        ParaProf.getHelpWindow().writeText("Change between the plots by selecting the desired type from the radio buttons in the upper right.");
        ParaProf.getHelpWindow().writeText("");
        ParaProf.getHelpWindow().writeText("Experiment with the controls at the right.");
        ParaProf.getHelpWindow().writeText("");
    }

    @Override
    public BufferedImage getImage() {
        return this.visRenderer.createScreenShot();
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        try {
            if (n >= 1) {
                return 1;
            }
            ParaProfUtils.scaleForPrint(graphics, pageFormat, this.visCanvas.getWidth(), this.visCanvas.getHeight());
            BufferedImage bufferedImage = this.visRenderer.createScreenShot();
            ImageObserver imageObserver = new ImageObserver(){

                public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
                    return false;
                }
            };
            graphics.drawImage(bufferedImage, 0, 0, Color.black, imageObserver);
            return 0;
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
            return 1;
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            if (object instanceof Timer) {
                if (this.visRenderer == null) {
                    ((Timer)object).stop();
                    return;
                }
                long l = System.currentTimeMillis();
                int n = this.visRenderer.getFramesRendered();
                if (n != 0) {
                    this.visRenderer.setFramesRendered(0);
                    float f = (float)n / ((float)(l - this.lastCall) / 1000.0f);
                    this.visRenderer.setFps(f);
                    System.out.println("FPS = " + f);
                    this.lastCall = l;
                }
                return;
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public ColorScale getColorScale() {
        return this.colorScale;
    }

    public Plot getPlot() {
        return this.plot;
    }

    public void setPlot(Plot plot) {
        this.plot = plot;
    }

    public List<String> getFunctionNames() {
        return this.functionNames;
    }

    public List<String> getThreadNames() {
        return this.threadNames;
    }

    public String getFunctionName(int n) {
        if (this.functionNames == null) {
            return null;
        }
        return this.functionNames.get(n);
    }

    public String getThreadName(int n) {
        if (this.threadNames == null) {
            return null;
        }
        return this.threadNames.get(n);
    }

    public double getMaxHeightValue() {
        return this.maxHeightValue;
    }

    public double getMaxColorValue() {
        return this.maxColorValue;
    }

    public double getMinHeightValue() {
        return this.minHeightValue;
    }

    public double getMinColorValue() {
        return this.minColorValue;
    }

    public String getHeightUnitLabel() {
        ParaProfMetric paraProfMetric = (ParaProfMetric)this.settings.getHeightMetric();
        return this.getUnitsString(this.units, this.settings.getHeightValue(), paraProfMetric);
    }

    public String getColorUnitLabel() {
        ParaProfMetric paraProfMetric = (ParaProfMetric)this.settings.getColorMetric();
        return this.getUnitsString(this.units, this.settings.getColorValue(), paraProfMetric);
    }

    public float getSelectedHeightRatio() {
        Function function;
        if (this.threads == null || this.functionNames == null) {
            return -1.0f;
        }
        if (this.settings.getSelections()[1] < 0 || this.settings.getSelections()[0] < 0) {
            return -1.0f;
        }
        Thread thread = this.threads.get(this.settings.getSelections()[1]);
        FunctionProfile functionProfile = thread.getFunctionProfile(function = this.functions.get(this.settings.getSelections()[0]));
        if (functionProfile == null) {
            return -1.0f;
        }
        ParaProfMetric paraProfMetric = (ParaProfMetric)this.settings.getHeightMetric();
        if (!paraProfMetric.isTimeMetric() || !ValueType.isTimeUnits(this.settings.getHeightValue())) {
            this.units = 0;
        }
        double d = this.settings.getHeightValue().getValue(functionProfile, this.settings.getHeightMetric().getID());
        return (float)(d / (double)this.maxHeightValue);
    }

    public float getSelectedColorRatio() {
        Function function;
        if (this.threads == null || this.functionNames == null) {
            return -1.0f;
        }
        if (this.settings.getSelections()[1] < 0 || this.settings.getSelections()[0] < 0) {
            return -1.0f;
        }
        Thread thread = this.threads.get(this.settings.getSelections()[1]);
        FunctionProfile functionProfile = thread.getFunctionProfile(function = this.functions.get(this.settings.getSelections()[0]));
        if (functionProfile == null) {
            return -1.0f;
        }
        ParaProfMetric paraProfMetric = (ParaProfMetric)this.settings.getColorMetric();
        if (!paraProfMetric.isTimeMetric() || !ValueType.isTimeUnits(this.settings.getColorValue())) {
            this.units = 0;
        }
        double d = this.settings.getColorValue().getValue(functionProfile, this.settings.getColorMetric().getID());
        return (float)(d / (double)this.maxColorValue);
    }

    public String getSelectedHeightValue() {
        Function function;
        if (this.threads == null || this.functionNames == null) {
            return "";
        }
        if (this.settings.getSelections()[1] < 0 || this.settings.getSelections()[0] < 0) {
            return "";
        }
        Thread thread = this.threads.get(this.settings.getSelections()[1]);
        FunctionProfile functionProfile = thread.getFunctionProfile(function = this.functions.get(this.settings.getSelections()[0]));
        if (functionProfile == null) {
            return "no value";
        }
        int n = this.units;
        ParaProfMetric paraProfMetric = (ParaProfMetric)this.settings.getHeightMetric();
        if (!paraProfMetric.isTimeMetric() || !ValueType.isTimeUnits(this.settings.getHeightValue())) {
            n = 0;
        }
        String string = UtilFncs.getOutputString((int)n, (double)this.settings.getHeightValue().getValue(functionProfile, this.settings.getHeightMetric().getID()), (int)6, (boolean)paraProfMetric.isTimeDenominator()).trim() + this.getUnitsString(n, this.settings.getHeightValue(), paraProfMetric);
        return string;
    }

    public String getSelectedColorValue() {
        Function function;
        if (this.threads == null || this.functionNames == null) {
            return "";
        }
        if (this.settings.getSelections()[1] < 0 || this.settings.getSelections()[0] < 0) {
            return "";
        }
        Thread thread = this.threads.get(this.settings.getSelections()[1]);
        FunctionProfile functionProfile = thread.getFunctionProfile(function = this.functions.get(this.settings.getSelections()[0]));
        if (functionProfile == null) {
            return "no value";
        }
        int n = this.units;
        ParaProfMetric paraProfMetric = (ParaProfMetric)this.settings.getColorMetric();
        if (!paraProfMetric.isTimeMetric() || !ValueType.isTimeUnits(this.settings.getColorValue())) {
            n = 0;
        }
        return UtilFncs.getOutputString((int)n, (double)this.settings.getColorValue().getValue(functionProfile, this.settings.getColorMetric().getID()), (int)6, (boolean)paraProfMetric.isTimeDenominator()).trim() + this.getUnitsString(n, this.settings.getColorValue(), paraProfMetric);
    }

    public String getSelectedMinTopoValue() {
        return this.getSelectedTopoValue(this.topoPlot.getMinShown());
    }

    public String getSelectedMaxTopoValue() {
        return this.getSelectedTopoValue(this.topoPlot.getMaxShown());
    }

    public String getStatMean() {
        if (this.topoPlot != null) {
            return this.getSelectedTopoValue(this.topoPlot.getStatMean());
        }
        return this.getSelectedTopoValue(Float.NaN);
    }

    public String getStatMax() {
        if (this.topoPlot != null) {
            return this.getSelectedTopoValue(this.topoPlot.getStatMax());
        }
        return this.getSelectedTopoValue(Float.NaN);
    }

    public String getStatMin() {
        if (this.topoPlot != null) {
            return this.getSelectedTopoValue(this.topoPlot.getStatMin());
        }
        return this.getSelectedTopoValue(Float.NaN);
    }

    private String getSelectedTopoValue(float f) {
        int n = this.units;
        ParaProfMetric paraProfMetric = (ParaProfMetric)this.settings.getTopoMetric(3);
        if (!paraProfMetric.isTimeMetric() || !ValueType.isTimeUnits(this.settings.getTopoValueType(3))) {
            n = 0;
        }
        return UtilFncs.getOutputString((int)n, (double)f, (int)6, (boolean)paraProfMetric.isTimeDenominator()).trim() + this.getUnitsString(n, this.settings.getTopoValueType(3), paraProfMetric);
    }

    private String getUnitsString(int n, ValueType valueType, ParaProfMetric paraProfMetric) {
        return valueType.getSuffix(n, paraProfMetric);
    }

    private void setTopoAxisStrings() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("X");
        arrayList.add("Y");
        arrayList.add("Z");
        List[] listArray = new List[4];
        for (int i = 0; i < 3; ++i) {
            if (this.minScatterValues[i] == Float.MAX_VALUE) {
                this.minScatterValues[i] = 0.0f;
            }
            listArray[i] = new ArrayList();
            listArray[i].add((int)this.minScatterValues[i] + "");
            listArray[i].add((int)((double)this.minScatterValues[i] + (double)(this.maxScatterValues[i] - this.minScatterValues[i]) * 0.25) + "");
            listArray[i].add((int)((double)this.minScatterValues[i] + (double)(this.maxScatterValues[i] - this.minScatterValues[i]) * 0.5) + "");
            listArray[i].add((int)((double)this.minScatterValues[i] + (double)(this.maxScatterValues[i] - this.minScatterValues[i]) * 0.75) + "");
            listArray[i].add((int)(this.minScatterValues[i] + (this.maxScatterValues[i] - this.minScatterValues[i])) + "");
        }
        ParaProfMetric paraProfMetric = (ParaProfMetric)this.settings.getTopoMetric(3);
        int n = this.settings.getTopoValueType(3).getUnits(this.units, paraProfMetric);
        String string = null;
        if (this.settings.getTopoFunction(3) != null) {
            String string2 = ParaProfUtils.getDisplayName(this.settings.getTopoFunction(3));
            if (string2.length() > 30) {
                string2 = string2.substring(0, 30) + "...";
            }
            string = this.settings.getTopoValueType(3) == ValueType.NUMCALLS || this.settings.getTopoValueType(3) == ValueType.NUMSUBR ? string2 + "\n(" + this.settings.getTopoValueType(3).toString() + ")" : string2 + "\n(" + this.settings.getTopoValueType(3).toString() + ", " + this.settings.getTopoMetric(3).getName() + ")";
        } else {
            string = "none";
        }
        this.colorScale.setStrings(UtilFncs.getOutputString((int)n, (double)this.minScatterValues[3], (int)6, (boolean)paraProfMetric.isTimeDenominator()).trim(), UtilFncs.getOutputString((int)n, (double)this.maxScatterValues[3], (int)6, (boolean)paraProfMetric.isTimeDenominator()).trim(), string);
        this.scatterPlotAxes.setStrings((String)arrayList.get(0), (String)arrayList.get(1), (String)arrayList.get(2), listArray[0], listArray[1], listArray[2]);
    }

    private void setAxisStrings() {
        if (this.settings.getVisType() == VisType.TOPO_PLOT) {
            this.setTopoAxisStrings();
        } else if (this.settings.getVisType() == VisType.SCATTER_PLOT) {
            Function[] functionArray = this.settings.getScatterFunctions();
            ValueType[] valueTypeArray = this.settings.getScatterValueTypes();
            Metric[] metricArray = this.settings.getScatterMetrics();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < functionArray.length; ++i) {
                if (functionArray[i] != null) {
                    String string;
                    if (i == 3) {
                        string = ParaProfUtils.getDisplayName(functionArray[i]);
                        if (string.length() > 30) {
                            string = string.substring(0, 30) + "...";
                        }
                    } else {
                        string = functionArray[i].getName();
                    }
                    if (valueTypeArray[i] == ValueType.NUMCALLS || valueTypeArray[i] == ValueType.NUMSUBR) {
                        arrayList.add(string + "\n(" + valueTypeArray[i].toString() + ")");
                        continue;
                    }
                    arrayList.add(string + "\n(" + valueTypeArray[i].toString() + ", " + metricArray[i].getName() + ")");
                    continue;
                }
                arrayList.add("none");
            }
            List[] listArray = new List[4];
            for (int i = 0; i < 4; ++i) {
                if (this.minScatterValues[i] == Float.MAX_VALUE) {
                    this.minScatterValues[i] = 0.0f;
                }
                ParaProfMetric paraProfMetric = (ParaProfMetric)metricArray[i];
                int n = valueTypeArray[i].getUnits(this.units, paraProfMetric);
                listArray[i] = new ArrayList();
                listArray[i].add(UtilFncs.getOutputString((int)n, (double)this.minScatterValues[i], (int)6, (boolean)paraProfMetric.isTimeDenominator()).trim());
                listArray[i].add(UtilFncs.getOutputString((int)n, (double)((double)this.minScatterValues[i] + (double)(this.maxScatterValues[i] - this.minScatterValues[i]) * 0.25), (int)6, (boolean)paraProfMetric.isTimeDenominator()).trim());
                listArray[i].add(UtilFncs.getOutputString((int)n, (double)((double)this.minScatterValues[i] + (double)(this.maxScatterValues[i] - this.minScatterValues[i]) * 0.5), (int)6, (boolean)paraProfMetric.isTimeDenominator()).trim());
                listArray[i].add(UtilFncs.getOutputString((int)n, (double)((double)this.minScatterValues[i] + (double)(this.maxScatterValues[i] - this.minScatterValues[i]) * 0.75), (int)6, (boolean)paraProfMetric.isTimeDenominator()).trim());
                listArray[i].add(UtilFncs.getOutputString((int)n, (double)(this.minScatterValues[i] + (this.maxScatterValues[i] - this.minScatterValues[i])), (int)6, (boolean)paraProfMetric.isTimeDenominator()).trim());
            }
            ParaProfMetric paraProfMetric = (ParaProfMetric)metricArray[3];
            int n = valueTypeArray[3].getUnits(this.units, paraProfMetric);
            this.colorScale.setStrings(UtilFncs.getOutputString((int)n, (double)this.minScatterValues[3], (int)6, (boolean)paraProfMetric.isTimeDenominator()).trim(), UtilFncs.getOutputString((int)n, (double)this.maxScatterValues[3], (int)6, (boolean)paraProfMetric.isTimeDenominator()).trim(), (String)arrayList.get(3));
            this.scatterPlotAxes.setStrings((String)arrayList.get(0), (String)arrayList.get(1), (String)arrayList.get(2), listArray[0], listArray[1], listArray[2]);
        } else {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("0");
            ParaProfMetric paraProfMetric = (ParaProfMetric)this.settings.getHeightMetric();
            int n = this.settings.getHeightValue().getUnits(this.units, paraProfMetric);
            arrayList.add(UtilFncs.getOutputString((int)n, (double)((double)this.maxHeightValue * 0.25), (int)6, (boolean)paraProfMetric.isTimeDenominator()).trim());
            arrayList.add(UtilFncs.getOutputString((int)n, (double)((double)this.maxHeightValue * 0.5), (int)6, (boolean)paraProfMetric.isTimeDenominator()).trim());
            arrayList.add(UtilFncs.getOutputString((int)n, (double)((double)this.maxHeightValue * 0.75), (int)6, (boolean)paraProfMetric.isTimeDenominator()).trim());
            arrayList.add(UtilFncs.getOutputString((int)n, (double)this.maxHeightValue, (int)6, (boolean)paraProfMetric.isTimeDenominator()).trim());
            String string = this.settings.getHeightValue().getSuffix(n, paraProfMetric);
            paraProfMetric = (ParaProfMetric)this.settings.getColorMetric();
            n = this.settings.getColorValue().getUnits(this.units, paraProfMetric);
            String string2 = this.settings.getColorValue().getSuffix(n, paraProfMetric);
            this.colorScale.setStrings("0", UtilFncs.getOutputString((int)n, (double)this.maxColorValue, (int)6, (boolean)paraProfMetric.isTimeDenominator()).trim(), string2);
            String string3 = "Thread";
            if (this.ppTrial.getDataSource().getExecutionType() == 1) {
                string3 = "MPI Rank";
            }
            if (this.ppTrial.getDataSource().getExecutionType() == 3) {
                string3 = "MPI Rank, Thread";
            }
            this.fullDataPlotAxes.setStrings(string3, "Function", string, this.threadNames, this.functionNames, arrayList);
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        try {
            if (keyEvent.getKeyChar() == '+') {
                this.visRenderer.zoomIn();
            } else if (keyEvent.getKeyChar() == '-') {
                this.visRenderer.zoomOut();
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    @Override
    public void setUnits(int n) {
        this.units = n;
        this.setAxisStrings();
        this.controlPanel.dataChanged();
        this.visRenderer.redraw();
    }

    @Override
    public void resort() {
        this.sortLocalData();
    }

    @Override
    public JFrame getFrame() {
        return this;
    }

    public void createNewCanvas() {
        this.visCanvas = new VisCanvas(this.visRenderer);
        this.visCanvas.addKeyListener((KeyListener)this);
        JPanel jPanel = new JPanel(){
            private static final long serialVersionUID = 2151986610100360208L;

            public Dimension getMinimumSize() {
                return new Dimension(10, 10);
            }
        };
        jPanel.addKeyListener(this);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        jPanel.add((Component)this.visCanvas.getActualCanvas(), gridBagConstraints);
        jPanel.setPreferredSize(new Dimension(5, 5));
        this.jSplitPane.setLeftComponent(jPanel);
    }

    @Override
    public Component getComponent() {
        return this;
    }
}

