/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof.barchart;

import edu.uoregon.tau.common.Common;
import edu.uoregon.tau.paraprof.DataSorter;
import edu.uoregon.tau.paraprof.FunctionBarChartWindow;
import edu.uoregon.tau.paraprof.FunctionOrdering;
import edu.uoregon.tau.paraprof.GlobalDataWindow;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.barchart.AbstractBarChartModel;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Thread;
import edu.uoregon.tau.perfdmf.UtilFncs;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalBarChartModel
extends AbstractBarChartModel {
    private GlobalDataWindow window;
    private DataSorter dataSorter;
    private ParaProfTrial ppTrial;
    private FunctionOrdering functionOrder;
    private List<Thread> theThreads;

    public GlobalBarChartModel(GlobalDataWindow globalDataWindow, DataSorter dataSorter, ParaProfTrial paraProfTrial) {
        this.window = globalDataWindow;
        this.dataSorter = dataSorter;
        this.ppTrial = paraProfTrial;
    }

    @Override
    public int getNumRows() {
        if (this.theThreads == null) {
            return 0;
        }
        return this.theThreads.size();
    }

    @Override
    public int getSubSize() {
        if (this.functionOrder != null) {
            return this.functionOrder.getOrder().length;
        }
        return 0;
    }

    private static String getName(Thread thread) {
        return ParaProfUtils.getThreadLabel(thread);
    }

    @Override
    public String getRowLabel(int n) {
        Thread thread = this.theThreads.get(n);
        return GlobalBarChartModel.getName(thread);
    }

    @Override
    public String getValueLabel(int n, int n2) {
        return "";
    }

    @Override
    public double getValue(int n, int n2) {
        Function function;
        Thread thread = this.theThreads.get(n);
        FunctionProfile functionProfile = thread.getFunctionProfile(function = this.functionOrder.getOrder()[n2]);
        if (functionProfile == null) {
            return -1.0;
        }
        return this.dataSorter.getValueType().getValue(functionProfile, this.dataSorter.getSelectedMetric(), this.dataSorter.getSelectedSnapshot());
    }

    @Override
    public Color getValueColor(int n, int n2) {
        Function function;
        Thread thread = this.theThreads.get(n);
        FunctionProfile functionProfile = thread.getFunctionProfile(function = this.functionOrder.getOrder()[n2]);
        if (functionProfile == null) {
            return Color.black;
        }
        return functionProfile.getFunction().getColor();
    }

    @Override
    public Color getValueHighlightColor(int n, int n2) {
        Function function = this.functionOrder.getOrder()[n2];
        if (function == this.ppTrial.getHighlightedFunction()) {
            return this.ppTrial.getColorChooser().getHighlightColor();
        }
        if (function.isGroupMember(this.ppTrial.getHighlightedGroup())) {
            return this.ppTrial.getColorChooser().getGroupHighlightColor();
        }
        return null;
    }

    @Override
    public void fireValueClick(int n, int n2, MouseEvent mouseEvent, JComponent jComponent) {
        Thread thread = this.theThreads.get(n);
        Function function = this.functionOrder.getOrder()[n2];
        FunctionProfile functionProfile = thread.getFunctionProfile(function);
        if (ParaProfUtils.rightClick(mouseEvent)) {
            JPopupMenu jPopupMenu = ParaProfUtils.createFunctionClickPopUp(this.ppTrial, functionProfile.getFunction(), functionProfile.getThread(), jComponent);
            jPopupMenu.show(jComponent, mouseEvent.getX(), mouseEvent.getY());
        } else {
            this.ppTrial.setHighlightedFunction(functionProfile.getFunction());
            FunctionBarChartWindow functionBarChartWindow = new FunctionBarChartWindow(this.ppTrial, functionProfile.getFunction(), jComponent);
            functionBarChartWindow.setVisible(true);
        }
    }

    @Override
    public void fireRowLabelClick(int n, MouseEvent mouseEvent, JComponent jComponent) {
        Thread thread = this.theThreads.get(n);
        if (ParaProfUtils.rightClick(mouseEvent)) {
            ParaProfUtils.handleThreadClick(this.ppTrial, this.window.getPhase(), thread, jComponent, mouseEvent);
        } else {
            FunctionBarChartWindow functionBarChartWindow = new FunctionBarChartWindow(this.ppTrial, thread, this.window.getPhase(), jComponent);
            functionBarChartWindow.setVisible(true);
        }
    }

    private static String getDisplayName(FunctionProfile functionProfile) {
        if (ParaProf.preferences.getReversedCallPaths()) {
            return functionProfile.getFunction().getReversedName();
        }
        return functionProfile.getFunction().getName();
    }

    @Override
    public String getValueToolTipText(int n, int n2) {
        Thread thread = this.theThreads.get(n);
        Function function = this.functionOrder.getOrder()[n2];
        FunctionProfile functionProfile = thread.getFunctionProfile(function);
        String string = this.ppTrial.getDataSource().getPhasesPresent() ? UtilFncs.getRightSide((String)functionProfile.getFunction().getName()) : GlobalBarChartModel.getDisplayName(functionProfile);
        String string2 = this.dataSorter.getSelectedMetric().getName();
        Metric metric = this.dataSorter.getSelectedMetric();
        String string3 = UtilFncs.getUnitsString((int)this.window.units(), (boolean)this.dataSorter.isTimeMetric(), (boolean)false);
        String string4 = UtilFncs.getOutputString((int)this.window.units(), (double)functionProfile.getExclusive(metric.getID()), (int)ParaProf.defaultNumberPrecision, (boolean)metric.isTimeDenominator());
        String string5 = UtilFncs.getOutputString((int)this.window.units(), (double)functionProfile.getInclusive(metric.getID()), (int)ParaProf.defaultNumberPrecision, (boolean)metric.isTimeDenominator());
        String string6 = "<br>Exclusive " + string2 + ": " + string4 + " " + string3;
        String string7 = "<br>Inclusive " + string2 + ": " + string5 + " " + string3;
        String string8 = "<br>Calls: " + functionProfile.getNumCalls();
        String string9 = "<br>SubCalls: " + functionProfile.getNumSubr();
        return "<html>" + Common.HTMLEntityEncode((String)string) + string6 + string7 + string8 + string9 + "</html>";
    }

    @Override
    public String getRowLabelToolTipText(int n) {
        Thread thread = this.theThreads.get(n);
        if (ParaProf.getHelpWindow().isShowing()) {
            ParaProf.getHelpWindow().clearText();
            if (thread.getNodeID() == -1) {
                ParaProf.getHelpWindow().writeText("This line represents the mean statistics (over all threads).\n");
            } else if (thread.getNodeID() != -2) {
                if (thread.getNodeID() == -3) {
                    ParaProf.getHelpWindow().writeText("This line represents the standard deviation of each function (over threads).\n");
                } else {
                    ParaProf.getHelpWindow().writeText("n,c,t stands for: Node, Context and Thread.\n");
                }
            }
            ParaProf.getHelpWindow().writeText("Right click to display options for viewing the data.");
            ParaProf.getHelpWindow().writeText("Left click to go directly to the Thread Data Window");
        }
        return "Right click for options";
    }

    @Override
    public void reloadData() {
        this.functionOrder = this.dataSorter.getOrdering();
        this.theThreads = this.dataSorter.getThreads();
        this.fireModelChanged();
    }

    @Override
    public String getOtherToolTopText(int n) {
        if (ParaProf.getHelpWindow().isShowing()) {
            ParaProf.getHelpWindow().clearText();
            ParaProf.getHelpWindow().writeText("Your mouse is over the misc. function section!\n");
            ParaProf.getHelpWindow().writeText("These are functions which have a non zero value, but whose screen representation is less than a pixel.\n");
            ParaProf.getHelpWindow().writeText("To view these function, right or left click to the left of this bar to bring up windows which will show more detailed information.");
        }
        return "Misc function section ... see help window for details";
    }

    public List<Thread> getThreads() {
        return this.theThreads;
    }

    @Override
    public DataSorter getDataSorter() {
        return this.dataSorter;
    }
}

