/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof.treetable;

import edu.uoregon.tau.common.Utility;
import edu.uoregon.tau.paraprof.treetable.ContextEventModel;
import edu.uoregon.tau.perfdmf.UserEventProfile;
import edu.uoregon.tau.perfdmf.UtilFncs;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextEventTreeNode
extends DefaultMutableTreeNode
implements Comparable<ContextEventTreeNode> {
    private static final long serialVersionUID = 8704255864552442447L;
    private List<ContextEventTreeNode> children;
    private String displayName;
    private ContextEventModel model;
    private UserEventProfile userEventProfile;
    private String name;

    public ContextEventTreeNode(String string, ContextEventModel contextEventModel) {
        this(null, contextEventModel, string);
    }

    public ContextEventTreeNode(UserEventProfile userEventProfile, ContextEventModel contextEventModel, String string) {
        this.userEventProfile = userEventProfile;
        this.model = contextEventModel;
        if (userEventProfile == null) {
            this.name = string.trim();
            this.displayName = UtilFncs.getRightMost((String)string);
        } else {
            this.name = userEventProfile.getUserEvent().getName().trim();
            this.displayName = this.name.indexOf(":") != -1 ? this.name.substring(0, this.name.indexOf(":")).trim() : this.name;
        }
    }

    public UserEventProfile getUserEventProfile() {
        return this.userEventProfile;
    }

    public List<ContextEventTreeNode> getChildren() {
        this.checkInitChildren();
        return this.children;
    }

    private void checkInitChildren() {
        if (this.children == null) {
            Object object;
            this.children = new ArrayList<ContextEventTreeNode>();
            HashMap<Object, String> hashMap = new HashMap<Object, String>();
            Iterator iterator = this.model.getThread().getUserEventProfiles();
            while (iterator.hasNext()) {
                Object object2;
                Object object3 = (UserEventProfile)iterator.next();
                if (object3 == null || !object3.getUserEvent().isContextEvent()) continue;
                object = object3.getName().substring(object3.getName().indexOf(":") + 1).trim();
                if (!((String)(object = Utility.removeRuns((String)object))).startsWith(this.name)) continue;
                String string = ((String)object).substring(this.name.length()).trim();
                if (string.startsWith("=>")) {
                    string = string.substring(2).trim();
                    object2 = this.name + " => " + UtilFncs.getLeftSide((String)string);
                    hashMap.put(object2, "1");
                    continue;
                }
                if (string.length() != 0) continue;
                object2 = new ContextEventTreeNode((UserEventProfile)object3, this.model, null);
                this.children.add((ContextEventTreeNode)object2);
            }
            for (Object object3 : hashMap.keySet()) {
                object = new ContextEventTreeNode((String)object3, this.model);
                this.children.add((ContextEventTreeNode)object);
            }
        }
    }

    public int getNumChildren() {
        this.checkInitChildren();
        return this.children.size();
    }

    public void sortChildren() {
        if (this.children != null) {
            Collections.sort(this.children);
            for (ContextEventTreeNode contextEventTreeNode : this.children) {
                contextEventTreeNode.sortChildren();
            }
        }
    }

    @Override
    public String toString() {
        return this.displayName;
    }

    @Override
    public int compareTo(ContextEventTreeNode contextEventTreeNode) {
        int n = 0;
        int n2 = this.model.getSortColumn();
        if (n2 == 0) {
            n = this.toString().compareTo(contextEventTreeNode.toString());
        } else {
            Double d = (Double)this.model.getValueAt(contextEventTreeNode, n2);
            Double d2 = (Double)this.model.getValueAt(this, n2);
            if (d == null && d2 != null) {
                return 1;
            }
            if (d != null && d2 == null) {
                return -1;
            }
            n = d == null && d2 == null ? 0 : (int)(d2 - d);
        }
        if (this.model.getSortAscending()) {
            return -n;
        }
        return n;
    }
}

