/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof.treetable;

import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.treetable.MiniHistogram;
import edu.uoregon.tau.paraprof.treetable.TreeTableNode;
import edu.uoregon.tau.paraprof.treetable.TreeTableWindow;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.UtilFncs;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public abstract class TreeTableColumn {
    protected TreeTableWindow window;

    public abstract String toString();

    public abstract Object getValueFor(TreeTableNode var1, boolean var2);

    public abstract TableCellRenderer getCellRenderer();

    public TreeTableColumn(TreeTableWindow treeTableWindow) {
        this.window = treeTableWindow;
    }

    protected Object getValueString(double d) {
        if (this.window.getDecimals() == -2) {
            return Double.toString(d);
        }
        if (this.window.getDecimals() == -1) {
            return new Double(d);
        }
        DecimalFormat decimalFormat = null;
        if (this.window.getDecimals() == 0) {
            decimalFormat = new DecimalFormat("#,###");
        } else if (this.window.getDecimals() == 1) {
            decimalFormat = new DecimalFormat("#,##0.0");
        } else if (this.window.getDecimals() == 2) {
            decimalFormat = new DecimalFormat("#,##0.00");
        } else if (this.window.getDecimals() == 3) {
            decimalFormat = new DecimalFormat("#,##0.000");
        } else if (this.window.getDecimals() == 4) {
            decimalFormat = new DecimalFormat("#,##0.0000");
        }
        String string = decimalFormat.format(d);
        return string;
    }

    protected Object adjustForUnits(double d, int n, boolean bl) {
        block7: {
            if (bl) {
                return new Double(d);
            }
            if (!this.window.getPPTrial().getMetric(n).isTimeMetric()) break block7;
            if (this.window.getPPTrial().getMetric(n).isTimeDenominator()) {
                if (this.window.getUnits() >= 3) {
                    return UtilFncs.getOutputString((int)3, (double)d, (int)ParaProf.defaultNumberPrecision, (boolean)this.window.getPPTrial().getMetric(n).isTimeDenominator()).trim();
                }
                for (int i = 0; i < this.window.getUnits(); ++i) {
                    d *= 1000.0;
                }
            } else {
                if (this.window.getUnits() >= 3) {
                    return UtilFncs.getOutputString((int)3, (double)d, (int)ParaProf.defaultNumberPrecision, (boolean)this.window.getPPTrial().getMetric(n).isTimeDenominator()).trim();
                }
                for (int i = 0; i < this.window.getUnits(); ++i) {
                    d /= 1000.0;
                }
            }
        }
        return this.getValueString(d);
    }

    public static class MiniHistogramColumn
    extends TreeTableColumn {
        public MiniHistogramColumn(TreeTableWindow treeTableWindow) {
            super(treeTableWindow);
        }

        public String toString() {
            return "Histogram";
        }

        public Object getValueFor(TreeTableNode treeTableNode, boolean bl) {
            if (treeTableNode.getFunctionProfile() == null) {
                return null;
            }
            return treeTableNode.getFunctionProfile().getFunction();
        }

        public TableCellRenderer getCellRenderer() {
            return new MiniHistogramCellRenderer(this.window);
        }
    }

    static class MiniHistogramCellRenderer
    implements TableCellRenderer {
        private TreeTableWindow window;

        public MiniHistogramCellRenderer(TreeTableWindow treeTableWindow) {
            this.window = treeTableWindow;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            n2 = jTable.convertColumnIndexToModel(n2) - 1;
            TreeTableNode treeTableNode = (TreeTableNode)object;
            MiniHistogramColumn miniHistogramColumn = (MiniHistogramColumn)this.window.getColumns().get(n2);
            Function function = (Function)miniHistogramColumn.getValueFor(treeTableNode, false);
            if (function == null) {
                return new JLabel("");
            }
            return new MiniHistogram(this.window.getPPTrial(), function);
        }
    }

    static class StdDevColumn
    extends TreeTableColumn {
        private int metricID;

        public String toString() {
            return "Std Dev";
        }

        public StdDevColumn(TreeTableWindow treeTableWindow, int n) {
            super(treeTableWindow);
            this.metricID = n;
        }

        public Object getValueFor(TreeTableNode treeTableNode, boolean bl) {
            FunctionProfile functionProfile = treeTableNode.getFunctionProfile();
            if (functionProfile == null) {
                return null;
            }
            Function function = functionProfile.getFunction();
            functionProfile = function.getStddevProfile();
            int n = this.window.getPPTrial().getSelectedSnapshot();
            return new Double(functionProfile.getExclusive(n, this.metricID));
        }

        public TableCellRenderer getCellRenderer() {
            return new ParaProfCellRenderer(this.window);
        }
    }

    static class NumCallsColumn
    extends TreeTableColumn {
        public String toString() {
            return "Calls";
        }

        public NumCallsColumn(TreeTableWindow treeTableWindow) {
            super(treeTableWindow);
        }

        public Object getValueFor(TreeTableNode treeTableNode, boolean bl) {
            FunctionProfile functionProfile = treeTableNode.getFunctionProfile();
            if (functionProfile == null) {
                return null;
            }
            int n = this.window.getPPTrial().getSelectedSnapshot();
            return new Double(functionProfile.getNumCalls(n));
        }

        public TableCellRenderer getCellRenderer() {
            return new ParaProfCellRenderer(this.window);
        }
    }

    static class NumSubrColumn
    extends TreeTableColumn {
        public String toString() {
            return "Child Calls";
        }

        public NumSubrColumn(TreeTableWindow treeTableWindow) {
            super(treeTableWindow);
        }

        public Object getValueFor(TreeTableNode treeTableNode, boolean bl) {
            if (treeTableNode == null) {
                return null;
            }
            FunctionProfile functionProfile = treeTableNode.getFunctionProfile();
            int n = this.window.getPPTrial().getSelectedSnapshot();
            if (functionProfile == null) {
                return null;
            }
            return new Double(functionProfile.getNumSubr(n));
        }

        public TableCellRenderer getCellRenderer() {
            return new ParaProfCellRenderer(this.window);
        }
    }

    static class ExclusivePerCallColumn
    extends TreeTableColumn {
        private int metricID;

        public ExclusivePerCallColumn(TreeTableWindow treeTableWindow, int n) {
            super(treeTableWindow);
            this.metricID = n;
        }

        public String toString() {
            return "Exclusive " + this.window.getPPTrial().getMetricName(this.metricID) + " / Call";
        }

        public Object getValueFor(TreeTableNode treeTableNode, boolean bl) {
            FunctionProfile functionProfile = treeTableNode.getFunctionProfile();
            int n = this.window.getPPTrial().getSelectedSnapshot();
            if (functionProfile == null) {
                return null;
            }
            return this.adjustForUnits(functionProfile.getExclusivePerCall(n, this.metricID), this.metricID, bl);
        }

        public TableCellRenderer getCellRenderer() {
            return new ParaProfCellRenderer(this.window);
        }
    }

    static class ExclusiveColumn
    extends TreeTableColumn {
        private int metricID;

        public ExclusiveColumn(TreeTableWindow treeTableWindow, int n) {
            super(treeTableWindow);
            this.metricID = n;
        }

        public String toString() {
            return "Exclusive " + this.window.getPPTrial().getMetricName(this.metricID);
        }

        public Object getValueFor(TreeTableNode treeTableNode, boolean bl) {
            FunctionProfile functionProfile = treeTableNode.getFunctionProfile();
            if (functionProfile == null) {
                return null;
            }
            int n = this.window.getPPTrial().getSelectedSnapshot();
            return this.adjustForUnits(functionProfile.getExclusive(n, this.metricID), this.metricID, bl);
        }

        public TableCellRenderer getCellRenderer() {
            return new ParaProfCellRenderer(this.window);
        }
    }

    static class InclusivePerCallColumn
    extends TreeTableColumn {
        private int metricID;

        public InclusivePerCallColumn(TreeTableWindow treeTableWindow, int n) {
            super(treeTableWindow);
            this.metricID = n;
        }

        public String toString() {
            return "Inclusive " + this.window.getPPTrial().getMetricName(this.metricID) + " / Call";
        }

        public Object getValueFor(TreeTableNode treeTableNode, boolean bl) {
            FunctionProfile functionProfile = treeTableNode.getFunctionProfile();
            int n = this.window.getPPTrial().getSelectedSnapshot();
            if (functionProfile == null) {
                return null;
            }
            return this.adjustForUnits(functionProfile.getInclusivePerCall(n, this.metricID), this.metricID, bl);
        }

        public TableCellRenderer getCellRenderer() {
            return new ParaProfCellRenderer(this.window);
        }
    }

    static class InclusiveColumn
    extends TreeTableColumn {
        private int metricID;

        public InclusiveColumn(TreeTableWindow treeTableWindow, int n) {
            super(treeTableWindow);
            this.metricID = n;
        }

        public String toString() {
            return "Inclusive " + this.window.getPPTrial().getMetricName(this.metricID);
        }

        public Object getValueFor(TreeTableNode treeTableNode, boolean bl) {
            FunctionProfile functionProfile = treeTableNode.getFunctionProfile();
            int n = this.window.getPPTrial().getSelectedSnapshot();
            if (functionProfile == null) {
                return null;
            }
            return this.adjustForUnits(functionProfile.getInclusive(n, this.metricID), this.metricID, bl);
        }

        public TableCellRenderer getCellRenderer() {
            return new ParaProfCellRenderer(this.window);
        }
    }

    static class ExclusivePercentColumn
    extends TreeTableColumn {
        private int metricID;

        public ExclusivePercentColumn(TreeTableWindow treeTableWindow, int n) {
            super(treeTableWindow);
            this.metricID = n;
        }

        public String toString() {
            return "Exclusive " + this.window.getPPTrial().getMetricName(this.metricID) + " %";
        }

        public Object getValueFor(TreeTableNode treeTableNode, boolean bl) {
            FunctionProfile functionProfile = treeTableNode.getFunctionProfile();
            int n = this.window.getPPTrial().getSelectedSnapshot();
            if (functionProfile == null) {
                return null;
            }
            if (bl) {
                return new Double(functionProfile.getExclusivePercent(n, this.metricID));
            }
            DecimalFormat decimalFormat = new DecimalFormat("##0.0");
            return decimalFormat.format(functionProfile.getExclusivePercent(this.metricID)) + "%";
        }

        public TableCellRenderer getCellRenderer() {
            return new ParaProfCellRenderer(this.window);
        }

        public int getMetricID() {
            return this.metricID;
        }
    }

    static class InclusivePercentColumn
    extends TreeTableColumn {
        private int metricID;

        public InclusivePercentColumn(TreeTableWindow treeTableWindow, int n) {
            super(treeTableWindow);
            this.metricID = n;
        }

        public String toString() {
            return "Inclusive " + this.window.getPPTrial().getMetricName(this.metricID) + " %";
        }

        public Object getValueFor(TreeTableNode treeTableNode, boolean bl) {
            FunctionProfile functionProfile = treeTableNode.getFunctionProfile();
            int n = this.window.getPPTrial().getSelectedSnapshot();
            if (functionProfile == null) {
                return null;
            }
            if (bl) {
                return new Double(functionProfile.getInclusivePercent(n, this.metricID));
            }
            DecimalFormat decimalFormat = new DecimalFormat("##0.0");
            return decimalFormat.format(functionProfile.getInclusivePercent(this.metricID)) + "%";
        }

        public TableCellRenderer getCellRenderer() {
            return new ParaProfCellRenderer(this.window);
        }

        public int getMetricID() {
            return this.metricID;
        }
    }

    static class RegularPerCallMetricColumn
    extends RegularMetricColumn {
        private int metricID;

        public RegularPerCallMetricColumn(TreeTableWindow treeTableWindow, int n) {
            super(treeTableWindow, n);
            this.metricID = n;
        }

        public String toString() {
            return this.window.getPPTrial().getMetricName(this.metricID) + " / Call";
        }

        public Object getValueFor(TreeTableNode treeTableNode, boolean bl) {
            FunctionProfile functionProfile = treeTableNode.getFunctionProfile();
            int n = this.window.getPPTrial().getSelectedSnapshot();
            if (functionProfile == null) {
                return null;
            }
            if (treeTableNode.getExpanded()) {
                return this.adjustForUnits(functionProfile.getExclusivePerCall(n, this.metricID), this.metricID, bl);
            }
            return this.adjustForUnits(functionProfile.getInclusivePerCall(n, this.metricID), this.metricID, bl);
        }

        public TableCellRenderer getCellRenderer() {
            return new ParaProfCellRenderer(this.window);
        }

        public int getMetricID() {
            return this.metricID;
        }
    }

    static class RegularPercentMetricColumn
    extends RegularMetricColumn {
        private int metricID;

        public RegularPercentMetricColumn(TreeTableWindow treeTableWindow, int n) {
            super(treeTableWindow, n);
            this.metricID = n;
        }

        public String toString() {
            return this.window.getPPTrial().getMetricName(this.metricID) + " %";
        }

        public Object getValueFor(TreeTableNode treeTableNode, boolean bl) {
            FunctionProfile functionProfile = treeTableNode.getFunctionProfile();
            int n = this.window.getPPTrial().getSelectedSnapshot();
            if (functionProfile == null) {
                return null;
            }
            if (bl) {
                if (treeTableNode.getExpanded()) {
                    return new Double(functionProfile.getExclusivePerCall(n, this.metricID));
                }
                return new Double(functionProfile.getInclusivePerCall(n, this.metricID));
            }
            DecimalFormat decimalFormat = new DecimalFormat("##0.0");
            if (treeTableNode.getExpanded()) {
                return decimalFormat.format(functionProfile.getExclusivePercent(n, this.metricID)) + "%";
            }
            return decimalFormat.format(functionProfile.getInclusivePercent(n, this.metricID)) + "%";
        }

        public TableCellRenderer getCellRenderer() {
            return new RegularMetricCellRenderer(this.window);
        }

        public int getMetricID() {
            return this.metricID;
        }
    }

    static class RegularMetricColumn
    extends TreeTableColumn {
        private int metricID;

        public RegularMetricColumn(TreeTableWindow treeTableWindow, int n) {
            super(treeTableWindow);
            this.metricID = n;
        }

        public String toString() {
            return this.window.getPPTrial().getMetricName(this.metricID);
        }

        public Object getValueFor(TreeTableNode treeTableNode, boolean bl) {
            FunctionProfile functionProfile = treeTableNode.getFunctionProfile();
            if (functionProfile == null) {
                return null;
            }
            int n = this.window.getPPTrial().getSelectedSnapshot();
            if (treeTableNode.getExpanded()) {
                return this.adjustForUnits(functionProfile.getExclusive(n, this.metricID), this.metricID, bl);
            }
            return this.adjustForUnits(functionProfile.getInclusive(n, this.metricID), this.metricID, bl);
        }

        public TableCellRenderer getCellRenderer() {
            return new RegularMetricCellRenderer(this.window);
        }

        public int getMetricID() {
            return this.metricID;
        }
    }

    static class RegularMetricCellRenderer
    extends JPanel
    implements TableCellRenderer {
        private static final long serialVersionUID = -4911710251628231833L;
        private NumberFormat formatter;
        private TreeTableWindow window;
        private JLabel iconLabel = new JLabel();
        private JLabel textLabel = new JLabel();
        private ColorIcon colorIcon = new ColorIcon();

        public RegularMetricCellRenderer(TreeTableWindow treeTableWindow) {
            this.window = treeTableWindow;
            this.iconLabel.setHorizontalAlignment(2);
            this.textLabel.setHorizontalAlignment(4);
            this.iconLabel.setIcon(this.colorIcon);
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 5, 0, 0);
            gridBagConstraints.weightx = 0.5;
            gridBagConstraints.weighty = 0.5;
            this.add((Component)this.iconLabel, gridBagConstraints);
            gridBagConstraints.anchor = 13;
            this.add((Component)this.textLabel, gridBagConstraints);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Object object2;
            n2 = jTable.convertColumnIndexToModel(n2) - 1;
            this.textLabel.setFont(jTable.getFont());
            TreeTableNode treeTableNode = (TreeTableNode)object;
            RegularMetricColumn regularMetricColumn = (RegularMetricColumn)this.window.getColumns().get(n2);
            Color color = treeTableNode.getColor(regularMetricColumn.getMetricID());
            if (treeTableNode.getModel().getPPTrial().getNumberOfMetrics() == 1) {
                this.iconLabel.setIcon(null);
            } else {
                this.iconLabel.setIcon(this.colorIcon);
            }
            this.iconLabel.setVisible(color != null);
            if (color != null) {
                this.colorIcon.setColor(color);
            }
            if ((object2 = regularMetricColumn.getValueFor(treeTableNode, false)) instanceof Double) {
                if (this.formatter == null) {
                    this.formatter = NumberFormat.getInstance();
                }
                this.textLabel.setText(object2 == null ? "" : this.formatter.format(object2));
            } else {
                this.textLabel.setText(object2 == null ? "" : object2.toString());
            }
            return this;
        }
    }

    static class ParaProfCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 5459926803089862887L;
        private NumberFormat formatter;
        private TreeTableWindow window;

        public ParaProfCellRenderer(TreeTableWindow treeTableWindow) {
            this.window = treeTableWindow;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (object instanceof TreeTableNode) {
                // empty if block
            }
            n2 = jTable.convertColumnIndexToModel(n2) - 1;
            TreeTableColumn treeTableColumn = this.window.getColumns().get(n2);
            Object object2 = treeTableColumn.getValueFor((TreeTableNode)object, false);
            this.setHorizontalAlignment(4);
            if (object2 instanceof Double) {
                if (this.formatter == null) {
                    this.formatter = NumberFormat.getInstance();
                }
                this.setText(object2 == null ? "" : this.formatter.format(object2));
            } else {
                this.setText(object2 == null ? "" : object2.toString());
            }
            return component;
        }

        public void setValue(Object object) {
        }
    }

    public static class ColorIcon
    implements Icon {
        private Color color = Color.black;
        private int size = 12;

        public int getIconHeight() {
            return this.size;
        }

        public int getIconWidth() {
            return this.size;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(this.color);
            graphics.fillRect(n, n2, this.size, this.size);
            graphics.setColor(Color.black);
            graphics.drawRect(n, n2, this.size, this.size);
        }

        public void setColor(Color color) {
            this.color = color;
        }
    }
}

