/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof.treetable;

import edu.uoregon.tau.common.AlphanumComparator;
import edu.uoregon.tau.paraprof.ColorBar;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.treetable.CallPathModel;
import edu.uoregon.tau.paraprof.treetable.TreeTableColumn;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeTableNode
extends DefaultMutableTreeNode
implements Comparable<TreeTableNode> {
    private static final long serialVersionUID = -3499993765860892169L;
    private List<TreeTableNode> children;
    private FunctionProfile functionProfile;
    private String displayName;
    private boolean expanded;
    private CallPathModel model;
    private String alternateName;
    private static AlphanumComparator cmp = new AlphanumComparator();

    public TreeTableNode(FunctionProfile functionProfile, CallPathModel callPathModel, String string) {
        this.functionProfile = functionProfile;
        this.model = callPathModel;
        this.alternateName = string;
        this.displayName = functionProfile != null ? (callPathModel.getWindow().getTreeMode() ? (callPathModel.getReversedCallPaths() ? ParaProfUtils.getReversedLeafDisplayName(functionProfile.getFunction()) : ParaProfUtils.getLeafDisplayName(functionProfile.getFunction())) : ParaProfUtils.getDisplayName(functionProfile.getFunction())) : string;
    }

    public FunctionProfile getFunctionProfile() {
        return this.functionProfile;
    }

    public List<TreeTableNode> getChildren() {
        this.checkInitChildren();
        return this.children;
    }

    public int getNumChildren() {
        this.checkInitChildren();
        return this.children.size();
    }

    private void checkInitChildren() {
        if (this.children == null) {
            Object object;
            this.children = new ArrayList<TreeTableNode>();
            List list = this.model.getThread().getFunctionProfiles();
            boolean bl = false;
            HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
            boolean bl2 = false;
            for (Object object2 : list) {
                int n;
                int n2;
                String string;
                if (object2 == this.functionProfile || object2 == null || !object2.isCallPathFunction()) continue;
                if (this.model.getReversedCallPaths()) {
                    object = object2.getFunction().getReversedName();
                    string = "<=";
                } else {
                    object = object2.getName();
                    string = "=>";
                }
                String string2 = this.alternateName;
                if (this.functionProfile != null) {
                    string2 = this.model.getReversedCallPaths() ? this.functionProfile.getFunction().getReversedName() : this.functionProfile.getName();
                }
                if ((n2 = ((String)object).indexOf(string2)) == 0) {
                    String string3 = ((String)object).substring(string2.length()).trim();
                    n = string3.lastIndexOf(string);
                    if (n != 0) continue;
                    bl2 = true;
                    TreeTableNode treeTableNode = new TreeTableNode((FunctionProfile)object2, this.model, null);
                    this.children.add(treeTableNode);
                    continue;
                }
                if (n2 == -1) continue;
                int n3 = ((String)object).indexOf(string, n2 + string2.length());
                n = ((String)object).indexOf(string, n3 + 1);
                if (n3 == -1) continue;
                bl = true;
                if (n == -1) {
                    hashMap.put(object2, new Object());
                    continue;
                }
                if (this.model.getReversedCallPaths()) {
                    hashMap.put(((String)object).substring(0, n), new Object());
                    continue;
                }
                hashMap.put(((String)object).substring(0, n), new Object());
            }
            if (!bl2 && bl) {
                for (Object object2 : hashMap.keySet()) {
                    object = object2 instanceof String ? new TreeTableNode(null, this.model, (String)object2) : new TreeTableNode((FunctionProfile)object2, this.model, null);
                    this.children.add((TreeTableNode)object);
                }
            }
        }
        try {
            Collections.sort(this.children);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public String toString() {
        return this.displayName;
    }

    public boolean getExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean bl) {
        this.expanded = bl;
    }

    public double getColorValue(int n, boolean bl) {
        if (!this.model.getWindow().getTreeMode()) {
            return -1.0;
        }
        if (this.functionProfile == null) {
            double d = 0.0;
            if (bl) {
                d = 0.0;
            } else {
                for (TreeTableNode treeTableNode : this.getChildren()) {
                    d += treeTableNode.getColorValue(n, false);
                }
            }
            return d;
        }
        if (this.functionProfile != null && this.model.getMaxValues()[n] != 0.0) {
            double d = bl ? this.functionProfile.getExclusive(n) : this.functionProfile.getInclusive(n);
            return d;
        }
        return 0.0;
    }

    public Color getColor(int n) {
        double d = this.getColorValue(n, this.expanded);
        if (d == -1.0) {
            return null;
        }
        Color color = ColorBar.getColor((float)(d / this.model.getMaxValues()[n]));
        return color;
    }

    public void sortChildren() {
        if (this.children != null) {
            Collections.sort(this.children);
            for (TreeTableNode treeTableNode : this.children) {
                treeTableNode.sortChildren();
            }
        }
    }

    @Override
    public int compareTo(TreeTableNode treeTableNode) {
        int n = -99;
        if (this.model.getSortColumn() == 0) {
            n = cmp.compare(this.toString(), treeTableNode.toString());
        } else {
            TreeTableColumn treeTableColumn = this.model.getWindow().getColumns().get(this.model.getSortColumn() - 1);
            Comparable comparable = (Comparable)treeTableColumn.getValueFor(this, true);
            Comparable comparable2 = (Comparable)treeTableColumn.getValueFor(treeTableNode, true);
            try {
                n = comparable.compareTo(comparable2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (this.model.getSortAscending()) {
            return -n;
        }
        return n;
    }

    public CallPathModel getModel() {
        return this.model;
    }
}

