/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.perfdmf.Database;
import edu.uoregon.tau.perfdmf.DatabaseException;
import edu.uoregon.tau.perfdmf.database.DB;
import edu.uoregon.tau.perfdmf.database.DBConnector;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Application
implements Serializable {
    private static final long serialVersionUID = -2031253072892944002L;
    private int applicationID;
    private String name;
    private String[] fields;
    private Database database;

    public Database getDatabase() {
        return this.database;
    }

    public void setDatabase(Database database) {
        this.database = database;
        this.fields = new String[database.getAppFieldNames().length];
    }

    public Application() {
        this.fields = new String[0];
    }

    public Application(Application application) {
        this.name = application.getName();
        this.applicationID = application.getID();
        this.fields = (String[])application.fields.clone();
        this.database = application.database;
    }

    public String[] getFields() {
        return this.fields;
    }

    public void setFields(String[] stringArray) {
        this.fields = stringArray;
    }

    public static String[] getFieldNames(DB dB) throws DatabaseException {
        Application.getMetaData(dB);
        return dB.getDatabase().getAppFieldNames();
    }

    public static void getMetaData(DB dB) {
        try {
            Object object;
            Database database = dB.getDatabase();
            ResultSet resultSet = null;
            DatabaseMetaData databaseMetaData = dB.getMetaData();
            resultSet = dB.getDBType().compareTo("oracle") == 0 || dB.getDBType().compareTo("derby") == 0 || dB.getDBType().compareTo("db2") == 0 ? databaseMetaData.getColumns(null, null, "APPLICATION", "%") : databaseMetaData.getColumns(null, null, "application", "%");
            Vector<String> vector = new Vector<String>();
            Vector<Integer> vector2 = new Vector<Integer>();
            boolean bl = false;
            while (resultSet.next()) {
                int n = resultSet.getInt("DATA_TYPE");
                object = resultSet.getString("COLUMN_NAME");
                if (((String)object).equals("ID")) {
                    if (bl) break;
                    bl = true;
                }
                if (!DBConnector.isReadAbleType(n) || ((String)object).toUpperCase().compareTo("ID") == 0 || ((String)object).toUpperCase().compareTo("NAME") == 0) continue;
                vector.add(resultSet.getString("COLUMN_NAME"));
                vector2.add(new Integer(n));
            }
            resultSet.close();
            String[] stringArray = new String[vector.size()];
            object = new int[vector2.size()];
            for (int i = 0; i < vector2.size(); ++i) {
                stringArray[i] = (String)vector.get(i);
                object[i] = (Integer)vector2.get(i);
            }
            database.setAppFieldNames(stringArray);
            database.setAppFieldTypes((int[])object);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public int getNumFields() {
        return this.fields.length;
    }

    public String getFieldName(int n) {
        return this.database.getAppFieldNames()[n];
    }

    public int getFieldType(int n) {
        return this.database.getAppFieldTypes()[n];
    }

    public String[] getFieldNames() {
        return this.database.getAppFieldNames();
    }

    public int[] getFieldTypes() {
        return this.database.getAppFieldTypes();
    }

    public int getID() {
        return this.applicationID;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public String getField(int n) {
        return this.fields[n];
    }

    public String getField(String string) {
        if (this.database.getAppFieldNames() == null) {
            return null;
        }
        for (int i = 0; i < this.database.getAppFieldNames().length; ++i) {
            if (!string.toUpperCase().equals(this.database.getAppFieldNames()[i].toUpperCase()) || i >= this.fields.length) continue;
            return this.fields[i];
        }
        return null;
    }

    public void setField(int n, String string) {
        if (DBConnector.isIntegerType(this.database.getAppFieldTypes()[n]) && string != null) {
            try {
                Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
        }
        if (DBConnector.isFloatingPointType(this.database.getAppFieldTypes()[n]) && string != null) {
            try {
                Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
        }
        this.fields[n] = string;
    }

    public void setID(int n) {
        this.applicationID = n;
    }

    public void setName(String string) {
        this.name = string;
    }

    public static Vector<Application> getApplicationList(DB dB, String string) {
        StringBuffer stringBuffer = null;
        try {
            Database database = dB.getDatabase();
            Application.getMetaData(dB);
            ResultSet resultSet = null;
            Vector<Application> vector = new Vector<Application>();
            stringBuffer = new StringBuffer("select id, name");
            for (int i = 0; i < database.getAppFieldNames().length; ++i) {
                stringBuffer.append(", " + database.getAppFieldNames()[i]);
            }
            stringBuffer.append(" from " + dB.getSchemaPrefix() + "application");
            stringBuffer.append(string);
            if (dB.getDBType().compareTo("oracle") == 0) {
                stringBuffer.append(" order by dbms_lob.substr(name), id asc");
            } else if (dB.getDBType().compareTo("derby") == 0) {
                stringBuffer.append(" order by cast (name as varchar(256)), id asc");
            } else if (dB.getDBType().compareTo("db2") == 0) {
                stringBuffer.append(" order by cast (name as varchar(256)), id asc");
            } else {
                stringBuffer.append(" order by name, id asc ");
            }
            resultSet = dB.executeQuery(stringBuffer.toString());
            while (resultSet.next()) {
                Application application = new Application();
                application.setDatabase(database);
                application.setID(resultSet.getInt(1));
                application.setName(resultSet.getString(2));
                for (int i = 0; i < database.getAppFieldNames().length; ++i) {
                    application.setField(i, resultSet.getString(i + 3));
                }
                vector.addElement(application);
            }
            resultSet.close();
            return vector;
        }
        catch (SQLException sQLException) {
            if (stringBuffer != null) {
                System.out.println(stringBuffer.toString());
            }
            System.err.println(sQLException.getMessage());
            throw new DatabaseException("", sQLException);
        }
    }

    public int saveApplication(DB dB) throws SQLException {
        int n;
        int n2;
        boolean bl = false;
        PreparedStatement preparedStatement = dB.prepareStatement("SELECT name FROM " + dB.getSchemaPrefix() + "application WHERE id = ?");
        preparedStatement.setInt(1, this.getID());
        ResultSet resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            bl = true;
        }
        resultSet.close();
        preparedStatement.close();
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append("UPDATE " + dB.getSchemaPrefix() + "application SET name = ?");
            for (n2 = 0; n2 < this.getNumFields(); ++n2) {
                if (!DBConnector.isWritableType(this.getFieldType(n2))) continue;
                stringBuffer.append(", " + this.getFieldName(n2) + " = ?");
            }
            stringBuffer.append(" WHERE id = ?");
        } else {
            stringBuffer.append("INSERT INTO " + dB.getSchemaPrefix() + "application (name");
            for (n2 = 0; n2 < this.getNumFields(); ++n2) {
                if (!DBConnector.isWritableType(this.getFieldType(n2))) continue;
                stringBuffer.append(", " + this.getFieldName(n2));
            }
            stringBuffer.append(") VALUES (?");
            for (n2 = 0; n2 < this.getNumFields(); ++n2) {
                if (!DBConnector.isWritableType(this.getFieldType(n2))) continue;
                stringBuffer.append(", ?");
            }
            stringBuffer.append(")");
        }
        preparedStatement = dB.prepareStatement(stringBuffer.toString());
        n2 = 1;
        preparedStatement.setString(n2++, this.getName());
        for (n = 0; n < this.getNumFields(); ++n) {
            if (!DBConnector.isWritableType(this.getFieldType(n))) continue;
            preparedStatement.setString(n2++, this.getField(n));
        }
        if (bl) {
            preparedStatement.setInt(n2++, this.getID());
        }
        preparedStatement.executeUpdate();
        preparedStatement.close();
        n = 0;
        if (bl) {
            n = this.getID();
        } else {
            String string = new String();
            string = dB.getDBType().compareTo("mysql") == 0 ? "select LAST_INSERT_ID();" : (dB.getDBType().compareTo("db2") == 0 ? "select IDENTITY_VAL_LOCAL() FROM application" : (dB.getDBType().compareTo("derby") == 0 ? "select IDENTITY_VAL_LOCAL() FROM application" : (dB.getDBType().compareTo("oracle") == 0 ? "SELECT " + dB.getSchemaPrefix() + "application_id_seq.currval FROM DUAL" : "select currval('application_id_seq');")));
            n = Integer.parseInt(dB.getDataItem(string));
        }
        return n;
    }

    public static void deleteApplication(DB dB, int n) {
        try {
            PreparedStatement preparedStatement = null;
            preparedStatement = dB.prepareStatement("delete from " + dB.getSchemaPrefix() + "application where id = ?");
            preparedStatement.setInt(1, n);
            preparedStatement.execute();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            System.out.println("An error occurred while deleting the application.");
            sQLException.printStackTrace();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }
}

