/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.perfdmf.Application;
import edu.uoregon.tau.perfdmf.AtomicEvent;
import edu.uoregon.tau.perfdmf.AtomicLocationProfile;
import edu.uoregon.tau.perfdmf.Context;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.Database;
import edu.uoregon.tau.perfdmf.DatabaseException;
import edu.uoregon.tau.perfdmf.Experiment;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.Group;
import edu.uoregon.tau.perfdmf.IntervalEvent;
import edu.uoregon.tau.perfdmf.IntervalLocationProfile;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Node;
import edu.uoregon.tau.perfdmf.Thread;
import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfdmf.UserEvent;
import edu.uoregon.tau.perfdmf.UserEventProfile;
import edu.uoregon.tau.perfdmf.database.ConnectionManager;
import edu.uoregon.tau.perfdmf.database.DB;
import java.io.File;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseAPI {
    private Application application = null;
    private Experiment experiment = null;
    private Trial trial = null;
    private List<Integer> nodes = null;
    private List<Integer> contexts = null;
    private List<Integer> threads = null;
    private Vector<IntervalEvent> intervalEvents = null;
    private List<Metric> metrics = null;
    private Vector<IntervalLocationProfile> intervalEventData = null;
    private Vector<AtomicEvent> atomicEvents = null;
    private Vector<AtomicLocationProfile> atomicEventData = null;
    private DB db = null;
    private ConnectionManager connector;
    private Hashtable<Integer, IntervalEvent> intervalEventHash = null;
    private Hashtable<Integer, AtomicEvent> atomicEventHash = null;
    private boolean cancelUpload = false;
    private Database database;
    private int totalItems;
    private int itemsDone;

    public void cancelUpload() {
        this.cancelUpload = true;
    }

    public String getMetricName(int n) {
        if (this.metrics == null && this.trial != null) {
            this.metrics = this.trial.getMetrics();
        }
        if (this.metrics != null && n < this.metrics.size()) {
            return this.metrics.get(n).getName();
        }
        return null;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public void setExperiment(Experiment experiment) {
        this.experiment = experiment;
    }

    public DB db() {
        return this.db;
    }

    public void setDB(DB dB) {
        this.db = dB;
    }

    public void initialize(String string, boolean bl) throws SQLException {
        if (string.startsWith("http") || new File(string).exists()) {
            this.initialize(new Database(string), bl);
        } else {
            System.err.println("Could not find file: " + string);
        }
    }

    public void initialize(String string, boolean bl, String string2) throws SQLException {
        if (string.startsWith("http") || new File(string).exists()) {
            this.initialize(new Database(string2, string), bl);
        } else {
            System.err.println("Could not find file: " + string);
        }
    }

    public void initialize(Database database, boolean bl) throws SQLException {
        this.database = database;
        this.connector = new ConnectionManager(database, bl);
        this.connector.connect();
        this.db = this.connector.getDB();
        Application.getMetaData(this.db);
        Experiment.getMetaData(this.db);
        Trial.getMetaData(this.db);
    }

    public void initialize(Database database, String string) throws SQLException {
        this.database = database;
        this.connector = new ConnectionManager(database, string);
        this.connector.connect();
        this.db = this.connector.getDB();
        Application.getMetaData(this.db);
        Experiment.getMetaData(this.db);
        Trial.getMetaData(this.db);
    }

    public void initialize(Database database) throws SQLException {
        this.database = database;
        this.connector = new ConnectionManager(database);
        this.connector.connect();
        this.db = this.connector.getDB();
        Application.getMetaData(this.db);
        Experiment.getMetaData(this.db);
        Trial.getMetaData(this.db);
    }

    public void terminate() {
        this.connector.dbclose();
    }

    public ConnectionManager getConnector() {
        return this.connector;
    }

    public List<Application> getApplicationList() throws DatabaseException {
        String string = "";
        return Application.getApplicationList(this.db, string);
    }

    public List<Experiment> getExperimentList() throws DatabaseException {
        String string = "";
        if (this.application != null) {
            string = "WHERE application = " + this.application.getID();
        }
        return Experiment.getExperimentList(this.db, string);
    }

    public List<Trial> getTrialList(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.experiment != null) {
            stringBuffer.append("WHERE t.experiment = " + this.experiment.getID());
        } else if (this.application != null) {
            stringBuffer.append("WHERE e.application = " + this.application.getID());
        }
        return Trial.getTrialList(this.db, stringBuffer.toString(), bl);
    }

    public Application setApplication(int n) {
        this.application = null;
        this.experiment = null;
        this.trial = null;
        this.intervalEventHash = null;
        this.atomicEventHash = null;
        String string = " WHERE id = " + n;
        Vector<Application> vector = Application.getApplicationList(this.db, string);
        if (vector.size() == 1) {
            this.application = vector.elementAt(0);
        }
        return this.application;
    }

    public Application setApplication(String string, String string2) {
        Vector<Application> vector;
        this.application = null;
        this.experiment = null;
        this.trial = null;
        this.intervalEventHash = null;
        this.atomicEventHash = null;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" WHERE name = '" + string + "'");
        if (string2 != null) {
            stringBuffer.append(" AND version = " + string2);
        }
        if ((vector = Application.getApplicationList(this.db, stringBuffer.toString())).size() == 1) {
            this.application = vector.elementAt(0);
            return this.application;
        }
        return null;
    }

    public Experiment setExperiment(int n) throws DatabaseException {
        this.experiment = null;
        this.trial = null;
        this.intervalEventHash = null;
        this.atomicEventHash = null;
        String string = " WHERE id = " + n;
        Vector<Experiment> vector = Experiment.getExperimentList(this.db, string);
        if (vector.size() == 1) {
            this.experiment = vector.elementAt(0);
            return this.experiment;
        }
        return null;
    }

    public Trial setTrial(int n, boolean bl) {
        return this.setTrial(n, true, bl);
    }

    private Trial setTrial(int n, boolean bl, boolean bl2) {
        String string;
        Vector<Trial> vector;
        this.trial = null;
        this.metrics = null;
        if (bl) {
            this.intervalEventHash = null;
            this.atomicEventHash = null;
        }
        if ((vector = Trial.getTrialList(this.db, string = " WHERE t.id = " + n, bl2)).size() == 1) {
            this.trial = vector.elementAt(0);
        }
        return this.trial;
    }

    public Trial setTrial(String string, boolean bl) {
        return this.setTrial(string, true, bl);
    }

    private Trial setTrial(String string, boolean bl, boolean bl2) {
        String string2;
        Vector<Trial> vector;
        this.trial = null;
        this.metrics = null;
        if (bl) {
            this.intervalEventHash = null;
            this.atomicEventHash = null;
        }
        if ((vector = Trial.getTrialList(this.db, string2 = " WHERE t.name = '" + string + "'", bl2)).size() == 1) {
            this.trial = vector.elementAt(0);
        }
        return this.trial;
    }

    public List<IntervalEvent> getIntervalEvents() {
        String string = new String();
        if (this.trial != null) {
            string = " WHERE trial = " + this.trial.getID();
        } else if (this.experiment != null) {
            string = " WHERE experiment = " + this.experiment.getID();
        } else if (this.application != null) {
            string = " WHERE application = " + this.application.getID();
        }
        this.intervalEvents = IntervalEvent.getIntervalEvents(this, this.db, string);
        if (this.intervalEventHash == null) {
            this.intervalEventHash = new Hashtable();
        }
        Enumeration<IntervalEvent> enumeration = this.intervalEvents.elements();
        while (enumeration.hasMoreElements()) {
            IntervalEvent intervalEvent = enumeration.nextElement();
            this.intervalEventHash.put(new Integer(intervalEvent.getID()), intervalEvent);
        }
        return this.intervalEvents;
    }

    public void getIntervalEventDetail(IntervalEvent intervalEvent) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" WHERE ms.interval_event = " + intervalEvent.getID());
        if (this.metrics != null && this.metrics.size() > 0) {
            stringBuffer.append(" AND ms.metric in (");
            Iterator<Metric> iterator = this.metrics.iterator();
            while (iterator.hasNext()) {
                Metric metric = iterator.next();
                stringBuffer.append(metric.getID());
                if (iterator.hasNext()) {
                    stringBuffer.append(", ");
                    continue;
                }
                stringBuffer.append(") ");
            }
        }
        IntervalLocationProfile.getIntervalEventDetail(this.db, intervalEvent, stringBuffer.toString());
    }

    public void getAtomicEventDetail(AtomicEvent atomicEvent) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" WHERE e.id = " + atomicEvent.getID());
        AtomicLocationProfile.getAtomicEventDetail(this.db, atomicEvent, stringBuffer.toString());
    }

    public List<AtomicEvent> getAtomicEvents() {
        String string = new String();
        if (this.trial != null) {
            string = " WHERE t.id = " + this.trial.getID();
        } else if (this.experiment != null) {
            string = " WHERE t.experiment = " + this.experiment.getID();
        } else if (this.application != null) {
            string = " WHERE e.application = " + this.application.getID();
        }
        this.atomicEvents = AtomicEvent.getAtomicEvents(this, this.db, string);
        if (this.atomicEventHash == null) {
            this.atomicEventHash = new Hashtable();
        }
        Enumeration<AtomicEvent> enumeration = this.atomicEvents.elements();
        while (enumeration.hasMoreElements()) {
            AtomicEvent atomicEvent = enumeration.nextElement();
            this.atomicEventHash.put(new Integer(atomicEvent.getID()), atomicEvent);
        }
        return this.atomicEvents;
    }

    public IntervalEvent setIntervalEvent(int n) {
        IntervalEvent intervalEvent = null;
        this.intervalEvents = new Vector();
        intervalEvent = this.getIntervalEvent(n);
        if (intervalEvent != null) {
            this.intervalEvents.addElement(intervalEvent);
            this.setTrial(intervalEvent.getTrialID(), false);
        }
        return intervalEvent;
    }

    public AtomicEvent setAtomicEvent(int n) {
        AtomicEvent atomicEvent = null;
        this.atomicEvents = new Vector();
        atomicEvent = this.getAtomicEvent(n);
        if (atomicEvent != null) {
            this.atomicEvents.addElement(atomicEvent);
        }
        return atomicEvent;
    }

    public void clearIntervalEvents() {
        this.intervalEvents = null;
    }

    public void setNode(int n) {
        Integer n2 = new Integer(n);
        this.nodes = new ArrayList<Integer>();
        this.nodes.add(n2);
    }

    public void setContext(int n) {
        Integer n2 = new Integer(n);
        this.contexts = new ArrayList<Integer>();
        this.contexts.add(n2);
    }

    public void setThread(int n) {
        Integer n2 = new Integer(n);
        this.threads = new ArrayList<Integer>();
        this.threads.add(n2);
    }

    public List<IntervalLocationProfile> getIntervalEventData() throws SQLException {
        Object object;
        Iterator<Serializable> iterator;
        if (this.trial == null && this.intervalEvents == null) {
            System.out.println("Please select a trial or a set of intervalEvents before getting intervalEvent data.");
            return null;
        }
        int n = 0;
        n = this.metrics != null && this.metrics.size() > 0 ? this.metrics.size() : this.trial.getMetricCount();
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.trial != null) {
            stringBuffer.append(" WHERE e.trial = " + this.trial.getID());
            bl = true;
        }
        if (this.intervalEvents != null && this.intervalEvents.size() > 0) {
            if (bl) {
                stringBuffer.append(" AND p.interval_event in (");
            } else {
                stringBuffer.append(" WHERE p.interval_event in (");
            }
            iterator = this.intervalEvents.elements();
            while (iterator.hasMoreElements()) {
                object = (IntervalEvent)iterator.nextElement();
                stringBuffer.append(((IntervalEvent)object).getID());
                if (iterator.hasMoreElements()) {
                    stringBuffer.append(", ");
                    continue;
                }
                stringBuffer.append(") ");
            }
        }
        if (this.nodes != null && this.nodes.size() > 0) {
            stringBuffer.append(" AND p.node IN (");
            iterator = this.nodes.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                stringBuffer.append(object);
                if (iterator.hasNext()) {
                    stringBuffer.append(", ");
                    continue;
                }
                stringBuffer.append(") ");
            }
        }
        if (this.contexts != null && this.contexts.size() > 0) {
            stringBuffer.append(" AND p.context IN (");
            iterator = this.contexts.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                stringBuffer.append(object);
                if (iterator.hasNext()) {
                    stringBuffer.append(", ");
                    continue;
                }
                stringBuffer.append(") ");
            }
        }
        if (this.threads != null && this.threads.size() > 0) {
            stringBuffer.append(" AND p.thread IN (");
            iterator = this.threads.iterator();
            while (iterator.hasNext()) {
                object = (Integer)iterator.next();
                stringBuffer.append(object);
                if (iterator.hasNext()) {
                    stringBuffer.append(", ");
                    continue;
                }
                stringBuffer.append(") ");
            }
        }
        if (this.metrics != null && this.metrics.size() > 0) {
            stringBuffer.append(" AND p.metric IN (");
            iterator = this.metrics.iterator();
            while (iterator.hasNext()) {
                object = (Metric)iterator.next();
                stringBuffer.append(((Metric)object).getID());
                if (iterator.hasNext()) {
                    stringBuffer.append(", ");
                    continue;
                }
                stringBuffer.append(") ");
            }
        }
        this.intervalEventData = IntervalLocationProfile.getIntervalEventData(this.db, n, stringBuffer.toString());
        return this.intervalEventData;
    }

    public List<AtomicLocationProfile> getAtomicEventData() {
        Object object;
        Iterator<Integer> iterator;
        if (this.trial == null && this.atomicEvents == null) {
            System.out.println("Please select a trial or a set of user events before getting user event data.");
            return null;
        }
        if (this.atomicEvents == null) {
            this.getAtomicEvents();
        }
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.trial != null) {
            stringBuffer.append(" WHERE e.trial = " + this.trial.getID());
            bl = true;
        }
        if (this.atomicEvents != null && this.atomicEvents.size() > 0) {
            if (bl) {
                stringBuffer.append(" AND e.id IN (");
            } else {
                stringBuffer.append(" WHERE e.id IN (");
            }
            iterator = this.atomicEvents.elements();
            while (iterator.hasMoreElements()) {
                object = (AtomicEvent)iterator.nextElement();
                stringBuffer.append(((AtomicEvent)object).getID());
                if (iterator.hasMoreElements()) {
                    stringBuffer.append(", ");
                    continue;
                }
                stringBuffer.append(") ");
            }
        }
        if (this.nodes != null && this.nodes.size() > 0) {
            stringBuffer.append(" AND p.node IN (");
            iterator = this.nodes.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                stringBuffer.append(object);
                if (iterator.hasNext()) {
                    stringBuffer.append(", ");
                    continue;
                }
                stringBuffer.append(") ");
            }
        }
        if (this.contexts != null && this.contexts.size() > 0) {
            stringBuffer.append(" AND p.context IN (");
            iterator = this.contexts.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                stringBuffer.append(object);
                if (iterator.hasNext()) {
                    stringBuffer.append(", ");
                    continue;
                }
                stringBuffer.append(") ");
            }
        }
        if (this.threads != null && this.threads.size() > 0) {
            stringBuffer.append(" AND p.thread IN (");
            iterator = this.threads.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                stringBuffer.append(object);
                if (iterator.hasNext()) {
                    stringBuffer.append(", ");
                    continue;
                }
                stringBuffer.append(") ");
            }
        }
        this.atomicEventData = AtomicLocationProfile.getAtomicEventData(this.db, stringBuffer.toString());
        return this.atomicEventData;
    }

    public IntervalEvent getIntervalEvent(int n) {
        IntervalEvent intervalEvent = null;
        if (this.intervalEventHash != null) {
            intervalEvent = this.intervalEventHash.get(new Integer(n));
        }
        if (intervalEvent == null) {
            String string = " WHERE id = " + n;
            Vector<IntervalEvent> vector = IntervalEvent.getIntervalEvents(this, this.db, string);
            if (vector.size() == 1) {
                intervalEvent = vector.elementAt(0);
            }
            if (this.intervalEventHash == null) {
                this.intervalEventHash = new Hashtable();
            }
            this.intervalEventHash.put(new Integer(intervalEvent.getID()), intervalEvent);
        }
        return intervalEvent;
    }

    public AtomicEvent getAtomicEvent(int n) {
        AtomicEvent atomicEvent = null;
        if (this.atomicEventHash != null) {
            atomicEvent = this.atomicEventHash.get(new Integer(n));
        }
        if (atomicEvent == null) {
            String string = " WHERE u.id = " + n;
            Vector<AtomicEvent> vector = AtomicEvent.getAtomicEvents(this, this.db, string);
            if (vector.size() == 1) {
                atomicEvent = vector.elementAt(0);
            }
            if (this.atomicEventHash == null) {
                this.atomicEventHash = new Hashtable();
            }
            this.atomicEventHash.put(new Integer(atomicEvent.getID()), atomicEvent);
        }
        return atomicEvent;
    }

    public int saveApplication(Application application) {
        try {
            return application.saveApplication(this.db);
        }
        catch (SQLException sQLException) {
            throw new DatabaseException("Error saving application", sQLException);
        }
    }

    public int saveExperiment(Experiment experiment) throws DatabaseException {
        try {
            return experiment.saveExperiment(this.db);
        }
        catch (SQLException sQLException) {
            throw new DatabaseException("Error saving experiment", sQLException);
        }
    }

    public int saveTrial() {
        int n = this.trial.saveTrial(this.db);
        return n;
    }

    private int saveMetric(int n, Metric metric) throws SQLException {
        int n2 = 0;
        PreparedStatement preparedStatement = null;
        preparedStatement = this.db.prepareStatement("INSERT INTO " + this.db.getSchemaPrefix() + "metric (name, trial) VALUES (?, ?)");
        preparedStatement.setString(1, metric.getName());
        preparedStatement.setInt(2, n);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        String string = new String();
        string = this.db.getDBType().compareTo("mysql") == 0 ? "select LAST_INSERT_ID();" : (this.db.getDBType().compareTo("db2") == 0 ? "select IDENTITY_VAL_LOCAL() FROM metric" : (this.db.getDBType().compareTo("derby") == 0 ? "select IDENTITY_VAL_LOCAL() FROM metric" : (this.db.getDBType().compareTo("oracle") == 0 ? "select " + this.db.getSchemaPrefix() + "metric_id_seq.currval FROM dual" : "select currval('metric_id_seq');")));
        n2 = Integer.parseInt(this.db.getDataItem(string));
        return n2;
    }

    private Hashtable<Integer, Integer> saveMetrics(int n, Trial trial, int n2) throws SQLException {
        Hashtable<Integer, Integer> hashtable = new Hashtable<Integer, Integer>();
        int n3 = 0;
        for (Metric metric : trial.getDataSource().getMetrics()) {
            int n4 = -1;
            if (n2 < 0 || n2 == n3) {
                n4 = this.saveMetric(n, metric);
            }
            hashtable.put(new Integer(n3), new Integer(n4));
            ++n3;
        }
        return hashtable;
    }

    private Hashtable<Integer, Integer> saveIntervalEvents(int n, Hashtable<Integer, Integer> hashtable, int n2) throws SQLException {
        Hashtable<Integer, Integer> hashtable2 = new Hashtable<Integer, Integer>();
        Enumeration<IntervalEvent> enumeration = this.intervalEvents.elements();
        while (enumeration.hasMoreElements()) {
            IntervalEvent intervalEvent = enumeration.nextElement();
            int n3 = intervalEvent.saveIntervalEvent(this.db, n, hashtable, n2);
            hashtable2.put(new Integer(intervalEvent.getID()), new Integer(n3));
        }
        return hashtable2;
    }

    private Hashtable<Integer, Integer> saveAtomicEvents(int n) {
        Hashtable<Integer, Integer> hashtable = new Hashtable<Integer, Integer>();
        Enumeration<AtomicEvent> enumeration = this.atomicEvents.elements();
        while (enumeration.hasMoreElements()) {
            AtomicEvent atomicEvent = enumeration.nextElement();
            int n2 = atomicEvent.saveAtomicEvent(this.db, n);
            hashtable.put(new Integer(atomicEvent.getID()), new Integer(n2));
        }
        return hashtable;
    }

    private void saveAtomicEventData(Hashtable<Integer, Integer> hashtable) {
        Enumeration<AtomicLocationProfile> enumeration = this.atomicEventData.elements();
        while (enumeration.hasMoreElements()) {
            AtomicLocationProfile atomicLocationProfile = enumeration.nextElement();
            Integer n = hashtable.get(new Integer(atomicLocationProfile.getAtomicEventID()));
            atomicLocationProfile.saveAtomicEventData(this.db, n);
        }
    }

    public int saveTrial(Trial trial) {
        return trial.saveTrial(this.db);
    }

    public int saveIntervalEvent(IntervalEvent intervalEvent, int n, Hashtable<Integer, Integer> hashtable) throws SQLException {
        return intervalEvent.saveIntervalEvent(this.db, n, hashtable, -1);
    }

    public int saveAtomicEvent(AtomicEvent atomicEvent, int n) {
        return atomicEvent.saveAtomicEvent(this.db, n);
    }

    public void saveAtomicEventData(AtomicLocationProfile atomicLocationProfile, int n) {
        atomicLocationProfile.saveAtomicEventData(this.db, n);
    }

    public int getProgress() {
        if (this.totalItems != 0) {
            return (int)((float)this.itemsDone / (float)this.totalItems * 100.0f);
        }
        return 0;
    }

    public synchronized int saveTrial(Trial trial, Metric metric) throws DatabaseException {
        int n;
        Hashtable<Integer, Integer> hashtable;
        Hashtable<Integer, Integer> hashtable2;
        Group group;
        DataSource dataSource = trial.getDataSource();
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator<Group> iterator = dataSource.getGroups();
        while (iterator.hasNext()) {
            group = iterator.next();
            arrayList.add(group.getName());
        }
        this.metrics = trial.getDataSource().getMetrics();
        int n2 = this.metrics.size();
        this.intervalEvents = new Vector();
        this.intervalEventData = new Vector();
        this.atomicEvents = new Vector();
        this.atomicEventData = new Vector();
        group = dataSource.getGroup("TAU_CALLPATH_DERIVED");
        Iterator<Comparable<Function>> iterator2 = dataSource.getFunctions();
        while (iterator2.hasNext()) {
            int n3;
            Function comparable2 = iterator2.next();
            if (comparable2.isGroupMember(group)) continue;
            hashtable2 = new IntervalEvent(this);
            ((IntervalEvent)((Object)hashtable2)).setName(comparable2.getName());
            ((IntervalEvent)((Object)hashtable2)).setID(comparable2.getID());
            hashtable = comparable2.getGroups();
            StringBuffer stringBuffer = new StringBuffer();
            if (hashtable != null) {
                for (n3 = 0; n3 < hashtable.size(); ++n3) {
                    if (n3 > 0) {
                        stringBuffer.append("|");
                    }
                    stringBuffer.append(((Group)hashtable.get(n3)).getName());
                }
                if (hashtable.size() > 0) {
                    ((IntervalEvent)((Object)hashtable2)).setGroup(stringBuffer.toString());
                }
            }
            this.intervalEvents.add((IntervalEvent)((Object)hashtable2));
            n3 = trial.getDataSource().getAllThreads().size();
            IntervalLocationProfile intervalLocationProfile = new IntervalLocationProfile(n2);
            IntervalLocationProfile intervalLocationProfile2 = new IntervalLocationProfile(n2);
            for (int i = 0; i < n2; ++i) {
                intervalLocationProfile.setNumCalls(comparable2.getTotalNumCalls());
                intervalLocationProfile.setNumSubroutines(comparable2.getTotalNumSubr());
                intervalLocationProfile.setInclusivePercentage(i, comparable2.getTotalInclusivePercent(i));
                intervalLocationProfile.setInclusive(i, comparable2.getTotalInclusive(i));
                intervalLocationProfile.setExclusivePercentage(i, comparable2.getTotalExclusivePercent(i));
                intervalLocationProfile.setExclusive(i, comparable2.getTotalExclusive(i));
                intervalLocationProfile.setInclusivePerCall(i, comparable2.getTotalInclusivePerCall(i));
                intervalLocationProfile2.setNumCalls(comparable2.getTotalNumCalls() / (double)n3);
                intervalLocationProfile2.setNumSubroutines(comparable2.getTotalNumSubr() / (double)n3);
                intervalLocationProfile2.setInclusivePercentage(i, comparable2.getTotalInclusivePercent(i));
                intervalLocationProfile2.setInclusive(i, comparable2.getTotalInclusive(i) / (double)n3);
                intervalLocationProfile2.setExclusivePercentage(i, comparable2.getTotalExclusivePercent(i));
                intervalLocationProfile2.setExclusive(i, comparable2.getTotalExclusive(i) / (double)n3);
                intervalLocationProfile2.setInclusivePerCall(i, comparable2.getTotalInclusivePerCall(i));
            }
            ((IntervalEvent)((Object)hashtable2)).setTotalSummary(intervalLocationProfile);
            ((IntervalEvent)((Object)hashtable2)).setMeanSummary(intervalLocationProfile2);
        }
        iterator2 = dataSource.getUserEvents();
        while (iterator2.hasNext()) {
            UserEvent userEvent = (UserEvent)iterator2.next();
            if (userEvent == null) continue;
            hashtable2 = new AtomicEvent(this);
            ((AtomicEvent)((Object)hashtable2)).setName(userEvent.getName());
            ((AtomicEvent)((Object)hashtable2)).setID(userEvent.getID());
            this.atomicEvents.add((AtomicEvent)((Object)hashtable2));
        }
        for (Thread thread : trial.getDataSource().getAllThreads()) {
            Object object;
            hashtable2 = thread.getFunctionProfiles();
            hashtable = hashtable2.iterator();
            while (hashtable.hasNext()) {
                FunctionProfile functionProfile = (FunctionProfile)hashtable.next();
                if (functionProfile == null || functionProfile.getFunction().isGroupMember(group)) continue;
                object = new IntervalLocationProfile(n2);
                ((IntervalLocationProfile)object).setNode(thread.getNodeID());
                ((IntervalLocationProfile)object).setContext(thread.getContextID());
                ((IntervalLocationProfile)object).setThread(thread.getThreadID());
                ((IntervalLocationProfile)object).setIntervalEventID(functionProfile.getFunction().getID());
                ((IntervalLocationProfile)object).setNumCalls(functionProfile.getNumCalls());
                ((IntervalLocationProfile)object).setNumSubroutines(functionProfile.getNumSubr());
                for (int i = 0; i < n2; ++i) {
                    ((IntervalLocationProfile)object).setInclusive(i, functionProfile.getInclusive(i));
                    ((IntervalLocationProfile)object).setExclusive(i, functionProfile.getExclusive(i));
                    ((IntervalLocationProfile)object).setInclusivePercentage(i, functionProfile.getInclusivePercent(i));
                    ((IntervalLocationProfile)object).setExclusivePercentage(i, functionProfile.getExclusivePercent(i));
                    ((IntervalLocationProfile)object).setInclusivePerCall(i, functionProfile.getInclusivePerCall(i));
                }
                this.intervalEventData.add((IntervalLocationProfile)object);
            }
            hashtable = thread.getUserEventProfiles();
            while (hashtable.hasNext()) {
                UserEventProfile userEventProfile = hashtable.next();
                if (userEventProfile == null) continue;
                object = new AtomicLocationProfile();
                ((AtomicLocationProfile)object).setAtomicEventID(userEventProfile.getUserEvent().getID());
                ((AtomicLocationProfile)object).setNode(thread.getNodeID());
                ((AtomicLocationProfile)object).setContext(thread.getContextID());
                ((AtomicLocationProfile)object).setThread(thread.getThreadID());
                ((AtomicLocationProfile)object).setSampleCount((int)userEventProfile.getNumSamples());
                ((AtomicLocationProfile)object).setMaximumValue(userEventProfile.getMaxValue());
                ((AtomicLocationProfile)object).setMinimumValue(userEventProfile.getMinValue());
                ((AtomicLocationProfile)object).setMeanValue(userEventProfile.getMeanValue());
                ((AtomicLocationProfile)object).setSumSquared(userEventProfile.getSumSquared());
                this.atomicEventData.add((AtomicLocationProfile)object);
            }
        }
        this.totalItems = this.intervalEvents.size() + this.intervalEventData.size() + this.atomicEvents.size() + this.atomicEventData.size();
        try {
            this.db.setAutoCommit(false);
        }
        catch (SQLException sQLException) {
            throw new DatabaseException("Saving Trial Failed: couldn't set AutoCommit to false", sQLException);
        }
        int n3 = 0;
        int n4 = -1;
        if (metric != null) {
            n = metric.getID();
        }
        try {
            hashtable2 = null;
            if (metric == null) {
                n3 = trial.saveTrial(this.db);
                trial.setID(n3);
                hashtable2 = this.saveMetrics(n3, trial, n);
                if (this.intervalEvents != null && this.intervalEvents.size() > 0) {
                    hashtable = this.saveIntervalEvents(n3, hashtable2, n);
                    this.saveIntervalLocationProfiles(this.db, hashtable, this.intervalEventData.elements(), hashtable2, n);
                }
                if (this.atomicEvents != null && this.atomicEvents.size() > 0) {
                    hashtable = this.saveAtomicEvents(n3);
                    if (this.atomicEventData != null && this.atomicEventData.size() > 0) {
                        this.saveAtomicEventData(hashtable);
                    }
                }
            } else {
                n3 = trial.getID();
                hashtable2 = this.saveMetrics(n3, trial, n);
                if (this.intervalEvents != null && this.intervalEvents.size() > 0) {
                    hashtable = this.saveIntervalEvents(n3, hashtable2, n);
                    this.saveIntervalLocationProfiles(this.db, hashtable, this.intervalEventData.elements(), hashtable2, n);
                }
            }
            for (Integer n5 : hashtable2.keySet()) {
                int n6 = hashtable2.get(n5);
                for (Metric metric2 : trial.getDataSource().getMetrics()) {
                    if (metric2.getID() != n5.intValue() || n6 == -1) continue;
                    metric2.setDbMetricID(n6);
                }
            }
        }
        catch (SQLException sQLException) {
            try {
                this.db.rollback();
                sQLException.printStackTrace();
                throw new DatabaseException("Saving Trial Failed, rollbacks successful", sQLException);
            }
            catch (SQLException sQLException2) {
                throw new DatabaseException("Saving Trial Failed, rollbacks failed!", sQLException2);
            }
        }
        try {
            this.db.commit();
            this.db.setAutoCommit(true);
        }
        catch (SQLException sQLException) {
            throw new DatabaseException("Saving Trial Failed: commit failed!", sQLException);
        }
        return n3;
    }

    private Map<Metric, Integer> uploadMetrics(int n, DataSource dataSource) throws SQLException {
        HashMap<Metric, Integer> hashMap = new HashMap<Metric, Integer>();
        for (Metric metric : dataSource.getMetrics()) {
            PreparedStatement preparedStatement = this.db.prepareStatement("INSERT INTO " + this.db.getSchemaPrefix() + "metric (name, trial) VALUES (?, ?)");
            preparedStatement.setString(1, metric.getName());
            preparedStatement.setInt(2, n);
            preparedStatement.executeUpdate();
            preparedStatement.close();
            String string = new String();
            string = this.db.getDBType().compareTo("mysql") == 0 ? "select LAST_INSERT_ID();" : (this.db.getDBType().compareTo("db2") == 0 ? "select IDENTITY_VAL_LOCAL() FROM metric" : (this.db.getDBType().compareTo("derby") == 0 ? "select IDENTITY_VAL_LOCAL() FROM metric" : (this.db.getDBType().compareTo("oracle") == 0 ? "select " + this.db.getSchemaPrefix() + "metric_id_seq.currval FROM dual" : "select currval('metric_id_seq');")));
            int n2 = Integer.parseInt(this.db.getDataItem(string));
            hashMap.put(metric, new Integer(n2));
        }
        return hashMap;
    }

    private Map<Function, Integer> uploadFunctions(int n, DataSource dataSource) throws SQLException {
        HashMap<Function, Integer> hashMap = new HashMap<Function, Integer>();
        Group group = dataSource.getGroup("TAU_CALLPATH_DERIVED");
        Iterator<Function> iterator = dataSource.getFunctions();
        while (iterator.hasNext()) {
            Function function = iterator.next();
            if (function.isGroupMember(group)) continue;
            String string = null;
            List<Group> list = function.getGroups();
            StringBuffer stringBuffer = new StringBuffer();
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    if (i > 0) {
                        stringBuffer.append("|");
                    }
                    stringBuffer.append(list.get(i).getName());
                }
                if (list.size() > 0) {
                    string = stringBuffer.toString();
                }
            }
            PreparedStatement preparedStatement = this.db.prepareStatement("INSERT INTO " + this.db.getSchemaPrefix() + "interval_event (trial, name, group_name) VALUES (?, ?, ?)");
            preparedStatement.setInt(1, n);
            preparedStatement.setString(2, function.getName());
            preparedStatement.setString(3, string);
            preparedStatement.executeUpdate();
            preparedStatement.close();
            String string2 = new String();
            string2 = this.db.getDBType().compareTo("mysql") == 0 ? "select LAST_INSERT_ID();" : (this.db.getDBType().compareTo("db2") == 0 ? "select IDENTITY_VAL_LOCAL() FROM interval_event" : (this.db.getDBType().compareTo("derby") == 0 ? "select IDENTITY_VAL_LOCAL() FROM interval_event" : (this.db.getDBType().compareTo("oracle") == 0 ? "select " + this.db.getSchemaPrefix() + "interval_event_id_seq.currval FROM dual" : "select currval('interval_event_id_seq');")));
            int n2 = Integer.parseInt(this.db.getDataItem(string2));
            hashMap.put(function, new Integer(n2));
            ++this.itemsDone;
        }
        return hashMap;
    }

    private Map<UserEvent, Integer> uploadUserEvents(int n, DataSource dataSource) throws SQLException {
        HashMap<UserEvent, Integer> hashMap = new HashMap<UserEvent, Integer>();
        String string = null;
        Iterator<UserEvent> iterator = dataSource.getUserEvents();
        while (iterator.hasNext()) {
            UserEvent userEvent = iterator.next();
            PreparedStatement preparedStatement = null;
            preparedStatement = this.db.prepareStatement("INSERT INTO " + this.db.getSchemaPrefix() + "atomic_event (trial, name, group_name) VALUES (?, ?, ?)");
            preparedStatement.setInt(1, n);
            preparedStatement.setString(2, userEvent.getName());
            preparedStatement.setString(3, string);
            preparedStatement.executeUpdate();
            preparedStatement.close();
            String string2 = new String();
            string2 = this.db.getDBType().compareTo("mysql") == 0 ? "select LAST_INSERT_ID();" : (this.db.getDBType().compareTo("db2") == 0 ? "select IDENTITY_VAL_LOCAL() FROM atomic_event" : (this.db.getDBType().compareTo("derby") == 0 ? "select IDENTITY_VAL_LOCAL() FROM atomic_event" : (this.db.getDBType().compareTo("oracle") == 0 ? "select " + this.db.getSchemaPrefix() + "atomic_event_id_seq.currval FROM dual" : "select currval('atomic_event_id_seq');")));
            int n2 = Integer.parseInt(this.db.getDataItem(string2));
            hashMap.put(userEvent, new Integer(n2));
            ++this.itemsDone;
        }
        return hashMap;
    }

    private void addBatchFunctionProfile(PreparedStatement preparedStatement, Thread thread, int n, int n2, FunctionProfile functionProfile, int n3, boolean bl, int n4) throws SQLException {
        preparedStatement.setInt(1, n3);
        preparedStatement.setInt(2, n2);
        preparedStatement.setDouble(3, functionProfile.getInclusivePercent(n));
        if (bl) {
            preparedStatement.setDouble(4, functionProfile.getInclusive(n) / (double)n4);
            preparedStatement.setDouble(5, functionProfile.getExclusivePercent(n));
            preparedStatement.setDouble(6, functionProfile.getExclusive(n) / (double)n4);
            preparedStatement.setDouble(7, functionProfile.getNumCalls() / (double)n4);
            preparedStatement.setDouble(8, functionProfile.getNumSubr() / (double)n4);
            preparedStatement.setDouble(9, functionProfile.getInclusivePerCall(n));
        } else {
            preparedStatement.setDouble(4, functionProfile.getInclusive(n));
            preparedStatement.setDouble(5, functionProfile.getExclusivePercent(n));
            preparedStatement.setDouble(6, functionProfile.getExclusive(n));
            preparedStatement.setDouble(7, functionProfile.getNumCalls());
            preparedStatement.setDouble(8, functionProfile.getNumSubr());
            preparedStatement.setDouble(9, functionProfile.getInclusivePerCall(n));
        }
        if (thread.getNodeID() >= 0) {
            preparedStatement.setInt(10, thread.getNodeID());
            preparedStatement.setInt(11, thread.getContextID());
            preparedStatement.setInt(12, thread.getThreadID());
        }
        ++this.itemsDone;
        preparedStatement.executeUpdate();
    }

    private void uploadFunctionProfiles(int n, DataSource dataSource, Map<Function, Integer> map, Map<Metric, Integer> map2, boolean bl) throws SQLException {
        PreparedStatement preparedStatement = null;
        PreparedStatement preparedStatement2 = null;
        PreparedStatement preparedStatement3 = null;
        if (this.db.getDBType().compareTo("oracle") == 0) {
            preparedStatement = this.db.prepareStatement("INSERT INTO " + this.db.getSchemaPrefix() + "interval_total_summary (interval_event, metric, inclusive_percentage, inclusive, exclusive_percentage, excl, call, subroutines, inclusive_per_call) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
            preparedStatement2 = this.db.prepareStatement("INSERT INTO " + this.db.getSchemaPrefix() + "interval_mean_summary (interval_event, metric, inclusive_percentage, inclusive, exclusive_percentage, excl, call, subroutines, inclusive_per_call) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
            preparedStatement3 = this.db.prepareStatement("INSERT INTO " + this.db.getSchemaPrefix() + "interval_location_profile (interval_event, metric, inclusive_percentage, inclusive, exclusive_percentage, excl, call, subroutines, inclusive_per_call, node, context, thread) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        } else if (this.db.getDBType().compareTo("derby") == 0) {
            preparedStatement = this.db.prepareStatement("INSERT INTO " + this.db.getSchemaPrefix() + "interval_total_summary (interval_event, metric, inclusive_percentage, inclusive, exclusive_percentage, exclusive, num_calls, subroutines, inclusive_per_call) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
            preparedStatement2 = this.db.prepareStatement("INSERT INTO " + this.db.getSchemaPrefix() + "interval_mean_summary (interval_event, metric, inclusive_percentage, inclusive, exclusive_percentage, exclusive, num_calls, subroutines, inclusive_per_call) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
            preparedStatement3 = this.db.prepareStatement("INSERT INTO " + this.db.getSchemaPrefix() + "interval_location_profile (interval_event, metric, inclusive_percentage, inclusive, exclusive_percentage, exclusive, num_calls, subroutines, inclusive_per_call, node, context, thread) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        } else if (this.db.getDBType().compareTo("mysql") == 0) {
            preparedStatement = this.db.prepareStatement("INSERT INTO " + this.db.getSchemaPrefix() + "interval_total_summary (interval_event, metric, inclusive_percentage, inclusive, exclusive_percentage, exclusive, `call`, subroutines, inclusive_per_call) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
            preparedStatement2 = this.db.prepareStatement("INSERT INTO " + this.db.getSchemaPrefix() + "interval_mean_summary (interval_event, metric, inclusive_percentage, inclusive, exclusive_percentage, exclusive, `call`, subroutines, inclusive_per_call) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
            preparedStatement3 = this.db.prepareStatement("INSERT INTO " + this.db.getSchemaPrefix() + "interval_location_profile (interval_event, metric, inclusive_percentage, inclusive, exclusive_percentage, exclusive, `call`, subroutines, inclusive_per_call, node, context, thread) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        } else {
            preparedStatement = this.db.prepareStatement("INSERT INTO " + this.db.getSchemaPrefix() + "interval_total_summary (interval_event, metric, inclusive_percentage, inclusive, exclusive_percentage, exclusive, call, subroutines, inclusive_per_call) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
            preparedStatement2 = this.db.prepareStatement("INSERT INTO " + this.db.getSchemaPrefix() + "interval_mean_summary (interval_event, metric, inclusive_percentage, inclusive, exclusive_percentage, exclusive, call, subroutines, inclusive_per_call) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
            preparedStatement3 = this.db.prepareStatement("INSERT INTO " + this.db.getSchemaPrefix() + "interval_location_profile (interval_event, metric, inclusive_percentage, inclusive, exclusive_percentage, exclusive, call, subroutines, inclusive_per_call, node, context, thread) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        }
        Group group = dataSource.getGroup("TAU_CALLPATH_DERIVED");
        for (Metric metric : dataSource.getMetrics()) {
            Integer n2 = map2.get(metric);
            Iterator<Function> iterator = dataSource.getFunctions();
            while (iterator.hasNext()) {
                Function function = iterator.next();
                if (function.isGroupMember(group)) continue;
                Integer n3 = map.get(function);
                Thread thread = dataSource.getTotalData();
                this.addBatchFunctionProfile(preparedStatement, thread, metric.getID(), n2, function.getTotalProfile(), n3, false, dataSource.getAllThreads().size());
                this.addBatchFunctionProfile(preparedStatement2, thread, metric.getID(), n2, function.getTotalProfile(), n3, true, dataSource.getAllThreads().size());
                Iterator<Thread> iterator2 = dataSource.getAllThreads().iterator();
                while (iterator2.hasNext() && !bl) {
                    Thread thread2 = iterator2.next();
                    FunctionProfile functionProfile = thread2.getFunctionProfile(function);
                    if (functionProfile == null) continue;
                    if (this.cancelUpload) {
                        return;
                    }
                    this.addBatchFunctionProfile(preparedStatement3, thread2, metric.getID(), n2, functionProfile, n3, false, dataSource.getAllThreads().size());
                }
            }
        }
        preparedStatement.close();
        preparedStatement2.close();
        preparedStatement3.close();
    }

    private void uploadUserEventProfiles(int n, DataSource dataSource, Map<UserEvent, Integer> map) throws SQLException {
        Iterator<Node> iterator = dataSource.getNodes();
        while (iterator.hasNext()) {
            Node node = iterator.next();
            Iterator<Context> iterator2 = node.getContexts();
            while (iterator2.hasNext()) {
                Context context = iterator2.next();
                Iterator<Thread> iterator3 = context.getThreads();
                while (iterator3.hasNext()) {
                    Thread thread = iterator3.next();
                    Iterator<UserEventProfile> iterator4 = thread.getUserEventProfiles();
                    while (iterator4.hasNext()) {
                        UserEventProfile userEventProfile = iterator4.next();
                        if (this.cancelUpload) {
                            return;
                        }
                        if (userEventProfile == null) continue;
                        int n2 = map.get(userEventProfile.getUserEvent());
                        PreparedStatement preparedStatement = null;
                        preparedStatement = this.db.prepareStatement("INSERT INTO " + this.db.getSchemaPrefix() + "atomic_location_profile (atomic_event, node, context, thread, sample_count, maximum_value, minimum_value, mean_value, standard_deviation) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
                        preparedStatement.setInt(1, n2);
                        preparedStatement.setInt(2, thread.getNodeID());
                        preparedStatement.setInt(3, thread.getContextID());
                        preparedStatement.setInt(4, thread.getThreadID());
                        preparedStatement.setInt(5, (int)userEventProfile.getNumSamples());
                        preparedStatement.setDouble(6, userEventProfile.getMaxValue());
                        preparedStatement.setDouble(7, userEventProfile.getMinValue());
                        preparedStatement.setDouble(8, userEventProfile.getMeanValue());
                        preparedStatement.setDouble(9, userEventProfile.getSumSquared());
                        preparedStatement.executeUpdate();
                        preparedStatement.close();
                    }
                }
            }
        }
    }

    private void computeUploadSize(DataSource dataSource) {
        this.totalItems = 0;
        Iterator<Function> iterator = dataSource.getFunctions();
        while (iterator.hasNext()) {
            iterator.next();
            ++this.totalItems;
        }
        int n = dataSource.getMetrics().size();
        Iterator<Function> iterator2 = dataSource.getFunctions();
        while (iterator2.hasNext()) {
            Function function = iterator2.next();
            this.totalItems += n;
            this.totalItems += n;
            for (Thread thread : dataSource.getAllThreads()) {
                FunctionProfile functionProfile = thread.getFunctionProfile(function);
                if (functionProfile == null) continue;
                this.totalItems += n;
            }
        }
    }

    public synchronized int uploadTrial(Trial trial) throws DatabaseException {
        return this.uploadTrial(trial, false);
    }

    public synchronized int uploadTrial(Trial trial, boolean bl) throws DatabaseException {
        DataSource dataSource = trial.getDataSource();
        try {
            this.db.setAutoCommit(false);
        }
        catch (SQLException sQLException) {
            throw new DatabaseException("Saving Trial Failed: couldn't set AutoCommit to false", sQLException);
        }
        int n = -1;
        try {
            n = trial.saveTrial(this.db);
            trial.setID(n);
            this.computeUploadSize(dataSource);
            Map<Metric, Integer> map = this.uploadMetrics(n, dataSource);
            for (Metric object2 : map.keySet()) {
                int n2 = map.get(object2);
                object2.setDbMetricID(n2);
            }
            Map<Function, Integer> map2 = this.uploadFunctions(n, dataSource);
            this.uploadFunctionProfiles(n, dataSource, map2, map, bl);
            Map<UserEvent, Integer> map3 = this.uploadUserEvents(n, dataSource);
            this.uploadUserEventProfiles(n, dataSource, map3);
            if (this.cancelUpload) {
                this.db.rollback();
                this.deleteTrial(n);
                return -1;
            }
        }
        catch (SQLException sQLException) {
            try {
                this.db.rollback();
                sQLException.printStackTrace();
                throw new DatabaseException("Saving Trial Failed, rollbacks successful", sQLException);
            }
            catch (SQLException sQLException2) {
                throw new DatabaseException("Saving Trial Failed, rollbacks failed!", sQLException2);
            }
        }
        try {
            this.db.commit();
            this.db.setAutoCommit(true);
        }
        catch (SQLException sQLException) {
            throw new DatabaseException("Saving Trial Failed: commit failed!", sQLException);
        }
        return n;
    }

    public int saveApplication() {
        int n = 0;
        try {
            if (this.application != null) {
                n = this.application.saveApplication(this.db);
            }
        }
        catch (SQLException sQLException) {
            throw new DatabaseException("Error saving application", sQLException);
        }
        return n;
    }

    public int saveExperiment() {
        int n = 0;
        try {
            if (this.experiment != null) {
                n = this.experiment.saveExperiment(this.db);
            }
        }
        catch (SQLException sQLException) {
            throw new DatabaseException("Error saving experiment", sQLException);
        }
        return n;
    }

    public void deleteTrial(int n) throws SQLException {
        Trial.deleteTrial(this.db, n);
    }

    public void deleteExperiment(int n) throws DatabaseException, SQLException {
        DatabaseAPI databaseAPI = new DatabaseAPI();
        databaseAPI.setDB(this.db());
        databaseAPI.setExperiment(n);
        ListIterator<Trial> listIterator = databaseAPI.getTrialList(false).listIterator();
        while (listIterator.hasNext()) {
            Trial trial = listIterator.next();
            Trial.deleteTrial(this.db, trial.getID());
        }
        Experiment.deleteExperiment(this.db, n);
    }

    public void deleteApplication(int n) throws DatabaseException, SQLException {
        DatabaseAPI databaseAPI = new DatabaseAPI();
        databaseAPI.setDB(this.db());
        databaseAPI.setApplication(n);
        ListIterator<Experiment> listIterator = databaseAPI.getExperimentList().listIterator();
        while (listIterator.hasNext()) {
            Experiment experiment = listIterator.next();
            databaseAPI.setExperiment(experiment.getID());
            ListIterator<Trial> listIterator2 = databaseAPI.getTrialList(false).listIterator();
            while (listIterator2.hasNext()) {
                Trial trial = listIterator2.next();
                Trial.deleteTrial(this.db, trial.getID());
            }
            Experiment.deleteExperiment(this.db, experiment.getID());
        }
        Application.deleteApplication(this.db, n);
    }

    public int getNumberOfMetrics() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT id, name ");
        stringBuffer.append("FROM " + this.db.getSchemaPrefix() + "metric ");
        stringBuffer.append("WHERE trial = ");
        stringBuffer.append(this.trial.getID());
        stringBuffer.append(" ORDER BY id ");
        try {
            ResultSet resultSet = this.db.executeQuery(stringBuffer.toString());
            int n = 0;
            while (resultSet.next()) {
                ++n;
            }
            resultSet.close();
            return n;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1;
        }
    }

    public void saveIntervalLocationProfiles(DB dB, Hashtable<Integer, Integer> hashtable, Enumeration<IntervalLocationProfile> enumeration, Hashtable<Integer, Integer> hashtable2, int n) throws SQLException {
        PreparedStatement preparedStatement = null;
        preparedStatement = dB.getDBType().compareTo("oracle") == 0 ? dB.prepareStatement("INSERT INTO " + dB.getSchemaPrefix() + "interval_location_profile (interval_event, node, context, thread, metric, inclusive_percentage, inclusive, exclusive_percentage, excl, call, subroutines, inclusive_per_call) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)") : (dB.getDBType().compareTo("derby") == 0 ? dB.prepareStatement("INSERT INTO " + dB.getSchemaPrefix() + "interval_location_profile (interval_event, node, context, thread, metric, inclusive_percentage, inclusive, exclusive_percentage, exclusive, num_calls, subroutines, inclusive_per_call) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)") : (dB.getDBType().compareTo("mysql") == 0 ? dB.prepareStatement("INSERT INTO " + dB.getSchemaPrefix() + "interval_location_profile (interval_event, node, context, thread, metric, inclusive_percentage, inclusive, exclusive_percentage, exclusive, `call`, subroutines, inclusive_per_call) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)") : dB.prepareStatement("INSERT INTO " + dB.getSchemaPrefix() + "interval_location_profile (interval_event, node, context, thread, metric, inclusive_percentage, inclusive, exclusive_percentage, exclusive, call, subroutines, inclusive_per_call) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)")));
        int n2 = 0;
        Integer n3 = null;
        while (enumeration.hasMoreElements()) {
            IntervalLocationProfile intervalLocationProfile = enumeration.nextElement();
            Integer n4 = hashtable.get(new Integer(intervalLocationProfile.getIntervalEventID()));
            n2 = 0;
            n3 = hashtable2.get(new Integer(n2));
            while (n3 != null) {
                if (n < 0 || n2 == n) {
                    preparedStatement.setInt(1, n4);
                    preparedStatement.setInt(2, intervalLocationProfile.getNode());
                    preparedStatement.setInt(3, intervalLocationProfile.getContext());
                    preparedStatement.setInt(4, intervalLocationProfile.getThread());
                    preparedStatement.setInt(5, n3);
                    preparedStatement.setDouble(6, intervalLocationProfile.getInclusivePercentage(n2));
                    preparedStatement.setDouble(7, intervalLocationProfile.getInclusive(n2));
                    preparedStatement.setDouble(8, intervalLocationProfile.getExclusivePercentage(n2));
                    preparedStatement.setDouble(9, intervalLocationProfile.getExclusive(n2));
                    preparedStatement.setDouble(10, intervalLocationProfile.getNumCalls());
                    preparedStatement.setDouble(11, intervalLocationProfile.getNumSubroutines());
                    preparedStatement.setDouble(12, intervalLocationProfile.getInclusivePerCall(n2));
                    preparedStatement.executeUpdate();
                }
                n3 = hashtable2.get(new Integer(++n2));
            }
        }
        preparedStatement.close();
    }

    public Application getApplication(String string, boolean bl) {
        List<Application> list = this.getApplicationList();
        for (Application application : list) {
            if (!application.getName().equals(string)) continue;
            return application;
        }
        if (bl) {
            Application application = new Application();
            application.setDatabase(this.database);
            application.setName(string);
            this.setApplication(application);
            int n = this.saveApplication();
            application.setID(n);
            return application;
        }
        return null;
    }

    public Experiment getExperiment(Application application, String string, boolean bl) {
        this.setApplication(application);
        List<Experiment> list = this.getExperimentList();
        for (Experiment experiment : list) {
            if (!experiment.getName().equals(string)) continue;
            return experiment;
        }
        if (bl) {
            Experiment experiment = new Experiment();
            experiment.setName(string);
            experiment.setApplicationID(application.getID());
            experiment.setDatabase(this.database);
            this.setExperiment(experiment);
            int n = this.saveExperiment();
            experiment.setID(n);
            return experiment;
        }
        return null;
    }

    public Trial getTrial(Application application, Experiment experiment, String string) {
        this.setApplication(application);
        List<Experiment> list = this.getExperimentList();
        for (Experiment experiment2 : list) {
            if (!experiment2.getName().equals(string)) continue;
            this.setExperiment(experiment2);
            List<Trial> list2 = this.getTrialList(false);
            for (Trial trial : list2) {
                if (!experiment.getName().equals(string)) continue;
                return trial;
            }
        }
        return null;
    }

    public Experiment getExperiment(String string, String string2, boolean bl) {
        Application application = this.getApplication(string, bl);
        if (application == null) {
            return null;
        }
        return this.getExperiment(application, string2, bl);
    }

    public DB getDb() {
        return this.db;
    }

    public Trial getTrial() {
        return this.trial;
    }
}

