/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.Group;
import edu.uoregon.tau.perfdmf.SourceRegion;
import edu.uoregon.tau.perfdmf.UtilFncs;
import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Function
implements Serializable,
Comparable<Function> {
    private static final long serialVersionUID = 362090098221172924L;
    private String name;
    private String reversedName;
    private int id = -1;
    private List<Group> groups = new ArrayList<Group>();
    private boolean phase = false;
    private Function actualPhase;
    private Function parentPhase;
    boolean callpathFunction = false;
    boolean callpathFunctionSet = false;
    private FunctionProfile meanProfile;
    private FunctionProfile stddevProfile;
    private FunctionProfile totalProfile;
    private boolean colorFlag = false;
    private Color color = null;
    private Color specificColor = null;
    private SourceRegion sourceLink;

    public Function(String string, int n, int n2) {
        this.name = string;
        this.id = n;
    }

    public int getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
        this.reversedName = null;
    }

    public String getReversedName() {
        if (this.reversedName == null) {
            if (!this.isCallPathFunction()) {
                this.reversedName = this.name;
            } else {
                String string = this.name;
                int n = string.lastIndexOf("=>");
                this.reversedName = "";
                while (n != -1) {
                    String string2 = string.substring(n + 3, string.length());
                    string2 = string2.trim();
                    this.reversedName = this.reversedName + string2;
                    if ((n = (string = string.substring(0, n)).lastIndexOf("=>")) == -1) continue;
                    this.reversedName = this.reversedName + " <= ";
                }
                this.reversedName = this.reversedName + " <= " + string;
            }
        }
        return this.reversedName.trim();
    }

    public String toString() {
        return this.name;
    }

    public SourceRegion getSourceLink() {
        if (this.sourceLink == null) {
            this.sourceLink = this.isGroupMember("TAU_CALLPATH_DERIVED") ? Function.getSourceLink(UtilFncs.getLeftSide(this.name)) : Function.getSourceLink(this.name);
        }
        return this.sourceLink;
    }

    public static SourceRegion getSourceLink(String string) {
        int n;
        int n2;
        int n3;
        int n4;
        SourceRegion sourceRegion = new SourceRegion();
        if (string.indexOf("OpenMP location:") != -1) {
            n4 = string.indexOf("file:");
            n3 = string.indexOf("<");
            n2 = string.indexOf(",");
            n = string.indexOf(">");
            sourceRegion.setFilename(string.substring(n4 + 5, n3).trim());
            sourceRegion.setStartLine(Integer.parseInt(string.substring(n3 + 1, n2).trim()));
            sourceRegion.setEndLine(Integer.parseInt(string.substring(n2 + 1, n).trim()));
        }
        if (string.indexOf("file:") != -1 && string.indexOf("line:") != -1) {
            string = string.substring(string.lastIndexOf("["));
            n4 = string.indexOf("file:");
            n3 = string.indexOf("line:");
            String string2 = string.substring(n4 + 5, n3).trim();
            sourceRegion.setFilename(string2);
            n = string.indexOf("]", n3) != -1 ? Integer.parseInt(string.substring(n3 + 5, string.indexOf("]"))) : Integer.parseInt(string.substring(n3 + 5).trim());
            sourceRegion.setStartLine(n);
            sourceRegion.setEndLine(n);
            return sourceRegion;
        }
        if (Function.isCallPathFunction(string)) {
            string = string.substring(string.lastIndexOf("=>") + 2);
        }
        if ((n4 = string.indexOf("[{")) == -1) {
            return sourceRegion;
        }
        n3 = string.indexOf("}", n4);
        if (n3 == -1) {
            return sourceRegion;
        }
        n2 = string.indexOf("{", n3 + 1);
        n = string.indexOf(",", n3 + 1);
        int n5 = string.indexOf("}", n3 + 1);
        int n6 = string.indexOf("-", n5 + 1);
        int n7 = string.indexOf("{", n2 + 1);
        int n8 = string.indexOf(",", n + 1);
        int n9 = string.indexOf("}", n5 + 1);
        String string3 = string.substring(n4 + 2, n3);
        string3 = string3.substring(string3.lastIndexOf("/") + 1);
        sourceRegion.setFilename(string3);
        if (n2 == -1) {
            return sourceRegion;
        }
        if (n6 == -1) {
            if (n == -1) {
                if (n5 != -1) {
                    int n10 = Integer.parseInt(string.substring(n2 + 1, n5));
                    sourceRegion.setStartLine(n10);
                    sourceRegion.setEndLine(n10);
                    return sourceRegion;
                }
                return sourceRegion;
            }
            int n11 = Integer.parseInt(string.substring(n2 + 1, n));
            sourceRegion.setStartLine(n11);
            sourceRegion.setEndLine(n11);
            return sourceRegion;
        }
        if (n2 == -1 || n7 == -1 || n == -1 || n8 == -1 || n5 == -1 || n9 == -1) {
            return sourceRegion;
        }
        int n12 = Integer.parseInt(string.substring(n2 + 1, n));
        int n13 = Integer.parseInt(string.substring(n + 1, n5));
        int n14 = Integer.parseInt(string.substring(n7 + 1, n8));
        int n15 = Integer.parseInt(string.substring(n8 + 1, n9));
        sourceRegion.setStartLine(n12);
        sourceRegion.setStartColumn(n13);
        sourceRegion.setEndLine(n14);
        sourceRegion.setEndColumn(n15);
        return sourceRegion;
    }

    public static boolean isCallPathFunction(String string) {
        return string.indexOf("=>") > 0;
    }

    public void addGroup(Group group) {
        if (this.isGroupMember(group)) {
            return;
        }
        this.groups.add(group);
    }

    public void removeGroup(Group group) {
        if (this.isGroupMember(group)) {
            this.groups.remove(group);
        }
    }

    public boolean isGroupMember(Group group) {
        return this.groups.contains(group);
    }

    public List<Group> getGroups() {
        return this.groups;
    }

    public String getGroupString() {
        String string = "";
        for (int i = 0; i < this.groups.size(); ++i) {
            Group group = this.groups.get(i);
            string = i == 0 ? group.getName() : string + " | " + group.getName();
        }
        return string;
    }

    public boolean isPhaseMember(Function function) {
        if (function == this) {
            return true;
        }
        if (function == null) {
            return true;
        }
        if (!this.isCallPathFunction()) {
            return false;
        }
        int n = this.name.indexOf("=>");
        String string = this.name.substring(0, n).trim();
        return string.compareTo(function.getName()) == 0;
    }

    public boolean isGroupMember(String string) {
        for (Group group : this.groups) {
            if (!group.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isCallPathFunction() {
        if (!this.callpathFunctionSet) {
            this.callpathFunction = Function.isCallPathFunction(this.name);
            this.callpathFunctionSet = true;
        }
        return this.callpathFunction;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        if (this.colorFlag) {
            return this.specificColor;
        }
        return this.color;
    }

    public void setColorFlag(boolean bl) {
        this.colorFlag = bl;
    }

    public boolean isColorFlagSet() {
        return this.colorFlag;
    }

    public void setSpecificColor(Color color) {
        this.specificColor = color;
    }

    public void setStddevProfile(FunctionProfile functionProfile) {
        this.stddevProfile = functionProfile;
    }

    public FunctionProfile getStddevProfile() {
        return this.stddevProfile;
    }

    public void setMeanProfile(FunctionProfile functionProfile) {
        this.meanProfile = functionProfile;
    }

    public FunctionProfile getMeanProfile() {
        return this.meanProfile;
    }

    public double getMeanInclusive(int n) {
        return this.meanProfile.getInclusive(n);
    }

    public double getMeanExclusive(int n) {
        return this.meanProfile.getExclusive(n);
    }

    public double getMeanInclusivePercent(int n) {
        return this.meanProfile.getInclusivePercent(n);
    }

    public double getMeanExclusivePercent(int n) {
        return this.meanProfile.getExclusivePercent(n);
    }

    public double getMeanNumCalls() {
        return this.meanProfile.getNumCalls();
    }

    public double getMeanNumSubr() {
        return this.meanProfile.getNumSubr();
    }

    public double getMeanInclusivePerCall(int n) {
        return this.meanProfile.getInclusivePerCall(n);
    }

    public double getTotalInclusive(int n) {
        return this.totalProfile.getInclusive(n);
    }

    public double getTotalExclusive(int n) {
        return this.totalProfile.getExclusive(n);
    }

    public double getTotalInclusivePercent(int n) {
        return this.totalProfile.getInclusivePercent(n);
    }

    public double getTotalExclusivePercent(int n) {
        return this.totalProfile.getExclusivePercent(n);
    }

    public double getTotalNumCalls() {
        return this.totalProfile.getNumCalls();
    }

    public double getTotalNumSubr() {
        return this.totalProfile.getNumSubr();
    }

    public double getTotalInclusivePerCall(int n) {
        return this.totalProfile.getInclusivePerCall(n);
    }

    public void setTotalProfile(FunctionProfile functionProfile) {
        this.totalProfile = functionProfile;
    }

    public FunctionProfile getTotalProfile() {
        return this.totalProfile;
    }

    @Override
    public int compareTo(Function function) {
        return this.id - function.getID();
    }

    public boolean isPhase() {
        return this.phase;
    }

    public void setPhase(boolean bl) {
        this.phase = bl;
    }

    public Function getActualPhase() {
        return this.actualPhase;
    }

    public void setActualPhase(Function function) {
        this.actualPhase = function;
    }

    public Function getParentPhase() {
        return this.parentPhase;
    }

    public void setParentPhase(Function function) {
        this.parentPhase = function;
    }
}

